/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OtherAppFileList
extends HRCoreBaseList {
    private static final String COL_POSITION_NAME = "position.name";
    private static final String FIELD_RECRUSTG_NAME = "recrustg.name";
    private static final String FIELD_RECRUSTAT_NAME = "recrustat.name";
    private static final String COL_POSPRIN = "posprin";
    private Map<Long, String> posprinMap = null;

    public void beforePackageData(BeforePackageDataEvent evt) {
        DynamicObjectCollection pageData = evt.getPageData();
        List positionIds = pageData.stream().map(dyo -> dyo.getDynamicObject("position")).filter(Objects::nonNull).map(dyo -> dyo.getLong("id")).collect(Collectors.toList());
        this.posprinMap = AppFileDataHelper.queryPosPrinByAppFileId(positionIds);
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = evt.getRowData();
        switch (fieldKey) {
            case "posprin": {
                this.setPosPrinValue(rowData, evt);
                break;
            }
            case "position.name": {
                this.setPosNameValue(rowData, evt);
                break;
            }
            case "position.number": {
                evt.setFormatValue((Object)String.format("%s-%s", rowData.getString(FIELD_RECRUSTG_NAME), rowData.getString(FIELD_RECRUSTAT_NAME)));
                break;
            }
        }
    }

    private void setPosNameValue(DynamicObject rowData, PackageDataEvent evt) {
        DynamicObject pos = rowData.getDynamicObject("position");
        if (pos != null) {
            evt.setFormatValue((Object)String.format("%s-%s", pos.getString("number"), pos.getString("name")));
        }
    }

    private void setPosPrinValue(DynamicObject rowData, PackageDataEvent evt) {
        Long posId;
        DynamicObject position = rowData.getDynamicObject("position");
        if (position != null && (posId = (Long)position.getPkValue()) != null && this.posprinMap != null) {
            String formatVal = this.posprinMap.get(posId);
            evt.setFormatValue((Object)formatVal);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                ListField recrustgName = new ListField(OtherAppFileList.FIELD_RECRUSTG_NAME);
                recrustgName.setFieldName(OtherAppFileList.FIELD_RECRUSTG_NAME);
                this.getListFields().add(recrustgName);
                ListField recrustatName = new ListField(OtherAppFileList.FIELD_RECRUSTAT_NAME);
                recrustatName.setFieldName(OtherAppFileList.FIELD_RECRUSTAT_NAME);
                this.getListFields().add(recrustatName);
                return super.getData(start, limit);
            }
        });
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object id = showParameter.getCustomParam("id");
        if (id != null) {
            QFilter qFilter = new QFilter("id", "!=", id);
            Long mid = (Long)showParameter.getCustomParam("stdrsm.mid");
            if (mid != null && mid != 0L) {
                qFilter.and(new QFilter("stdrsm.mid", "=", (Object)mid));
            } else {
                qFilter.and(new QFilter("1", "!=", (Object)1));
            }
            evt.getQFilters().add(qFilter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("position_name".equals(args.getFieldName())) {
            args.setCancel(true);
            Long appFileId = (Long)((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            this.showPostionView(appFileId);
        }
    }

    private void showPostionView(Long appFileId) {
        DynamicObject appFile;
        DynamicObject position;
        if (appFileId != null && (position = (appFile = AppFileDataHelper.queryAppFileById((Object)appFileId)).getDynamicObject("position")) != null) {
            if (PositionDataHelper.hasPositionPerm((Long)position.getLong("id"))) {
                AppFileHelper.showPositionFormView((long)position.getLong("id"), (IFormView)this.getView());
            } else {
                AppFileHelper.showErrorNotification((DynamicObject)position, (IFormView)this.getView());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if (operate != null && "view".equals(operate.getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            args.setCancel(true);
            if (listSelectedData.size() == 1) {
                this.showAppFileViewPage((Long)listSelectedData.get(0).getPrimaryKeyValue());
            }
        }
    }

    private void showAppFileViewPage(Long appFileId) {
        String pageNum;
        boolean hasManageAppFileRight;
        Long userId = TSCRequestContext.getUserId();
        boolean bl = hasManageAppFileRight = !AppFileRightHelper.hasAppFileRight((List)Lists.newArrayList((Object[])new Long[]{appFileId}), (Long)userId, (String)"tsirm_appfile_viewm", (String)"47150e89000000ac", (boolean)false).isEmpty();
        if (hasManageAppFileRight) {
            pageNum = "tsirm_appfile_viewm";
        } else {
            boolean hasChargeAppFileRight;
            boolean bl2 = hasChargeAppFileRight = !AppFileRightHelper.hasAppFileRight((List)Lists.newArrayList((Object[])new Long[]{appFileId}), (Long)userId, (String)"tsirm_appfile_viewc", (String)"47150e89000000ac", (boolean)true).isEmpty();
            if (hasChargeAppFileRight) {
                pageNum = "tsirm_appfile_viewc";
            } else {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6682\u65e0\u8be5\u6863\u6848\u7684\u67e5\u770b\u6743\u9650", (String)"OtherAppFileList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                return;
            }
        }
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setPageId(userId + appFileId + this.getView().getPageId());
        showParameter.setFormId(pageNum);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPkId((Object)appFileId);
        showParameter.setCustomParam("isEdit", (Object)true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

