/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.download;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.print.NotePrintService;
import kd.bos.url.UrlService;
import kd.tsc.tsirm.business.domain.appfile.AppFileResManagerHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileOpRecordService;
import kd.tsc.tsirm.formplugin.web.appfile.download.Control;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class DownloadAppFileBoxPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(DownloadAppFileBoxPlugin.class);
    private static final String BUTTON_ENSURE = "button_ensure";
    private static final EnumMap<Control, Function<DownloadAppFileBoxPlugin, File>> FILE_FUNCTIONS = new EnumMap(Control.class);

    public void preOpenForm(PreOpenFormEventArgs args) {
        String operationKey = (String)args.getFormShowParameter().getCustomParam("operationKey");
        if (this.isDownload(operationKey)) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5e94\u8058\u4fe1\u606f", (String)"DownloadAppFileBoxPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else if ("printappfile".equals(operationKey)) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6253\u5370\u5e94\u8058\u4fe1\u606f", (String)"DownloadAppFileBoxPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else if ("printfile".equals(operationKey)) {
            args.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0b\u8f7d/\u6253\u5370", (String)"DownloadAppFileBoxPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterBindData(EventObject evt) {
        String operationKey = (String)this.getView().getFormShowParameter().getCustomParam("operationKey");
        if (this.isDisabled(operationKey, Control.CHECKBOX_ORIGINAL)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{Control.CHECKBOX_ORIGINAL.KEY});
        }
        if (this.isDisabled(operationKey, Control.CHECKBOX_WEB)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{Control.CHECKBOX_WEB.KEY});
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        this.getModel().beginInit();
        String fieldKey = args.getProperty().getName();
        List<Control> options = Stream.of(Control.values()).filter(this::isOption).collect(Collectors.toList());
        if (Control.CHECKBOX_ALL.KEY.equals(fieldKey)) {
            if (((Boolean)args.getChangeSet()[0].getNewValue()).booleanValue()) {
                options.forEach(control -> this.getModel().setValue(control.KEY, (Object)Boolean.TRUE));
            } else {
                options.forEach(control -> this.getModel().setValue(control.KEY, (Object)Boolean.FALSE));
            }
        } else {
            Optional<Object> result = options.stream().map(control -> this.getModel().getValue(control.KEY)).filter(opt -> (Boolean)opt == false).findFirst();
            if (result.isPresent()) {
                this.getModel().setValue(Control.CHECKBOX_ALL.KEY, (Object)Boolean.FALSE);
            } else {
                this.getModel().setValue(Control.CHECKBOX_ALL.KEY, (Object)Boolean.TRUE);
            }
        }
        this.getModel().endInit();
        this.getView().updateView();
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{BUTTON_ENSURE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        List<Control> options = this.getSelectedOptions();
        if (CollectionUtils.isEmpty(options)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u4e0b\u8f7d/\u6253\u5370\u7684\u6570\u636e", (String)"DownloadAppFileBoxPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.downloadOrPrint();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (BUTTON_ENSURE.equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.downloadOrPrint();
        }
    }

    private void downloadOrPrint() {
        String operationKey = (String)this.getView().getFormShowParameter().getCustomParam("operationKey");
        try {
            if ("printappfile".equals(operationKey)) {
                this.print();
            } else if ("printfile".equals(operationKey)) {
                this.bosPrint();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IllegalStateException(ResManager.loadKDString((String)"IO\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"DownloadAppFileBoxPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), e);
        }
        this.getView().close();
    }

    private void print() throws IOException {
        List<File> files = this.getSelectedFiles();
        if (CollectionUtils.isEmpty(files)) {
            return;
        }
        File targetFile = files.get(0);
        FormShowParameter para = new FormShowParameter();
        para.setFormId("bos_printpreview");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap reservedSpace = Maps.newHashMap();
        reservedSpace.put("reservedSpace", "true");
        para.getOpenStyle().setCustParam((Map)reservedSpace);
        LocaleString name = new LocaleString(targetFile.getName().substring(0, targetFile.getName().length() - 4));
        para.setCustomParam("src", (Object)new NotePrintService().createPdfUrl(name, FileUtils.readFileToByteArray((File)targetFile)));
        this.getView().getParentView().showForm(para);
        this.getView().sendFormAction(this.getView().getParentView());
        files.add(targetFile);
        this.delete(files);
    }

    private void bosPrint() {
        OperationResult operationResult = this.getView().getParentView().invokeOperation("printpreview");
        this.getView().sendFormAction(this.getView().getParentView());
        if (operationResult.isSuccess()) {
            List<Long> appFileIdList = Collections.singletonList(this.getView().getParentView().getModel().getDataEntity().getLong("id"));
            AppFileOpRecordService.getInstance().sendOpRecord(AppFileResManagerHelper.getRecRoleName(), OpDefEnum.TSIRM_PRINT_APPFILE, appFileIdList, null);
        }
    }

    private List<Control> getSelectedOptions() {
        return Arrays.stream(Control.values()).filter(control -> this.getModel().getDataEntity().getBoolean(control.KEY)).collect(Collectors.toList());
    }

    private List<File> getSelectedFiles() {
        List<Control> options = this.getSelectedOptions();
        return options.stream().filter(obj -> obj != Control.CHECKBOX_ALL).map(obj -> FILE_FUNCTIONS.get(obj).apply(this)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private String getOriginalResumeURL() {
        return this.getView().getParentView().getModel().getDataEntity().getDynamicObject("appres").getString("resumestoadd");
    }

    private File getOriginalFile() {
        try {
            File tempDir = FileUtils.getTempDirectory();
            String fileURL = this.getOriginalResumeURL();
            String fullURL = UrlService.getAttachmentFullUrl((String)fileURL);
            File file = new File(tempDir, FilenameUtils.getName((String)fileURL));
            FileUtils.copyURLToFile((URL)new URL(fullURL), (File)file);
            return file;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void delete(List<File> files) {
        files.forEach(file -> {
            if (FileUtils.deleteQuietly((File)file)) {
                return;
            }
            logger.error("Failed to delete file {}", (Object)file.getName());
        });
    }

    private boolean isDownload(String operationKey) {
        return "downloadappfile".equals(operationKey) || "downloadfile".equals(operationKey);
    }

    private boolean isPrint(String operationKey) {
        return "printappfile".equals(operationKey) || "printfile".equals(operationKey);
    }

    private boolean isDisabled(String operationKey, Control control) {
        switch (control) {
            case CHECKBOX_ORIGINAL: {
                return StringUtils.isBlank((String)this.getOriginalResumeURL()) || this.isPrint(operationKey);
            }
            case CHECKBOX_WEB: {
                return "downloadfile".equals(operationKey);
            }
        }
        return false;
    }

    private boolean isOption(Control control) {
        return control != Control.CHECKBOX_ALL && this.getView().getControl(control.KEY) != null && this.isEnable(control);
    }

    private boolean isEnable(Control control) {
        return Optional.ofNullable(this.getPageCache().get("controlMetaState")).map(obj -> JsonParser.parseString((String)obj).getAsJsonObject().getAsJsonObject(control.KEY)).map(obj -> obj.get("lockControl")).map(JsonElement::getAsBoolean).orElse(true);
    }

    static {
        FILE_FUNCTIONS.put(Control.CHECKBOX_ORIGINAL, DownloadAppFileBoxPlugin::getOriginalFile);
    }
}

