/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.flowlock;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dtx.util.DynamicObjectSerializeUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;

public class AppFileFlowLockInfoPlugin
extends HRDynamicFormBasePlugin {
    public void preOpenForm(PreOpenFormEventArgs ee) {
        ee.getFormShowParameter().setStatus(OperationStatus.VIEW);
    }

    public void afterCreateNewData(EventObject eventObject) {
        DynamicObject[] flowLocks;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String data = (String)formShowParameter.getCustomParam("data");
        if (HRStringUtils.isNotEmpty((String)data) && (flowLocks = (DynamicObject[])Arrays.stream(DynamicObjectSerializeUtil.deserialize((String)data, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tsirm_appfileflowlock"))).map(dyn -> (DynamicObject)dyn).toArray(DynamicObject[]::new)).length > 0) {
            String appFileId = flowLocks[0].getString("appfile.id");
            Date lockTime = flowLocks[0].getDate("locktime");
            Date autoUnLockTime = flowLocks[0].getDate("autounlocktime");
            String lockerId = flowLocks[0].getString("locker.id");
            DynamicObject appFile = AppFileHelper.queryOne((long)Long.parseLong(appFileId));
            Map userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(lockerId));
            String posNumber = appFile.getString("position.number");
            String posName = appFile.getString("position.name");
            this.getModel().setValue("posname", (Object)String.format("%s/%s", posName, posNumber));
            this.getModel().setValue("locker", (Object)String.format(Locale.ROOT, "%s/%s", userInfo.get("name"), userInfo.get("number")));
            this.getModel().setValue("locktime", (Object)HRInteDateTimeUtil.formatDate((String)"tsirm_appfile_viewm", (String)"createtime", (Date)lockTime));
            this.getModel().setValue("remaintime", (Object)AppFileHelper.calDuration((Date)new Date(), (Date)autoUnLockTime));
        }
    }
}

