/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.list;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListFieldsControlEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileSRHelper;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.BlacklistHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileOperateEnum;
import kd.tsc.tsrbd.business.domain.label.service.LabelDataHelper;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import org.apache.commons.lang3.tuple.Pair;

public class AppFileList
extends HRCoreBaseList {
    private static final Log logger = LogFactory.getLog(AppFileList.class);
    private static long packageDataDuration = 0L;
    private static final Integer[] FILTER_FEEDBACK_VALUES = new Integer[]{1, 2, 3, 4, 5};
    private static final String[] FILTER_FEEDBACK_KEYS = new String[]{"fifbnum1", "fifbnum2", "fifbnum3", "fifbnum4", "fifbnum5"};
    private static final String KEY_STDRSM_DATASTATUS = "stdrsm.datastatus";
    private static final String[] FILTER_FEEDBACK_PIC_KEYS = new String[]{"fifbpic1", "fifbpic2", "fifbpic3", "fifbpic4", "fifbpic5"};
    private static final String POSITION_NUMBER_NAME = "positionnumbername";
    private static final String FIELD_POSITION_NAME = "position.name";
    private static final String FIELD_POSITION_NUMBER = "position.number";
    private static final String COL_SIMILARRES = "similarres";
    private static final String COL_PORTRAIT = "portrait";
    private static final String COL_FIFB = "fifb";
    private static final String[] FILTER_FIELDS = new String[]{"nofkfilterfknum", "suitfilterfknum", "nosuitfilterfknum", "pendfilterfknum", "tfposfilterfknum"};
    private final Map<String, String> fieldMappingNumMap = new HashMap<String, String>();
    private final Map<String, String> fieldMappingImageMap = new HashMap<String, String>();
    private final Map<String, Integer> fieldImageMap = new HashMap<String, Integer>();
    private final Map<Long, Map<String, String>> packData = new HashMap<Long, Map<String, String>>(30);
    private Map<Long, String> flowLockData;
    private final Map<String, Integer> colMap = Maps.newHashMap();
    private final Pair<Collection<String>, Collection<String>> operationVisibleTuple = Pair.of((Object)Sets.newHashSet(), (Object)Sets.newHashSet());

    private void init() {
        this.fieldMappingNumMap.put("nofkfilterfknum", "fifbnum1");
        this.fieldMappingNumMap.put("suitfilterfknum", "fifbnum2");
        this.fieldMappingNumMap.put("nosuitfilterfknum", "fifbnum3");
        this.fieldMappingNumMap.put("pendfilterfknum", "fifbnum4");
        this.fieldMappingNumMap.put("tfposfilterfknum", "fifbnum5");
        this.fieldMappingImageMap.put("nofkfilterfknum", "fifbpic1");
        this.fieldMappingImageMap.put("suitfilterfknum", "fifbpic2");
        this.fieldMappingImageMap.put("nosuitfilterfknum", "fifbpic3");
        this.fieldMappingImageMap.put("pendfilterfknum", "fifbpic4");
        this.fieldMappingImageMap.put("tfposfilterfknum", "fifbpic5");
        this.fieldImageMap.put("fifbpic1", 1);
        this.fieldImageMap.put("fifbpic2", 2);
        this.fieldImageMap.put("fifbpic3", 3);
        this.fieldImageMap.put("fifbpic4", 4);
        this.fieldImageMap.put("fifbpic5", 5);
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BillList billList = (BillList)this.getControl("billlistap");
        AppFileList listPlugin = this;
        billList.addListFieldsControlListeners(arg_0 -> AppFileList.lambda$registerListener$0((AbstractListPlugin)listPlugin, billList, arg_0));
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        logger.info("AppFileList.beforePackageData.start->{}");
        long sTime = System.currentTimeMillis();
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObjectCollection pageData = evt.getPageData();
        this.init();
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)pageData.size());
        for (DynamicObject pageDatum : pageData) {
            HashMap map = Maps.newHashMapWithExpectedSize((int)FILTER_FIELDS.length);
            long rowId = pageDatum.getLong("id");
            for (int i = 0; i < FILTER_FIELDS.length; ++i) {
                boolean b = pageDatum.containsProperty(FILTER_FIELDS[i]);
                if (!b) continue;
                map.put(this.fieldMappingNumMap.get(FILTER_FIELDS[i]), pageDatum.getInt(FILTER_FIELDS[i]));
                if (pageDatum.getInt(FILTER_FIELDS[i]) == 0) {
                    map.put(this.fieldMappingImageMap.get(FILTER_FIELDS[i]), 0);
                    continue;
                }
                Integer imageValue = this.fieldImageMap.get(this.fieldMappingImageMap.get(FILTER_FIELDS[i]));
                map.put(this.fieldMappingImageMap.get(FILTER_FIELDS[i]), imageValue);
            }
            dataMap.put(rowId, map);
        }
        for (Map.Entry rowDataEntry : dataMap.entrySet()) {
            HashMap param = new HashMap();
            ((Map)rowDataEntry.getValue()).forEach((key, value) -> param.put(key, null == value || value == 0 ? "" : String.valueOf(value)));
            this.packData.put((Long)rowDataEntry.getKey(), param);
        }
        if (!pageData.isEmpty() && ((DynamicObject)pageData.get(0)).containsProperty("filestatus")) {
            this.flowLockData = AppFileFlowLockHelper.getFlowLockData((List)pageData);
        }
        if (null != this.flowLockData) {
            this.getPageCache().put("flowlockstatus", SerializationUtils.toJsonString(this.flowLockData));
            Object unShowLabel = listShowParameter.getCustomParam(AppFileListConstants.KEY_UN_SHOW_LABEL);
            if (unShowLabel instanceof String) {
                this.getPageCache().put(AppFileListConstants.KEY_UN_SHOW_LABEL, String.valueOf(unShowLabel));
            }
        }
        long eTime = System.currentTimeMillis();
        logger.info("AppFileList.beforePackageData.duration->{}", (Object)(eTime - sTime));
    }

    public void packageData(PackageDataEvent evt) {
        DynamicObject appres;
        long sTime = System.currentTimeMillis();
        DynamicObject rowData = evt.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (fieldKey.startsWith(COL_FIFB)) {
            Long id = rowData.getLong("id");
            Map<String, String> rowMap = this.packData.get(id);
            if (rowMap != null) {
                evt.setFormatValue((Object)rowMap.get(fieldKey));
            }
        } else if (POSITION_NUMBER_NAME.equals(fieldKey)) {
            String posNumber = rowData.getString(FIELD_POSITION_NUMBER);
            String noPrefixNumber = posNumber != null && posNumber.length() > 5 ? posNumber.substring(5) : "";
            evt.setFormatValue((Object)(noPrefixNumber + "-" + rowData.getString(FIELD_POSITION_NAME)));
        } else if ("filterstatus".equals(fieldKey)) {
            evt.setFormatValue((Object)"");
        } else if ("flowlockstatus".equals(fieldKey) && this.flowLockData != null) {
            Long appFileId = rowData.getLong("id");
            evt.setFormatValue((Object)this.flowLockData.get(appFileId));
        } else if ("showworkingyears".equals(fieldKey) && (appres = rowData.getDynamicObject("appres")) != null) {
            int workingyears = appres.getInt("workingyears");
            String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workingyears);
            evt.setFormatValue((Object)workYearShow);
        }
        long eTime = System.currentTimeMillis();
        packageDataDuration += eTime - sTime;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
        Long appFileId = (Long)selectedRow.getPrimaryKeyValue();
        String fieldName = args.getFieldName();
        if ("blackliststatus".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
            BlacklistHelper.showBlacklistDetail((Long)appFile.getLong("stdrsm.id"), (IFormView)this.getView());
        } else if (COL_SIMILARRES.equals(fieldName)) {
            args.setCancel(true);
            this.clickSimilarColumn(appFileId);
        } else if ("flowlockstatus".equals(fieldName)) {
            args.setCancel(true);
            this.clickFlowColumn(appFileId);
        } else if (COL_PORTRAIT.equals(fieldName)) {
            args.setCancel(true);
            DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
            long rsmId = appFile.getLong("appres.id");
            LabelDataHelper.showAppRsmPortraitPage((IFormView)this.getView(), (Long)rsmId, (Long)LabelTagObjTypeEnum.IN_RESUME.getId());
        } else if (fieldName.startsWith(COL_FIFB)) {
            args.setCancel(true);
            this.clickRowHandle(fieldName, appFileId);
        }
    }

    private void clickRowHandle(String focusField, Long clickId) {
        if (focusField.startsWith(COL_FIFB)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.NonModal);
            DynamicObject appFile = AppFileHelper.queryOne((long)clickId);
            showParameter.setCaption(ResManager.loadKDString((String)"{0}\u7684\u53cd\u9988\u8be6\u60c5", (String)"AppFileList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{appFile.getString("name")}));
            showParameter.setFormId("tsirm_filterfeedbackpop");
            if (AppFileDataHelper.isExistFilterTaskByAppFileId((Long)clickId)) {
                showParameter.setCustomParam("appFileId", (Object)clickId);
                this.getView().showForm(showParameter);
            }
        }
    }

    private void clickFlowColumn(Long clickId) {
        String flowLockDataStr = this.getPageCache().get("flowlockstatus");
        if (HRStringUtils.isNotEmpty((String)flowLockDataStr)) {
            boolean notEmpty;
            Map currFlowLockDataMap = (Map)SerializationUtils.fromJsonString((String)flowLockDataStr, Map.class);
            String strClickId = String.valueOf(clickId);
            boolean bl = notEmpty = null != currFlowLockDataMap && HRStringUtils.isNotEmpty((String)((String)currFlowLockDataMap.get(strClickId)));
            if (notEmpty) {
                AppFileFlowLockHelper.showFlowLockInfoPage((Long)clickId, (IFormView)this.getView());
            }
        }
    }

    private void clickSimilarColumn(Long appFileId) {
        DynamicObject appFile;
        long stdRsmId;
        Map currSuspectDataMap;
        String suspectDataStr = this.getPageCache().get(COL_SIMILARRES);
        if (HRStringUtils.isNotEmpty((String)suspectDataStr) && Boolean.TRUE.equals((currSuspectDataMap = (Map)SerializationUtils.fromJsonString((String)suspectDataStr, Map.class)).get(String.valueOf(stdRsmId = (appFile = AppFileHelper.queryOne((long)appFileId)).getLong("stdrsm.id"))))) {
            AppFileSRHelper.showSimilarPage((Long)appFileId, (IFormView)this.getView());
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        final BillList billList = (BillList)this.getControl("billlistap");
        final ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                AppFileList.this.handleOpBtnsAndFields();
                this.loadOtherMustFields();
                this.setColumnVisible();
                return super.getData(start, limit);
            }

            private void setColumnVisible() {
                List listFieldsControlColumns;
                if (!(listShowParameter.isLookUp() || AppFileList.this.colMap.isEmpty() || (listFieldsControlColumns = billList.getListFieldsControlColumns()) != null && !listFieldsControlColumns.isEmpty())) {
                    AppFileListHelper.setListFieldVisible((BillList)billList, (Map)AppFileList.this.colMap);
                }
            }

            private void loadOtherMustFields() {
                ListField posName = new ListField(AppFileList.FIELD_POSITION_NAME);
                posName.setFieldName(AppFileList.FIELD_POSITION_NAME);
                this.getListFields().add(posName);
                ListField posNumber = new ListField(AppFileList.FIELD_POSITION_NUMBER);
                posNumber.setFieldName(AppFileList.FIELD_POSITION_NUMBER);
                this.getListFields().add(posNumber);
                ListField stdRsmId = new ListField(AppFileList.KEY_STDRSM_DATASTATUS);
                stdRsmId.setFieldName(AppFileList.KEY_STDRSM_DATASTATUS);
                this.getListFields().add(stdRsmId);
                for (String field : FILTER_FIELDS) {
                    ListField listField = new ListField(field);
                    listField.setFieldName(field);
                    this.getListFields().add(listField);
                }
            }
        });
    }

    public void afterBindData(EventObject evt) {
        logger.info("AppFileList.beforePackageData.start->{}");
        this.setOperationBtnVisible();
    }

    private void setOperationBtnVisible() {
        this.getView().setVisible(Boolean.FALSE, ((Collection)this.operationVisibleTuple.getRight()).toArray(new String[0]));
        this.getView().setVisible(Boolean.TRUE, ((Collection)this.operationVisibleTuple.getLeft()).toArray(new String[0]));
        boolean hasAddRsm = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.OPENFILLRESADD.getCtrlKey());
        boolean showAnalysisRsm = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.ANALYSISRESADD.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasAddRsm && showAnalysisRsm), new String[]{"baranalysisresadd1"});
        Boolean hasAddTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.ADDTAG.getCtrlKey());
        Boolean showRmTag = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.REMOVETAG.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasAddTag != false && showRmTag != false), new String[]{"barremovetag1"});
        Boolean hasTpTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.TRANSFERPOS.getCtrlKey());
        Boolean showSaveTalentTag = ((Collection)this.operationVisibleTuple.getLeft()).contains(AppFileOperateEnum.SAVETALENT.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasTpTag != false && showSaveTalentTag != false), new String[]{"barsavetalent1"});
        boolean hasHireOkTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIRERECOMEND.getCtrlKey());
        boolean hasHireJobRankTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIREJOBRANK.getCtrlKey());
        boolean hasHireSalaryTag = ((Collection)this.operationVisibleTuple.getRight()).contains(AppFileOperateEnum.HIRESALARY.getCtrlKey());
        this.getView().setVisible(Boolean.valueOf(hasHireOkTag && !hasHireJobRankTag), new String[]{"barhirejobrank1"});
        this.getView().setVisible(Boolean.valueOf(hasHireOkTag && hasHireJobRankTag && !hasHireSalaryTag), new String[]{"barhiresalary1"});
    }

    private void handleOpBtnsAndFields() {
        long[] procInfoArr = AppFileListHelper.getProcIdAndStgId((AbstractListPlugin)this);
        long procId = procInfoArr[0];
        long stgId = procInfoArr[1];
        AppFileListHelper.handleOperateBtnAndField((long)procId, (long)stgId, this.colMap, this.operationVisibleTuple);
    }

    private static /* synthetic */ void lambda$registerListener$0(AbstractListPlugin listPlugin, BillList billList, ListFieldsControlEvent evt) {
        long[] procInfoArr = AppFileListHelper.getProcIdAndStgId((AbstractListPlugin)listPlugin);
        HashMap tplAllColMap = Maps.newHashMapWithExpectedSize((int)128);
        AppFileListHelper.handleFieldVisible((long)procInfoArr[0], (long)procInfoArr[1], (Map)tplAllColMap);
        AppFileListHelper.setListFieldVisible((BillList)billList, (Map)tplAllColMap);
    }
}

