/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListGridView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileRightHelper;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.collections.CollectionUtils;

public class AppFileListF7Plugin
extends AbstractListPlugin {
    private static final String IMAGES_PERSON = "/images/pc/emotion/default_person_82_82.png";
    private static final String KEY_LISTTYPE = "listtype";
    private static final String KEY_METHODNAME = "methodname";
    private static final String KEY_SELECTED_ROWS = "billlistap_lsrc";
    private static final String KEY_SELECT_ROW = "selectrow";
    private static final String HIRE_APPROVAL = "tsirm_hireapprovalsg";
    private static final String UNF_PERSON_INFO = "tsirm_unifpersoninfo";

    public void preOpenForm(PreOpenFormEventArgs ee) {
        boolean hasRight;
        super.preOpenForm(ee);
        Long userId = TSCRequestContext.getUserId();
        HasPermOrgResult managePermResult = AppFileRightHelper.getManagePermResult((String)"47150e89000000ac", (Long)userId);
        HasPermOrgResult myChargePermResult = AppFileRightHelper.getMyChargePermResult((String)"47150e89000000ac", (Long)userId);
        Object isMyCharge = ee.getFormShowParameter().getCustomParam("chanrgrange");
        if ("1".equals(isMyCharge)) {
            hasRight = myChargePermResult.hasAllOrgPerm() || !myChargePermResult.getHasPermOrgs().isEmpty();
        } else if ("0".equals(isMyCharge)) {
            hasRight = managePermResult.hasAllOrgPerm() || !managePermResult.getHasPermOrgs().isEmpty();
        } else {
            boolean bl = hasRight = managePermResult.hasAllOrgPerm() || !managePermResult.getHasPermOrgs().isEmpty() || !myChargePermResult.getHasPermOrgs().isEmpty();
        }
        if (!hasRight) {
            ee.setCancel(true);
            ee.setCancelMessage(ResManager.loadKDString((String)"\u60a8\u6682\u65e0\u5019\u9009\u4eba\u5217\u8868\u7684\u83dc\u5355\u6743\u9650", (String)"AppFileListF7Plugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap listTypeMap = Maps.newLinkedHashMap();
        if (managePermResult.hasAllOrgPerm() || !managePermResult.getHasPermOrgs().isEmpty()) {
            listTypeMap.put("0", ResManager.loadKDString((String)"\u5168\u90e8\u5019\u9009\u4eba", (String)"AppFileListF7Plugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        if (myChargePermResult.hasAllOrgPerm() || !myChargePermResult.getHasPermOrgs().isEmpty()) {
            listTypeMap.put("1", ResManager.loadKDString((String)"\u6211\u4ea4\u4ed8\u7684\u5019\u9009\u4eba", (String)"AppFileListF7Plugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        ee.getFormShowParameter().setCustomParam(KEY_LISTTYPE, (Object)listTypeMap);
    }

    public void registerListener(EventObject ee) {
        super.registerListener(ee);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter = new QFilter("filestatus", "!=", (Object)AppFileConstants.APP_FILE_STATUS_EXPIRED);
        event.setCustomQFilters(Arrays.asList(qFilter.toArray()));
    }

    public void afterCreateNewData(EventObject ee) {
        ComboEdit listType = (ComboEdit)this.getControl(KEY_LISTTYPE);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map listTypeMap = (Map)formShowParameter.getCustomParam(KEY_LISTTYPE);
        if (!listTypeMap.isEmpty()) {
            ArrayList comboItemList = Lists.newArrayListWithExpectedSize((int)listTypeMap.size());
            for (Map.Entry entry : listTypeMap.entrySet()) {
                ComboItem item = new ComboItem();
                item.setValue((String)entry.getKey());
                item.setCaption(new LocaleString((String)entry.getValue()));
                comboItemList.add(item);
            }
            listType.setComboItems((List)comboItemList);
            String isMyCharge = (String)formShowParameter.getCustomParam("chanrgrange");
            isMyCharge = isMyCharge == null ? (String)listTypeMap.keySet().iterator().next() : isMyCharge;
            this.getModel().setValue(KEY_LISTTYPE, (Object)isMyCharge);
            this.getView().getPageCache().put("chanrgrange", isMyCharge);
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                return;
            }
            this.setSelectRow(parentView);
        }
    }

    private List<Long> setSelectRow(IFormView parentView) {
        ArrayList<Long> selectRowList = new ArrayList<Long>();
        if (HIRE_APPROVAL.equals(parentView.getEntityId())) {
            DynamicObject appFile = parentView.getModel().getDataEntity(true).getDynamicObject("appfile");
            if (null != appFile) {
                ((ListShowParameter)this.getView().getFormShowParameter()).setSelectedRows(new Object[]{appFile.getPkValue()});
                selectRowList.add(appFile.getLong("id"));
            }
        } else if (UNF_PERSON_INFO.equals(parentView.getEntityId())) {
            IDataModel model = parentView.getModel();
            Optional.ofNullable(model).filter(parentModel -> parentModel.getValue("subentryentity") != null).flatMap(pModel -> Optional.ofNullable((DynamicObjectCollection)pModel.getValue("subentryentity")).filter(collection -> collection.size() > 0)).ifPresent(subCollection -> subCollection.forEach(appFile -> {
                if (null == appFile || selectRowList.contains(appFile.getLong("appresid"))) {
                    return;
                }
                selectRowList.add(appFile.getLong("appresid"));
            }));
            Optional.of(selectRowList).filter(selectRows -> selectRows.size() > 0).ifPresent(list -> ((ListShowParameter)this.getView().getFormShowParameter()).setSelectedRows(list.toArray()));
        }
        return selectRowList;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control ctrl = (Control)evt.getSource();
        if ("btnok".equals(ctrl.getKey())) {
            Object maxSelectNumberObj = this.getView().getFormShowParameter().getCustomParam("maxSelectNumber");
            if (maxSelectNumberObj != null) {
                int maxSelectNumber = Integer.parseInt(maxSelectNumberObj.toString());
                evt.setCancel(AppFileListHelper.handleOutMaxSelectNum((AbstractListPlugin)this, (int)maxSelectNumber));
                return;
            }
            ListSelectedRowCollection selectedRows = this.beforeOkClick();
            if (selectedRows.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u4f4d\u5019\u9009\u4eba\u3002", (String)"AppFileListF7Plugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    private ListSelectedRowCollection beforeOkClick() {
        BillList billList = (BillList)this.getControl("billlistap");
        if (null == billList) {
            return new ListSelectedRowCollection();
        }
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        String selectRow = this.getPageCache().get(KEY_SELECT_ROW);
        if (HRStringUtils.isBlank((CharSequence)selectRow)) {
            return selectedRows;
        }
        List selectedRowIds = (List)SerializationUtils.fromJsonString((String)selectRow, ArrayList.class);
        if (CollectionUtils.isEmpty((Collection)selectedRowIds)) {
            selectedRows.clear();
        } else {
            List collect = selectedRows.stream().filter(row -> !selectedRowIds.contains(row.getPrimaryKeyValue())).collect(Collectors.toList());
            selectedRows.removeAll(collect);
        }
        return selectedRows;
    }

    public void beforeBindData(EventObject ee) {
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        BillList billList = (BillList)this.getControl("billlistap");
        for (Control item : billList.getItems()) {
            if (!(item instanceof ListGridView)) continue;
            ListGridView gridView = (ListGridView)item;
            gridView.setDetailEntry(false);
            gridView.setFormDetailId("");
        }
        String listType = dataEntity.getString(KEY_LISTTYPE);
        if ("1".equals(listType)) {
            formShowParameter.setBillFormId("tsirm_appfile_viewc");
        } else {
            formShowParameter.setBillFormId("tsirm_appfile_viewm");
        }
        this.getView().getPageCache().put("chanrgrange", listType);
        this.getView().cacheFormShowParameter();
    }

    public void afterBindData(EventObject ee) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        List<Long> selectPkIds = this.setSelectRow(parentView);
        this.getPageCache().put(KEY_SELECT_ROW, SerializationUtils.toJsonString(selectPkIds));
        List<Map<String, Object>> returnList = this.getCustomControlItems(selectPkIds);
        this.setItems(returnList);
    }

    public void propertyChanged(PropertyChangedArgs ee) {
        if (KEY_LISTTYPE.equals(ee.getProperty().getName())) {
            BillList billList = (BillList)this.getControl("billlistap");
            String lastSelectedRows = this.getPageCache().get("lastSelectedRows");
            this.getPageCache().put("lastSelectedRows", this.getListSelectedRowCollectionByPart().serialize());
            if (HRStringUtils.isNotEmpty((String)lastSelectedRows)) {
                this.putListSelectedRowCollectionByPart(ListSelectedRowCollection.deSerialize((String)lastSelectedRows));
            }
            billList.refresh();
        }
    }

    public void customEvent(CustomEventArgs customEventArgs) {
        this.handleCustomEvent(customEventArgs);
    }

    public void listRowClick(ListRowClickEvent listRowClickEvent) {
        this.addItems();
    }

    private List<Map<String, Object>> getCustomControlItems(List<Long> selectRowPkIds) {
        Map selectDataMap = AppFileDataHelper.getAppFileNameAndPhotoMap(selectRowPkIds);
        ArrayList<Map<String, Object>> returnList = new ArrayList<Map<String, Object>>(selectRowPkIds.size());
        for (Long pkId : selectRowPkIds) {
            DynamicObject appFile = (DynamicObject)selectDataMap.get(pkId);
            if (appFile == null) continue;
            HashMap returnData = Maps.newHashMapWithExpectedSize((int)3);
            String photo = String.valueOf(appFile.get("appres.photo"));
            returnData.put("value", appFile.getString("id"));
            returnData.put("text", appFile.getString("name"));
            returnData.put("path", HRStringUtils.isNotEmpty((String)photo) ? photo : IMAGES_PERSON);
            returnList.add(returnData);
        }
        return returnList;
    }

    private void handleCustomEvent(CustomEventArgs customEventArgs) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String eventName = customEventArgs.getEventName();
        String argsStr = customEventArgs.getEventArgs();
        ListView listView = (ListView)customEventArgs.getSource();
        ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
        if ("removeItem".equals(eventName)) {
            List pkIdsStrList = (List)SerializationUtils.fromJsonString((String)argsStr, List.class);
            Set rmIdSet = pkIdsStrList.stream().map(Long::valueOf).collect(Collectors.toSet());
            Set currPagePkSet = listView.getCurrentListAllRowCollection().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            int[] selRows = listSelectedRows.stream().filter(row -> currPagePkSet.contains(row.getPrimaryKeyValue()) && !rmIdSet.contains(row.getPrimaryKeyValue())).mapToInt(ListSelectedRow::getRowKey).toArray();
            billList.selectRows(selRows);
            listSelectedRows.removeIf(row -> rmIdSet.contains(row.getPrimaryKeyValue()));
            List result = listSelectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
            this.getPageCache().put(KEY_SELECTED_ROWS, result.isEmpty() ? "0" : "1");
            this.getPageCache().put(KEY_SELECT_ROW, SerializationUtils.toJsonString(result));
            this.removeItem(pkIdsStrList);
        } else if ("removeAllItems".equals(eventName)) {
            this.getPageCache().put(KEY_SELECT_ROW, SerializationUtils.toJsonString((Object)CollectionUtils.EMPTY_COLLECTION));
            listView.clearSelection();
            this.removeAllItems();
        }
    }

    private void removeItem(List<String> pkIds) {
        CustomControl f7Person = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put(KEY_METHODNAME, "removeItem");
        map.put("args", pkIds);
        f7Person.setData((Object)map);
    }

    private void removeAllItems() {
        CustomControl f7Person = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap map = Maps.newHashMap();
        map.put(KEY_METHODNAME, "removeAllItems");
        f7Person.setData((Object)map);
    }

    private void addItems() {
        ListSelectedRowCollection selectedRows = this.getListSelectedRowCollectionByPart();
        List<Long> selectPkIds = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        this.getPageCache().put(KEY_SELECT_ROW, SerializationUtils.toJsonString(selectPkIds));
        List<Map<String, Object>> returnList = this.getCustomControlItems(selectPkIds);
        this.setItems(returnList);
    }

    private ListSelectedRowCollection afterBindSelectRow() {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        DynamicObject appFile = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObject("appfile");
        if (null != appFile) {
            ((ListShowParameter)this.getView().getFormShowParameter()).setSelectedRows(new Object[]{appFile.getPkValue()});
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            listSelectedRow.setPrimaryKeyValue(appFile.getPkValue());
            listSelectedRows.add((Object)listSelectedRow);
        }
        return listSelectedRows;
    }

    private void setItems(List<Map<String, Object>> returnList) {
        CustomControl cusCtl = (CustomControl)this.getView().getControl("customcontrolap");
        HashMap itemsMap = Maps.newHashMap();
        itemsMap.put("items", returnList);
        ArrayList itemsList = Lists.newArrayList((Object[])new Map[]{itemsMap});
        HashMap customControlDataMap = Maps.newHashMap();
        customControlDataMap.put(KEY_METHODNAME, "addItems");
        customControlDataMap.put("args", itemsList);
        cusCtl.setData((Object)customControlDataMap);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = formShowParameter.getBillFormId();
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId(billFormId);
        baseShowParameter.setPkId(this.getFocusRowPkId());
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private ListSelectedRowCollection getListSelectedRowCollectionByPart() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows;
    }

    private void putListSelectedRowCollectionByPart(ListSelectedRowCollection listSelectedRowCollection) {
        String lsrcStr = this.getPageCache().get(KEY_SELECTED_ROWS);
        if (HRStringUtils.isEmpty((String)lsrcStr)) {
            return;
        }
        if (lsrcStr.startsWith("[")) {
            this.getPageCache().put(KEY_SELECTED_ROWS, listSelectedRowCollection.serialize());
            return;
        }
        ListSelectedRowCollection listSelectedRowCollection2 = new ListSelectedRowCollection();
        int size = listSelectedRowCollection.size();
        this.getPageCache().put(KEY_SELECTED_ROWS, Integer.toString(size / 1000 + (size % 1000 == 0 ? 0 : 1)));
        for (int i = 1; i <= size; ++i) {
            listSelectedRowCollection2.add((Object)listSelectedRowCollection.get(i - 1));
            if (i % 1000 != 0) continue;
            this.getPageCache().put("billlistap_lsrc_" + i / 1000, listSelectedRowCollection2.serialize());
            listSelectedRowCollection2 = new ListSelectedRowCollection();
        }
        if (size % 1000 != 0) {
            this.getPageCache().put("billlistap_lsrc_" + (size / 1000 + 1), listSelectedRowCollection2.serialize());
        }
    }
}

