/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.list;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListViewDetailHelper;
import kd.tsc.tsirm.business.domain.appfile.list.entity.AppFileListDetailViewVO;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileFilterHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RsmHelper;

public class AppFileListViewDetailList
extends AbstractFormPlugin
implements ClickListener {
    public void afterCreateNewData(EventObject evt) {
        String pkId = (String)this.getView().getFormShowParameter().getCustomParam("pkId");
        String childViewsStr = this.getView().getParentView().getPageCache().get("childviews");
        Map childViews = HRStringUtils.isNotEmpty((String)childViewsStr) ? (Map)SerializationUtils.fromJsonString((String)childViewsStr, Map.class) : Maps.newHashMap();
        if (!HRObjectUtils.equals(childViews.get(pkId), (Object)this.getView().getFormShowParameter().getPageId())) {
            childViews.put(pkId, this.getView().getFormShowParameter().getPageId());
            this.getView().getParentView().getPageCache().put("childviews", SerializationUtils.toJsonString(childViews));
        }
    }

    public void afterBindData(EventObject evt) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Long pkId = Long.valueOf((String)parameter.getCustomParam("pkId"));
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            DynamicObject resumeFilterTask;
            ListView parentListView = (ListView)parentView;
            if (parentListView.getBillFormId().startsWith("tsirm_appfile_view")) {
                DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)pkId);
                pkId = appFile.getLong("appres.id");
            } else if ("tsirm_resumefilterir".equals(parentListView.getBillFormId())) {
                resumeFilterTask = AppFileFilterHelper.queryOneResumeFilterTaskByPk((Object)pkId);
                if (resumeFilterTask != null) {
                    pkId = resumeFilterTask.getDynamicObject("appfile").getLong("id");
                    DynamicObject appFile = AppFileDataHelper.queryAppFileById((Object)pkId);
                    pkId = appFile.getLong("appres.id");
                }
            } else if ("tsirm_rsm_unallocated".equals(parentListView.getBillFormId())) {
                resumeFilterTask = RsmHelper.findOne((long)pkId);
            }
            AppFileListDetailViewVO appFileListDetailViewVO = AppFileListViewDetailHelper.getAppFileListDetailViewVOByAppRsmId((Long)pkId);
            if (appFileListDetailViewVO == null) {
                return;
            }
            this.setValToView(appFileListDetailViewVO);
        }
    }

    private void setValToView(AppFileListDetailViewVO appFileListDetailViewVO) {
        this.handleHide(appFileListDetailViewVO);
        Image head = (Image)this.getControl("headaddress");
        if (HRStringUtils.isNotEmpty((String)appFileListDetailViewVO.getHeadAddress())) {
            head.setUrl(HRImageUrlUtil.getImageFullUrl((String)appFileListDetailViewVO.getHeadAddress()));
        }
        Label sexLab = (Label)this.getControl("basemsgsex");
        sexLab.setText(appFileListDetailViewVO.getSex());
        Label ageLab = (Label)this.getControl("basemsgage");
        ageLab.setText(appFileListDetailViewVO.getAge());
        Label expLab = (Label)this.getControl("basemsgexp");
        expLab.setText(appFileListDetailViewVO.getWorkYears());
        Label schoolLab = (Label)this.getControl("educationschool");
        schoolLab.setText(appFileListDetailViewVO.getSchool());
        Label majorLab = (Label)this.getControl("educationmajor");
        majorLab.setText(appFileListDetailViewVO.getMajor());
        Label degreeLab = (Label)this.getControl("educationdegree");
        degreeLab.setText(appFileListDetailViewVO.getDegree());
        Label firstNameLab = (Label)this.getControl("companyfirstname");
        firstNameLab.setText(appFileListDetailViewVO.getCompanyNameFirst());
        Label firstPositionLab = (Label)this.getControl("companyfirstposition");
        firstPositionLab.setText(appFileListDetailViewVO.getPositionFirst());
        Label firstTimeLab = (Label)this.getControl("companyfirsttime");
        firstTimeLab.setText(appFileListDetailViewVO.getWorkTimeFirst());
        Label firstCountLab = (Label)this.getControl("companyfirstcount");
        firstCountLab.setText(appFileListDetailViewVO.getWorkTimeCountFirst());
        Label secondNameLab = (Label)this.getControl("companysecondname");
        secondNameLab.setText(appFileListDetailViewVO.getCompanyNameSecond());
        Label secondPositionLab = (Label)this.getControl("companysecondposition");
        secondPositionLab.setText(appFileListDetailViewVO.getPositionSecond());
        Label secondTimeLab = (Label)this.getControl("companysecondtime");
        secondTimeLab.setText(appFileListDetailViewVO.getWorkTimeSecond());
        Label secondCountLab = (Label)this.getControl("companysecondcount");
        secondCountLab.setText(appFileListDetailViewVO.getWorkTimeCountSecond());
    }

    private void handleHide(AppFileListDetailViewVO appFileListDetailViewVO) {
        if (appFileListDetailViewVO == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"basemsgsex", "basemsgage", "basemsgexp", "educationschool", "educationmajor", "educationdegree", "companyfirstname", "companyfirstposition", "companyfirsttime", "companyfirstcount", "companysecondname", "companysecondposition", "companysecondtime", "companysecondcount"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getSex())), new String[]{"basemsgsex"});
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getAge())), new String[]{"basemsgage"});
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getWorkYears())), new String[]{"basemsgexp"});
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getSchool())), new String[]{"educationschool"});
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getMajor())), new String[]{"educationmajor"});
        this.getView().setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)appFileListDetailViewVO.getDegree())), new String[]{"educationdegree"});
    }
}

