/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.list;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Set;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFilePermissionHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.operation.AppFileOperateService;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;

public class AppFileOpList
extends HRCoreBaseList {
    private static final Set<String> OPEN_PAGE_OPS = Sets.newHashSet((Object[])new String[]{"eliminateright", "changestageright", "transferposright", "archiveright"});

    public void registerListener(EventObject object) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        AppFileListHelper.validateCurrOpIsExist((AbstractListPlugin)this, (BeforeItemClickEvent)evt);
    }

    public void itemClick(ItemClickEvent evt) {
        AppFileOperateService.getInstance().handleItemClick((AbstractFormPlugin)this, evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        if (evt.isCancel()) {
            return;
        }
        AppFileOperateService.getInstance().handleOperateBefore((AbstractFormPlugin)this, evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        AppFileOperateService.getInstance().handleOperateAfter((AbstractFormPlugin)this, afterDoOperationEventArgs);
        if (OPEN_PAGE_OPS.contains(afterDoOperationEventArgs.getOperateKey()) && !afterDoOperationEventArgs.getOperationResult().isSuccess() && !afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().isEmpty()) {
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
        }
        this.getPageCache().put(AppFileListConstants.KEY_OPERATE_NAME, ((FormOperate)afterDoOperationEventArgs.getSource()).getOperateName().getLocaleValue());
        if (afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess() && "recover".equals(afterDoOperationEventArgs.getOperateKey())) {
            ((IListView)this.getView()).clearSelection();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (!AppFilePermissionHelper.handleCloseCallBckPermission((AbstractFormPlugin)this, (ClosedCallBackEvent)closedCallBackEvent, (ListSelectedRowCollection)this.getSelectedRows())) {
            return;
        }
        AppFileOperateService.getInstance().handleOperateCloseCallBack((AbstractFormPlugin)this, closedCallBackEvent);
        ((IListView)this.getView()).clearSelection();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (!AppFilePermissionHelper.handleConfirmCallBckPermission((AbstractFormPlugin)this, (MessageBoxClosedEvent)messageBoxClosedEvent, (ListSelectedRowCollection)this.getSelectedRows())) {
            return;
        }
        AppFileOpHelper.handleConfirmCallBack((MessageBoxClosedEvent)messageBoxClosedEvent, (AbstractFormPlugin)this);
        ((IListView)this.getView()).clearSelection();
    }

    protected void reload() {
        super.reload();
        AppFileListHelper.refreshChildViews((AbstractListPlugin)this);
    }
}

