/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.list;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterKeyValueCollection;
import kd.bos.entity.filter.FilterKeyValueCollections;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.business.domain.appfile.AppFileFlowLockHelper;
import kd.tsc.tsirm.business.domain.appfile.list.AppFileListHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileHomePageHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppProHomePageHelper;
import kd.tsc.tsirm.business.domain.position.service.enums.PositionPermEnum;
import kd.tsc.tsirm.business.domain.position.service.permission.PositionPermService;
import kd.tsc.tsirm.common.constants.appfile.AppFileConstants;
import kd.tsc.tsirm.common.constants.appfile.AppFileListConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.ListViewUtils;
import kd.tsc.tsrbs.common.utils.TSCBaseUtils;
import org.apache.commons.lang3.ObjectUtils;

public class AppFileSearchList
extends HRCoreBaseList
implements BeforeFilterF7SelectListener {
    private static final Log log = LogFactory.getLog(AppFileSearchList.class);
    public static final String KEY_LASTFILTERDATA = "lastFilterData";
    private static final String KEY_POSITION_ID = "position.id";
    private static final Map<Integer, QueryAppFileIdsFunction> GEN_DEF_QUERY_MAP = Maps.newHashMap();
    private static final Map<Integer, QueryAppFileIdsFunction> GEN_DEF_PRO_QUERY_MAP;
    private long positionId = 0L;
    private long stgId = 0L;
    private final Map<String, List<Object>> filterDataMap = new HashMap<String, List<Object>>(16);
    private Map<String, List<Object>> lastFilterDataMap = new HashMap<String, List<Object>>(16);
    private List<Long> currFilterStgIds;
    private List<Long> currFilterStatusIds;

    public void registerListener(EventObject evt) {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        if (fc != null) {
            fc.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey()) || "openfillresadd".equals(operate.getOperateKey()) || "analysisresadd".equals(operate.getOperateKey())) {
            this.getView().getPageCache().remove("defaultQFilter");
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        if (0L == this.positionId) {
            Object objPositionId = this.getView().getFormShowParameter().getCustomParam(AppFileListConstants.DEFAULT_FILTER_POSITION_ID);
            this.positionId = null == objPositionId ? 0L : Long.parseLong(objPositionId.toString());
        }
        switch (args.getFieldName()) {
            case "recrustg.name": {
                this.clearStage(args);
                break;
            }
            case "recrustat.name": {
                this.clearPosAndStageFilter(args);
                break;
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        long sTime = System.currentTimeMillis();
        this.addPositionFilterColumn(args);
        this.setCommonFilterColumnsDefaultValue(args);
        this.setDefaultValueToFilterValueMap(args);
        this.setCommonStgFilterItems(args);
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.filterContainerInit.duration->{}", (Object)(eTime - sTime));
    }

    public void beforeBindData(EventObject evt) {
        if (this.filterDataMap.isEmpty()) {
            this.handleFilterValues();
        }
        AppFileListHelper.putProcInfoToCache((AbstractListPlugin)this, (long)this.positionId, (long)this.stgId);
    }

    public void setFilter(SetFilterEvent evt) {
        evt.setOrderBy("enterlinktime DESC");
        if (this.positionId != 0L) {
            QFilter positionQFilter = new QFilter(KEY_POSITION_ID, "=", (Object)this.positionId);
            evt.getQFilters().add(positionQFilter);
        }
        evt.getQFilters().removeIf(qFilter -> qFilter == null || "chanrgrange".equals(qFilter.getProperty()) || "candidatelabel.id".equals(qFilter.getProperty()) || AppFileListConstants.KEY_WORKINGYEARSCOMBO.equals(qFilter.getProperty()));
        AppFileSearchList.handleSchemeFilter(evt);
        this.handleCommonFilter(evt);
        String defaultQFilterStr = this.getView().getPageCache().get("defaultQFilter");
        this.getView().getPageCache().remove("defaultQFilter");
        if (HRStringUtils.isNotEmpty((String)defaultQFilterStr)) {
            QFilter defaultQFilter = QFilter.fromSerializedString((String)defaultQFilterStr);
            evt.getQFilters().add(defaultQFilter);
        }
        this.handleMyHandFilter(evt);
        boolean lookUp = ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
        if (lookUp) {
            evt.getQFilters().add(new QFilter("id", "not in", (Object)AppFileFlowLockHelper.getGrayLockAppFileIdList()));
        }
    }

    private void setDefaultValueToFilterValueMap(FilterContainerInitArgs args) {
        Integer queryType;
        long sTime = System.currentTimeMillis();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (this.filterDataMap.isEmpty()) {
            for (FilterColumn commonFilterColumn : args.getCommonFilterColumns()) {
                this.filterDataMap.put(commonFilterColumn.getFilterField().getFieldName(), commonFilterColumn.getDefaultValues());
            }
            this.getPositionIdAndStgId();
            this.getPageCache().put(KEY_LASTFILTERDATA, SerializationUtils.toJsonString(this.filterDataMap));
        }
        if ((queryType = (Integer)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_QUERY_TYPE)) != null) {
            Long recruitProcId = Long.parseLong((String)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_RECRUIT_PROC_ID));
            String timeRangeType = (String)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_TIME_RANG_TYPE);
            boolean isOwner = (Boolean)formShowParameter.getCustomParam(AppFileListConstants.CUSTOM_FILTER_IS_OWNER);
            ArrayList<Long> orgIds = new ArrayList<Long>();
            if (formShowParameter.getCustomParam("orgId") != null) {
                orgIds.add(Long.parseLong((String)formShowParameter.getCustomParam("orgId")));
            }
            if (formShowParameter.getCustomParam("orgIds") != null) {
                List orgObjIds = (List)formShowParameter.getCustomParam("orgIds");
                for (Object orgId : orgObjIds) {
                    orgIds.add(Long.parseLong(String.valueOf(orgId)));
                }
            }
            QFilter queryQFilter = AppFileSearchList.generateQFilterByParams(isOwner, recruitProcId, timeRangeType, orgIds, queryType);
            this.getView().getPageCache().put("defaultQFilter", queryQFilter.toSerializedString());
            formShowParameter.getCustomParams().remove(AppFileListConstants.CUSTOM_FILTER_QUERY_TYPE);
            this.getView().cacheFormShowParameter();
        }
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.setDefaultValueToFilterValueMap.duration->{}", (Object)(eTime - sTime));
    }

    private static QFilter generateQFilterByParams(boolean isOwner, Long recruitProcId, String timeRangeType, List<Long> orgIds, Integer queryType) {
        Collection<Object> appFileIds;
        if (queryType > 100) {
            QueryAppFileIdsFunction queryAppFileIdsFunction = GEN_DEF_PRO_QUERY_MAP.get(queryType);
            if (queryAppFileIdsFunction != null) {
                List positionIds = AppFilePositionHelper.getPositionIdsRightRecruing((String)"position", (boolean)isOwner, orgIds);
                appFileIds = queryAppFileIdsFunction.queryAppFileIds(isOwner, recruitProcId, timeRangeType, positionIds);
            } else {
                appFileIds = Sets.newHashSet();
            }
        } else {
            QueryAppFileIdsFunction queryAppFileIdsFunction = GEN_DEF_QUERY_MAP.get(queryType);
            appFileIds = queryAppFileIdsFunction != null ? queryAppFileIdsFunction.queryAppFileIds(isOwner, recruitProcId, timeRangeType, orgIds) : Sets.newHashSet();
        }
        return new QFilter("id", "in", (Object)appFileIds);
    }

    private void addPositionFilterColumn(FilterContainerInitArgs args) {
        long sTime = System.currentTimeMillis();
        List commonFilterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        CommonBaseDataFilterColumn positionColumn = new CommonBaseDataFilterColumn();
        positionColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e94\u8058\u804c\u4f4d", (String)"AppFileSearchList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        positionColumn.setFieldName(KEY_POSITION_ID);
        positionColumn.setEntityField(false);
        positionColumn.setDefaultValue("");
        positionColumn.setEntityType(EntityMetadataCache.getDataEntityType((String)"tsirm_appfile_view"));
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(16);
        this.setPositionFilterColItems(combos);
        positionColumn.setComboItems(combos);
        positionColumn.setType("enum");
        int pos = 0;
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            ++pos;
            if (!"position.positionstatus".equals(commonFilterColumn.getFieldName())) continue;
            break;
        }
        commonFilterColumns.add(pos, positionColumn);
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.addPositionFilterColumn.duration->{}", (Object)(eTime - sTime));
    }

    private QFilter setPositionFilter() {
        ImmutableList positionPermEnums = null;
        if (!this.getIsMyCharge()) {
            positionPermEnums = ImmutableList.of((Object)PositionPermEnum.ADMIN_ORG, (Object)PositionPermEnum.ORG, (Object)PositionPermEnum.SEV_LEVEL);
        } else if (this.getIsMyCharge()) {
            positionPermEnums = ImmutableList.of((Object)PositionPermEnum.DELIVERY);
        }
        QFilter positionQFilter = PositionPermService.getInstance((List)positionPermEnums).getHavePermPositionQFilter();
        QFilter rootQFilter = new QFilter("positionstatus", "in", (Object)new String[]{"A", "C", "D", "G"});
        if (positionQFilter == null) {
            positionQFilter = rootQFilter;
        } else {
            positionQFilter.and(rootQFilter);
        }
        return positionQFilter;
    }

    private void setPositionFilterColItems(List<ComboItem> combos) {
        long sTime = System.currentTimeMillis();
        QFilter positionQFilter = this.setPositionFilter();
        log.info("AppFileSearchList.setPositionFilterColItems.before.query.position->{}", (Object)System.currentTimeMillis());
        DynamicObject[] positions = AppFilePositionHelper.queryPositions((QFilter)positionQFilter);
        log.info("AppFileSearchList.setPositionFilterColItems.end.query.position->{}", (Object)System.currentTimeMillis());
        if (ObjectUtils.isNotEmpty((Object)positions)) {
            log.info("AppFileSearchList.setPositionFilterColItems.positions.length->{}", (Object)positions.length);
        }
        for (DynamicObject position : positions) {
            ComboItem item = new ComboItem();
            String posNumber = position.getString("number");
            String fullPosName = "";
            if (!HRStringUtils.isEmpty((String)posNumber)) {
                fullPosName = posNumber.substring(5) + "-" + position.getString("name");
            }
            item.setCaption(new LocaleString(fullPosName));
            item.setValue(position.getString("id"));
            combos.add(item);
        }
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.setPositionFilterColItems.duration->{}", (Object)(eTime - sTime));
    }

    private void setCommonFilterColumnsDefaultValue(FilterContainerInitArgs args) {
        long sTime = System.currentTimeMillis();
        List commonFilterColumns = args.getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String positionIdStr = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_POSITION_ID)));
        String positionSkip = (String)formShowParameter.getCustomParam("positionSkip");
        String statusFilter = (String)formShowParameter.getCustomParam("statusFilter");
        String changeStatus = (String)formShowParameter.getCustomParam("changeStatus");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        if (formShowParameter.getCustomParam("orgId") != null) {
            orgIds.add(formShowParameter.getCustomParam("orgId"));
        }
        if (formShowParameter.getCustomParam("orgIds") != null) {
            List orgIntIds = (List)formShowParameter.getCustomParam("orgIds");
            for (Object orgId : orgIntIds) {
                orgIds.add(String.valueOf(orgId));
            }
        }
        String stgIdStr = TSCBaseUtils.getString((String)((String)formShowParameter.getCustomParam(AppFileListConstants.DEFAULT_FILTER_RECRUSTG_ID)));
        block13: for (FilterColumn commonFilterColumn : commonFilterColumns) {
            switch (commonFilterColumn.getFieldName()) {
                case "createorg.name": {
                    commonFilterColumn.setDefaultValue("");
                    continue block13;
                }
                case "position.id": {
                    commonFilterColumn.setDefaultValue(positionIdStr);
                    continue block13;
                }
                case "recrustg.name": {
                    commonFilterColumn.setDefaultValue(stgIdStr);
                    continue block13;
                }
                case "filestatus": {
                    if (HRStringUtils.isEmpty((String)positionIdStr) && orgIds == null && HRStringUtils.isEmpty((String)stgIdStr)) {
                        commonFilterColumn.setDefaultValue(AppFileConstants.APP_FILE_STATUS_IN);
                    }
                    if (positionSkip != null) {
                        commonFilterColumn.setDefaultValue("");
                    }
                    if (statusFilter != null) {
                        commonFilterColumn.setDefaultValue(statusFilter);
                    }
                    if (changeStatus == null) continue block13;
                    commonFilterColumn.setDefaultValue(changeStatus);
                    continue block13;
                }
            }
            if (commonFilterColumn.getDefaultValues() != null && !commonFilterColumn.getDefaultValues().isEmpty()) continue;
            commonFilterColumn.setDefaultValue("");
        }
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.setCommonFilterColumnsDefaultValue.duration->{}", (Object)(eTime - sTime));
    }

    private void handleMyHandFilter(SetFilterEvent evt) {
        if (this.getIsMyCharge()) {
            Long userId = TSCRequestContext.getUserId();
            String myHandFilterSql = String.format(Locale.ROOT, "select fid from t_tsirm_posprin where fbasedataid = %d", userId);
            evt.getQFilters().add(QFilter.sqlExpress((String)"position.manageinfo", (String)"in", (String)myHandFilterSql));
        }
    }

    private static void handleSchemeFilter(SetFilterEvent evt) {
        for (int i = 0; i < evt.getQFilters().size(); ++i) {
            QFilter qFilter = (QFilter)evt.getQFilters().get(i);
            if (!"candidatelabel.name".equals(qFilter.getProperty())) continue;
            QFilter newCandidateSchameQfilter = AppFileListHelper.getLabelSchemaFilter((QFilter)qFilter);
            evt.getQFilters().set(i, newCandidateSchameQfilter);
            break;
        }
    }

    private void handleCommonFilter(SetFilterEvent evt) {
        List<Object> workingYear;
        List<Object> candidateLabels;
        List<Object> changeRanges = this.filterDataMap.get("chanrgrange");
        if (changeRanges != null && !changeRanges.isEmpty() && "1".equals(changeRanges.get(0))) {
            Long userId = TSCRequestContext.getUserId();
            QFilter chargeQFilter = new QFilter("position.posprin.fbasedataid", "=", (Object)userId);
            evt.getQFilters().add(chargeQFilter);
        }
        if ((candidateLabels = this.filterDataMap.get("candidatelabel.id")) != null && !candidateLabels.isEmpty() && !candidateLabels.get(0).toString().isEmpty()) {
            String labelIdStr = candidateLabels.stream().map(Object::toString).filter(HRStringUtils::isNotEmpty).collect(Collectors.joining(","));
            AppFileListHelper.setCommonLabelQFilter((SetFilterEvent)evt, (String)labelIdStr);
        }
        if ((workingYear = this.filterDataMap.get("workingyearscombo")) != null && !workingYear.isEmpty() && !workingYear.get(0).toString().isEmpty()) {
            String value = workingYear.get(0).toString();
            AppFileListHelper.setWorkingYearsQFilter((SetFilterEvent)evt, (String)value);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent f7SelectEvent) {
        if (KEY_POSITION_ID.equals(f7SelectEvent.getFieldName())) {
            f7SelectEvent.setBillFormId("tsirm_position_f7view");
            f7SelectEvent.getQfilters().add(this.setPositionFilter());
            f7SelectEvent.addCustomParam("hasclose", (Object)true);
        } else if ("recrustg.id".equals(f7SelectEvent.getFieldName())) {
            if (this.positionId != 0L) {
                this.currFilterStgIds = AppFilePositionHelper.queryPosProcStageIdList((long)this.positionId);
                f7SelectEvent.getQfilters().add(new QFilter("id", "in", this.currFilterStgIds));
            } else {
                f7SelectEvent.getQfilters().add(new QFilter("1", "!=", (Object)1));
            }
        } else if ("recrustat.id".equals(f7SelectEvent.getFieldName())) {
            if (this.positionId != 0L && this.stgId != 0L) {
                this.currFilterStatusIds = AppFilePositionHelper.queryPosProcStageStatusIdListNew((long)this.stgId);
                f7SelectEvent.getQfilters().add(new QFilter("id", "in", this.currFilterStatusIds));
            } else {
                f7SelectEvent.getQfilters().add(new QFilter("1", "!=", (Object)1));
            }
        }
    }

    private void positionChargeFilter(QFilter positionQfilter) {
        Long currUserId = TSCRequestContext.getUserId();
        if (this.getIsMyCharge()) {
            positionQfilter.and(new QFilter("manageinfo.posprin.fbasedataid", "=", (Object)currUserId));
        }
    }

    private boolean getIsMyCharge() {
        if ("1".equals(this.getPageCache().get("chanrgrange"))) {
            return true;
        }
        List<Object> changeRanges = this.filterDataMap.get("chanrgrange");
        return AppFileSearchList.isNotEmptyList(changeRanges) && "1".equals(changeRanges.get(0));
    }

    private void clearStage(SetFilterEvent args) {
        if (this.positionId != 0L) {
            this.currFilterStgIds = AppFilePositionHelper.queryPosProcStageIdList((long)this.positionId);
            if (this.currFilterStgIds != null && this.currFilterStgIds.size() > 0 && this.stgId == 0L) {
                this.stgId = this.currFilterStgIds.get(0);
            }
            args.getQFilters().add(new QFilter("id", "in", this.currFilterStgIds));
            args.setOrderBy("createtime");
        } else {
            args.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private void clearPosAndStageFilter(SetFilterEvent args) {
        if (this.positionId != 0L && this.stgId != 0L) {
            this.currFilterStatusIds = AppFilePositionHelper.queryPosProcStageStatusIdListNew((long)this.stgId);
            args.getQFilters().add(new QFilter("id", "in", this.currFilterStatusIds));
            args.setOrderBy("createtime");
        } else {
            args.getQFilters().add(new QFilter("1", "!=", (Object)1));
        }
    }

    private void handleFilterValues() {
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        FilterKeyValueCollections otherFilterValues = fc.getCachedFilterValues().getOtherFilterValues();
        if (otherFilterValues != null) {
            String lastFilterDataJsonStr = this.getPageCache().get(KEY_LASTFILTERDATA);
            if (HRStringUtils.isNotEmpty((String)lastFilterDataJsonStr)) {
                this.lastFilterDataMap = (Map)SerializationUtils.fromJsonString((String)lastFilterDataJsonStr, Map.class);
            }
            if (this.lastFilterDataMap.size() == otherFilterValues.getFilterValueCollection().size()) {
                for (FilterKeyValueCollection filterKeyValueCollection : otherFilterValues.getFilterValueCollection()) {
                    List filterKeyValues = filterKeyValueCollection.getFilterKeyValues();
                    ListViewUtils.handleFilterKeyValue((List)filterKeyValues, this.filterDataMap);
                }
            } else {
                this.filterDataMap.putAll(this.lastFilterDataMap);
            }
            this.clearFilterData();
            this.getPositionIdAndStgId();
            this.getPageCache().put(KEY_LASTFILTERDATA, SerializationUtils.toJsonString(this.filterDataMap));
        }
    }

    private void setCommonStgFilterItems(FilterContainerInitArgs args) {
        long sTime = System.currentTimeMillis();
        if (this.currFilterStgIds != null && !this.currFilterStgIds.isEmpty()) {
            FilterColumn statFilterColumn;
            FilterColumn stgFilterColumn = (FilterColumn)args.getCommonFilterColumns().get(4);
            if (stgFilterColumn instanceof CommonBaseDataFilterColumn && stgFilterColumn.getFieldName().startsWith("recrustg")) {
                CommonBaseDataFilterColumn filterCol = (CommonBaseDataFilterColumn)stgFilterColumn;
                this.filterComboItemSort(filterCol.getComboItems(), this.currFilterStgIds);
            }
            if (this.currFilterStatusIds != null && !this.currFilterStatusIds.isEmpty() && (statFilterColumn = (FilterColumn)args.getCommonFilterColumns().get(4)) instanceof CommonBaseDataFilterColumn && statFilterColumn.getFieldName().startsWith("recrustat")) {
                CommonBaseDataFilterColumn filterCol = (CommonBaseDataFilterColumn)statFilterColumn;
                this.filterComboItemSort(filterCol.getComboItems(), this.currFilterStatusIds);
            }
        }
        long eTime = System.currentTimeMillis();
        log.info("AppFileSearchList.setCommonStgFilterItems.duration->{}", (Object)(eTime - sTime));
    }

    private void filterComboItemSort(List<ComboItem> items, List<Long> sortValues) {
        for (int i = 0; i < sortValues.size(); ++i) {
            for (int j = i + 1; j < items.size(); ++j) {
                if (!sortValues.get(i).toString().equals(items.get(j).getValue())) continue;
                Collections.swap(items, i, j);
            }
        }
    }

    private void getPositionIdAndStgId() {
        String value;
        List<Object> stgObjects;
        String value2;
        List<Object> posObjects = this.filterDataMap.get(KEY_POSITION_ID);
        if (posObjects != null && !posObjects.isEmpty() && HRStringUtils.isNotEmpty((String)(value2 = (String)posObjects.get(0)))) {
            this.positionId = Long.parseLong(value2);
        }
        if ((stgObjects = this.filterDataMap.get("recrustg.id")) != null && !stgObjects.isEmpty() && HRStringUtils.isNotEmpty((String)(value = (String)stgObjects.get(0)))) {
            this.stgId = Long.parseLong(value);
        }
    }

    private void clearFilterData() {
        if (this.lastFilterDataMap != null && !this.lastFilterDataMap.isEmpty()) {
            if (!(HRObjectUtils.equals(this.lastFilterDataMap.get("chanrgrange"), this.filterDataMap.get("chanrgrange")) && HRObjectUtils.equals(this.lastFilterDataMap.get("createorg.id"), this.filterDataMap.get("createorg.id")) && HRObjectUtils.equals(this.lastFilterDataMap.get("adminorg.id"), this.filterDataMap.get("adminorg.id")))) {
                List<Object> positionFilters = this.filterDataMap.get(KEY_POSITION_ID);
                AppFileSearchList.clearList(positionFilters);
            }
            if (!HRObjectUtils.equals(this.lastFilterDataMap.get(KEY_POSITION_ID), this.filterDataMap.get(KEY_POSITION_ID))) {
                List<Object> stgFilters = this.filterDataMap.get("recrustg.id");
                AppFileSearchList.clearList(stgFilters);
            }
            if (!HRObjectUtils.equals(this.lastFilterDataMap.get("recrustg.id"), this.filterDataMap.get("recrustg.id"))) {
                List<Object> stsFilters = this.filterDataMap.get("recrustat.id");
                AppFileSearchList.clearList(stsFilters);
            }
        }
    }

    private static void clearList(List<Object> list) {
        if (list != null) {
            list.clear();
        }
    }

    private static boolean isNotEmptyList(List<Object> list) {
        return list != null && !list.isEmpty() && !"".equals(list.get(0));
    }

    static {
        GEN_DEF_QUERY_MAP.put(1, AppFileHomePageHelper::queryTobeFilterWaitedAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(2, AppFileHomePageHelper::queryFilterSentAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(3, AppFileHomePageHelper::queryFilterFinishedAppFileIdSet);
        GEN_DEF_QUERY_MAP.put(4, AppFileHomePageHelper::queryTobeArrangedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(5, AppFileHomePageHelper::queryTobeInterviewedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(6, AppFileHomePageHelper::queryToBeAdvancedAppFileIdList);
        GEN_DEF_QUERY_MAP.put(7, AppFileHomePageHelper::getWaitedHireIds);
        GEN_DEF_QUERY_MAP.put(8, AppFileHomePageHelper::getHireAuditingIds);
        GEN_DEF_QUERY_MAP.put(9, AppFileHomePageHelper::getHireAuditedIds);
        GEN_DEF_PRO_QUERY_MAP = Maps.newHashMap();
        GEN_DEF_PRO_QUERY_MAP.put(101, AppProHomePageHelper::queryTobeFilterWaitedAppFileIdSet);
        GEN_DEF_PRO_QUERY_MAP.put(102, AppProHomePageHelper::queryFilterFinishedAppFileIdSet);
        GEN_DEF_PRO_QUERY_MAP.put(103, AppProHomePageHelper::queryTobeArrangedAppFileIdList);
        GEN_DEF_PRO_QUERY_MAP.put(104, AppProHomePageHelper::queryTobeInterviewedAppFileIdList);
        GEN_DEF_PRO_QUERY_MAP.put(105, AppProHomePageHelper::queryToBeAdvancedAppFileIdList);
        GEN_DEF_PRO_QUERY_MAP.put(106, AppProHomePageHelper::getWaitedHireIds);
        GEN_DEF_PRO_QUERY_MAP.put(107, AppProHomePageHelper::getHireAuditingIds);
        GEN_DEF_PRO_QUERY_MAP.put(108, AppProHomePageHelper::getWaitChangeIds);
        GEN_DEF_PRO_QUERY_MAP.put(109, AppProHomePageHelper::getChangingIds);
    }

    static interface QueryAppFileIdsFunction {
        public Collection<Long> queryAppFileIds(boolean var1, Long var2, String var3, List<Long> var4);
    }
}

