/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.appfile.trace;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;

public class AppFileTraceList
extends HRDataBaseList {
    private static final String KEY_INCTLINKTIME = "inctlinktime";
    private DynamicObjectCollection traceList = null;
    private DynamicObject appFile = null;
    private Object[] outTimeObjects = null;
    private String[] durations = null;
    private int rowIndex1 = 0;
    private int rowIndex2 = 0;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                AppFileTraceList.this.appFile = AppFileDataHelper.queryAppFileById((Object)AppFileTraceList.this.getView().getFormShowParameter().getCustomParam("appFileId"));
                AppFileTraceList.this.traceList = super.getData(start, limit + 1);
                AppFileTraceList.access$202(AppFileTraceList.this, new Object[AppFileTraceList.this.traceList.size()]);
                AppFileTraceList.access$302(AppFileTraceList.this, new String[AppFileTraceList.this.traceList.size()]);
                AppFileTraceList.this.calData(limit);
                if (AppFileTraceList.this.traceList.size() > limit) {
                    DynamicObjectCollection collections = new DynamicObjectCollection(AppFileTraceList.this.traceList.getDynamicObjectType(), AppFileTraceList.this.traceList.getParent());
                    collections.addAll((Collection)AppFileTraceList.this.traceList.subList(0, limit));
                    return collections;
                }
                return AppFileTraceList.this.traceList;
            }
        });
    }

    private void calData(int limit) {
        Date endDate;
        for (int i = 0; i < this.traceList.size() - 1; ++i) {
            Date nextLinkTime = ((DynamicObject)this.traceList.get(i + 1)).getDate(KEY_INCTLINKTIME);
            this.outTimeObjects[i] = HRDateTimeUtils.format((Date)nextLinkTime, (String)"yyyy-MM-dd HH:mm");
            Date currLinkTime = ((DynamicObject)this.traceList.get(i)).getDate(KEY_INCTLINKTIME);
            this.durations[i] = AppFileHelper.calDuration((Date)currLinkTime, (Date)nextLinkTime);
        }
        if (this.traceList.size() <= limit) {
            endDate = AppFileHelper.getEndDateByStatus((DynamicObject)this.appFile);
            int endIndex = this.traceList.size() - 1;
            if (endIndex >= 0) {
                Date linkTime = ((DynamicObject)this.traceList.get(endIndex)).getDate(KEY_INCTLINKTIME);
                if (endDate == null) {
                    this.outTimeObjects[endIndex] = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"AppFileTraceList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    endDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                } else {
                    this.outTimeObjects[endIndex] = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd HH:mm");
                }
                this.durations[endIndex] = AppFileHelper.calDuration((Date)linkTime, (Date)endDate);
            }
        } else {
            endDate = ((DynamicObject)this.traceList.get(limit)).getDate(KEY_INCTLINKTIME);
        }
        if (!this.traceList.isEmpty()) {
            this.setTotalDuration(((DynamicObject)this.traceList.get(0)).getDate(KEY_INCTLINKTIME), endDate);
        }
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        this.rowIndex1 = 0;
        this.rowIndex2 = 0;
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        if ("inctstatustime".equals(columnDesc.getFieldKey())) {
            evt.setFormatValue(this.outTimeObjects[this.rowIndex1]);
            ++this.rowIndex1;
        } else if ("duration".equals(columnDesc.getFieldKey())) {
            evt.setFormatValue((Object)this.durations[this.rowIndex2]);
            ++this.rowIndex2;
        }
    }

    private void setTotalDuration(Date inctlinktime, Date endDate) {
        Label duration = (Label)this.getView().getParentView().getControl("duration");
        duration.setText(AppFileHelper.calDuration((Date)inctlinktime, (Date)endDate));
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void setFilter(SetFilterEvent evt) {
        evt.getQFilters().add(new QFilter("appfile", "=", this.getView().getFormShowParameter().getCustomParam("appFileId")));
        evt.setOrderBy("createtime asc");
    }

    static /* synthetic */ Object[] access$202(AppFileTraceList x0, Object[] x1) {
        x0.outTimeObjects = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(AppFileTraceList x0, String[] x1) {
        x0.durations = x1;
        return x1;
    }
}

