/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.emp;

import com.google.gson.Gson;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsrbd.business.domain.applyprogress.ApplyProgressService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyCardPlugin
extends HRDynamicFormBasePlugin {
    private String BTN_OPEN = "btn_open";
    private String BTN_CLOSE = "btn_close";
    public static final String FLEX_APPLY_PROGRESS = "flex_apply_progress";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{this.BTN_OPEN, this.BTN_CLOSE, "advertname"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initPositionInfo();
    }

    private void initPositionInfo() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String advertname = (String)customParams.get("advertname");
        String demanddpmt = (String)customParams.get("demanddpmt");
        String resumename = (String)customParams.get("resumename");
        Long advertId = (Long)customParams.get("advertid");
        this.getModel().setValue("advertid", (Object)advertId);
        this.getModel().setValue("demanddpmt", (Object)(StringUtils.isEmpty((CharSequence)demanddpmt) ? "-" : demanddpmt));
        this.getModel().setValue("resumename", (Object)resumename);
        this.getModel().setValue("applytime", (Object)("0".equals(customParams.get("applytime").toString()) ? null : new Date(Long.parseLong(customParams.get("applytime").toString()))));
        Label control = (Label)this.getControl("advertname");
        control.setText(advertname);
        List<Map<String, Object>> applyProgressInfo = this.getApplyProgressInfo();
        if (ObjectUtils.isEmpty(applyProgressInfo)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"latestappprgs"});
        } else {
            Map<String, Object> stringObjectMap = applyProgressInfo.get(applyProgressInfo.size() - 1);
            Object name = stringObjectMap.get("nodename");
            this.getModel().setValue("latestappprgs", name);
        }
    }

    public void afterBindData(EventObject e) {
        String isOpen = (String)this.getView().getFormShowParameter().getCustomParam("isopen");
        if ("1".equals(isOpen)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_OPEN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_APPLY_PROGRESS, this.BTN_CLOSE});
            this.initApplyProgressInfo();
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_CLOSE, FLEX_APPLY_PROGRESS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.BTN_OPEN});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals(this.BTN_OPEN)) {
            this.initApplyProgressInfo();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_OPEN});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{FLEX_APPLY_PROGRESS, this.BTN_CLOSE});
            this.initApplyProgressInfo();
        } else if (key.equals(this.BTN_CLOSE)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.BTN_CLOSE, FLEX_APPLY_PROGRESS});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.BTN_OPEN});
        } else if ("advertname".equals(key)) {
            this.openAdvertDetailPage();
        }
    }

    private void openAdvertDetailPage() {
        BaseShowParameter bsp = new BaseShowParameter();
        bsp.setFormId("tsirm_openadvertnew");
        bsp.setPkId((Object)this.getModel().getDataEntity().getLong("advertid"));
        bsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)bsp);
    }

    private void initApplyProgressInfo() {
        List<Map<String, Object>> applyProgressInfo = this.getApplyProgressInfo();
        if (ObjectUtils.isEmpty(applyProgressInfo)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"latestappprgs"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"applyprogressflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"noapplyprogressflex"});
        } else {
            Map<String, Object> stringObjectMap = applyProgressInfo.get(applyProgressInfo.size() - 1);
            Object name = stringObjectMap.get("nodename");
            this.getModel().setValue("latestappprgs", name);
            this.setApplyProgressCustomControl(applyProgressInfo);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"noapplyprogressflex"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"latestappprgs", "applyprogressflex"});
        }
    }

    private void setApplyProgressCustomControl(List<Map<String, Object>> applyProgressInfo) {
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, String> customParam = new HashMap<String, String>(3);
        Gson gson = new Gson();
        String evlJson = applyProgressInfo == null || applyProgressInfo.size() == 0 ? "[]" : gson.toJson(applyProgressInfo, List.class);
        customParam.put("initData", evlJson);
        customParam.put("random", new SecureRandom().nextInt() + "");
        customcontrol.setData(customParam);
    }

    private List<Map<String, Object>> getApplyProgressInfo() {
        Long appFileId = (Long)this.getView().getFormShowParameter().getCustomParam("appfile");
        DynamicObject[] appFileStatTrackRecords = AppFileHelper.getAppFileStatTrackRecord((Long)appFileId);
        DynamicObject[] appFileTrackRecords = AppFileHelper.getAppFileTrackRecord((Long)appFileId);
        ArrayList<DynamicObject> applyProgressList = new ArrayList<DynamicObject>(appFileStatTrackRecords.length + appFileTrackRecords.length);
        applyProgressList.addAll(Arrays.asList(appFileTrackRecords));
        applyProgressList.addAll(Arrays.asList(appFileStatTrackRecords));
        applyProgressList.sort((a, b) -> a.getDate("createtime").compareTo(b.getDate("createtime")));
        DynamicObject applyProgressDy = ApplyProgressService.getApplyProgressByReCruTyp((Long)1030L);
        DynamicObjectCollection recrutgEntry = applyProgressDy.getDynamicObjectCollection("recrustg_entry");
        List recrutgList = recrutgEntry.stream().filter(dynamicObject -> dynamicObject.getBoolean("isdisplaystg")).collect(Collectors.toList());
        DynamicObjectCollection recrustatEntry = applyProgressDy.getDynamicObjectCollection("recrustat_entry");
        List recrustatList = recrustatEntry.stream().filter(dynamicObject -> dynamicObject.getBoolean("isdisplaysta")).collect(Collectors.toList());
        DynamicObjectCollection fileStatusEntry = applyProgressDy.getDynamicObjectCollection("filestatus_entry");
        List fileStatusList = fileStatusEntry.stream().filter(dynamicObject -> dynamicObject.getBoolean("isdisplayapp")).collect(Collectors.toList());
        ArrayList<Map<String, Object>> applyProgressMapList = new ArrayList<Map<String, Object>>(applyProgressList.size());
        for (int i = 0; i < applyProgressList.size(); ++i) {
            DynamicObject applyDy = (DynamicObject)applyProgressList.get(i);
            String applyProgressName = "";
            Date applyProgressDate = null;
            String formId = applyDy.getDataEntityType().getName();
            String dateStr = null;
            if ("tsirm_appfiletrace".equals(formId)) {
                applyProgressDate = applyDy.getDate("inctlinktime");
                if (null != applyProgressDate) {
                    dateStr = HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletrace", (String)"inctlinktime", (Date)applyProgressDate);
                }
                DynamicObject inrecrustgDy = applyDy.getDynamicObject("inrecrustg");
                DynamicObject inrecrustatDy = applyDy.getDynamicObject("inrecrustat");
                if (ObjectUtils.isEmpty((Object)inrecrustatDy)) continue;
                Optional<DynamicObject> recrustgDy = recrutgList.stream().filter(dynamicObject -> dynamicObject.getLong("recrustg.id") == inrecrustgDy.getLong("id")).findFirst();
                Optional<DynamicObject> recrustatDy = recrustatList.stream().filter(dynamicObject -> dynamicObject.getLong("recrustat.id") == inrecrustatDy.getLong("id")).findFirst();
                if (recrustgDy.isPresent() && recrustatDy.isPresent()) {
                    applyProgressName = recrustgDy.get().getString("displaynamestg") + "-" + recrustatDy.get().getString("displaynamesta");
                }
            } else {
                applyProgressDate = applyDy.getDate("operatetime");
                if (null != applyProgressDate) {
                    dateStr = HRInteDateTimeUtil.formatDate((String)"tsirm_appfilestatreclist", (String)"operatetime", (Date)applyProgressDate);
                }
                String fileStatus = applyDy.getString("newfilestatus");
                Optional<DynamicObject> fileStatusDy = fileStatusList.stream().filter(dynamicObject -> fileStatus.equals(dynamicObject.getString("filestatus"))).findFirst();
                if (fileStatusDy.isPresent()) {
                    applyProgressName = fileStatusDy.get().getString("displaynameapp");
                }
            }
            if (!ObjectUtils.isNotEmpty((Object)applyProgressName)) continue;
            HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
            resultMap.put("nodename", applyProgressName);
            resultMap.put("isHasColor", false);
            resultMap.put("number", 0);
            resultMap.put("time", dateStr);
            applyProgressMapList.add(resultMap);
        }
        if (ObjectUtils.isNotEmpty(applyProgressMapList)) {
            ((Map)applyProgressMapList.get(applyProgressMapList.size() - 1)).put("isHasColor", true);
        }
        return applyProgressMapList;
    }
}

