/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.emp;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.advert.service.AdvertDetailExDataHelper;
import kd.tsc.tsirm.business.domain.pc.helper.EmpDeliveryHelper;
import kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService;
import kd.tsc.tsirm.common.util.FormShowUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ApplyListPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(ApplyListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] empCVDys = PersonalCenterService.getInstance().getEmpCVs(Long.valueOf(RequestContext.get().getCurrUserId()));
        List deliveryRecordList = EmpDeliveryHelper.getDeliveryRecords(Arrays.stream(empCVDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList()));
        if (ObjectUtils.isEmpty((Object)deliveryRecordList)) {
            this.openApplyNoDataPage();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
        } else {
            this.openApplyPage(deliveryRecordList);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
        }
    }

    private void openApplyPage(List<DynamicObject> deliveryRecordList) {
        Container flexPanel = (Container)this.getControl("flexpanelap1");
        for (int i = 0; i < deliveryRecordList.size(); ++i) {
            DynamicObject deliveryRecordDy = deliveryRecordList.get(i);
            FormShowParameter showParameter = FormShowUtils.setFlexFormShow((Container)flexPanel, (String)flexPanel.getKey().concat(String.valueOf(i)), (String)"tsirm_apply_card");
            Map<String, Object> paramMap = this.getCustomParams(i, deliveryRecordDy);
            showParameter.setCustomParams(paramMap);
            this.getView().showForm(showParameter);
        }
    }

    private Map<String, Object> getCustomParams(int i, DynamicObject deliveryRecordDy) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        log.info("ApplyListPlugin advertId -> {}", (Object)deliveryRecordDy.getLong("advert.id"));
        DynamicObject advertDy = AdvertDetailExDataHelper.getInstance().queryAdvertDetail(Long.valueOf(deliveryRecordDy.getLong("advert.id")));
        DynamicObject empCVDy = deliveryRecordDy.getDynamicObject("cv");
        String advertName = advertDy.getString("fullname");
        DynamicObjectCollection orgList = advertDy.getDynamicObjectCollection("adminorgsdpt");
        List orgNameList = orgList.stream().map(org -> org.getString("fbasedataid.name")).collect(Collectors.toList());
        String resumeName = ResManager.loadKDString((String)"{0}\u7684\u7b80\u5386", (String)"ApplyListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{empCVDy.getString("fullname")});
        Long appFileId = deliveryRecordDy.getLong("appfile.id");
        paramMap.put("advertname", advertName);
        paramMap.put("demanddpmt", StringUtils.join(orgNameList, (String)";"));
        paramMap.put("resumename", resumeName);
        paramMap.put("advertid", advertDy.getLong("id"));
        paramMap.put("applytime", deliveryRecordDy.getDate("applytime") == null ? 0L : deliveryRecordDy.getDate("applytime").getTime());
        paramMap.put("appfile", appFileId);
        Long advertId = (Long)this.getView().getFormShowParameter().getCustomParam("advertId");
        if (advertId != null && advertId.longValue() == advertDy.getLong("id")) {
            paramMap.put("isopen", "1");
        } else if (advertId == null) {
            if (i == 0) {
                paramMap.put("isopen", "1");
            } else {
                paramMap.put("isopen", "0");
            }
        } else {
            paramMap.put("isopen", "0");
        }
        return paramMap;
    }

    private void openApplyNoDataPage() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tsirm_apply_nodata");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("flexpanelap2");
        this.getView().showForm(fsp);
    }
}

