/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.emp;

import java.util.Date;
import java.util.EventObject;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.tsc.common.vo.BizResult;
import kd.sdk.tsc.tsirm.extpoint.cv.DeliveryParam;
import kd.sdk.tsc.tsirm.extpoint.cv.EmpDeliveryTypeEnum;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBusinessHelper;
import kd.tsc.tsirm.business.domain.cert.CertService;
import kd.tsc.tsirm.business.domain.pc.factory.PCServiceFactory;
import kd.tsc.tsirm.business.domain.pc.service.AbstractEmpCVService;
import kd.tsc.tsirm.business.domain.pc.service.PersonalCenterService;
import kd.tsc.tsrbs.business.domain.rsm.entity.SaveCandidateResult;

public class EmpCVListPlugin
extends HRDynamicFormBasePlugin {
    public static final String FIELD_RSMUPDATETIME = "rsmupdatetime";
    public static final String FIELD_RSMREMARK = "rsmremark";
    public static final String BTN_CONFIRMAPP = "confirmapp";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"flexpanelap5", "labelap4", "fullname", "vectorap"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    private void initData() {
        Label control = (Label)this.getControl("labelap2");
        String advertName = (String)this.getView().getFormShowParameter().getCustomParam("advertName");
        control.setText(advertName);
        DynamicObject empCVDy = PersonalCenterService.getInstance().getEmpCV().getData();
        Date updateDate = empCVDy.getDate(FIELD_RSMUPDATETIME);
        updateDate = updateDate == null ? empCVDy.getDate("createtime") : updateDate;
        String name = ResManager.loadKDString((String)"{0}\u7684\u7b80\u5386", (String)"EmpCVListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{empCVDy.getString("fullname")});
        Label fullName = (Label)this.getControl("fullname");
        fullName.setText(name);
        this.getModel().setValue(FIELD_RSMUPDATETIME, (Object)updateDate);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_CONFIRMAPP.equals(itemKey)) {
            String state;
            this.checkAdvertState(evt);
            boolean cancel = evt.isCancel();
            if (!cancel && "FAIL".equals(state = CertService.getInstance().getVerifyCertResult(Long.valueOf(RequestContext.get().getCurrUserId())))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4f60\u7684\u8d26\u53f7\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u201c%S\u201d\u3002", (String)"HomePageApplyPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), CertService.getInstance().getCertTips()));
                evt.setCancel(true);
            }
        }
    }

    private void checkAdvertState(BeforeItemClickEvent evt) {
        Long advertId = (Long)this.getView().getFormShowParameter().getCustomParam("advertId");
        if (!AdvertBusinessHelper.isAdvertCanDelivery((Long)advertId)) {
            evt.setCancel(true);
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u804c\u4f4d\u5df2\u4e0b\u7ebf\u3002", (String)"EmpCVListPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().getParentView().invokeOperation("refresh");
            this.getView().close();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (BTN_CONFIRMAPP.equals(itemKey)) {
            this.deliveryCV();
        }
    }

    private void deliveryCV() {
        Long userId = RequestContext.get().getCurrUserId();
        Long positionId = (Long)this.getView().getFormShowParameter().getCustomParam("positionId");
        Long advertId = (Long)this.getView().getFormShowParameter().getCustomParam("advertId");
        DynamicObject empCVDy = PersonalCenterService.getInstance().getEmpCV().getData();
        Long cvId = empCVDy.getLong("id");
        DeliveryParam deliveryParam = new DeliveryParam(userId, positionId, advertId, cvId, EmpDeliveryTypeEnum.DELIVTYPE_POSITION);
        BizResult bizResult = PersonalCenterService.getInstance().deliveryCV(deliveryParam);
        SaveCandidateResult saveCandidateResult = (SaveCandidateResult)bizResult.getData();
        Boolean isSuccess = (Boolean)saveCandidateResult.get((Object)"isSuccess");
        this.getView().returnDataToParent((Object)"deliveryCV");
        if (isSuccess.booleanValue()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u5e94\u8058\u6210\u529f\uff0c\u4f60\u53ef\u5728\u201c\u6211\u7684\u5e94\u8058\u201d\u67e5\u770b\u5e94\u8058\u8fdb\u5c55\u3002", (String)"EmpCVListPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        } else {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u5e94\u8058\u5931\u8d25\uff0c\u91cd\u590d\u5e94\u8058\u3002", (String)"EmpCVListPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("labelap4".equals(key) || "flexpanelap5".equals(key) || "vectorap".equals(key)) {
            this.updateCV();
        } else if ("fullname".equals(key)) {
            this.openCVDetailPage();
        }
    }

    private void updateCV() {
        DynamicObject empCVDy = PersonalCenterService.getInstance().getEmpCV().getData();
        Long cvId = empCVDy.getLong("id");
        AbstractEmpCVService empCVService = PCServiceFactory.getEmpCVService();
        BizResult bizResult = empCVService.updateCVFormPersonInfo(cvId);
        if (bizResult.getSuccess().booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b80\u5386\u66f4\u65b0\u6210\u529f\u3002", (String)"EmpCVListPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        } else {
            this.getView().showTipNotification(bizResult.getMessage());
        }
    }

    private void openCVDetailPage() {
        DynamicObject empCVDy = PersonalCenterService.getInstance().getEmpCV().getData();
        Long cvId = empCVDy.getLong("id");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("tsirm_empcv");
        showParameter.setPkId((Object)cvId);
        showParameter.setStatus(OperationStatus.VIEW);
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.NonModal));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

