/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.exam;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.exam.service.ExamKDStringService;
import kd.tsc.tsrbd.common.constants.TSCBaseConstants;

public class ExamLogicDeleteBaseList
extends HRDataBaseList {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        if ("logicdelexam".equals(operate.getOperateKey())) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("logicdelexam", (IFormPlugin)this);
                String msg = ExamKDStringService.getDeleteConfirmMsg();
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
                beforeDoOperationEventArgs.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if ("logicdelexam".equals(afterDoOperationEventArgs.getOperateKey())) {
            IFormView parentView = this.getView().getParentView();
            afterDoOperationEventArgs.getOperationResult().setShowMessage(false);
            if (afterDoOperationEventArgs.getOperationResult().isSuccess()) {
                parentView.showSuccessNotification(ExamKDStringService.getDeleteSuccessMsg(), TSCBaseConstants.SUCCESS_NOTIFICATION_DEFAULT_TIME);
            } else {
                parentView.showSuccessNotification(ExamKDStringService.getDeleteFailMsg(), TSCBaseConstants.SUCCESS_NOTIFICATION_DEFAULT_TIME);
            }
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            ListView listView = (ListView)this.getView();
            listView.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("logicdelexam".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("logicdelexam", operateOption);
        }
    }
}

