/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.exam;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListCardView;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tsc.tsirm.common.enums.exam.ExamTypeEnum;

public class ExamWrittenBaseList
extends HRCoreBaseList {
    private Map<Long, String> idAndScoreStrMapping;
    private String showStatus;

    public void setFilter(SetFilterEvent evt) {
        Long appFileId = (Long)this.getView().getFormShowParameter().getCustomParam("appFileId");
        evt.addCustomQFilter(new QFilter("appfile", "=", (Object)appFileId));
        evt.addCustomQFilter(new QFilter("examtype", "=", (Object)ExamTypeEnum.DIC_EXAMTYPE_WRITTEN.getCode()));
        evt.addCustomQFilter(new QFilter("isdeleted", "=", (Object)Boolean.FALSE));
        evt.setOrderBy("examtime DESC,createtime DESC");
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        ListCardView listCardView = (ListCardView)this.getView().getControl("cardview");
        listCardView.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"buttonap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        if (listSelectedRowCollection.size() > 0) {
            Long examId = (Long)this.getSelectedRows().get(0).getPrimaryKeyValue();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tsirm_examwrittenattch");
            showParameter.setCustomParam("examId", (Object)examId);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.showStatus = this.getView().getFormShowParameter().getStatus().name();
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection rows = super.getData(start, limit);
                if (rows.isEmpty()) {
                    return rows;
                }
                ExamWrittenBaseList.this.idAndScoreStrMapping = Maps.newHashMapWithExpectedSize((int)rows.size());
                for (DynamicObject row : rows) {
                    BigDecimal score = row.getBigDecimal("score");
                    String scoreStr = score.stripTrailingZeros().toPlainString();
                    ExamWrittenBaseList.this.idAndScoreStrMapping.put(row.getLong("id"), scoreStr);
                }
                return rows;
            }
        });
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("scoreshow".equals(fieldKey)) {
            Long pk = (Long)evt.getRowData().getPkValue();
            evt.setFormatValue((Object)this.idAndScoreStrMapping.get(pk));
        } else if ("showstatus".equals(fieldKey)) {
            evt.setFormatValue((Object)this.showStatus);
        }
    }
}

