/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.hire.approval;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalViewService;
import kd.tsc.tsirm.common.dto.hire.HireVerifyResult;
import kd.tsc.tsrbd.common.utils.NotDataChangeUtils;

public class HireApprovalBillEdit
extends HRCoreBaseBillEdit {
    private static final String KEY_RECORDFLEX = "recordflex";
    private boolean selectChange = true;
    private static final Set<String> ENTITY_BTN = Sets.newHashSetWithExpectedSize((int)3);
    private static final Map<String, String> AUDIT_STATUSMAP = Maps.newHashMap();

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        this.getModel().setValue("createorg", (Object)0L);
        this.getInitApprovalDyData();
    }

    public void afterLoadData(EventObject event) {
        super.afterLoadData(event);
        this.getInitApprovalDyData();
    }

    public void preOpenForm(PreOpenFormEventArgs preOpenFormEventArgs) {
        super.preOpenForm(preOpenFormEventArgs);
        OperationStatus status = preOpenFormEventArgs.getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.EDIT.getValue()) {
            preOpenFormEventArgs.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.initHeadInfoForNew();
        this.setBillStatusVisible();
        this.setToolbarVisible();
        this.setAppFileLinkVisible();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"appfile"});
        }
        if (this.getView().getFormShowParameter().getCustomParam("appFileId") != null) {
            this.getModel().setDataChanged(false);
        }
        this.showRecord();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        args.setCancel(!this.verify(key));
    }

    private void checkAppFileAdd() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            DynamicObject appFileDy = (DynamicObject)this.getModel().getValue("appfile");
            if (appFileDy == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit", "bar_submiteffect", "bar_save"});
            } else {
                HireVerifyResult hireVerifyResult = HireApprovalService.verifyAddData(Collections.singletonList(appFileDy.getLong("id")));
                if (hireVerifyResult.getFailAppFileId().contains(appFileDy.getLong("id"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"bar_submit", "bar_submiteffect", "bar_save"});
                    List failReason = (List)hireVerifyResult.getFailReason().get(appFileDy.getLong("id"));
                    for (String reason : failReason) {
                        this.getView().showTipNotification(reason);
                    }
                }
            }
        }
    }

    private void showRecord() {
        Boolean showRecord = (Boolean)this.getView().getFormShowParameter().getCustomParam("SHOW_WORK_FLOW_RECORD");
        if (showRecord != null) {
            this.getView().setVisible(showRecord, new String[]{KEY_RECORDFLEX});
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        this.addClickListeners(new String[]{"openappfile", "editopenappfile"});
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("bar_modify".equals(key)) {
            String auditstatus = this.getModel().getDataEntity().getString("billstatus");
            if (!"A".equals(auditstatus) && !"G".equals(auditstatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6279\u72b6\u6001\u4e3a\u201c\u5f85\u91cd\u65b0\u63d0\u4ea4\u201d\u3001\u201c\u6682\u5b58\u201d\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u4fee\u6539\u3002", (String)"HireApprovalBillEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            }
            if ("tsirm_hireapprovalsgcard".equals(this.getView().getFormShowParameter().getFormId())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"appfile"});
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            if ("submiteffect".equals(operateKey) || "unsubmit".equals(operateKey) || "discard".equals(operateKey) || "submit".equals(operateKey) || "save".equals(operateKey)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                this.getView().invokeOperation("refresh");
            } else if ("modify_ext".equals(operateKey)) {
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        this.handleOpenAppFile(evt);
    }

    private void handleOpenAppFile(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("openappfile".equals(key) || "editopenappfile".equals(key)) {
            Object appFile = this.getModel().getValue("appfile");
            if (appFile == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8fd8\u6ca1\u6709\u9009\u62e9\u5019\u9009\u4eba\u3002", (String)"HireApprovalBillEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long openAppFileId = ((DynamicObject)appFile).getLong("id");
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setFormId("tsirm_appfile_view");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_appfile_view"));
            showParameter.setPkId((Object)openAppFileId);
            String pageId = this.getView().getPageId() + "tsirm_appfile_view" + openAppFileId;
            showParameter.setPageId(pageId);
            showParameter.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        boolean checkChange = false;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status)) {
            checkChange = true;
        }
        if (OperationStatus.ADDNEW.equals((Object)status) && this.getModel().getValue("appfile") == null) {
            checkChange = true;
        }
        if (checkChange) {
            event.setCheckDataChange(false);
        }
    }

    private void initHeadInfoForNew() {
        String applyTime = "";
        Date submitterTime = (Date)this.getModel().getValue("createtime");
        applyTime = submitterTime != null ? HRInteDateTimeUtil.formatDate((String)"tsirm_appfile_viewm", (String)"applytime", (Date)submitterTime) : HRInteDateTimeUtil.formatDate((String)"tsirm_appfile_viewm", (String)"applytime", (Date)new Date());
        Label billNoLabel = (Label)this.getControl("billnoshow");
        billNoLabel.setText((String)this.getModel().getValue("billno"));
        DynamicObject creator = this.getModel().getDataEntity().getDynamicObject("creator");
        this.getModel().setValue("createuser1", (Object)creator);
        NotDataChangeUtils.setPropertyNotDataChanged((IDataModel)this.getModel(), (String[])new String[]{"createuser1"});
        Label applyTimeLabel = (Label)this.getControl("applytime");
        applyTimeLabel.setText(applyTime);
    }

    private void setBillStatusVisible() {
        String icon;
        this.getView().setVisible(Boolean.FALSE, new String[]{"auditstatusa", "auditstatusb", "auditstatusc", "auditstatusd", "auditstatuse", "auditstatusg", "auditstatusf"});
        Object auditObj = this.getModel().getValue("billstatus");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status) && auditObj != null && (icon = AUDIT_STATUSMAP.get(auditObj.toString())) != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{icon});
        }
    }

    private void setToolbarVisible() {
        this.isViewOpTab(Boolean.FALSE);
        String auditstatus = this.getModel().getDataEntity().getString("billstatus");
        if ("B".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_unsubmit", "bar_viewflowchart"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_discard"});
        } else if ("A".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_submit", "bar_submiteffect"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_discard"});
        } else if ("G".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_submit", "bar_discard", "bar_viewflowchart"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_unsubmit", "bar_submiteffect"});
        } else if ("C".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_discard", "bar_viewflowchart"});
        } else if ("E".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_discard", "bar_viewflowchart"});
        } else if ("D".equals(auditstatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_viewflowchart"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_discard"});
        }
    }

    private void setAppFileLinkVisible() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            DynamicObject appFileDy = (DynamicObject)this.getModel().getValue("appfile");
            this.getView().setVisible(appFileDy == null ? Boolean.FALSE : Boolean.TRUE, new String[]{"openappfile"});
        }
    }

    private void isViewOpTab(Boolean isView) {
        this.getView().setVisible(isView, new String[]{"bar_modify", "bar_submit", "bar_submiteffect", "bar_unsubmit", "bar_discard", "bar_viewflowchart"});
    }

    private void getInitApprovalDyData() {
        this.getModel().beginInit();
        this.initApprovalInfo();
        this.getModel().setDataChanged(false);
        this.getModel().endInit();
    }

    private void initApprovalInfo() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.ADDNEW.getValue()) {
            HireApprovalViewService.initHireApprovalData((IFormView)this.getView(), (IDataModel)this.getModel());
            AttachmentPanel panel = (AttachmentPanel)this.getControl("hirefile");
            panel.getAttachmentData().forEach(arg_0 -> ((AttachmentPanel)panel).remove(arg_0));
        } else {
            HireApprovalViewService.setHireInfo((IFormView)this.getView(), (IDataModel)this.getModel());
        }
    }

    private boolean verify(String key) {
        if (ENTITY_BTN.contains(key)) {
            boolean verifyPositionAndJob = HireApprovalViewService.verifyPositionAndJob((IFormView)this.getView(), (IDataModel)this.getModel());
            return verifyPositionAndJob;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if ("appfile".equals(key)) {
            DynamicObject appFileDy = (DynamicObject)args.getChangeSet()[0].getNewValue();
            if (this.selectChange) {
                this.selectChange = false;
                if (appFileDy != null) {
                    Long appFileId = appFileDy.getLong("id");
                    this.getView().getPageCache().put("appFileSelect", appFileId.toString());
                    this.checkAppFileAdd();
                } else {
                    this.getView().getPageCache().put("appFileSelect", null);
                }
                this.getView().invokeOperation("refresh");
            }
        }
    }

    static {
        ENTITY_BTN.add("save");
        ENTITY_BTN.add("submit");
        ENTITY_BTN.add("submiteffect");
        AUDIT_STATUSMAP.put("C", "auditstatusc");
        AUDIT_STATUSMAP.put("B", "auditstatusb");
        AUDIT_STATUSMAP.put("A", "auditstatusa");
        AUDIT_STATUSMAP.put("E", "auditstatuse");
        AUDIT_STATUSMAP.put("D", "auditstatusd");
        AUDIT_STATUSMAP.put("G", "auditstatusg");
        AUDIT_STATUSMAP.put("F", "auditstatusf");
    }
}

