/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.hire.approval;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.hire.approval.common.HireCommonKDStringHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class HireApprovalBillList
extends HRDataBaseList {
    private static final HashMap<String, String> DATE_ENUM_MAP = new HashMap(16);

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        event.setOrderBy("createtime desc");
        if (this.getView().getPageCache().get("initPage") == null) {
            this.getView().getPageCache().put("initPage", "1");
            this.setCustomParamFilter(event);
        }
    }

    private void setCustomParamFilter(SetFilterEvent event) {
        Object dataObj = this.getView().getFormShowParameter().getCustomParam("timeRangeType");
        if (dataObj != null) {
            long userId = TSCRequestContext.getUserId();
            QFilter qFilter = new QFilter("submitor", "=", (Object)userId);
            event.getQFilters().add(qFilter);
            event.getQFilters().removeIf(qFilter1 -> "submitor.id".equals(qFilter1.getProperties()[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Object dataObj = this.getView().getFormShowParameter().getCustomParam("timeRangeType");
        if (dataObj != null) {
            List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
            for (FilterColumn filterColumn : filterColumns) {
                if ("submittime".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValue(DATE_ENUM_MAP.get(dataObj));
                } else if ("billstatus".equals(filterColumn.getFieldName())) {
                    filterColumn.setDefaultValues(new Object[]{"G", "B", "D"});
                }
                if (!"submitor.name".equals(filterColumn.getFieldName())) continue;
                filterColumn.setDefaultValue("103");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (operateKey.equals("discard")) {
            int limit = 200;
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows != null && selectedRows.size() > limit) {
                this.getView().showTipNotification(HireCommonKDStringHelper.getRowLimit((int)limit));
                args.setCancel(true);
            }
        } else if (operateKey.equals("dochg")) {
            int limit = 1000;
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows != null && selectedRows.size() > limit) {
                this.getView().showTipNotification(HireCommonKDStringHelper.getRowLimit((int)limit));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("discard".equals(operateKey) || "effectlist".equals(operateKey) || "dochg".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
    }

    static {
        DATE_ENUM_MAP.put("today", "13");
        DATE_ENUM_MAP.put("this_week", "10");
        DATE_ENUM_MAP.put("this_month", "63");
        DATE_ENUM_MAP.put("past_three_month", "24");
        DATE_ENUM_MAP.put("past_one_year", "68");
    }
}

