/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.hire.approval;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalAppFileService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.common.enums.OpDefEnum;

public class HireApprovalBillOpRecordList
extends HRDataBaseList {
    private DynamicObject[] hireApprovalArr;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"exportlist") || HRStringUtils.equals((String)operateKey, (String)"exportlistbyselectfields") || HRStringUtils.equals((String)operateKey, (String)"exportlist_expt") || HRStringUtils.equals((String)operateKey, (String)"unsubmit") || HRStringUtils.equals((String)operateKey, (String)"delete") || HRStringUtils.equals((String)operateKey, (String)"submitlist") || HRStringUtils.equals((String)operateKey, (String)"effectlist")) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            Set approvalIdList = selectedRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
            DynamicObject[] hireApprovalArr = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_hireapprovalsg").loadDynamicObjectArray(approvalIdList.toArray());
            this.hireApprovalArr = hireApprovalArr;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            this.approvalOpRecord(operateKey);
        }
    }

    private void approvalOpRecord(String operateKey) {
        OpDefEnum oper = null;
        if (HRStringUtils.equals((String)operateKey, (String)"exportlist") || HRStringUtils.equals((String)operateKey, (String)"exportlistbyselectfields") || HRStringUtils.equals((String)operateKey, (String)"exportlist_expt")) {
            oper = OpDefEnum.TSIRM_EXT_EMP_APPFORM;
        } else if (HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
            oper = OpDefEnum.TSIRM_REVOKE_EMPLOY_APPFORM;
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete")) {
            oper = OpDefEnum.TSIRM_DELETE_EMP_APPFORM;
        } else if (HRStringUtils.equals((String)operateKey, (String)"submitlist")) {
            oper = OpDefEnum.TSIRM_HIRE_APPROVAL;
        } else if (HRStringUtils.equals((String)operateKey, (String)"effectlist")) {
            oper = OpDefEnum.TSIRM_SUB_EFF_EMP_APPFORM;
        } else {
            return;
        }
        HireApprovalAppFileService.approvalOpRecord((DynamicObject[])this.hireApprovalArr, (OpDefEnum)oper, (boolean)true);
    }
}

