/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.hire.approval;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.application.external.ExtHRPIWorkRoleService;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalViewService;
import kd.tsc.tsirm.common.enums.hire.PositiontypeEnum;

public class HireApprovalJobRankBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final Set<String> REGISTER_F7_SELECT = Sets.newHashSet();

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.handleVisibleAndEnable();
        Object postMode = this.getModel().getValue("postpattern");
        this.postionTypeChangeEvt(this.getView(), postMode);
    }

    private void handleVisibleAndEnable() {
        HireApprovalViewService.handelPositionJobInfoVisibleAndEnableForAdd((IFormView)this.getView(), (IDataModel)this.getModel());
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String key = event.getProperty().getName();
        Object newValue = event.getChangeSet()[0].getNewValue();
        Object oldValue = event.getChangeSet()[0].getOldValue();
        switch (key) {
            case "position": {
                HireApprovalViewService.handlePositionChange((IFormView)this.getView(), (IDataModel)this.getModel(), null, (Object)newValue, (Object)oldValue);
                HireApprovalViewService.handlePositionChangeForAdminOrg((IFormView)this.getView(), (IDataModel)this.getModel(), (Object)newValue, (Object)oldValue);
                this.handlePositionPropertyChangeEvt(event);
                this.updateComponentView();
                break;
            }
            case "stposition": {
                HireApprovalViewService.handlePositionChange((IFormView)this.getView(), (IDataModel)this.getModel(), null, (Object)newValue, (Object)oldValue);
                this.updateComponentView();
                break;
            }
            case "jobscm": {
                break;
            }
            case "job": {
                HireApprovalViewService.handleJobChange((IFormView)this.getView(), (IDataModel)this.getModel(), null, (Object)newValue, (Object)oldValue);
                HireApprovalViewService.handelJobChangeForClassFamilySeq((IFormView)this.getView(), (IDataModel)this.getModel(), (Object)newValue, (Object)oldValue);
                this.updateComponentView();
                break;
            }
            case "postpattern": {
                this.handlePostTypePropertyChangeEvt(event, this.getView());
                this.updateComponentView();
                break;
            }
            case "org": {
                this.handleDeptPropertyChangeEvt(event);
                this.updateComponentView();
            }
        }
    }

    public void registerListener(EventObject event) {
        super.registerListener(event);
        for (String key : REGISTER_F7_SELECT) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (basedataEdit == null) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = ((BasedataEdit)beforeF7SelectEvent.getSource()).getKey();
        DynamicObject appFile = (DynamicObject)this.getModel().getValue("appfile");
        Long appFileId = 0L;
        if (appFile != null) {
            appFileId = appFile.getLong("id");
        }
        ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).setMultiSelect(false);
        this.handlePositionAndJobFilter(beforeF7SelectEvent, key, appFileId);
    }

    private void handlePositionAndJobFilter(BeforeF7SelectEvent beforeF7SelectEvent, String key, Long appFileId) {
        switch (key) {
            case "posttype": {
                beforeF7SelectEvent.setCustomQFilters(HireApprovalViewService.handlePosttypeF7Select());
                break;
            }
            case "socarea": {
                beforeF7SelectEvent.setCustomQFilters(HireApprovalViewService.handleSocAreaF7((Long)appFileId));
                break;
            }
            case "jobscm": {
                beforeF7SelectEvent.setCustomQFilters(HireApprovalViewService.handleJobScmF7((Long)appFileId));
                break;
            }
            case "job": {
                break;
            }
            case "position": {
                break;
            }
            case "joblevel": {
                beforeF7SelectEvent.setCustomQFilters(HireApprovalViewService.handleJobLevelF7((IDataModel)this.getModel()));
                break;
            }
            case "jobgrade": {
                beforeF7SelectEvent.setCustomQFilters(HireApprovalViewService.handleJobGradeF7((IDataModel)this.getModel()));
                break;
            }
            case "org": {
                break;
            }
        }
    }

    private void postionTypeChangeEvt(IFormView formView, Object postMode) {
        if (PositiontypeEnum.POS.getCode().equals(postMode)) {
            BasedataEdit postion = (BasedataEdit)this.getControl("position");
            postion.setMustInput(true);
            BasedataEdit job = (BasedataEdit)this.getView().getControl("job");
            job.setMustInput(false);
            BasedataEdit stdPosition = (BasedataEdit)this.getControl("stposition");
            stdPosition.setMustInput(false);
            formView.setVisible(Boolean.valueOf(true), new String[]{"position", "job"});
            formView.setVisible(Boolean.valueOf(false), new String[]{"stposition"});
            formView.setEnable(Boolean.valueOf(true), new String[]{"position"});
            formView.setEnable(Boolean.valueOf(false), new String[]{"job", "org"});
        } else if (PositiontypeEnum.STDPOS.getCode().equals(postMode)) {
            BasedataEdit stdPosition = (BasedataEdit)this.getControl("stposition");
            stdPosition.setMustInput(true);
            BasedataEdit job = (BasedataEdit)this.getView().getControl("job");
            job.setMustInput(false);
            BasedataEdit postion = (BasedataEdit)this.getControl("position");
            postion.setMustInput(false);
            formView.setVisible(Boolean.valueOf(true), new String[]{"stposition"});
            formView.setVisible(Boolean.valueOf(true), new String[]{"job"});
            formView.setVisible(Boolean.valueOf(false), new String[]{"position"});
            formView.setEnable(Boolean.valueOf(true), new String[]{"stposition", "org"});
            formView.setEnable(Boolean.valueOf(false), new String[]{"job"});
        } else if (PositiontypeEnum.JOB.getCode().equals(postMode)) {
            BasedataEdit job = (BasedataEdit)this.getView().getControl("job");
            job.setMustInput(true);
            BasedataEdit postion = (BasedataEdit)this.getControl("position");
            postion.setMustInput(false);
            BasedataEdit stdPosition = (BasedataEdit)this.getControl("stposition");
            stdPosition.setMustInput(false);
            formView.setVisible(Boolean.valueOf(true), new String[]{"job"});
            formView.setVisible(Boolean.valueOf(false), new String[]{"position", "stposition"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"job", "org"});
        }
    }

    private void handlePostTypePropertyChangeEvt(PropertyChangedArgs propertyChangedArgs, IFormView formView) {
        IDataModel model = formView.getModel();
        model.setValue("realityorgleader", null);
        model.setValue("realitysuperior", null);
        model.setValue("position", null);
        model.setValue("stposition", null);
        model.setValue("job", null);
        model.setValue("org", null);
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (null == newValue) {
            return;
        }
        Object postMode = newValue;
        this.postionTypeChangeEvt(formView, postMode);
    }

    private void handleDeptPropertyChangeEvt(PropertyChangedArgs args) {
        Object newValue = args.getChangeSet()[0].getNewValue();
        Object postModeObj = this.getModel().getValue("postpattern");
        if (newValue != null) {
            DynamicObject company;
            DynamicObject dept = (DynamicObject)newValue;
            Long id = dept.getLong("id");
            List personList = ExtHRPIWorkRoleService.getMainChargeIdByOrg((Long)id);
            if (personList != null) {
                this.getModel().setValue("realityorgleader", (Object)personList.toArray());
                if (PositiontypeEnum.STDPOS.getCode().equals(postModeObj)) {
                    this.getModel().setValue("realitysuperior", (Object)personList.toArray());
                }
            }
            if ((company = dept.getDynamicObject("company")) != null) {
                this.getModel().setValue("company", (Object)company);
            } else {
                this.getModel().setValue("company", null);
            }
        } else {
            this.getModel().setValue("realityorgleader", null);
            this.getModel().setValue("company", null);
        }
    }

    private void handlePositionPropertyChangeEvt(PropertyChangedArgs args) {
        Object postModeObj = this.getModel().getValue("postpattern");
        if (PositiontypeEnum.POS.getCode().equals(postModeObj)) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                Long roleId;
                List superior;
                DynamicObject position = (DynamicObject)newValue;
                if (null != position && (superior = ExtHRPIWorkRoleService.getSuperiorIdByRole((Long)(roleId = Long.valueOf(position.getLong("workrole.id"))))) != null && superior.size() > 0) {
                    this.getModel().setValue("realitysuperior", (Object)superior.toArray());
                }
            } else {
                this.getModel().setValue("realitysuperior", null);
            }
        }
    }

    private void updateComponentView() {
        this.getView().updateView("flexreparejobpanel");
    }

    static {
        REGISTER_F7_SELECT.add("position");
        REGISTER_F7_SELECT.add("posttype");
        REGISTER_F7_SELECT.add("labrelstatuscls");
        REGISTER_F7_SELECT.add("laborreltypecls");
        REGISTER_F7_SELECT.add("jobscm");
        REGISTER_F7_SELECT.add("job");
        REGISTER_F7_SELECT.add("joblevel");
        REGISTER_F7_SELECT.add("jobgrade");
        REGISTER_F7_SELECT.add("org");
    }
}

