/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.hire.approval;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;

public class HireApprovalSingleCardBillList
extends HRCoreBaseBillList {
    private static final String OP_VIEWSINGLE = "viewsingle";

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        this.setAppFileIdFilter(setFilterEvent);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.handleListOp(operateKey);
        }
    }

    private void handleListOp(String operateKey) {
        if (OP_VIEWSINGLE.equals(operateKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRow currentListSelectedRow = listView.getCurrentSelectedRowInfo();
            Object pkId = currentListSelectedRow.getPrimaryKeyValue();
            Boolean showApprovalRecordFlag = Boolean.TRUE;
            if ("A".equals(currentListSelectedRow.getBillStatus())) {
                showApprovalRecordFlag = Boolean.FALSE;
            }
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setPkId(pkId);
            billShowParameter.setFormId("tsirm_hireapprovalsg");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setCustomParam("SHOW_WORK_FLOW_RECORD", (Object)showApprovalRecordFlag);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    private void setAppFileIdFilter(SetFilterEvent event) {
        Object appFileIdObj = this.getView().getFormShowParameter().getCustomParam("appFileId");
        if (appFileIdObj != null) {
            long appFileId = Long.parseLong(appFileIdObj.toString());
            event.getQFilters().add(new QFilter("appfile", "=", (Object)appFileId));
        } else {
            event.getQFilters().add(new QFilter("appfile", "=", (Object)0L));
        }
    }
}

