/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.home;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.home.ArgIntvServiceImp;
import kd.tsc.tsirm.business.domain.intv.service.home.TssrmServiceCache;
import kd.tsc.tsirm.formplugin.web.home.bean.IntvDataBean;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class IntvCaleCardPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log LOGGER = LogFactory.getLog(IntvCaleCardPlugin.class);
    private static final ArrayList<String> WEEK_NUM_LIST = new ArrayList(7);
    private SimpleDateFormat datefm_yMd = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat datefm_M = new SimpleDateFormat("MM");
    private SimpleDateFormat datefm_d = new SimpleDateFormat("dd");
    private static final int LIST_LIMIT_LENGTH = 30;
    private HRBaseServiceHelper tsrbsArgIntvServiceHelper = new HRBaseServiceHelper("tsirm_argintv");
    private ArgIntvServiceImp argIntvService = (ArgIntvServiceImp)TssrmServiceCache.get(ArgIntvServiceImp.class);
    private static final String PAGE_CACHE_KEY_ARGINTVIDSOFDAY = "argIntvIdsOfDay";
    private static final String PAGE_CACHE_KEY_INTERVIEWEENAMESOFDAY = "intervieweeNamesOfDay";
    private static final Map<String, String> EVL_STATE;
    private static final Map<String, String> EVLORG_FRM;

    public static void initDesc() {
        EVL_STATE.put("A", ResManager.loadKDString((String)"\u5168\u90e8\u672a\u8bc4\u4ef7", (String)"IntvCaleCardPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        EVL_STATE.put("B", ResManager.loadKDString((String)"\u5168\u90e8\u5df2\u8bc4\u4ef7", (String)"IntvCaleCardPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        EVL_STATE.put("C", ResManager.loadKDString((String)"\u90e8\u5206\u8bc4\u4ef7", (String)"IntvCaleCardPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        EVLORG_FRM.put("A", ResManager.loadKDString((String)"\u96c6\u4f53\u9762\u8bd5", (String)"IntvCaleCardPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        EVLORG_FRM.put("B", ResManager.loadKDString((String)"\u5c0f\u7ec4\u9762\u8bd5", (String)"IntvCaleCardPlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        EVLORG_FRM.put("C", ResManager.loadKDString((String)"\u4e2a\u4eba\u9762\u8bd5", (String)"IntvCaleCardPlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        this.addClickListeners(new String[]{"flexleft", "flexright", "turntotoday"});
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        for (int iNum = 0; iNum < 6; ++iNum) {
            for (int j = 0; j < 7; ++j) {
                Label flex = (Label)this.getControl("date_" + iNum + "_" + j);
                flex.addClickListener((ClickListener)this);
            }
        }
        Container flexIntv = (Container)this.getControl("intvtitleap");
        flexIntv.addClickListener((ClickListener)this);
        Label getMore = (Label)this.getControl("tomorelistap");
        getMore.addClickListener((ClickListener)this);
        Label getInterviewList = (Label)this.getControl("interviewarrangelist");
        getInterviewList.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        Date date = new Date();
        this.setDateFlex(date);
        this.getIntviewAgmtData(date);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String changeName = evt.getProperty().getName();
        if (changeName.equals("permissionsselected")) {
            this.getMonthHaveDateDay();
            this.getIntviewAgmtData((Date)this.getModel().getValue("dateshowday"));
        }
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            this.getMonthHaveDateDay();
            this.getIntviewAgmtData((Date)this.getModel().getValue("dateshowday"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("flexleft") || key.equals("flexright")) {
            this.tabDateMonth(key);
        } else if (key.startsWith("date_")) {
            this.clickDate(key);
        } else if (key.equals("turntotoday")) {
            this.getModel().setValue("dateshowmonth", (Object)new Date());
            this.getModel().setValue("dateshowday", (Object)new Date());
            this.getIntviewAgmtData(new Date());
            this.setDateFlex(new Date());
        } else if (HRStringUtils.equals((String)key, (String)"intvtitleap")) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("intventryentity");
            long currUserId = RequestContext.get().getCurrUserId();
            boolean b = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)"47150e89000000ac");
            if (!b) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntvCaleCardPlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tsirm_argintvdetail");
            String argIntvIdsOfDay = this.getPageCache().get(PAGE_CACHE_KEY_ARGINTVIDSOFDAY);
            List argIntvIdListOfDay = JSON.parseArray((String)argIntvIdsOfDay, Long.class);
            showParameter.setCustomParam("arg_intv_id", argIntvIdListOfDay.get(currentIndex));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        } else if (HRStringUtils.equals((String)key, (String)"cancleintvap")) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("intventryentity");
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("callBackId", (IFormPlugin)this);
            String intervieweeNamesOfDay = this.getPageCache().get(PAGE_CACHE_KEY_INTERVIEWEENAMESOFDAY);
            List intervieweeNameListOfDay = JSON.parseArray((String)intervieweeNamesOfDay, String.class);
            String name = (String)intervieweeNameListOfDay.get(currentIndex);
            String time = "";
            SimpleDateFormat argIntvIdListOfDay = this.datefm_yMd;
            synchronized (argIntvIdListOfDay) {
                time = this.datefm_yMd.format(this.getModel().getValue("dateshowday"));
            }
            String intvLink = (String)this.getModel().getValue("intvlinktext", currentIndex);
            String confirmMessage = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u53d6\u6d88{0}{1}\u7684{2}\uff1f", (String)"IntvCaleCardPlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{name, time, intvLink});
            this.getView().showConfirm(confirmMessage, MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
        if (HRStringUtils.equals((String)key, (String)"interviewarrangelist")) {
            this.openTsrbsArgIntvListView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        int result = evt.getResult().getValue();
        if (result == MessageBoxResult.Yes.getValue() && evt.getCallBackId().equals("callBackId")) {
            int currentIndex = this.getModel().getEntryCurrentRowIndex("intventryentity");
            String argIntvIdsOfDay = this.getPageCache().get(PAGE_CACHE_KEY_ARGINTVIDSOFDAY);
            List argIntvIdListOfDay = JSON.parseArray((String)argIntvIdsOfDay, Long.class);
            Long argIntvId = (Long)argIntvIdListOfDay.get(currentIndex);
            DynamicObject dynamicObject = this.tsrbsArgIntvServiceHelper.queryOne((Object)argIntvId);
            ArgIntvHelper argIntvHelper = new ArgIntvHelper();
            Boolean isCancelSucc = argIntvHelper.setCancelStatus(dynamicObject);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("intventryentity");
            if (isCancelSucc.booleanValue()) {
                cardEntry.setChildVisible(true, currentIndex, new String[]{"alreadycancle"});
                cardEntry.setChildVisible(false, currentIndex, new String[]{"cancleintvap"});
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9762\u8bd5\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", (String)"IntvCaleCardPlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openTsrbsArgIntvListView() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("bos_list");
        showParameter.setBillFormId("tsirm_appfiletask");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        HashMap customParamMap = new HashMap(10);
        showParameter.setCustomParams(customParamMap);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9762\u8bd5\u7ba1\u7406", (String)"IntvCaleCardPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void tabDateMonth(String key) {
        Date date = (Date)this.getModel().getValue("dateshowmonth");
        if (date != null) {
            int month = 0;
            if ("flexleft".equals(key)) {
                month = -1;
            } else if ("flexright".equals(key)) {
                month = 1;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(2, month);
            calendar.set(5, 1);
            this.getModel().setValue("dateshowmonth", (Object)calendar.getTime());
            this.setDateFlex(calendar.getTime());
        }
    }

    private Date getDay(int row, int col) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.getModel().getValue("dateshowmonth"));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        calendar.add(5, 0 - weekday);
        calendar.add(5, (row - 1) * 7 + col);
        return calendar.getTime();
    }

    private int[] getRegion(Date day) {
        Date firstDay = this.getDay(1, 1);
        long diff = (day.getTime() - firstDay.getTime()) / 86400000L;
        int dayDiff = (int)diff;
        return new int[]{dayDiff / 7, dayDiff % 7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clickDate(String dateKey) {
        Date preDayDate = (Date)this.getModel().getValue("dateshowday");
        int[] currRegion = this.getRegion(preDayDate);
        String currKey = "date_" + currRegion[0] + "_" + currRegion[1];
        this.updateLabelColor(currKey, "inherit", "#333333");
        SimpleDateFormat simpleDateFormat = this.datefm_yMd;
        synchronized (simpleDateFormat) {
            if (HRStringUtils.equals((String)this.datefm_yMd.format(new Date()), (String)this.datefm_yMd.format(preDayDate))) {
                this.updateLabelColor(currKey, "inherit", "#5582F3");
            }
        }
        String[] region = dateKey.replace("date_", "").split("_");
        Date curDayDate = this.getDay(Integer.parseInt(region[0]) + 1, Integer.parseInt(region[1]) + 1);
        this.getModel().setValue("weektext", (Object)WEEK_NUM_LIST.get(Integer.parseInt(region[1])));
        this.updateLabelColor(dateKey, "#5582F3", "#FFFFFF");
        this.getIntviewAgmtData(curDayDate);
        this.getModel().setValue("dateshowday", (Object)curDayDate);
        Date curMonth = (Date)this.getModel().getValue("dateshowmonth");
        String curMonthNum = "";
        SimpleDateFormat simpleDateFormat2 = this.datefm_M;
        synchronized (simpleDateFormat2) {
            curMonthNum = this.datefm_M.format(curMonth);
            if (!this.datefm_M.format(curDayDate).equals(curMonthNum)) {
                if (curMonth.before(curDayDate)) {
                    Vector rightMonth = (Vector)this.getView().getControl("flexright");
                    rightMonth.click();
                } else {
                    Vector leftMonth = (Vector)this.getView().getControl("flexleft");
                    leftMonth.click();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDateFlex(Date date) {
        Date current = new Date();
        if (this.getModel().isDataLoaded()) {
            current = (Date)this.getModel().getValue("dateshowday");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        int week = calendar.get(7);
        int max = calendar.getActualMaximum(5);
        calendar.add(5, 0 - week);
        int index = 0;
        for (int iNum = 0; iNum < 6; ++iNum) {
            for (int j = 0; j <= 6; ++j) {
                calendar.add(5, 1);
                LabelAp dateLabel = new HRLabelAp.Builder("date_" + iNum + "_" + j).build();
                LabelAp tipsLabel = new HRLabelAp.Builder("tips_" + iNum + "_" + j).build();
                SimpleDateFormat simpleDateFormat = this.datefm_d;
                synchronized (simpleDateFormat) {
                    dateLabel.setName(new LocaleString(this.datefm_d.format(calendar.getTime())));
                }
                dateLabel.setForeColor("#000");
                dateLabel.setWidth(new LocaleString("38px"));
                dateLabel.setHeight(new LocaleString("38px"));
                dateLabel.setLineHeight("35px");
                dateLabel.setTextAlign("center");
                dateLabel.setRadius("50%");
                dateLabel.setBackColor("inherit");
                tipsLabel.setBackColor("#ffffff");
                simpleDateFormat = this.datefm_yMd;
                synchronized (simpleDateFormat) {
                    if (this.datefm_yMd.format(current.getTime()).equals(this.datefm_yMd.format(calendar.getTime()))) {
                        dateLabel.setForeColor("#FFFFFF");
                        dateLabel.setBackColor("#5582F3");
                        this.getModel().setValue("weektext", (Object)WEEK_NUM_LIST.get(j));
                    }
                }
                if (index < week - 1) {
                    dateLabel.setForeColor("#ccc");
                }
                if (index - week - max + 2 > 0) {
                    dateLabel.setForeColor("#ccc");
                }
                simpleDateFormat = this.datefm_yMd;
                synchronized (simpleDateFormat) {
                    if (!HRStringUtils.equals((String)this.datefm_yMd.format(current.getTime()), (String)this.datefm_yMd.format(calendar.getTime())) && HRStringUtils.equals((String)this.datefm_yMd.format(new Date()), (String)this.datefm_yMd.format(calendar.getTime()))) {
                        dateLabel.setForeColor("#5582F3");
                    }
                }
                this.getView().updateControlMetadata(dateLabel.getKey(), dateLabel.createControl());
                this.getView().updateControlMetadata(tipsLabel.getKey(), tipsLabel.createControl());
                ++index;
            }
        }
        this.getMonthHaveDateDay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getMonthHaveDateDay() {
        String firstDate = "";
        String lastDay = "";
        SimpleDateFormat simpleDateFormat = this.datefm_yMd;
        synchronized (simpleDateFormat) {
            firstDate = this.datefm_yMd.format(this.getDay(1, 1));
            lastDay = this.datefm_yMd.format(this.getDay(6, 7));
        }
        String type = (String)this.getModel().getValue("permissionsselected");
        List dateList = this.argIntvService.listArgIntvDate(type, firstDate, lastDay);
        HashSet hasDateDays = Sets.newHashSetWithExpectedSize((int)dateList.size());
        for (String date : dateList) {
            if (!HRStringUtils.isNotEmpty((String)date) || date.length() < 10) continue;
            hasDateDays.add(date.substring(0, 10));
        }
        this.updateMonthStyle(hasDateDays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMonthStyle(Set<String> hasDateDays) {
        this.clearMonthStyle();
        for (String date : hasDateDays) {
            int[] currRegion = new int[]{};
            try {
                SimpleDateFormat simpleDateFormat = this.datefm_yMd;
                synchronized (simpleDateFormat) {
                    currRegion = this.getRegion(this.datefm_yMd.parse(date));
                }
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
            String currKey = "tips_" + currRegion[0] + "_" + currRegion[1];
            this.updateLabelColor(currKey, "#5582F3", null);
        }
    }

    private void clearMonthStyle() {
        for (int iNum = 0; iNum < 6; ++iNum) {
            for (int j = 0; j < 7; ++j) {
                String key = "tips_" + iNum + "_" + j;
                this.updateLabelColor(key, "#ffffff", null);
            }
        }
    }

    private void getIntviewAgmtData(Date date) {
        String type = (String)this.getModel().getValue("permissionsselected");
        DynamicObjectCollection dynamicObjects = this.argIntvService.listArgIntv(type, date);
        ArrayList<Long> argIntvIdsOfDay = new ArrayList<Long>(dynamicObjects.size());
        ArrayList intervieweeNamesOfDay = new ArrayList(dynamicObjects.size());
        ArrayList<IntvDataBean> intvDataBeans = new ArrayList<IntvDataBean>(dynamicObjects.size());
        HashMap group2IndexMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject intv : dynamicObjects) {
            IntvDataBean intvDataBean;
            String groupId = intv.getString("tsirm_intvroundentry.tsirm_intvgroupentry.id");
            String intver = intv.getString("tsirm_intvroundentry.tsirm_intvgroupentry.intver.fbasedataid.name");
            if (!group2IndexMap.containsKey(groupId)) {
                intvDataBean = new IntvDataBean();
                String arranger = intv.getString("interviewarranger.name");
                intvDataBean.setArranger(arranger);
                intvDataBean.setIntvOrgFrm(intv.getString("intvorgfrm"));
                intvDataBean.setInterviewTitle(intv.getString("interviewtitle"));
                intvDataBean.setIntvMethodName(intv.getString("tsirm_intvroundentry.interviewmethod.name"));
                intvDataBean.setIntvThemeName(intv.getString("tsirm_intvroundentry.interviewtheme.name"));
                String startTime = DateUtils.secondToTime((int)intv.getInt("tsirm_intvroundentry.tsirm_intvgroupentry.intvstarttime")).substring(0, 5);
                intvDataBean.setIntvStartTime(startTime);
                String interviewStatus = intv.getString("interviewstatus");
                intvDataBean.setInterviewStatus(interviewStatus);
                String intvEvlSts = intv.getString("intvevlsts");
                intvDataBean.setIntvEvlSts(intvEvlSts);
                ArrayList<String> intvers = new ArrayList<String>();
                intvers.add(intver);
                intvDataBean.setIntvers(intvers);
                intvDataBeans.add(intvDataBean);
                group2IndexMap.put(groupId, intvDataBeans.size() - 1);
                argIntvIdsOfDay.add(intv.getLong("id"));
                continue;
            }
            intvDataBean = (IntvDataBean)intvDataBeans.get((Integer)group2IndexMap.get(groupId));
            List<String> intvers = intvDataBean.getIntvers();
            intvers.add(intver);
        }
        this.getPageCache().put(PAGE_CACHE_KEY_ARGINTVIDSOFDAY, JSON.toJSONString(argIntvIdsOfDay));
        this.getPageCache().put(PAGE_CACHE_KEY_INTERVIEWEENAMESOFDAY, JSON.toJSONString(intervieweeNamesOfDay));
        this.setDateForEntry(intvDataBeans);
    }

    public void setDateForEntry(List<IntvDataBean> intvDataBeans) {
        IntvCaleCardPlugin.initDesc();
        this.getModel().deleteEntryData("intventryentity");
        int listCount = intvDataBeans.size();
        if (listCount > 0) {
            int[] rowIndex = this.getModel().batchCreateNewEntryRow("intventryentity", listCount);
            CardEntry cardEntry = (CardEntry)this.getView().getControl("intventryentity");
            for (int iNum = 0; iNum < listCount; ++iNum) {
                IntvDataBean intvData = intvDataBeans.get(iNum);
                cardEntry.setChildVisible(false, rowIndex[iNum], new String[]{"tomorelistap"});
                this.getModel().setValue("intvtimetext", (Object)intvData.getIntvStartTime(), rowIndex[iNum]);
                int inteversNum = intvData.getIntvers().size();
                String intversText = intvData.getIntvers().size() <= 3 ? StringUtils.join((Object[])intvData.getIntvers().toArray(), (String)",") : ResManager.loadKDString((String)"{0}\u7b49{1}}\u4f4d", (String)"IntvCaleCardPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{StringUtils.join((Object[])intvData.getIntvers().subList(0, 3).toArray(), (String)","), inteversNum});
                this.getModel().setValue("intvertext", (Object)intversText, rowIndex[iNum]);
                this.getModel().setValue("arrangertext", (Object)intvData.getArranger(), rowIndex[iNum]);
                this.getModel().setValue("intvmethodtext", (Object)intvData.getIntvMethodName(), rowIndex[iNum]);
                this.getModel().setValue("intvtitle", (Object)intvData.getInterviewTitle(), rowIndex[iNum]);
                this.getModel().setValue("intvogrtypetext", (Object)intvData.getIntvThemeName(), rowIndex[iNum]);
                this.getModel().setValue("intvorgfrmtext", (Object)EVLORG_FRM.get(intvData.getIntvOrgFrm()), rowIndex[iNum]);
                this.getModel().setValue("intvevlstate", (Object)EVL_STATE.get(intvData.getIntvEvlSts()), rowIndex[iNum]);
                this.setStatusSytle(intvData.getInterviewStatus(), cardEntry, rowIndex[iNum]);
                this.cancleIntvIsShow(intvData, cardEntry, rowIndex[iNum]);
                this.iconShowState(intvData, cardEntry, rowIndex[iNum]);
                this.entryLeftLineShow(cardEntry, rowIndex[iNum], listCount);
            }
        }
    }

    private void setStatusSytle(String interviewStatus, CardEntry cardEntry, int rowIndex) {
        if (HRStringUtils.isNotEmpty((String)interviewStatus)) {
            if (HRStringUtils.equals((String)"A", (String)interviewStatus)) {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"statusb", "statusc"});
            } else if (HRStringUtils.equals((String)"B", (String)interviewStatus)) {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"statusa", "statusc"});
            } else if (HRStringUtils.equals((String)"C", (String)interviewStatus)) {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"statusa", "statusb"});
            } else {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"statusa", "statusb", "statusc"});
            }
        } else {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"statusa", "statusb", "statusc"});
        }
    }

    private void cancleIntvIsShow(IntvDataBean intvData, CardEntry cardEntry, int iNum) {
        if (!intvData.getIntvEvlSts().equals("A")) {
            cardEntry.setChildVisible(false, iNum, new String[]{"alreadycancle"});
        } else if (!intvData.getInterviewStatus().equals("C")) {
            cardEntry.setChildVisible(false, iNum, new String[]{"alreadycancle"});
        }
    }

    private void iconShowState(IntvDataBean intvData, CardEntry cardEntry, int iNum) {
        if (intvData.getIntvEvlSts().equals("A")) {
            cardEntry.setChildVisible(false, iNum, new String[]{"partiallycompletedicon", "completedicon"});
        } else if (intvData.getIntvEvlSts().equals("B")) {
            cardEntry.setChildVisible(false, iNum, new String[]{"partiallycompletedicon", "incompleteicon"});
        } else {
            cardEntry.setChildVisible(false, iNum, new String[]{"incompleteicon", "completedicon"});
        }
    }

    private void entryLeftLineShow(CardEntry cardEntry, int iNum, int listCount) {
        if (iNum == listCount - 1 || iNum == 0) {
            if (iNum == listCount - 1) {
                cardEntry.setChildVisible(false, iNum, new String[]{"lwhitetop", "lbluebot"});
            }
            if (iNum == 0) {
                cardEntry.setChildVisible(false, iNum, new String[]{"lbluetop", "lwhitebot"});
            }
        } else {
            cardEntry.setChildVisible(false, iNum, new String[]{"lwhitetop", "lwhitebot"});
        }
    }

    private void updateLabelColor(String key, String bgcolor, String frcolor) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("bc", bgcolor);
        map.put("fc", frcolor);
        this.getView().updateControlMetadata(key, map);
    }

    static {
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u65e5", (String)"IntvCaleCardPlugin_0", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u4e00", (String)"IntvCaleCardPlugin_1", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u4e8c", (String)"IntvCaleCardPlugin_2", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u4e09", (String)"IntvCaleCardPlugin_3", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u56db", (String)"IntvCaleCardPlugin_4", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u4e94", (String)"IntvCaleCardPlugin_5", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        WEEK_NUM_LIST.add(ResManager.loadKDString((String)"\u5468\u516d", (String)"IntvCaleCardPlugin_6", (String)"tsc-tssrm-formplugin", (Object[])new Object[0]));
        EVL_STATE = new HashMap<String, String>(3);
        EVLORG_FRM = new HashMap<String, String>(3);
    }
}

