/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.home;

import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileHomePageHelper;
import kd.tsc.tsirm.business.domain.hire.approval.HireApprovalDomainService;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsrbd.common.enums.DatePeriodEnum;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.enums.DateEnum;
import org.apache.commons.lang3.StringUtils;

public class PendingCardPlugin
extends AbstractFormPlugin {
    private static final String KEY_RESUME_SCREEN_LABEL = "labelap22";
    private static final String KEY_INTV_TRACE_LABEL = "labelap23";
    private static final String KEY_DATE_PERIOD_COMBO_FIELD = "combofield11";
    private static final String KEY_HIRE = "labelap24";

    public void afterCreateNewData(EventObject evt) {
        super.afterCreateNewData(evt);
        String dateValue = (String)this.getModel().getValue(KEY_DATE_PERIOD_COMBO_FIELD);
        this.updateNums(dateValue);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label = (Label)this.getView().getControl(KEY_INTV_TRACE_LABEL);
        label.addClickListener((ClickListener)this);
        Label hireLabel = (Label)this.getView().getControl(KEY_HIRE);
        hireLabel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)source.getKey(), (String)KEY_INTV_TRACE_LABEL)) {
            this.openView();
        }
        if (HRStringUtils.equals((String)source.getKey(), (String)KEY_HIRE)) {
            this.showFormList("tsirm_hireapprovalsg");
        }
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            String dateValue = (String)this.getModel().getValue(KEY_DATE_PERIOD_COMBO_FIELD);
            this.updateNums(dateValue);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)KEY_DATE_PERIOD_COMBO_FIELD, (String)fieldName)) {
            ChangeData changeData = evt.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            this.updateNums(newValue);
        }
    }

    private void updateNums(String timeFilterType) {
        String startTime = "";
        String endTime = "";
        if (HRStringUtils.isNotEmpty((String)timeFilterType)) {
            startTime = (String)AppFileHomePageHelper.coversTimePeriod((String)timeFilterType).get("startdate");
            endTime = (String)AppFileHomePageHelper.coversTimePeriod((String)timeFilterType).get("enddate");
        }
        Label label = (Label)this.getView().getControl(KEY_RESUME_SCREEN_LABEL);
        DynamicObject[] resumeDyn = AppFileHomePageHelper.getResumeFilterData((String)startTime, (String)endTime);
        int resumeNum = resumeDyn == null ? 0 : resumeDyn.length;
        label.setText(resumeNum + "");
        label = (Label)this.getView().getControl(KEY_INTV_TRACE_LABEL);
        int traceNum = IntvAppfileTaskHelper.getInstance().getTraceNum(startTime, endTime);
        label.setText(traceNum + "");
        Label hire = (Label)this.getView().getControl(KEY_HIRE);
        String hireNum = HireApprovalDomainService.getHireApprovalData((String)startTime, (String)endTime);
        hire.setText(hireNum.toString());
    }

    public void showFormList(String pageKey) {
        ListShowParameter HRBUCAViewList = new ListShowParameter();
        HRBUCAViewList.setBillFormId(pageKey);
        HRBUCAViewList.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, String> params = new HashMap<String, String>(16);
        String timeRangeType = (String)this.getModel().getValue(KEY_DATE_PERIOD_COMBO_FIELD);
        params.put("timeRangeType", timeRangeType);
        if (StringUtils.equals((CharSequence)pageKey, (CharSequence)"tso_offerbaselist")) {
            HRBUCAViewList.setCaption(String.format(ResManager.loadKDString((String)"Offer\u7ba1\u7406", (String)"PendingCardPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), new Object[0]));
        }
        HRBUCAViewList.setCustomParams(params);
        this.getView().showForm((FormShowParameter)HRBUCAViewList);
    }

    private void openView() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_intvlist");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        HashMap<String, Object> customParamMap = new HashMap<String, Object>(10);
        customParamMap.put("is_homepage", Boolean.TRUE);
        customParamMap.put("active_table", "appfiletask");
        String createTimeCode = "";
        String dateValue = (String)this.getModel().getValue(KEY_DATE_PERIOD_COMBO_FIELD);
        if (HRStringUtils.isNotEmpty((String)dateValue)) {
            if (HRStringUtils.equals((String)DatePeriodEnum.TODAY.getCode(), (String)dateValue)) {
                createTimeCode = DateEnum.TODAY.getCode();
            } else if (HRStringUtils.equals((String)DatePeriodEnum.THIS_MONTH.getCode(), (String)dateValue)) {
                createTimeCode = DateEnum.THIS_MONTH.getCode();
            } else if (HRStringUtils.equals((String)DatePeriodEnum.PAST_THREE_MONTH.getCode(), (String)dateValue)) {
                createTimeCode = DateEnum.NEARLY_THREE_MONTHS.getCode();
            } else if (HRStringUtils.equals((String)DatePeriodEnum.NEST_THREE_MONTH.getCode(), (String)dateValue)) {
                createTimeCode = DateEnum.FUTURE_THREE_MONTHS.getCode();
            } else if (HRStringUtils.equals((String)DatePeriodEnum.PAST_ONE_YEAR.getCode(), (String)dateValue)) {
                createTimeCode = DateEnum.LAST_YEAR.getCode();
            } else {
                LocalDate startDate = DateUtils.getByPeriod((DatePeriodEnum)DatePeriodEnum.getByCode((String)dateValue));
                String startTime = DateUtils.getDayStartTime((LocalDate)startDate);
                String endTime = DateUtils.getDayEndTime((LocalDate)LocalDate.now());
                customParamMap.put("start_createtime", "".equals(startTime) ? null : startTime);
                customParamMap.put("end_createtime", "".equals(endTime) ? null : endTime);
            }
        }
        if (HRStringUtils.isNotEmpty((String)createTimeCode)) {
            customParamMap.put("createtime", createTimeCode);
        }
        customParamMap.put("is_arranger_self", Boolean.TRUE);
        customParamMap.put("task_status", "A");
        showParameter.setCustomParams(customParamMap);
        showParameter.setCaption(ResManager.loadKDString((String)"\u9762\u8bd5\u7ba1\u7406\u5217\u8868", (String)"PendingCardPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }
}

