/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.home;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.position.service.PositionHomeDataHelper;

public class RecruDataViewPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RecruDataViewPlugin.class);

    public void afterCreateNewData(EventObject evt) {
        this.setPageDateValue();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"ownerselect", (String)fieldName)) {
            this.setPageDateValue();
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label1 = (Label)this.getView().getControl("positionnum");
        Label label2 = (Label)this.getView().getControl("personnum");
        label1.addClickListener((ClickListener)this);
        label2.addClickListener((ClickListener)this);
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            this.setPageDateValue();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)"personnum", (String)source.getKey()) || HRStringUtils.equals((String)"positionnum", (String)source.getKey())) {
            String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
            String pageKey = HRStringUtils.equals((String)"owner", (String)ownerSelectValue) ? "tsirm_position_delivery" : "tsirm_position";
            this.showFormDataList(pageKey);
        }
    }

    private List<Long> getHasPremOrgIds() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List hasPermViewOrgs = PositionHomeDataHelper.getHasPermViewOrgs((FormShowParameter)formShowParameter);
        List orgList = PositionHomeDataHelper.queryPositionAllUseOrg((List)hasPermViewOrgs);
        ArrayList<Long> orgs = new ArrayList<Long>(orgList.size());
        for (Map org : orgList) {
            orgs.add(Long.parseLong((String)org.get("id")));
        }
        return orgs;
    }

    public void setPageDateValue() {
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        List<Long> orgs = this.getHasPremOrgIds();
        Map positionMap = PositionHomeDataHelper.queryPositionNum((boolean)isOwner, orgs);
        PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"positionnum", (int)((Integer)positionMap.get("totalNum")));
        PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"personnum", (int)((Integer)positionMap.get("statusOpenNum")));
    }

    private void showFormDataList(String pageKey) {
        ListShowParameter HRBUCAViewList = new ListShowParameter();
        HRBUCAViewList.setBillFormId(pageKey);
        HRBUCAViewList.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        Boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        params.put("isOwner", isOwner);
        params.put("recruitProcId", "0");
        HRBUCAViewList.setCustomParams(params);
        try {
            this.getView().showForm((FormShowParameter)HRBUCAViewList);
        }
        catch (Exception evt) {
            logger.error(evt.getMessage());
            IListView listViewException = (IListView)this.getView();
            listViewException.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9875\u9762\u6807\u8bc6\u662f\u5426\u6b63\u786e", (String)"RecruDataViewPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }
}

