/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.home;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.tsirm.extpoint.home.HomeViewService;
import kd.tsc.tsirm.business.domain.appfile.service.AppFileHomePageHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHomeDataHelper;
import kd.tsc.tsirm.common.format.Numformat;

public class RecruProcessCardPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RecruProcessCardPlugin.class);
    private static final Map<String, Integer> QUERY_TYPE_MAP = Maps.newHashMapWithExpectedSize((int)12);
    private static final int MAXNUM = 9999;

    public void afterCreateNewData(EventObject evt) {
        this.setOrgSelectValue();
        this.setProcSelectValue();
        this.setPageDateValue();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"ownerselect", (String)fieldName)) {
            this.setOrgSelectValue();
            this.setProcSelectValue();
            this.setPageDateValue();
        }
        if (HRStringUtils.equals((String)"orgselect", (String)fieldName)) {
            this.setProcSelectValue();
            this.setPageDateValue();
        }
        if (HRStringUtils.equals((String)"procselect", (String)fieldName) || HRStringUtils.equals((String)"dataselect", (String)fieldName)) {
            this.setPageDateValue();
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label1 = (Label)this.getView().getControl("positionnum");
        Label label2 = (Label)this.getView().getControl("personnum");
        Label label3 = (Label)this.getView().getControl("tobescreened");
        Label label4 = (Label)this.getView().getControl("screening");
        Label label5 = (Label)this.getView().getControl("screened");
        Label label6 = (Label)this.getView().getControl("tobearranged");
        Label label7 = (Label)this.getView().getControl("tobeinterviewed");
        Label label8 = (Label)this.getView().getControl("tobeadvanced");
        Label label9 = (Label)this.getView().getControl("tobe_employment");
        Label label10 = (Label)this.getView().getControl("employmenting");
        Label label11 = (Label)this.getView().getControl("employmented");
        label1.addClickListener((ClickListener)this);
        label2.addClickListener((ClickListener)this);
        label3.addClickListener((ClickListener)this);
        label4.addClickListener((ClickListener)this);
        label5.addClickListener((ClickListener)this);
        label6.addClickListener((ClickListener)this);
        label7.addClickListener((ClickListener)this);
        label8.addClickListener((ClickListener)this);
        label9.addClickListener((ClickListener)this);
        label10.addClickListener((ClickListener)this);
        label11.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String pageKey;
        super.click(evt);
        Control source = (Control)evt.getSource();
        Integer queryType = null;
        if (HRStringUtils.equals((String)"personnum", (String)source.getKey()) || HRStringUtils.equals((String)"positionnum", (String)source.getKey())) {
            String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
            pageKey = HRStringUtils.equals((String)"owner", (String)ownerSelectValue) ? "tsirm_position_delivery" : "tsirm_position";
        } else {
            pageKey = "tsirm_appfile_view";
            queryType = QUERY_TYPE_MAP.get(source.getKey());
        }
        this.showFormDataList(pageKey, queryType);
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            this.setPageDateValue();
        }
    }

    public void setOrgSelectValue() {
        long userOrgId = RequestContext.get().getOrgId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List hasPermViewOrgs = PositionHomeDataHelper.getHasPermViewOrgs((FormShowParameter)formShowParameter);
        List orgList = PositionHomeDataHelper.queryPositionAllUseOrg((List)hasPermViewOrgs);
        if (orgList.size() == 0) {
            this.getModel().setValue("orgselect", (Object)userOrgId);
            List userOrg = PositionHomeDataHelper.getUserOrg((Long)userOrgId);
            this.setComboEdit(userOrg);
            return;
        }
        this.setComboEdit(orgList);
        if (hasPermViewOrgs.contains(userOrgId)) {
            this.getModel().setValue("orgselect", (Object)userOrgId);
        } else {
            this.getModel().setValue("orgselect", hasPermViewOrgs.get(0));
        }
    }

    private List<Long> getSelectedOrgIds() {
        String orgSelect = (String)this.getModel().getValue("orgselect");
        long orgSelectValue = Long.parseLong(orgSelect);
        orgSelectValue = orgSelectValue != 0L ? orgSelectValue : RequestContext.get().getOrgId();
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(orgSelectValue);
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, HomeViewService.class, (String)"kd.sdk.tsc.tsirm.extpoint.home.HomeViewService", null);
        proxy.callAfter(service -> {
            if (service != null) {
                service.setCustomOrgIds(orgs);
            }
            return null;
        });
        return orgs;
    }

    private void setComboEdit(List<Map<String, String>> orgList) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("orgselect");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(orgList.size());
        for (Map<String, String> org : orgList) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(org.get("name")));
            comboItem.setValue(org.get("id"));
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void setProcSelectValue() {
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        String orgSelect = (String)this.getModel().getValue("orgselect");
        if ("0".equals(orgSelect)) {
            return;
        }
        List positionRecruitId = PositionHomeDataHelper.queryPositionRecruitProc((boolean)isOwner, this.getSelectedOrgIds());
        QFilter filter = new QFilter("id", "in", (Object)positionRecruitId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,name";
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        try (DataSet result = hrBaseServiceHelper.queryDataSet("tsrbd_rqmtproc", selectFields, filters, "createtime desc");){
            ComboEdit comboEdit = (ComboEdit)this.getControl("procselect");
            ArrayList comboItems = Lists.newArrayListWithCapacity((int)10);
            ComboItem comboItem = new ComboItem();
            String caption = ResManager.loadKDString((String)"\u5168\u90e8", (String)"RecruProcessCardPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            comboItem.setCaption(new LocaleString(caption));
            comboItem.setValue("0");
            comboItems.add(comboItem);
            for (Row row : result) {
                comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(row.getString("name")));
                comboItem.setValue(row.getString("id"));
                comboItems.add(comboItem);
            }
            comboEdit.setComboItems((List)comboItems);
            if (comboItems.size() > 1) {
                this.getModel().setValue("procselect", (Object)((ComboItem)comboItems.get(1)).getValue());
            } else {
                this.getModel().setValue("procselect", (Object)"0");
            }
        }
    }

    public void setPageDateValue() {
        Map employmentMap;
        Map interviewMap;
        long now = System.currentTimeMillis();
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        String procSelect = (String)this.getModel().getValue("procselect");
        Long procSelectValue = Long.valueOf(procSelect);
        String dataSelectValue = (String)this.getModel().getValue("dataselect");
        boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        List<Long> orgs = this.getSelectedOrgIds();
        Map positionMap = PositionHomeDataHelper.queryPositionNum((boolean)isOwner, (Long)procSelectValue, (String)dataSelectValue, orgs);
        Label positionNumLabel = (Label)this.getView().getControl("positionnum");
        positionNumLabel.setText(Numformat.excessNumShowAdd((int)((Integer)positionMap.get("totalNum")), (int)9999));
        Label personNumLabel = (Label)this.getView().getControl("personnum");
        personNumLabel.setText(Numformat.excessNumShowAdd((int)((Integer)positionMap.get("statusOpenNum")), (int)9999));
        Map screenMap = AppFileHomePageHelper.getFilterCandidateData((boolean)isOwner, (Long)procSelectValue, (String)dataSelectValue, orgs);
        if (!screenMap.isEmpty()) {
            Label tobeScreenedLabel = (Label)this.getView().getControl("tobescreened");
            Label screeningLabel = (Label)this.getView().getControl("screening");
            Label screenedLabel = (Label)this.getView().getControl("screened");
            tobeScreenedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)screenMap.get("begin")), (int)9999));
            screeningLabel.setText(Numformat.excessNumShowAdd((int)((Integer)screenMap.get("in")), (int)9999));
            screenedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)screenMap.get("end")), (int)9999));
        }
        if (!(interviewMap = AppFileHomePageHelper.getInterviewCandidateData((boolean)isOwner, (Long)procSelectValue, (String)dataSelectValue, orgs)).isEmpty()) {
            Label tobeArrangedLabel = (Label)this.getView().getControl("tobearranged");
            Label tobeInterviewedLabel = (Label)this.getView().getControl("tobeinterviewed");
            Label tobeAdvancedLabel = (Label)this.getView().getControl("tobeadvanced");
            tobeArrangedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)interviewMap.get("begin")), (int)9999));
            tobeInterviewedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)interviewMap.get("in")), (int)9999));
            tobeAdvancedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)interviewMap.get("end")), (int)9999));
        }
        if (!(employmentMap = AppFileHomePageHelper.getHireCandidateData((boolean)isOwner, (Long)procSelectValue, (String)dataSelectValue, orgs)).isEmpty()) {
            Label tobeEmploymentLabel = (Label)this.getView().getControl("tobe_employment");
            Label employmentingLabel = (Label)this.getView().getControl("employmenting");
            Label employmentedLabel = (Label)this.getView().getControl("employmented");
            tobeEmploymentLabel.setText(Numformat.excessNumShowAdd((int)((Integer)employmentMap.get("begin")), (int)9999));
            employmentingLabel.setText(Numformat.excessNumShowAdd((int)((Integer)employmentMap.get("in")), (int)9999));
            employmentedLabel.setText(Numformat.excessNumShowAdd((int)((Integer)employmentMap.get("end")), (int)9999));
        }
    }

    private void showFormDataList(String pageKey, Integer queryType) {
        ListShowParameter HRBUCAViewList = new ListShowParameter();
        HRBUCAViewList.setBillFormId(pageKey);
        HRBUCAViewList.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        String procSelectValue = (String)this.getModel().getValue("procselect");
        String dataSelectValue = (String)this.getModel().getValue("dataselect");
        Boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        if ("tsirm_appfile_view".equals(pageKey)) {
            if (isOwner.booleanValue()) {
                HRBUCAViewList.setBillFormId("tsirm_appfile_viewc");
            } else {
                HRBUCAViewList.setBillFormId("tsirm_appfile_viewm");
            }
        }
        params.put("isOwner", isOwner);
        params.put("recruitProcId", procSelectValue);
        params.put("timeRangeType", dataSelectValue);
        params.put("queryType", queryType);
        params.put("orgIds", this.getSelectedOrgIds());
        HRBUCAViewList.setCustomParams(params);
        try {
            this.getView().showForm((FormShowParameter)HRBUCAViewList);
        }
        catch (Exception evt) {
            logger.error(evt.getMessage());
            IListView listViewException = (IListView)this.getView();
            listViewException.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9875\u9762\u6807\u8bc6\u662f\u5426\u6b63\u786e", (String)"RecruProcessCardPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    static {
        QUERY_TYPE_MAP.put("tobescreened", 1);
        QUERY_TYPE_MAP.put("screening", 2);
        QUERY_TYPE_MAP.put("screened", 3);
        QUERY_TYPE_MAP.put("tobearranged", 4);
        QUERY_TYPE_MAP.put("tobeinterviewed", 5);
        QUERY_TYPE_MAP.put("tobeadvanced", 6);
        QUERY_TYPE_MAP.put("tobe_employment", 7);
        QUERY_TYPE_MAP.put("employmenting", 8);
        QUERY_TYPE_MAP.put("employmented", 9);
    }
}

