/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.home;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.tsc.tsirm.extpoint.home.HomeViewService;
import kd.tsc.tsirm.business.domain.appfile.service.AppFilePositionHelper;
import kd.tsc.tsirm.business.domain.appfile.service.AppProHomePageHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionHomeDataHelper;
import kd.tsc.tsirm.common.util.FormShowUtils;

public class RecruProcessPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(RecruProcessPlugin.class);
    private static final String KEY_ALLORG = "allorg";
    private static final Map<String, Integer> QUERY_TYPE_MAP = Maps.newHashMapWithExpectedSize((int)12);

    public void afterCreateNewData(EventObject evt) {
        this.setOrgSelectValue();
        this.setProcSelectValue();
        this.setPageDateValue();
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)"ownerselect", (String)fieldName)) {
            this.setOrgSelectValue();
            this.setProcSelectValue();
            this.setPageDateValue();
        }
        if (HRStringUtils.equals((String)"orgselect", (String)fieldName)) {
            logger.info("start setProcSelectValue");
            this.setProcSelectValue();
            this.setPageDateValue();
        }
        if (HRStringUtils.equals((String)"procselect", (String)fieldName)) {
            Map comboValueMap = FormShowUtils.getComboValueMap((IFormView)this.getView(), (String)"procselect");
            String procSelect = (String)this.getModel().getValue("procselect");
            Optional firstKey = comboValueMap.keySet().stream().findFirst();
            if (firstKey.isPresent() && comboValueMap.get(procSelect) == null) {
                String resetValue = (String)firstKey.get();
                this.getModel().setValue("procselect", (Object)resetValue);
            }
            this.setPageDateValue();
        }
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Label label3 = (Label)this.getView().getControl("tobescreened");
        Label label5 = (Label)this.getView().getControl("screened");
        Label label6 = (Label)this.getView().getControl("tobearranged");
        Label label7 = (Label)this.getView().getControl("tobeinterviewed");
        Label label8 = (Label)this.getView().getControl("tobeadvanced");
        Label label9 = (Label)this.getView().getControl("tobe_employment");
        Label label10 = (Label)this.getView().getControl("employmenting");
        Label label11 = (Label)this.getView().getControl("waitchange");
        Label label12 = (Label)this.getView().getControl("changing");
        label3.addClickListener((ClickListener)this);
        label5.addClickListener((ClickListener)this);
        label6.addClickListener((ClickListener)this);
        label7.addClickListener((ClickListener)this);
        label8.addClickListener((ClickListener)this);
        label9.addClickListener((ClickListener)this);
        label10.addClickListener((ClickListener)this);
        label11.addClickListener((ClickListener)this);
        label12.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        Integer queryType = null;
        String pageKey = "tsirm_appfile_view";
        queryType = QUERY_TYPE_MAP.get(source.getKey());
        this.showFormDataList(pageKey, queryType);
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.equals((String)"refreshFromGridContainer", (String)evt.getKey())) {
            this.setPageDateValue();
        }
    }

    public void setOrgSelectValue() {
        long userOrgId = RequestContext.get().getOrgId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List hasPermViewOrgs = PositionHomeDataHelper.getHasPermViewOrgs((FormShowParameter)formShowParameter);
        List orgList = PositionHomeDataHelper.queryPositionAllUseOrg((List)hasPermViewOrgs);
        if (orgList.size() == 0) {
            orgList = PositionHomeDataHelper.getUserOrg((Long)userOrgId);
        }
        this.setComboEdit(orgList);
        this.getModel().setValue("orgselect", (Object)KEY_ALLORG);
    }

    private List<Long> getSelectedOrgIds() {
        String orgSelect = (String)this.getModel().getValue("orgselect");
        ArrayList<Long> orgs = new ArrayList<Long>();
        if (HRStringUtils.equals((String)KEY_ALLORG, (String)orgSelect)) {
            Map comboPropValueMap = FormShowUtils.getComboValueMap((IFormView)this.getView(), (String)"orgselect");
            List orgIds = null;
            if (!CollectionUtils.isEmpty((Map)comboPropValueMap)) {
                orgIds = comboPropValueMap.keySet().stream().filter(value -> !HRStringUtils.equals((String)value, (String)KEY_ALLORG)).map(Long::parseLong).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty(orgIds)) {
                orgs.add(RequestContext.get().getOrgId());
            } else {
                orgs.addAll(orgIds);
            }
        } else {
            long orgSelectValue = Long.parseLong(orgSelect);
            orgSelectValue = orgSelectValue != 0L ? orgSelectValue : RequestContext.get().getOrgId();
            orgs.add(orgSelectValue);
        }
        HRPluginProxy proxy = HRPlugInProxyFactory.create(null, HomeViewService.class, (String)"kd.sdk.tsc.tsirm.extpoint.home.HomeViewService", null);
        proxy.callAfter(service -> {
            if (service != null) {
                service.setCustomOrgIds(orgs);
            }
            return null;
        });
        return orgs;
    }

    private void setComboEdit(List<Map<String, String>> orgList) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("orgselect");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(orgList.size());
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"RecruProcessPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0])));
        comboItem.setValue(KEY_ALLORG);
        comboItems.add(comboItem);
        for (Map<String, String> org : orgList) {
            comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(org.get("name")));
            comboItem.setValue(org.get("id"));
            comboItems.add(comboItem);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void setProcSelectValue() {
        long now = System.currentTimeMillis();
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        String orgSelect = (String)this.getModel().getValue("orgselect");
        if ("0".equals(orgSelect)) {
            return;
        }
        List positionRecruitId = PositionHomeDataHelper.queryPositionRecruitProc((boolean)isOwner, this.getSelectedOrgIds());
        QFilter filter = new QFilter("id", "in", (Object)positionRecruitId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,number,name";
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsrbd_rqmtproc");
        try (DataSet result = hrBaseServiceHelper.queryDataSet("tsrbd_rqmtproc", selectFields, filters, "createtime desc");){
            ComboEdit comboEdit = (ComboEdit)this.getControl("procselect");
            ArrayList comboItems = Lists.newArrayListWithCapacity((int)10);
            ComboItem comboItem = new ComboItem();
            String caption = ResManager.loadKDString((String)"\u5168\u90e8", (String)"RecruProcessPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            comboItem.setCaption(new LocaleString(caption));
            comboItem.setValue("0");
            comboItems.add(comboItem);
            for (Row row : result) {
                comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(row.getString("name")));
                comboItem.setValue(row.getString("id"));
                comboItems.add(comboItem);
            }
            comboEdit.setComboItems((List)comboItems);
            this.getModel().setValue("procselect", (Object)"0");
        }
    }

    public void setPageDateValue() {
        Map changeCandidateData;
        Map employmentMap;
        Map interviewMap;
        long now = System.currentTimeMillis();
        logger.info("start setProcSelectValue");
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        String procSelect = (String)this.getModel().getValue("procselect");
        Long procSelectValue = Long.valueOf(procSelect);
        boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        List<Long> orgs = this.getSelectedOrgIds();
        List positionIds = AppFilePositionHelper.getPositionIdsRightRecruing((String)"position", (boolean)isOwner, orgs);
        Map screenMap = AppProHomePageHelper.getFilterCandidateData((boolean)isOwner, (Long)procSelectValue, null, (List)positionIds);
        if (!screenMap.isEmpty()) {
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"tobescreened", (int)((Integer)screenMap.get("begin")));
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"screened", (int)((Integer)screenMap.get("end")));
        }
        if (!(interviewMap = AppProHomePageHelper.getInterviewCandidateData((boolean)isOwner, (Long)procSelectValue, null, (List)positionIds)).isEmpty()) {
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"tobearranged", (int)((Integer)interviewMap.get("begin")));
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"tobeinterviewed", (int)((Integer)interviewMap.get("in")));
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"tobeadvanced", (int)((Integer)interviewMap.get("end")));
        }
        if (!(employmentMap = AppProHomePageHelper.getHireCandidateData((boolean)isOwner, (Long)procSelectValue, null, (List)positionIds)).isEmpty()) {
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"tobe_employment", (int)((Integer)employmentMap.get("begin")));
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"employmenting", (int)((Integer)employmentMap.get("in")));
        }
        if (!(changeCandidateData = AppProHomePageHelper.getChangeCandidateData((boolean)isOwner, (Long)procSelectValue, null, (List)positionIds)).isEmpty()) {
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"waitchange", (int)((Integer)changeCandidateData.get("begin")));
            PositionHomeDataHelper.setHomeLabelValue((IFormView)this.getView(), (String)"changing", (int)((Integer)changeCandidateData.get("in")));
        }
        logger.info("end setProcSelectValue, cost:{}", (Object)(System.currentTimeMillis() - now));
    }

    private void showFormDataList(String pageKey, Integer queryType) {
        ListShowParameter HRBUCAViewList = new ListShowParameter();
        HRBUCAViewList.setBillFormId(pageKey);
        HRBUCAViewList.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String ownerSelectValue = (String)this.getModel().getValue("ownerselect");
        String procSelectValue = (String)this.getModel().getValue("procselect");
        Boolean isOwner = HRStringUtils.equals((String)"owner", (String)ownerSelectValue);
        if ("tsirm_appfile_view".equals(pageKey)) {
            if (isOwner.booleanValue()) {
                HRBUCAViewList.setBillFormId("tsirm_appfile_viewc");
            } else {
                HRBUCAViewList.setBillFormId("tsirm_appfile_viewm");
            }
        }
        params.put("isOwner", isOwner);
        params.put("recruitProcId", procSelectValue);
        params.put("queryType", queryType);
        params.put("orgIds", this.getSelectedOrgIds());
        if (queryType.equals(108)) {
            params.put("changeStatus", "C");
        } else if (queryType.equals(109)) {
            params.put("changeStatus", "D");
        }
        HRBUCAViewList.setCustomParams(params);
        try {
            this.getView().showForm((FormShowParameter)HRBUCAViewList);
        }
        catch (Exception evt) {
            logger.error(evt.getMessage());
            IListView listViewException = (IListView)this.getView();
            listViewException.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u9875\u9762\u6807\u8bc6\u662f\u5426\u6b63\u786e", (String)"RecruProcessPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    static {
        QUERY_TYPE_MAP.put("tobescreened", 101);
        QUERY_TYPE_MAP.put("screened", 102);
        QUERY_TYPE_MAP.put("tobearranged", 103);
        QUERY_TYPE_MAP.put("tobeinterviewed", 104);
        QUERY_TYPE_MAP.put("tobeadvanced", 105);
        QUERY_TYPE_MAP.put("tobe_employment", 106);
        QUERY_TYPE_MAP.put("employmenting", 107);
        QUERY_TYPE_MAP.put("waitchange", 108);
        QUERY_TYPE_MAP.put("changing", 109);
    }
}

