/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.position.service.PositionDataHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.common.util.IntvPermUtil;
import kd.tsc.tsrbs.common.enums.CommonEnum;
import kd.tsc.tsrbs.common.enums.DateEnum;
import kd.tsc.tsrbs.common.enums.InterviewEnum;
import kd.tsc.tsrbs.common.enums.QueryDateEnum;
import kd.tsc.tsrbs.common.utils.ComboItemUtils;
import kd.tsc.tsrbs.common.utils.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class AppFileTaskBillList
extends HRDataBaseList {
    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if ("intvevlstatus".equals(fieldKey)) {
            String intvEvlStatus = evt.getRowData().getString("intvevlstatus");
            evt.setFormatValue((Object)(StringUtils.isEmpty((CharSequence)intvEvlStatus) ? "-" : intvEvlStatus));
        }
        if ("intvstarttime".equals(fieldKey) && evt.getRowData().containsProperty("intvTime")) {
            Date intvStartDate = evt.getRowData().getDate("intvTime");
            evt.setFormatValue((Object)(intvStartDate == null ? "00:00:00" : IntvDateUtil.getIntvDate((Date)intvStartDate, (String)"HH:mm:ss")));
        }
    }

    public void afterCreateNewData(EventObject evt) {
        if (!IntvPermUtil.verifyHasPerm((String)this.getView().getEntityId(), (String)"bar_list_urgeevl", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_list_urgeevl"});
        }
        if (!IntvPermUtil.verifyHasPerm((String)this.getView().getEntityId(), (String)"bar_list_urgereply", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_list_urgereply"});
        }
        if (!IntvPermUtil.verifyHasPerm((String)this.getView().getEntityId(), (String)"bar_cancelintv", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancelintv"});
        }
    }

    public void setFilter(SetFilterEvent evt) {
        String startCreateTime = (String)this.getView().getFormShowParameter().getCustomParam("start_createtime");
        String endCreateTime = (String)this.getView().getFormShowParameter().getCustomParam("end_createtime");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Optional.ofNullable(startCreateTime).ifPresent(startTime -> qFilterList.add(new QFilter("argintv.createtime", ">=", (Object)IntvDateUtil.parseDateTimeStr((String)startTime, (String)"yyyy-MM-dd HH:mm:ss"))));
        Optional.ofNullable(endCreateTime).ifPresent(endTime -> qFilterList.add(new QFilter("argintv.createtime", "<=", (Object)IntvDateUtil.parseDateTimeStr((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"))));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        long currUserId = RequestContext.get().getCurrUserId();
        boolean superUser = PermissionServiceHelper.isSuperUser((long)currUserId);
        if (!superUser) {
            QFilter qFilter = new QFilter("interviewarranger.id", "=", (Object)RequestContext.get().getCurrUserId());
            qFilter.or(new QFilter("application.position", "in", (Object)PositionDataHelper.getHashPermPositionIds()));
            qFilterList.add(qFilter);
        }
        evt.setCustomQFilters(qFilterList);
        evt.setOrderBy("intvtime desc,id desc");
        super.setFilter(evt);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        args = this.setCommonFilterColumn(args);
        super.filterContainerInit(args);
    }

    private Boolean isSelfExists(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Boolean.FALSE;
        }
        long count = userIdList.stream().filter(userId -> UserServiceHelper.getCurrentUserId() == userId).count();
        return count == 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    private List<Map<String, Object>> getAllUserInfoList(List<Long> userIdList) {
        return UserServiceHelper.get(userIdList);
    }

    private List<ComboItem> getComboItemList(List<Map<String, Object>> userInfoList) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        Optional.ofNullable(userInfoList).ifPresent(userList -> userList.forEach(userInfo -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(userInfo.get("id")));
            comboItem.setCaption(new LocaleString(((OrmLocaleValue)userInfo.get("name")).getLocaleValue()));
            comboItemList.add(comboItem);
        }));
        return comboItemList;
    }

    private void setIntvArger(CommonFilterColumn commonFilterColumn, List<Long> userIdList) {
        if (this.isSelfExists(userIdList).booleanValue()) {
            commonFilterColumn.setDefaultValue(String.valueOf(UserServiceHelper.getCurrentUserId()));
        }
        commonFilterColumn.setComboItems(this.getComboItemList(this.getAllUserInfoList(userIdList)));
    }

    private FilterContainerInitArgs setCommonFilterColumn(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String creatTimeCode = (String)customParams.get("createtime");
        String taskStatus = (String)customParams.get("task_status");
        long currUserId = RequestContext.get().getCurrUserId();
        List commonFilterColumnList = args.getCommonFilterColumns();
        commonFilterColumnList.forEach(commonFilterColumn -> {
            if ("taskstatus".equals(commonFilterColumn.getFieldName())) {
                commonFilterColumn.setDefaultValue(taskStatus);
            } else if ("interviewarranger.name".equals(commonFilterColumn.getFieldName())) {
                ArrayList userIdList = Lists.newArrayList((Object[])new Long[]{currUserId});
                this.setIntvArger((CommonFilterColumn)commonFilterColumn, userIdList);
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)creatTimeCode)) {
            CommonFilterColumn intvDateColumn = new CommonFilterColumn("argintv.createtime");
            intvDateColumn.setCaption(new LocaleString(InterviewEnum.INTERVIEW_CREATE_TIME.getValue()));
            intvDateColumn.setCustom(true);
            intvDateColumn.setDefaultValue(creatTimeCode);
            List comboItemList = ComboItemUtils.setComboItem((CommonEnum[])QueryDateEnum.values());
            intvDateColumn.setComboItems(StringUtils.isEmpty((CharSequence)creatTimeCode) ? comboItemList : ComboItemUtils.setComboItem((CommonEnum)EnumUtils.getEnumByCode((String)creatTimeCode, DateEnum.class), (List)comboItemList));
            args.addFilterColumn((FilterColumn)intvDateColumn);
        }
        return args;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.showForm(args.getFieldName(), this.getPrimaryKey());
    }

    private Long getPrimaryKey() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        return (Long)baseDataListRow.getPrimaryKeyValue();
    }

    private void showForm(String column, Long primaryKey) {
        BillShowParameter showParameter;
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(primaryKey, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"AppFileTaskBillList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        if ("application_name".equals(column)) {
            showParameter = new BillShowParameter();
            showParameter.setFormId("tsirm_appfile_viewm");
            Optional.ofNullable(TsrbsHelper.selectById((Long)primaryKey, (String)"tsirm_appfiletask")).ifPresent(arg_0 -> AppFileTaskBillList.lambda$showForm$6((FormShowParameter)showParameter, arg_0));
        } else if ("argintv_interviewtitle".equals(column)) {
            showParameter = new FormShowParameter();
            showParameter.setFormId("tsirm_argintvdetail");
            Optional.ofNullable(TsrbsHelper.selectById((Long)primaryKey, (String)"tsirm_appfiletask")).ifPresent(arg_0 -> AppFileTaskBillList.lambda$showForm$7((FormShowParameter)showParameter, arg_0));
        } else {
            return;
        }
        showParameter.setCustomParam("pageId", (Object)this.getView().getPageId());
        OpenStyle openStyle = showParameter.getOpenStyle();
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private static /* synthetic */ void lambda$showForm$7(FormShowParameter showParameter, DynamicObject appFileTask) {
        showParameter.setCustomParam("arg_intv_id", (Object)appFileTask.getLong("argintv.id"));
    }

    private static /* synthetic */ void lambda$showForm$6(FormShowParameter showParameter, DynamicObject appFileTask) {
        showParameter.setCaption(ResManager.loadKDString((String)"\u5019\u9009\u4eba-{0}", (String)"AppFileTaskBillList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{appFileTask.getString("application.name")}));
        ((BillShowParameter)showParameter).setPkId((Object)appFileTask.getLong("application.id"));
        showParameter.setStatus(OperationStatus.EDIT);
    }
}

