/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvOperateUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.constants.intv.TssrmIntvFormConstants;
import kd.tsc.tsirm.common.util.FormShowUtils;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.common.util.IntvPermUtil;
import org.springframework.util.CollectionUtils;

public class ArgIntvDetailEdit
extends HRCoreBaseBillEdit {
    private static final Log logger = LogFactory.getLog(ArgIntvDetailEdit.class);
    private static final Map<String, String> INTVRESULT_MAP = new HashMap<String, String>(8);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Toolbar scoreToolBar = (Toolbar)this.getView().getControl("toolbarap");
        scoreToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (TssrmIntvFormConstants.IntvDetail.BUTTON_LIST.indexOf(evt.getItemKey())) {
            case 0: {
                this.jumpModifyPage();
                break;
            }
            case 3: {
                this.getView().invokeOperation("refresh");
                break;
            }
            default: {
                return;
            }
        }
    }

    private void jumpModifyPage() {
        if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"arg_intv").booleanValue()) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        boolean b = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)"4715a0df000000ac");
        if (!b) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\"\u9762\u8bd5\u7ba1\u7406\"\u7684\u4fee\u6539\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ArgIntvDetailEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long argIntvId = (Long)this.getView().getFormShowParameter().getCustomParam("arg_intv_id");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(argIntvId, "argintv").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"ArgIntvDetailEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        IntvCheckResultEntity stateEntity = IntvCheckHelper.checkIntvState((Long)argIntvId);
        IntvCheckResultEntity startTimeEntity = IntvCheckHelper.checkIntvStartTime((Long)argIntvId);
        IntvCheckResultEntity intvEvlStateEntity = IntvCheckHelper.checkIntvevlState((Long)argIntvId);
        if (stateEntity.isCheckResult() && startTimeEntity.isCheckResult() && intvEvlStateEntity.isCheckResult()) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setPkId((Object)argIntvId);
            showParameter.setFormId("tsirm_argintv");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setCustomParam("position", (Object)this.getPositionIdByArgIntvId(argIntvId));
            String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
            showParameter.setCustomParam("pageId", (Object)pageId);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_argintv"));
            showParameter.setCaption(ResManager.loadKDString((String)"\u4fee\u6539\u9762\u8bd5", (String)"ArgIntvBaseEdit_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().showForm((FormShowParameter)showParameter);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"ArgIntvDetailEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public Long getPositionIdByArgIntvId(Long argIntvId) {
        DynamicObject appFile;
        QFilter qFilter = new QFilter("argintv.id", "=", (Object)argIntvId);
        List appFileTaskList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_appfiletask");
        if (!CollectionUtils.isEmpty((Collection)appFileTaskList) && Objects.nonNull(appFile = TsrbsHelper.selectById((Long)((DynamicObject)appFileTaskList.get(0)).getLong("application.id"), (String)"tsirm_appfilemdl")) && appFile.getDynamicObject("position") != null) {
            return appFile.getDynamicObject("position").getLong("id");
        }
        return 0L;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("tsirm_argintvtpl".equals(actionId) || "tsirm_intvevl".equals(actionId) || "tsirm_argintv".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (HRStringUtils.equals((String)"tsirm_intvevl", (String)messageBoxClosedEvent.getCallBackId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject evt) {
        super.beforeBindData(evt);
        this.init();
    }

    private void init() {
        Long argIntvId = (Long)this.getView().getFormShowParameter().getCustomParam("arg_intv_id");
        DynamicObject interview = TsrbsHelper.selectById((Long)argIntvId, (String)"tsirm_argintv");
        if (Objects.isNull(interview)) {
            logger.warn("interview business object is null,argIntvId: {}", (Object)argIntvId);
            return;
        }
        DynamicObjectCollection intvRounds = interview.getDynamicObjectCollection("tsirm_intvroundentry");
        if (CollectionUtils.isEmpty((Collection)intvRounds)) {
            logger.warn("rounds business object is null,argIntvId: {}", (Object)argIntvId);
            return;
        }
        DynamicObject round = (DynamicObject)intvRounds.get(0);
        DynamicObjectCollection intvGroupList = round.getDynamicObjectCollection("tsirm_intvgroupentry");
        if (CollectionUtils.isEmpty((Collection)intvGroupList)) {
            logger.warn("groups business object is null,argIntvId: {}", (Object)argIntvId);
            return;
        }
        String interviewStatus = interview.getString("interviewstatus");
        String intvOrgFrm = interview.getString("intvorgfrm");
        DynamicObject interviewMethod = round.getDynamicObject("interviewmethod");
        if (Objects.isNull(interviewMethod)) {
            logger.warn("round interviewMethod object is null,argIntvId:{}", (Object)argIntvId);
            return;
        }
        String intvMethod = interviewMethod.getString("id");
        this.processTitle(interview.getString("interviewtitle"), interviewStatus);
        List<DynamicObject> sortIntvGroupList = intvGroupList.stream().sorted(Comparator.comparingInt(intvGroup -> intvGroup.getInt("seq"))).collect(Collectors.toList());
        this.setInterviewProperty(interview, round, sortIntvGroupList);
        this.setFlexShowForm(sortIntvGroupList, interviewStatus, intvOrgFrm, intvMethod);
    }

    private void setPerm() {
        String entityId = this.getView().getEntityId();
        if (!IntvPermUtil.verifyHasPerm((String)entityId, (String)"bar_list_urgeevl", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_urgeevl"});
        }
        if (!IntvPermUtil.verifyHasPerm((String)entityId, (String)"bar_list_urgereply", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_urgereply"});
        }
        if (!IntvPermUtil.verifyHasPerm((String)entityId, (String)"bar_cancelintv", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_cancle"});
        }
        if (!IntvPermUtil.verifyHasPerm((String)entityId, (String)"bar_modify", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    private void setFlexShowForm(List<DynamicObject> intvGroupList, String interviewStatus, String intvOrgFrm, String intvMethod) {
        Container flexPanel = (Container)this.getControl("intvinfoflex");
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
        for (int i = 0; i < intvGroupList.size(); ++i) {
            FormShowParameter showParameter = FormShowUtils.setFlexFormShow((Container)flexPanel, (String)flexPanel.getKey().concat(String.valueOf(i)), (String)"tsirm_groupinfo");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("interviewmethod", intvMethod);
            paramMap.put("intvorgfrm", intvOrgFrm);
            paramMap.put("interviewStatus", interviewStatus);
            paramMap.put("pageId", pageId);
            paramMap.put("index", i);
            paramMap.put("groupid", intvGroupList.get(i).getLong("id"));
            showParameter.setCustomParams(paramMap);
            this.getView().showForm(showParameter);
        }
    }

    public void processTitle(String intvTitle, String interviewStatus) {
        String borderColor;
        String backColor;
        String foreColor;
        this.getModel().setValue("title", (Object)intvTitle);
        this.getModel().setValue("status", (Object)INTVRESULT_MAP.get(interviewStatus));
        switch (interviewStatus) {
            case "A": {
                foreColor = "#FFCB78";
                backColor = "#FFFBF2";
                borderColor = "1px_solid_rgba(255,203,120,1)";
                break;
            }
            case "B": {
                foreColor = "#6DD18E";
                backColor = "#F2FFF5";
                borderColor = "1px_solid_rgba(109,209,142,1)";
                break;
            }
            case "C": {
                foreColor = "#D9D9D9";
                backColor = "#FAFAFA";
                borderColor = "1px_solid_rgba(217,217,217,1)";
                break;
            }
            default: {
                return;
            }
        }
        HashMap ctrl = Maps.newHashMapWithExpectedSize((int)1);
        ctrl.put("fc", foreColor);
        ctrl.put("bc", backColor);
        HashMap borderMap = new HashMap(16);
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("t", borderColor);
        map.put("r", borderColor);
        map.put("l", borderColor);
        map.put("b", borderColor);
        borderMap.put("b", map);
        ctrl.put("s", borderMap);
        this.getView().updateControlMetadata("status", (Map)ctrl);
        this.getView().updateControlMetadata("leftparentheses", (Map)ctrl);
        this.getView().updateControlMetadata("rightparentheses", (Map)ctrl);
    }

    private void setInterviewProperty(DynamicObject interview, DynamicObject round, List<DynamicObject> groupList) {
        this.getModel().setValue("argintv", (Object)interview);
        this.getModel().setValue("intvround", (Object)round);
        this.getModel().setValue("intvgroup", (Object)groupList.get(0));
        this.getModel().setValue("dayofweek", (Object)IntvDateUtil.parseDayOfWeek((Date)groupList.get(0).getDate("intvdate")));
        this.getModel().setValue("createtime", (Object)HRInteDateTimeUtil.formatDate((String)"tsirm_argintv", (String)"createtime", (Date)interview.getDate("createtime")));
        if ("B".equals(interview.getString("intvorgfrm"))) {
            String grouping = ResManager.loadKDString((String)"\u5171{0}\u7ec4{1}\u4eba", (String)"ArgIntvDetailEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{groupList.size(), interview.getDynamicObjectCollection("intvcandate").size()});
            this.getModel().setValue("grouping", (Object)grouping);
        } else if ("A".equals(interview.getString("intvorgfrm"))) {
            String grouping = ResManager.loadKDString((String)"\u5171{0}\u4eba", (String)"ArgIntvDetailEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{interview.getDynamicObjectCollection("intvcandate").size()});
            this.getModel().setValue("grouping", (Object)grouping);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pipeline1", "grouping"});
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        Long argIntvId = (Long)this.getView().getFormShowParameter().getCustomParam("arg_intv_id");
        IntvCheckResultEntity stateEntity = IntvCheckHelper.checkIntvState((Long)argIntvId);
        IntvCheckResultEntity appFileTaskStatusEntity = IntvCheckHelper.checkAppFileTaskStatus((Long)argIntvId);
        IntvCheckResultEntity startTimeEntity = IntvCheckHelper.checkIntvStartTime((Long)argIntvId);
        IntvCheckResultEntity intvEvlStateEntity = IntvCheckHelper.checkIntvevlState((Long)argIntvId);
        if (!stateEntity.isCheckResult()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_urgeevl", "bar_urgereply", "bar_modify", "bar_cancle"});
        } else {
            if (startTimeEntity.isCheckResult() && intvEvlStateEntity.isCheckResult()) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify", "bar_cancle"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_cancle"});
            }
            if (!appFileTaskStatusEntity.isCheckResult()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify", "bar_cancle"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_urgeevl", "bar_urgereply"});
        }
        this.setPerm();
    }

    static {
        INTVRESULT_MAP.put("A", ResManager.loadKDString((String)"\u672a\u5b8c\u6210", (String)"evaluationResult_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        INTVRESULT_MAP.put("B", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"evaluationResult_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        INTVRESULT_MAP.put("C", ResManager.loadKDString((String)"\u5df2\u53d6\u6d88", (String)"evaluationResult_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
    }
}

