/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.intv.service.CancelIntvResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckHelper;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvDetailUtil;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvOperateUtils;
import kd.tsc.tsirm.common.constants.intv.TssrmIntvFormConstants;
import kd.tsc.tsrbs.common.utils.CacheUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class CancelAppFileIntvPlugin
extends HRCoreBaseBillEdit {
    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("bar_cancelintv".equals(operate.getOperateKey())) {
            if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"cancel_intv").booleanValue()) {
                args.setCancel(true);
                return;
            }
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRowList = listView.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRowList)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u5c11\u64cd\u4f5c1\u4eba", (String)"CancelAppFileIntvPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectedRowList.size() > TssrmIntvFormConstants.CancelAppFileIntv.MAX_INTV_CANCEL_PEOPLE_NUMBER) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u591a\u64cd\u4f5c100\u4eba", (String)"CancelAppFileIntvPlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<Long> appFileTaskIdList = selectedRowList.stream().map(selectedRow -> (Long)selectedRow.getPrimaryKeyValue()).collect(Collectors.toList());
            for (Long aLong : appFileTaskIdList) {
                if (IntvJurisdictionService.getInstance().isHasIntvJur(aLong, "appfiletask").booleanValue()) continue;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"CancelAppFileIntvPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(true);
                return;
            }
            CancelIntvResultEntity entity = IntvCheckHelper.checkAppFileIntv(appFileTaskIdList);
            this.cancelIntvHandle(entity, operate.getOperateKey(), appFileTaskIdList);
        } else if ("cancelIntv".equals(operate.getOperateKey())) {
            if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"cancel_intv").booleanValue()) {
                args.setCancel(true);
                return;
            }
            Long appFileTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("key_appFileTask");
            if (!IntvJurisdictionService.getInstance().isHasIntvJur(appFileTaskId, "appfiletask").booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"CancelAppFileIntvPlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(true);
                return;
            }
            CancelIntvResultEntity entity = IntvCheckHelper.checkAppFileIntv(Collections.singletonList(appFileTaskId));
            this.cancelIntvHandle(entity, operate.getOperateKey(), Collections.singletonList(appFileTaskId));
        }
    }

    public void cancelIntvHandle(CancelIntvResultEntity entity, String itemKey, List<Long> appFileTaskIdList) {
        if (entity.getResult().booleanValue()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u53d6\u6d88\u9762\u8bd5", (String)"CancelAppFileIntvPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            String appFileTaskIdStr = Joiner.on((String)"\u3001").join(appFileTaskIdList);
            CacheUtils.getDistributeSessionlessCache().put(this.getView().getPageId(), (Object)appFileTaskIdStr);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u9762\u8bd5\u5df2\u7ed3\u675f\u3002", (String)"CancelAppFileIntvPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && ("bar_cancelintv".equals(messageBoxClosedEvent.getCallBackId()) || "cancelIntv".equals(messageBoxClosedEvent.getCallBackId()))) {
            CancelIntvResultEntity entity;
            if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"cancel_intv").booleanValue()) {
                return;
            }
            if ("bar_cancelintv".equals(messageBoxClosedEvent.getCallBackId())) {
                String appFileTaskIdStr = (String)CacheUtils.getDistributeSessionlessCache().get(this.getView().getPageId());
                if (StringUtils.isEmpty((CharSequence)appFileTaskIdStr)) {
                    return;
                }
                List appFileTaskIdList = Arrays.stream(appFileTaskIdStr.split("\u3001")).map(Long::valueOf).collect(Collectors.toList());
                entity = IntvCheckHelper.checkAppFileIntv(appFileTaskIdList);
            } else {
                Long appFileTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("key_appFileTask");
                entity = IntvCheckHelper.checkAppFileIntv(Collections.singletonList(appFileTaskId));
            }
            if (!entity.getResult().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"CancelAppFileIntvPlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean cancelStatus = IntvDetailUtil.cancelIntv(null, (List)entity.getDynamicObjectList(), (Boolean)Boolean.TRUE);
            this.refreshHandle(cancelStatus);
        }
    }

    public void refreshHandle(Boolean cancelStatus) {
        if (cancelStatus.booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\uff0c\u81ea\u52a8\u8df3\u8fc7\u9762\u8bd5\u5df2\u7ed3\u675f\u7684\u5019\u9009\u4eba", (String)"CancelAppFileIntvPlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5931\u8d25\uff0c\u9762\u8bd5\u5df2\u7ed3\u675f", (String)"CancelAppFileIntvPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }
}

