/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.FormShowUtils;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.springframework.util.CollectionUtils;

public class GroupInfoPlugin
extends HRDynamicFormBasePlugin {
    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String interviewStatus = (String)customParams.get("interviewStatus");
        String intvOrgFrm = (String)customParams.get("intvorgfrm");
        String interviewMethod = (String)customParams.get("interviewmethod");
        Long groupId = (Long)customParams.get("groupid");
        DynamicObject intvGroupInfo = TsrbsHelper.selectById((Long)groupId, (String)"tsirm_intvgrouptpl");
        if (Objects.isNull(intvGroupInfo)) {
            return;
        }
        QFilter qilter = new QFilter("intvgroup", "=", (Object)intvGroupInfo.getLong("id"));
        Optional.of(intvGroupInfo).ifPresent(intvGroup -> this.setIntvGroupInfo((DynamicObject)intvGroup, intvOrgFrm, interviewMethod));
        List intvTaskList = TsrbsHelper.selectByFilter((QFilter[])qilter.toArray(), (String)"tsirm_intvtask");
        if (CollectionUtils.isEmpty((Collection)intvTaskList)) {
            return;
        }
        ArrayList newIntvTaskList = new ArrayList();
        intvTaskList.removeIf(intvTask -> "0".equals(intvTask.getString("enable")) && !"D".equals(intvTask.getString("taskstatus")));
        intvTaskList.stream().collect(Collectors.groupingBy(intvTask -> intvTask.getLong("interviewer.id"))).forEach((intverId, intvTasks) -> newIntvTaskList.add(this.getNewIntvTaskByIntver((List<DynamicObject>)intvTasks)));
        if (CollectionUtils.isEmpty(newIntvTaskList)) {
            return;
        }
        List<DynamicObject> sortIntvTaskList = newIntvTaskList.stream().sorted(Comparator.comparingLong(intvTask -> intvTask.getDynamicObject("interviewer").getLong("id"))).collect(Collectors.toList());
        this.buildIntverPanel(sortIntvTaskList);
        List appFileIdList = TsrbsHelper.selectByFilter((QFilter[])qilter.toArray(), (String)"tsirm_appfiletask");
        List idList = appFileIdList.stream().map(appFileId -> appFileId.getLong("id")).collect(Collectors.toList());
        Optional.of(TsrbsHelper.selectByIdList(idList, (String)"tsirm_appfiletask")).ifPresent(appFileTaskList -> this.setFlexShowForm((List<DynamicObject>)appFileTaskList, interviewStatus, intvOrgFrm));
    }

    private DynamicObject getNewIntvTaskByIntver(List<DynamicObject> intvTasks) {
        return intvTasks.stream().sorted(Comparator.comparing(intvTask -> intvTask.getDate("createtime"), Comparator.reverseOrder())).findFirst().orElseGet(DynamicObject::new);
    }

    private void setFlexShowForm(List<DynamicObject> appFileTaskList, String interviewStatus, String intvOrgFrm) {
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
        for (int i = 0; i < appFileTaskList.size(); ++i) {
            Container flexPanel = (Container)this.getControl("intvinfoflex");
            FormShowParameter showParameter = FormShowUtils.setFlexFormShow((Container)flexPanel, (String)flexPanel.getKey().concat(String.valueOf(i)), (String)"tsirm_intvinfo");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("intvorgfrm", intvOrgFrm);
            paramMap.put("interviewStatus", interviewStatus);
            paramMap.put("pageId", pageId);
            paramMap.put("key_appFileTask", appFileTaskList.get(i).getLong("id"));
            showParameter.setCustomParams(paramMap);
            this.getView().showForm(showParameter);
        }
    }

    private void setIntvGroupInfo(DynamicObject intvGroupInfo, String intvOrgFrm, String interviewMethod) {
        int index = (Integer)this.getView().getFormShowParameter().getCustomParam("index");
        String startTime = IntvDateUtil.formatTime((Long)intvGroupInfo.getLong("intvstarttime"), (String)"HH:mm");
        String endTime = IntvDateUtil.formatTime((Long)(intvGroupInfo.getLong("intvendtime") > (long)IntvDateUtil.MAX_SECOND_OF_DAY.intValue() ? (long)IntvDateUtil.MAX_SECOND_OF_DAY.intValue() : intvGroupInfo.getLong("intvendtime")), (String)"HH:mm");
        this.getModel().setValue("index", (Object)Num2ChUtils.toCH((int)(index + 1)));
        this.getModel().setValue("intvtime", (Object)startTime.concat("-").concat(endTime));
        if (!"B".equals(intvOrgFrm)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
        if ("1010".equals(interviewMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"videoflex"});
            this.getModel().setValue("intvaddr", (Object)intvGroupInfo.getString("addressdetail.name"));
            this.getModel().setValue("intvroom", intvGroupInfo.get("interviewroom"));
        } else if ("1040".equals(interviewMethod)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"interviewflex"});
            this.getModel().setValue("intvervedioaddress", intvGroupInfo.get("intvervedioaddress"));
            this.getModel().setValue("candatevedioaddress", intvGroupInfo.get("candatevedioaddress"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"interviewflex", "videoflex"});
        }
    }

    public void buildIntverPanel(List<DynamicObject> intvTaskList) {
        if (CollectionUtils.isEmpty(intvTaskList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"intverrelapyflex"});
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < intvTaskList.size(); ++i) {
            vs.set("intver1", (Object)intvTaskList.get(i).getString("interviewer.name"), i);
            vs.set("intverreply", (Object)this.getIntverReply(intvTaskList.get(i).getString("interveranswer")), i);
            if (!"D".equals(intvTaskList.get(i).get("interveranswer"))) {
                cardEntry.setChildVisible(false, i, new String[]{"intver2"});
            } else {
                vs.set("intver2", (Object)intvTaskList.get(i).getDynamicObject("passedperson").getString("name"), i);
            }
            if (i != intvTaskList.size() - 1) continue;
            cardEntry.setChildVisible(false, i, new String[]{"commalabel"});
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
    }

    public String getIntverReply(String interverAnswer) {
        String intverReply = null;
        switch (interverAnswer) {
            case "A": {
                intverReply = ResManager.loadKDString((String)"\u672a\u7b54\u590d", (String)"GroupInfoPlugin_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "B": {
                intverReply = ResManager.loadKDString((String)"\u63a5\u53d7", (String)"GroupInfoPlugin_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "C": {
                intverReply = ResManager.loadKDString((String)"\u62d2\u7edd", (String)"GroupInfoPlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "D": {
                intverReply = ResManager.loadKDString((String)"\u8f6c\u4ea4\u7ed9", (String)"GroupInfoPlugin_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return intverReply;
    }
}

