/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvDetailUtil;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.formplugin.web.intv.IntervEvalBasePlugin;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbs.common.enums.SignStatusEnum;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

abstract class IntervEvalBaseIRPlugin
extends HRDynamicFormBasePlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(IntervEvalBasePlugin.class);
    private static final int MAPCOUNT = 16;
    private static final int BUTTONKEYSIZE = 10;
    private static final Set<String> INTEVALKEYS = new HashSet<String>(16);
    private static final String BUTTON_CANCLE = "cancelIntv";
    private Set<String> BUTTON_KEY = new HashSet<String>();
    private static final List<String> TOADDBUTTONKEY;

    IntervEvalBaseIRPlugin() {
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.setButtonKey();
        Button buttonap = (Button)this.getView().getControl("insteadbutton");
        buttonap.addClickListener((ClickListener)this);
        Button buttonap1 = (Button)this.getView().getControl("uninsteadbutton");
        buttonap1.addClickListener((ClickListener)this);
        Button urgeButton = (Button)this.getView().getControl("urgebutton");
        urgeButton.addClickListener((ClickListener)this);
        Button urarrivedButton = (Button)this.getView().getControl("unarrived");
        urarrivedButton.addClickListener((ClickListener)this);
        Button viewBtn = (Button)this.getView().getControl("viewbtn");
        viewBtn.addClickListener((ClickListener)this);
        for (String key : this.BUTTON_KEY) {
            this.addClickListeners(new String[]{key});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (this.hasDigit(sourceKey)) {
            if ("0".equals(sourceKey = sourceKey.substring(sourceKey.length() - 1))) {
                sourceKey = "0";
            }
        } else {
            sourceKey = "";
        }
        int currentIndex = this.getModel().getEntryCurrentRowIndex("myfieldcontainer");
        String intevPk = this.getModel().getValue("intervpk" + sourceKey, currentIndex).toString();
        String interviewevl = this.getModel().getValue("interviewevl" + sourceKey).toString();
        Pair flag = IntervEvalHelper.selectIntvStateByPk((String)intevPk);
        String index = "_" + currentIndex;
        this.getPageCache().put("myfieldcontainer", index);
        this.getPageCache().put("intvIndex", sourceKey);
        Long appFileTaskId = Long.valueOf(this.getView().getModel().getValue("appfiletask").toString());
        if (source.getKey().contains("viewbtn")) {
            QuestionnaireHelper.showTsirmIntvEvlPage((String)intevPk, (String)interviewevl, (String)"view", (String)((Object)((Object)this)).getClass().getName(), (IFormView)this.getView(), null, (String)"tsirm_intvevl");
            return;
        }
        if (((Boolean)flag.getLeft()).booleanValue()) {
            if (source.getKey().contains("insteadbutton") || source.getKey().contains("uninsteadbutton")) {
                QuestionnaireHelper.showTsirmIntvEvlPage((String)intevPk, (String)interviewevl, (String)"edit", (String)((Object)((Object)this)).getClass().getName(), (IFormView)this.getView(), null, (String)"tsirm_intvevl");
            }
            if (source.getKey().contains("unarrived")) {
                this.getPageCache().put("appFileTaskId", String.valueOf(appFileTaskId));
                this.getPageCache().put("intevPk", intevPk);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("unarrived");
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u6807\u8bb0\u5019\u9009\u4eba\u672a\u5230\u573a\uff1f", (String)"IntvTemplatePlugin_2", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        } else {
            ConfirmCallBackListener confirmCallBackListener;
            if (source.getKey().contains("unarrived")) {
                confirmCallBackListener = new ConfirmCallBackListener(index, (IFormPlugin)this);
                this.getPageCache().put("pkValue", intevPk);
                if (((Boolean)flag.getRight()).booleanValue()) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u5df2\u7ed3\u675f,\u4e0d\u53ef\u6807\u8bb0\u672a\u5230\u573a", (String)"IntvTemplatePlugin_11", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                } else {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u8bc4\u4ef7\u4fe1\u606f\u5df2\u88ab\u8bc4\u4ef7,\u4e0d\u53ef\u6807\u8bb0\u672a\u5230\u573a", (String)"IntvTemplatePlugin_12", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                }
            }
            confirmCallBackListener = new ConfirmCallBackListener(index, (IFormPlugin)this);
            this.getPageCache().put("pkValue", intevPk);
            if (((Boolean)flag.getRight()).booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u5df2\u7ed3\u675f,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String)"IntvTemplatePlugin_13", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u4efb\u52a1\u5df2\u88ab\u8bc4\u4ef7,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c\u3002", (String)"IntvTemplatePlugin_14", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (MessageBoxResult.Yes.equals((Object)result) && "unarrived".equals(messageBoxClosedEvent.getCallBackId())) {
            String appFileTaskId = this.getPageCache().get("appFileTaskId");
            String intevPk = this.getPageCache().get("intevPk");
            Pair flag = IntervEvalHelper.selectIntvStateByPk((String)intevPk);
            if (((Boolean)flag.getLeft()).booleanValue()) {
                DynamicObject appFileTask = TsrbsHelper.selectById((Long)Long.valueOf(appFileTaskId), (String)"tsirm_appfiletask");
                IntvDetailUtil.updateSignInStatus((DynamicObject)appFileTask, (String)SignStatusEnum.UN_READY.getCode());
            } else if (((Boolean)flag.getRight()).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u5df2\u7ed3\u675f,\u4e0d\u53ef\u6807\u8bb0\u672a\u5230\u573a", (String)"CancelIntvConfirmMessagePlugin_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u8bc4\u4ef7\u4fe1\u606f\u5df2\u88ab\u8bc4\u4ef7,\u4e0d\u53ef\u6807\u8bb0\u672a\u5230\u573a", (String)"CancelIntvConfirmMessagePlugin_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
        String pkValue = this.getPageCache().get("pkValue");
        String currentIndex = this.getPageCache().get("myfieldcontainer");
        if (StringUtils.isNotBlank((CharSequence)currentIndex) && StringUtils.startsWith((CharSequence)currentIndex, (CharSequence)"_") && MessageBoxResult.Yes.equals((Object)result)) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String myfieldcontainerIndex = this.getPageCache().get("myfieldcontainer");
        String intvIndex = this.getPageCache().get("intvIndex");
        if (StringUtils.isNotBlank((CharSequence)myfieldcontainerIndex) && StringUtils.startsWith((CharSequence)myfieldcontainerIndex, (CharSequence)"_")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (MapUtils.isNotEmpty((Map)returnData) && MapUtils.getBoolean((Map)returnData, (Object)"change").booleanValue()) {
                this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"IntvTemplatePlugin_3", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                this.getView().invokeOperation("refresh");
            }
        } else {
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        List<Map<String, Object>> list;
        String param = (String)this.getView().getFormShowParameter().getCustomParam("applicationid");
        List<Map<String, Object>> mapList = this.dbResult(param);
        Optional<List<Map<String, Object>>> mapList1 = Optional.of(mapList);
        if (mapList1.isPresent() && (list = mapList1.get()).size() == 0) {
            Label label = (Label)this.getView().getControl("labelap2");
            label.setText(ResManager.loadKDString((String)"\u6682\u65e0\u9762\u8bd5\u6570\u636e", (String)"IntvTemplatePlugin_5", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]));
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("myfieldcontainer");
        List controls = cardEntry.getControls();
        HashMap<String, ArrayList<Map<String, Object>>> map1 = new HashMap<String, ArrayList<Map<String, Object>>>(16);
        for (Map<String, Object> map2 : mapList) {
            ArrayList<Map<String, Object>> mapList2 = (ArrayList<Map<String, Object>>)map1.get(map2.get("appfiletask"));
            if (mapList2 == null) {
                mapList2 = new ArrayList<Map<String, Object>>(16);
            }
            mapList2.add(map2);
            map1.put(String.valueOf(map2.get("appfiletask")), mapList2);
        }
        Optional.of(map1).filter(maps -> maps.size() > 0).ifPresent(map -> {
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow("myfieldcontainer", map.size());
            int index = 0;
            HashMap orderMap = new HashMap(16);
            ArrayList orderMapList = new ArrayList(16);
            for (Map.Entry entry : map1.entrySet()) {
                orderMap = new HashMap(16);
                orderMap.put(entry.getKey(), ((List)entry.getValue()).get(0));
                orderMapList.add(orderMap);
            }
            orderMapList.sort((o1, o2) -> {
                boolean i1 = false;
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String intvtime1 = "";
                    for (Map.Entry entry : o1.entrySet()) {
                        intvtime1 = ((Map)o1.get(entry.getKey())).get("intvtime").toString();
                    }
                    String intvtime2 = "";
                    for (Map.Entry entry : o2.entrySet()) {
                        intvtime2 = ((Map)o2.get(entry.getKey())).get("intvtime").toString();
                    }
                    Date date = simpleDateFormat.parse(intvtime1);
                    Date date2 = simpleDateFormat.parse(intvtime2);
                    return date2.compareTo(date);
                }
                catch (Exception e1) {
                    logger.error("IntervEvalBasePlugin.afterCreateNewData.error", (Throwable)e1);
                    return 0;
                }
            });
            for (Map map2 : orderMapList) {
                for (Map.Entry entry : map2.entrySet()) {
                    String orderKey = (String)entry.getKey();
                    List orderValue = (List)map1.get(orderKey);
                    this.getPageCache().put(orderKey + "interCount", String.valueOf(orderValue.size()));
                    int finalI = index++;
                    controls.forEach(control -> this.setDataModel((Control)control, orderValue, dataModel, finalI));
                }
            }
        });
    }

    public boolean hasDigit(String content) {
        boolean flag = false;
        String REGEXP = ".*\\d+.*";
        Pattern pattern = Pattern.compile(REGEXP);
        Matcher matcher = pattern.matcher(content);
        if (matcher.matches()) {
            flag = true;
        }
        return flag;
    }

    private void setDataModel(Control control, List<Map<String, Object>> rmap, IDataModel dataModel, int finalI) {
        for (int i = 0; i < rmap.size(); ++i) {
            if (!(control instanceof TextEdit)) continue;
            String oringnkey = control.getKey();
            if (this.hasDigit(oringnkey)) {
                return;
            }
            String value = (String)rmap.get(i).get(oringnkey);
            if (HRStringUtils.equals((String)oringnkey, (String)"generpeople")) {
                value = IntervEvalHelper.geti18nStr((String)value);
            }
            if (HRStringUtils.equals((String)oringnkey, (String)"generpeoplenew")) {
                value = (String)rmap.get(i).get("generpeople");
            }
            if (HRStringUtils.equals((String)oringnkey, (String)"intvcontent") && HRStringUtils.isEmpty((String)value)) {
                value = "";
            }
            if (i != 0 && INTEVALKEYS.contains(oringnkey)) {
                oringnkey = control.getKey() + i;
            }
            String vedioaddress = (String)rmap.get(i).get("intvervedioaddress");
            if (oringnkey.contains("intvaddress") && !Objects.equals(vedioaddress, "")) {
                value = vedioaddress;
            }
            dataModel.setValue(oringnkey, (Object)value, finalI);
        }
    }

    private void setButtonKey() {
        this.BUTTON_KEY.clear();
        for (int i = 0; i < 10; ++i) {
            for (String toAddButtonKey : TOADDBUTTONKEY) {
                this.BUTTON_KEY.add(toAddButtonKey + i);
            }
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        CardEntry cardEntry = (CardEntry)this.getView().getControl("myfieldcontainer");
        EntryData entryData = cardEntry.getEntryData();
        DynamicObject[] dataEntitys = entryData.getDataEntitys();
        this.buttonShow(cardEntry, dataEntitys, this.getPageCache());
        this.setButtonKey();
    }

    public abstract void buttonShow(CardEntry var1, DynamicObject[] var2, IPageCache var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"VA_FORMAT_STRING_EXPECTED_MESSAGE_FORMAT_SUPPLIED"})
    private List<Map<String, Object>> dbResult(String applicationId) {
        String className = ((Object)((Object)this)).getClass().getName();
        ArrayList listMaps = Lists.newArrayList();
        if (HRStringUtils.isNotEmpty((String)applicationId)) {
            DataSet orderDataSet = null;
            try {
                orderDataSet = IntervEvalHelper.joinDataSet((String)className, (String)applicationId);
                for (Row next : orderDataSet) {
                    HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
                    this.getIntvevlMap(next, resultMap);
                    IntervEvalHelper.getOtherFields((Row)next, resultMap, (String)applicationId);
                    listMaps.add(resultMap);
                }
            }
            catch (Exception e) {
                logger.error("IntervEvalBasePlugin.dbResult.error", (Throwable)e);
            }
            finally {
                try {
                    Optional.ofNullable(orderDataSet).ifPresent(dataSet -> dataSet.close());
                }
                catch (Exception e) {
                    logger.error("IntervEvalBasePlugin.dbResult.error release resources", (Throwable)e);
                }
            }
        }
        return listMaps;
    }

    protected void getIntvevlMap(Row next, Map<String, Object> resultMap) {
        IntervEvalHelper.getIntvevlMap((Row)next, resultMap);
    }

    static {
        INTEVALKEYS.add("intver");
        INTEVALKEYS.add("intvcontent");
        INTEVALKEYS.add("invtevlsts");
        INTEVALKEYS.add("intvevlrslt");
        INTEVALKEYS.add("intvevltime");
        INTEVALKEYS.add("generpeople");
        INTEVALKEYS.add("intervpk");
        INTEVALKEYS.add("interviewevl");
        INTEVALKEYS.add("handlestatus");
        INTEVALKEYS.add("currentpermiss");
        TOADDBUTTONKEY = new ArrayList<String>(Arrays.asList("insteadbutton", "uninsteadbutton", "urgebutton", "unarrived", "viewbtn"));
    }
}

