/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;

public class IntvAnswerEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public static final String NONJOINFLEX = "nonjoinflex";
    public static final String ANSWERFLEX = "answerflex";
    public static final String JOINGROUP = "joingroup";
    public static final String BUTTONAP = "buttonap";
    public static final String JOINFLEXAP = "joinflexap";
    public static final String JOINSTATUS = "joinstatus";
    public static final String SPECIFICREASON = "refusalcause";
    public static final String INTVOUTTIME = "intvouttime";
    public static final String LBL_SHOWOUTTIME = "outtimemsg";
    public static final String REFUSERESON = "refusereson";
    public static final String RECRURSN = "recrursn";
    public static final String MODIFYAP = "modifyap";
    public static final String IMG_ANSEWE = "imganswer";
    public static final String INTERVIEWARRANGER = "interviewarranger";
    public static final String INTERVIEWTITLE = "INTERVIEWTITLE";
    public static final long OTHERNUM = 1030030L;
    public static final String NOTICE = "notice";
    public static final String APPLICATION = "application";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{BUTTONAP, MODIFYAP});
        MulBasedataEdit refuseresonControl = (MulBasedataEdit)this.getView().getControl(REFUSERESON);
        if (!Objects.isNull(refuseresonControl)) {
            refuseresonControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        boolean checkAuthRes = this.checkAuth();
        if (checkAuthRes) {
            this.initVisible();
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{INTVOUTTIME, LBL_SHOWOUTTIME});
            this.getView().setVisible(Boolean.FALSE, new String[]{JOINSTATUS, MODIFYAP, ANSWERFLEX, IMG_ANSEWE});
            Label label = (Label)this.getControl(LBL_SHOWOUTTIME);
            label.setText(ResManager.loadKDString((String)"\u6682\u65e0\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u5730\u5740\u662f\u5426\u6b63\u786e\u3002", (String)"IntvAnswerEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean checkAuth() {
        String appPhoneSecParamValue;
        boolean res = false;
        String appfilePhone = this.getAppfilePhone();
        String appfilePhoneSec = EncryptionDecryptUtil.getEncryptStr((Object)appfilePhone);
        if (appfilePhoneSec.equals(appPhoneSecParamValue = this.getAppPhoneSec())) {
            return true;
        }
        return res;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = source.getKey();
        if (REFUSERESON.equals(key)) {
            ListShowParameter refuseresonControl = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            refuseresonControl.setFormId("bos_listf7_tsc");
        }
    }

    public String getAppfilePhone() {
        String appfilePhone = "";
        Long appfileTaskId = this.getAppfileTaskId();
        DynamicObject appFileTaskDO = IntvAppfileTaskHelper.getInstance().queryAppfileTaskById(appfileTaskId);
        if (appFileTaskDO == null) {
            return appfilePhone;
        }
        if (appFileTaskDO.getDynamicObject(APPLICATION) == null) {
            return appfilePhone;
        }
        appfilePhone = appFileTaskDO.getDynamicObject(APPLICATION).getString("phone");
        return appfilePhone;
    }

    public DynamicObject getIntvDynamicObject() {
        Long appfileTaskId = this.getAppfileTaskId();
        DynamicObject dynamicObject = IntvAppfileTaskHelper.getInstance().queryAppfileTaskById(appfileTaskId);
        return dynamicObject;
    }

    public Long getAppfileTaskId() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Long appfileTaskId = 0L;
        if (customParams.get("appfileTaskId") != null) {
            appfileTaskId = Long.parseLong(customParams.get("appfileTaskId").toString());
        }
        return appfileTaskId;
    }

    public String getAppPhoneSec() {
        String appPhoneSec = "";
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.get("phone") != null) {
            appPhoneSec = customParams.get("phone").toString();
        }
        return appPhoneSec;
    }

    public void initVisible() {
        DynamicObject appfileTask = IntvAppfileTaskHelper.getInstance().queryAppfileTaskById(this.getAppfileTaskId(), "applicationanswer,taskstatus,application");
        if (appfileTask == null) {
            return;
        }
        Label nameLabel = (Label)this.getControl("labelap");
        nameLabel.setText(appfileTask.getString("application.name") == null ? "" : appfileTask.getString("application.name").concat("\uff0c"));
        String answerState = appfileTask.getString("applicationanswer");
        String appfileTaskStatus = appfileTask.getString("taskstatus");
        if (!this.checkIntvTime()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INTVOUTTIME, LBL_SHOWOUTTIME});
            this.getView().setVisible(Boolean.FALSE, new String[]{JOINSTATUS, MODIFYAP, ANSWERFLEX, IMG_ANSEWE});
            Label label = (Label)this.getControl(LBL_SHOWOUTTIME);
            label.setText(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u5b89\u6392\u5df2\u8fc7\u671f\u3002", (String)"IntvAnswerEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (appfileTaskStatus.equals("B")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{INTVOUTTIME, LBL_SHOWOUTTIME});
            this.getView().setVisible(Boolean.FALSE, new String[]{JOINSTATUS, MODIFYAP, ANSWERFLEX, IMG_ANSEWE});
            Label label = (Label)this.getControl(LBL_SHOWOUTTIME);
            label.setText(ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u53d6\u6d88", (String)"IntvAnswerEdit_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (answerState.equals("A")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NONJOINFLEX, JOINFLEXAP, SPECIFICREASON, INTVOUTTIME});
            this.getView().setVisible(Boolean.TRUE, new String[]{ANSWERFLEX});
        } else if (answerState.equals("B")) {
            String msgStr = ResManager.loadKDString((String)"\u53c2\u52a0", (String)"IntvAnswerEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            Label label = (Label)this.getControl(JOINSTATUS);
            label.setText(msgStr);
            this.getView().setVisible(Boolean.FALSE, new String[]{ANSWERFLEX, INTVOUTTIME});
            this.getView().setVisible(Boolean.TRUE, new String[]{JOINFLEXAP});
        } else {
            String msgStr = ResManager.loadKDString((String)"\u4e0d\u53c2\u52a0", (String)"IntvAnswerEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            Label label = (Label)this.getControl(JOINSTATUS);
            label.setText(msgStr);
            this.getView().setVisible(Boolean.FALSE, new String[]{ANSWERFLEX, INTVOUTTIME});
            this.getView().setVisible(Boolean.TRUE, new String[]{JOINFLEXAP});
        }
    }

    public boolean checkIntvTime() {
        Long intvStartTimeLong;
        boolean isOutTime = false;
        DynamicObject intvDynamicObject = this.getIntvDynamicObject();
        DynamicObject group = intvDynamicObject.getDynamicObject("intvgroup");
        Date intvStartTime = group.getDate("intvdate");
        boolean checktime = IntvDateUtil.intvTimeIsBeforeNow((Date)intvStartTime, (Long)(intvStartTimeLong = Long.valueOf(group.getLong("intvstarttime"))));
        if (!checktime) {
            isOutTime = true;
        }
        return isOutTime;
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        String name = evt.getProperty().getName();
        if (JOINGROUP.equals(name)) {
            ChangeData changeData = evt.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            if ("2".equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{NONJOINFLEX});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{NONJOINFLEX});
            }
        }
        if (REFUSERESON.equals(name)) {
            this.initRefusalCauseVisable();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String joinResult = dataEntity.getString(JOINGROUP);
            DynamicObjectCollection refusereson = dataEntity.getDynamicObjectCollection(REFUSERESON);
            if (refusereson.isEmpty() && "2".equals(joinResult)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62d2\u7edd\u539f\u56e0\u201d\u3002", (String)"IntvAnswerEdit_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("3".equals(joinResult)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u662f\u5426\u53c2\u52a0\u9762\u8bd5\u201d\u3002", (String)"IntvAnswerEdit_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("submit".equals(key) && operationResult.isSuccess()) {
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String joinResult = dataEntity.getString(JOINGROUP);
            Label label = (Label)this.getControl(JOINSTATUS);
            DynamicObject intvDynamicObject = this.getIntvDynamicObject();
            DynamicObject application = intvDynamicObject.getDynamicObject(APPLICATION);
            DynamicObject argintv = intvDynamicObject.getDynamicObject("argintv");
            DynamicObjectCollection refusereson = dataEntity.getDynamicObjectCollection(REFUSERESON);
            this.getView().setVisible(Boolean.FALSE, new String[]{ANSWERFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{JOINFLEXAP});
            String msgStr = this.getShowMsg(joinResult);
            DynamicObject appfileTask = IntvAppfileTaskHelper.getInstance().queryAppTaskInfo(this.getAppfileTaskId());
            appfileTask.set("applicationanswer", (Object)("1".equals(joinResult) ? "B" : "C"));
            appfileTask.set(RECRURSN, (Object)refusereson);
            appfileTask.set(SPECIFICREASON, this.getModel().getValue(SPECIFICREASON));
            IntvAppfileTaskHelper.getInstance().updateTasks(appfileTask);
            label.setText(msgStr);
            this.sendHrMessage(argintv.getDynamicObject(INTERVIEWARRANGER).getLong("id"), application.getString("name"), msgStr, argintv.getString(INTERVIEWTITLE));
            String refusalcause = this.getModel().getValue(SPECIFICREASON).toString();
            if ("1".equals(joinResult)) {
                IntvOpRecordService.getInstance().replyAcceptOR(application, argintv.getString("interviewtitle"));
            }
            if ("2".equals(joinResult)) {
                IntvOpRecordService.getInstance().replyRefuseOR(application, refusereson, refusalcause, argintv.getString("interviewtitle"), this.getView());
            }
        }
        if ("modify".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NONJOINFLEX, JOINFLEXAP, SPECIFICREASON});
            this.getView().setVisible(Boolean.TRUE, new String[]{ANSWERFLEX});
            this.getView().setVisible(Boolean.FALSE, new String[]{NONJOINFLEX});
            this.getModel().setValue(SPECIFICREASON, (Object)"");
            this.getModel().getDataEntity();
            this.getModel().setValue(REFUSERESON, null);
            this.getModel().setValue(JOINGROUP, (Object)"3");
        }
    }

    public String getShowMsg(String joinResult) {
        String msgStr = "";
        msgStr = "1".equals(joinResult) ? ResManager.loadKDString((String)"\u53c2\u52a0", (String)"IntvAnswerEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53c2\u52a0", (String)"IntvAnswerEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        return msgStr;
    }

    public void initRefusalCauseVisable() {
        TextEdit textEdit;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection refusereson = dataEntity.getDynamicObjectCollection(REFUSERESON);
        boolean showRefusalCause = false;
        for (DynamicObject dynamicObject : refusereson) {
            if (dynamicObject.getDynamicObject("fbasedataid").getLong("id") != 1030030L) continue;
            showRefusalCause = true;
        }
        if (showRefusalCause) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SPECIFICREASON});
            textEdit = (TextEdit)this.getView().getControl(SPECIFICREASON);
            textEdit.setMustInput(true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SPECIFICREASON});
            this.getModel().setValue(SPECIFICREASON, (Object)"");
            textEdit = (TextEdit)this.getView().getControl(SPECIFICREASON);
            textEdit.setMustInput(false);
        }
    }

    private Long sendHrMessage(Long hrId, String appFileName, String answerResult, String intvTitle) {
        MessageInfo message = new MessageInfo();
        message.setType(NOTICE);
        message.setTitle(ResManager.loadKDString((String)"\u7b54\u590d\u901a\u77e5", (String)"IntvAnswerEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        ArrayList hrIds = Lists.newArrayList();
        hrIds.add(hrId);
        message.setUserIds((List)hrIds);
        message.setSenderId(Long.valueOf(0L));
        message.setTag(ResManager.loadKDString((String)"\u7b54\u590d\u901a\u77e5", (String)"IntvAnswerEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        message.setContent(ResManager.loadKDString((String)"{0}\u7b54\u590d{1}\u60a8\u5b89\u6392\u7684{2}", (String)"IntvAnswerEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{appFileName, answerResult, intvTitle}));
        return MessageCenterServiceHelper.sendMessage((MessageInfo)message);
    }
}

