/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import org.springframework.util.CollectionUtils;

public class IntvArgBillList
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(IntvArgBillList.class);
    private static List<DynamicObject> argIntvList = new ArrayList<DynamicObject>();
    private Map<Long, LinkedList<Integer>> numMap = new HashMap<Long, LinkedList<Integer>>(16);
    private Map<Long, LinkedList<String>> iconMap = new HashMap<Long, LinkedList<String>>(16);

    public void setFilter(SetFilterEvent evt) {
        List filterList = evt.getQFilters();
        Optional<QFilter> optional = filterList.stream().filter(Objects::nonNull).filter(qFilter -> "interviewdate".equals(qFilter.getProperty())).findFirst();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (optional.isPresent()) {
            QFilter intvDateFilter = optional.get();
            filterList.remove(intvDateFilter);
            intvDateFilter.__setProperty("tsirm_intvroundentry.tsirm_intvgroupentry.intvdate");
            List intvDateFilterNestList = intvDateFilter.getNests(true);
            QFilter intvDateFilterNest = ((QFilter.QFilterNest)intvDateFilterNestList.get(0)).getFilter();
            intvDateFilterNest.__setProperty("tsirm_intvroundentry.tsirm_intvgroupentry.intvdate");
            qFilterList.add(intvDateFilter);
        }
        String startCreateTime = (String)this.getView().getFormShowParameter().getCustomParam("start_createtime");
        String endCreateTime = (String)this.getView().getFormShowParameter().getCustomParam("end_createtime");
        Optional.ofNullable(startCreateTime).ifPresent(startTime -> qFilterList.add(new QFilter("arrangeantime", ">=", (Object)IntvDateUtil.parseDateTimeStr((String)startTime, (String)"yyyy-MM-dd HH:mm:ss"))));
        Optional.ofNullable(endCreateTime).ifPresent(endTime -> qFilterList.add(new QFilter("arrangeantime", "<=", (Object)IntvDateUtil.parseDateTimeStr((String)endTime, (String)"yyyy-MM-dd HH:mm:ss"))));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        QFilter qFilter2 = new QFilter("interviewarranger.id", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter2.or(new QFilter("id", "in", (Object)IntvJurisdictionService.getInstance().getHasIntvArgJurIds()));
        qFilterList.add(qFilter2);
        Optional.of(qFilterList).ifPresent(arg_0 -> ((SetFilterEvent)evt).setCustomQFilters(arg_0));
        evt.setOrderBy("arrangeantime desc");
        super.setFilter(evt);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        args = this.setCommonFilterColumn(args);
        super.filterContainerInit(args);
    }

    public void beforePackageData(BeforePackageDataEvent evt) {
        DynamicObjectCollection pageDataList = evt.getPageData();
        List idList = pageDataList.stream().map(pageData -> pageData.getLong("id")).collect(Collectors.toList());
        argIntvList = TsrbsHelper.selectByIdList(idList, (String)"tsirm_argintv");
        pageDataList.forEach(this::getIconAndNum);
    }

    private void getIconAndNum(DynamicObject pageData) {
        LinkedList<Integer> numList = new LinkedList<Integer>();
        LinkedList<String> iconList = new LinkedList<String>();
        Long id = pageData.getLong("id");
        int processingNum = this.getAppFileTaskNumberByStatus(id, "A");
        int cancelNum = this.getAppFileTaskNumberByStatus(id, "B");
        int alreadyNum = this.getAppFileTaskNumberByStatus(id, "C");
        if (0 != alreadyNum) {
            numList.add(alreadyNum);
            iconList.add("1");
        }
        if (0 != cancelNum) {
            numList.add(cancelNum);
            iconList.add("2");
        }
        if (0 != processingNum) {
            numList.add(processingNum);
            iconList.add("3");
        }
        this.numMap.put(id, numList);
        this.iconMap.put(id, iconList);
    }

    public void afterBindData(EventObject event) {
        HashMap<String, String> customStyleMap = new HashMap<String, String>(16);
        customStyleMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiW2NvbC1pZD0naWNvbnN0YXR1cyddIC5fMkJQa0dPT1ouXzJVdmNQRFBkLl8yRmpCTkd2WSB7XG5cdHdpZHRoOjMwcHggIWltcG9ydGFudDtcbn0ifQ==");
        this.getView().updateControlMetadata("flexpanelap1", customStyleMap);
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        Long id = evt.getRowData().getLong("id");
        DynamicObject argIntv = argIntvList.stream().filter(staticArgIntv -> evt.getRowData().getLong("id") == staticArgIntv.getLong("id")).findAny().orElse(null);
        LinkedList<Integer> numList = this.numMap.get(id);
        LinkedList<String> iconList = this.iconMap.get(id);
        switch (fieldKey) {
            case "statusicon1": 
            case "statusicon2": 
            case "statusicon3": {
                evt.setFormatValue((Object)(CollectionUtils.isEmpty(iconList) ? null : iconList.removeFirst()));
                break;
            }
            case "statusnum1": 
            case "statusnum2": 
            case "statusnum3": {
                evt.setFormatValue((Object)(CollectionUtils.isEmpty(numList) ? null : numList.removeFirst()));
                break;
            }
            case "intvstarttime": {
                evt.setFormatValue((Object)this.getIntvStartTime(argIntv));
                break;
            }
            case "intver_name": {
                Optional.ofNullable(argIntv).ifPresent(intv -> evt.setFormatValue((Object)this.setIntverHandle((DynamicObject)intv)));
                break;
            }
        }
    }

    private String setIntverHandle(DynamicObject argIntv) {
        ArrayList intvGroupList = new ArrayList(0);
        ArrayList intverFileList = new ArrayList(0);
        Optional.ofNullable(argIntv.getDynamicObjectCollection("tsirm_intvroundentry")).ifPresent(intvRoundList -> intvRoundList.forEach(intvRound -> {
            DynamicObjectCollection intvGroupCollection = intvRound.getDynamicObjectCollection("tsirm_intvgroupentry");
            intvGroupList.addAll(intvGroupCollection);
        }));
        intvGroupList.forEach(intvGroup -> {
            DynamicObjectCollection intverFileCollection = intvGroup.getDynamicObjectCollection("intver");
            intverFileList.addAll(intverFileCollection);
        });
        List intverFileNameList = intverFileList.stream().filter(intverFile -> intverFile.getDynamicObject("fbasedataid") != null).map(intverFile -> intverFile.getDynamicObject("fbasedataid").getString("name")).distinct().collect(Collectors.toList());
        return Joiner.on((String)";").join(intverFileNameList);
    }

    private String getIntvStartTime(DynamicObject argIntv) {
        if (Objects.isNull(argIntv)) {
            log.warn("interview business object is null");
            return null;
        }
        DynamicObjectCollection intvRoundList = argIntv.getDynamicObjectCollection("tsirm_intvroundentry");
        if (CollectionUtils.isEmpty((Collection)intvRoundList)) {
            log.warn("rounds business object is null");
            return null;
        }
        DynamicObject round = (DynamicObject)intvRoundList.get(0);
        DynamicObjectCollection intvGroupList = round.getDynamicObjectCollection("tsirm_intvgroupentry");
        if (CollectionUtils.isEmpty((Collection)intvGroupList)) {
            log.warn("groups business object is null");
            return null;
        }
        DynamicObject minIntvGroup = intvGroupList.stream().min(Comparator.comparingInt(intvGroup -> intvGroup.getInt("seq"))).orElseGet(DynamicObject::new);
        String intvDate = HRInteDateTimeUtil.formatDate((String)"tsirm_intvgroup", (String)"intvdate", (Date)minIntvGroup.getDate("intvdate"));
        String startTime = IntvDateUtil.formatTime((Long)minIntvGroup.getLong("intvstarttime"), (String)"HH:mm");
        return intvDate.concat(" ").concat(startTime);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.showForm("interviewtitle", this.getPrimaryKey());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.showForm(args.getFieldName(), this.getPrimaryKey());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (!"interviewarranger.id".equals(args.getFieldName())) {
            return;
        }
        List<Map<String, Object>> allUserInfoList = this.getAllUserInfoList();
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        map.put("initRootOrgId", UserServiceHelper.getUserMainOrgId((long)UserServiceHelper.getCurrentUserId()));
        args.setCustomParams(map);
        Optional.ofNullable(allUserInfoList).ifPresent(userInfoList -> {
            List idList = userInfoList.stream().map(userInfo -> userInfo.get("id")).collect(Collectors.toList());
            args.setQfilters(Collections.singletonList(new QFilter("id", "in", idList)));
        });
    }

    private FilterContainerInitArgs setCommonFilterColumn(FilterContainerInitArgs args) {
        Boolean isHomePage = this.getView().getFormShowParameter().getCustomParam("is_homepage") == null ? Boolean.FALSE : (Boolean)this.getView().getFormShowParameter().getCustomParam("is_homepage");
        String createTime = (String)this.getView().getFormShowParameter().getCustomParam("createtime");
        List commonFilterColumnList = args.getCommonFilterColumns();
        if (CollectionUtils.isEmpty((Collection)commonFilterColumnList)) {
            return args;
        }
        List<Long> userIdList = this.getAllUserIdList();
        commonFilterColumnList.forEach(commonFilterColumn -> {
            switch (commonFilterColumn.getFieldName()) {
                case "interviewarranger.name": {
                    this.setIntvArger((CommonFilterColumn)commonFilterColumn, isHomePage, userIdList);
                    break;
                }
                case "arrangeantime": {
                    Optional.ofNullable(createTime).ifPresent(arg_0 -> ((FilterColumn)commonFilterColumn).setDefaultValue(arg_0));
                    break;
                }
                case "interviewstatus": {
                    if (!isHomePage.booleanValue()) break;
                    commonFilterColumn.setDefaultValue("A");
                    break;
                }
                default: {
                    return;
                }
            }
        });
        return args;
    }

    private void setIntvArger(CommonFilterColumn commonFilterColumn, Boolean isHomePage, List<Long> userIdList) {
        Boolean isArrangerSelf = (Boolean)this.getView().getFormShowParameter().getCustomParam("is_arranger_self");
        if ((Objects.isNull(isHomePage) || Objects.nonNull(isArrangerSelf)) && this.isSelfExists(userIdList).booleanValue()) {
            commonFilterColumn.setDefaultValue(String.valueOf(UserServiceHelper.getCurrentUserId()));
        }
        long currUserId = RequestContext.get().getCurrUserId();
        List maps = UserServiceHelper.get((List)Lists.newArrayList((Object[])new Long[]{currUserId}));
        commonFilterColumn.setComboItems(this.getComboItemList(maps));
    }

    private List<ComboItem> getComboItemList(List<Map<String, Object>> userInfoList) {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        Optional.ofNullable(userInfoList).ifPresent(userList -> userList.forEach(userInfo -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(String.valueOf(userInfo.get("id")));
            comboItem.setCaption(new LocaleString(((OrmLocaleValue)userInfo.get("name")).getLocaleValue()));
            comboItemList.add(comboItem);
        }));
        return comboItemList;
    }

    private List<Map<String, Object>> getAllUserInfoList() {
        return UserServiceHelper.get(this.getAllUserIdList());
    }

    private List<Map<String, Object>> getAllUserInfoList(List<Long> userIdList) {
        return UserServiceHelper.get(userIdList);
    }

    private Boolean isSelfExists(List<Long> userIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Boolean.FALSE;
        }
        long count = userIdList.stream().filter(userId -> UserServiceHelper.getCurrentUserId() == userId).count();
        return count == 0L ? Boolean.FALSE : Boolean.TRUE;
    }

    private List<Long> getAllUserIdList() {
        Set arrangerId = ArgIntvHelper.getArrangerId((String)"interviewarranger");
        return CollectionUtils.isEmpty((Collection)arrangerId) ? null : Lists.newArrayList((Iterable)arrangerId);
    }

    private int getAppFileTaskNumberByStatus(Long id, String taskStatus) {
        QFilter qFilter = new QFilter("argintv", "=", (Object)id);
        qFilter.and(new QFilter("taskstatus", "=", (Object)taskStatus)).and(new QFilter("enable", "=", (Object)"1"));
        return TsrbsHelper.count((QFilter[])qFilter.toArray(), (String)"tsirm_appfiletask");
    }

    private Long getPrimaryKey() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        return (Long)baseDataListRow.getPrimaryKeyValue();
    }

    private void showForm(String column, Long primaryKey) {
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(primaryKey, "argintv").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvArgBillList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.setCustomParam("arg_intv_id", (Object)primaryKey);
        if (!"interviewtitle".equals(column)) {
            return;
        }
        showParameter.setFormId("tsirm_argintvdetail");
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.MainNewTabPage));
        this.getView().showForm(showParameter);
    }
}

