/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.GetAbleInterviewTimeHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckEntity;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckResultEntity;
import kd.tsc.tsirm.common.entity.IntvGroupParam;
import kd.tsc.tsirm.common.entity.intv.AppFileUser;
import kd.tsc.tsirm.common.entity.intv.AppfileUserForGroup;
import kd.tsc.tsirm.common.entity.intv.GroupAppfileUser;
import kd.tsc.tsirm.common.entity.intv.IntvUnifyTimeParam;
import kd.tsc.tsirm.common.entity.intv.ableintvtime.AbleInterviewTimeResultEntity;
import kd.tsc.tsirm.common.util.IntvBatchUtil;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.IntvCommonFun;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.PageCacheUtil;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbs.common.utils.Num2ChUtils;
import org.apache.commons.collections4.CollectionUtils;

public class IntvBatchGroupEdit
extends HRDataBaseEdit {
    public static final int GROUP_PERSON_NUM = 19;
    public static final String PHOTO = "appres.photo";
    public static final int MAXPERSONNUM = 20;
    private static Set<String> GROUP_DEL_AP = Sets.newHashSetWithExpectedSize((int)20);
    public static double doubleOne = 1.0;

    public void afterBindData(EventObject evt) {
        IFormView mainView;
        int isAddNew;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        IFormView parentView = this.getView().getParentView();
        FormShowParameter formShowParameter = parentView.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            this.setViewAndPropers(entryEntity, parentView);
        }
        if ((isAddNew = PageCacheUtil.INSTANCE.getIntValue("isAddNew", mainView = this.getView().getParentView())) == 1) {
            StringBuilder sb = new StringBuilder();
            for (int index = 0; index < 20; ++index) {
                sb.append("groupdelap").append(index).append(",").append("cardentrycombo").append(index).append(",");
            }
            IntvCommonFun.INSTANCE.hiddenEntryEle1(this.getView(), "subentryentity", sb.toString().split(","));
        }
        IntvCommonFun.setSubPageFieldEmptyTip(this.getView());
    }

    private void setViewAndPropers(DynamicObjectCollection entryEntity, IFormView parentView) {
        DynamicObject dataEntityFather = parentView.getModel().getDataEntity(true);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        CardEntry entry = (CardEntry)this.getControl("subentryentity");
        DynamicObjectCollection subEntryEntityBatch = dynamicObject.getDynamicObjectCollection("subentryentity");
        for (int index = 0; index < subEntryEntityBatch.size(); ++index) {
            DynamicObjectCollection collection = ((DynamicObject)dataEntityFather.getDynamicObjectCollection("tsirm_intvroundentry").get(0)).getDynamicObjectCollection("tsirm_intvgroupentry");
            DynamicObject object = (DynamicObject)collection.get(index);
            DynamicObjectCollection groupCandate = object.getDynamicObjectCollection("groupcandate");
            int groupPersonNum = groupCandate.size();
            if (groupPersonNum >= 20) continue;
            entry.setChildVisible(false, index, this.getVisible(groupPersonNum));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"entryentity"});
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"buttonap", "intver", "close_cale", "vep_upcale", "open_cale"});
        for (String groupDel : GROUP_DEL_AP) {
            this.addClickListeners(new String[]{groupDel});
        }
    }

    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        if ("getIntverIntersectData".equals(eventName)) {
            String intverIntersectData = GetAbleInterviewTimeHelper.getAbleInterviewTimeByJsonObjStr((String)eventArgs);
            IntvCommonFun.INSTANCE.setIntvCustomapData(this.getView(), "intv_insert_customap", "setIntverIntersectData", intverIntersectData);
        }
    }

    public void beforeBindData(EventObject evt) {
        FormShowParameter formShowParameter;
        OperationStatus status;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        IFormView parentView = this.getView().getParentView();
        DynamicObject dataEntityFather = parentView.getModel().getDataEntity(true);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        int groupNum = dynamicObject.getInt("unifygroupnum");
        List<Long> appfileIds = IntvCommonFun.INSTANCE.getAppFileUsersIds(this.getView().getParentView());
        if (groupNum == 0) {
            dynamicObject.set("unifygroupnum", (Object)appfileIds.size());
        }
        if (OperationStatus.EDIT.equals((Object)(status = (formShowParameter = parentView.getFormShowParameter()).getStatus())) || OperationStatus.VIEW.equals((Object)status)) {
            this.initViewAndModelControl(model, dataEntityFather, dynamicObject, appfileIds);
        }
    }

    private void initViewAndModelControl(IDataModel model, DynamicObject dataEntityFather, DynamicObject dynamicObject, List<Long> appfileIds) {
        DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)dataEntityFather.getDynamicObjectCollection("tsirm_intvroundentry").get(0)).getDynamicObjectCollection("tsirm_intvgroupentry");
        if (!dynamicObjectCollection.isEmpty()) {
            DynamicObjectCollection subEntryEntityBatch = dynamicObject.getDynamicObjectCollection("subentryentity");
            ArgIntvHelper argIntvHelper = new ArgIntvHelper();
            DynamicObject[] appFile = argIntvHelper.getAppFile(appfileIds);
            List appFileList = Arrays.stream(appFile).collect(Collectors.toList());
            int iNum = 0;
            int index = 0;
            subEntryEntityBatch.clear();
            for (DynamicObject object : dynamicObjectCollection) {
                DynamicObject objectBatch = subEntryEntityBatch.addNew();
                HRDynamicObjectUtils.copy((DynamicObject)object, (DynamicObject)objectBatch);
                IntvDateUtil.overturnDateTime((DynamicObject)object, (DynamicObject)objectBatch);
                DynamicObjectCollection groupCandate = object.getDynamicObjectCollection("groupcandate");
                int groupPersonNum = groupCandate.size();
                List<DynamicObject> appFiles = appFileList.subList(index, index + groupPersonNum);
                this.allocByPerson(model, groupPersonNum, iNum, appFiles);
                ++iNum;
                index += groupPersonNum;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        DynamicObject entryEntity;
        Date unifyIntvTime;
        String name = evt.getProperty().getName();
        List<Long> appfileIds = IntvCommonFun.INSTANCE.getAppFileUsersIds(this.getView().getParentView());
        int size = appfileIds.size();
        if ("unifypersonnum".equals(name) || "unifygroupnum".equals(name) || "radiogroupfield".equals(name)) {
            this.dynamicCalculate(name, size);
        } else if (name.contains("combo")) {
            this.handleGroupHeaderMove(name);
        } else if (name.equals("unifyintvtime") && !Objects.isNull(unifyIntvTime = (entryEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0)).getDate("unifyintvtime"))) {
            String formatUnifyIntvTime = HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)unifyIntvTime);
            this.getView().getParentView().getPageCache().put("unifyintvtime", formatUnifyIntvTime);
        }
        String clickButtonAssignDataFlag = this.getView().getPageCache().get("clickButtonAssignDataFlag");
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        if ("unifyintver".equals(name)) {
            DynamicObjectCollection intvers = ((DynamicObject)dataEntity.getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("unifyintver");
            if (intvers.size() > 10) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9{0}\u4e2a\u9762\u8bd5\u5b98\u3002", (String)"IntvBatchGroupEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{10}));
            }
            this.getView().sendFormAction(this.getView().getParentView());
            AbleInterviewTimeResultEntity ableInterviewTimeResult = GetAbleInterviewTimeHelper.getAbleInterviewTime((DynamicObjectCollection)intvers, (Date)new Date());
            IntvCommonFun.INSTANCE.setIntvCustomapData(this.getView(), "intv_insert_customap", "setIntverIntersectData", JSON.toJSONString((Object)ableInterviewTimeResult));
        }
        if (IntvBatchUtil.isNameAndClick((String)name, (String)clickButtonAssignDataFlag)) {
            DynamicObjectCollection entryEntity1 = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObject dynamicObject = (DynamicObject)entryEntity1.get(0);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
            for (DynamicObject object : dynamicObjectCollection) {
                DynamicObjectCollection intvers = object.getDynamicObjectCollection("intver");
                if (intvers.size() <= 10) continue;
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e9{0}\u4e2a\u9762\u8bd5\u5b98\u3002", (String)"IntvBatchGroupEdit_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{10}));
                break;
            }
            if (name.equals("intver")) {
                CardEntry cardEntryAppfile = (CardEntry)this.getControl("subentryentity");
                int[] selectRows = cardEntryAppfile.getSelectRows();
                if (selectRows.length == 0) {
                    return;
                }
                int rowIndex = selectRows[0];
                DynamicObjectCollection changeIntvers = ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getDynamicObjectCollection("intver");
                AbleInterviewTimeResultEntity ableInterviewTimeResult = GetAbleInterviewTimeHelper.getAbleInterviewTime((DynamicObjectCollection)changeIntvers, (Date)new Date());
                IntvCommonFun.INSTANCE.setIntvCustomapData(this.getView(), "intv_insert_customap", "setIntverIntersectData", JSON.toJSONString((Object)ableInterviewTimeResult));
            }
            List<IntvCheckEntity> checkObjects = this.getCheckObjects(dynamicObjectCollection);
            List checkRes = IntvCheckHelper.checkIntvObject(checkObjects);
            for (IntvCheckResultEntity checkRe : checkRes) {
                if (checkRe.isCheckResult()) continue;
                this.getView().getParentView().showTipNotification(checkRe.getCheckMessage());
            }
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void dynamicCalculate(String name, int size) {
        boolean moreMaxPerson;
        double sum = Double.parseDouble(String.valueOf(size));
        DynamicObject entryEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0);
        int groupNum = entryEntity.getInt("unifygroupnum");
        double unifyGroupNum = (double)groupNum * doubleOne;
        double unifyPersonNum = (double)entryEntity.getInt("unifypersonnum") * doubleOne;
        String radioGroupField = entryEntity.getString("radiogroupfield");
        if (groupNum > size) {
            this.getModel().setValue("unifygroupnum", (Object)size);
        }
        boolean flag = "unifygroupnum".equals(name) || "radiogroupfield".equals(name);
        boolean bl = moreMaxPerson = "unifypersonnum".equals(name) || "radiogroupfield".equals(name);
        if (HRStringUtils.equals((String)radioGroupField, (String)"2")) {
            if (flag) {
                this.divideByGroup(size, sum, unifyGroupNum);
            }
            if (moreMaxPerson) {
                this.divideByMaxPersonGroup(sum, unifyGroupNum, unifyPersonNum);
            }
        }
        if (HRStringUtils.equals((String)radioGroupField, (String)"1")) {
            if (flag) {
                this.divideByPerson(sum, unifyGroupNum, unifyPersonNum);
            }
            if (moreMaxPerson) {
                this.divideByMaxPerson(sum, unifyPersonNum);
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"subentryentity"});
    }

    private void divideByMaxPersonGroup(double sum, double unifyGroupNum, double unifyPersonNum) {
        double dv;
        String result = this.getPageCache().get("unifypersonnum");
        double remainder = 0.0;
        if (HRStringUtils.isNotEmpty((String)result)) {
            remainder = Double.parseDouble(result);
        }
        if (Double.compare(dv = unifyGroupNum * unifyPersonNum - remainder, sum) == 0) {
            return;
        }
        this.getModel().setValue("unifygroupnum", (Object)Math.ceil(sum / unifyPersonNum));
    }

    private void divideByGroup(int size, double sum, double unifyGroupNum) {
        double peopleRes = Math.ceil(sum / unifyGroupNum);
        double vd = unifyGroupNum * peopleRes - sum;
        this.getPageCache().put("unifypersonnum", String.valueOf(vd));
        if (peopleRes > 20.0) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("tsrbsGroupOverload", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6bcf\u7ec4\u6700\u591a\u5206\u914d20\u4eba\uff0c\u5f53\u524d{0}\u4eba;\r\n(\u70b9\u51fb\u786e\u5b9a\u5c06\u81ea\u52a8\u4e3a\u60a8\u5206\u914d\uff0c\u70b9\u51fb\u53d6\u6d88\u5c06\u6062\u590d\u9ed8\u8ba4)", (String)"IntvBatchGroupEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{size}), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
        } else {
            this.getModel().setValue("unifypersonnum", (Object)peopleRes);
        }
    }

    private void divideByMaxPerson(double sum, double unifyPersonNum) {
        if (unifyPersonNum > 20.0) {
            this.getModel().setValue("unifypersonnum", (Object)20);
        } else {
            double vd = sum - Math.floor(sum / unifyPersonNum) * unifyPersonNum;
            this.getPageCache().put("unifygroupnum", String.valueOf(vd));
            this.getModel().setValue("unifygroupnum", (Object)Math.ceil(sum / unifyPersonNum));
        }
    }

    private void divideByPerson(double sum, double unifyGroupNum, double unifyPersonNum) {
        double dv;
        double personnum = Math.ceil(sum / unifyGroupNum);
        String result = this.getPageCache().get("unifygroupnum");
        double remainder = 0.0;
        if (HRStringUtils.isNotEmpty((String)result)) {
            remainder = Double.parseDouble(result);
        }
        if (Double.compare(dv = (unifyGroupNum - 1.0) * unifyPersonNum + remainder, sum) == 0) {
            return;
        }
        this.getModel().setValue("unifypersonnum", (Object)personnum);
    }

    private void handleGroupHeaderMove(String name) {
        String comboInit = this.getView().getPageCache().get("comboInit");
        if (!HRStringUtils.isEmpty((String)comboInit)) {
            return;
        }
        String comboRun = this.getView().getPageCache().get("comboRun");
        if (!HRStringUtils.isEmpty((String)comboRun)) {
            this.getView().getPageCache().put("comboRun", "");
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl("subentryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int currRow = selectRows[0];
        String comboValue = (String)this.getModel().getValue(name, currRow);
        int targetGroupIndex = Integer.parseInt(comboValue) - 1;
        int xNum = Integer.parseInt(name.split("combo")[1]);
        long appFileId = this.getAppFileId(xNum, currRow);
        List<GroupAppfileUser> groupAppFileUser = IntvCommonFun.INSTANCE.getGroupAppFileUser(this.getView());
        LinkedList targetGroup = groupAppFileUser.get(targetGroupIndex).getAppfileUserForGroup();
        LinkedList curGroup = groupAppFileUser.get(currRow).getAppfileUserForGroup();
        Iterator iterator = curGroup.iterator();
        while (iterator.hasNext()) {
            AppfileUserForGroup next = (AppfileUserForGroup)iterator.next();
            if (!next.getAppFileId().equals(appFileId)) continue;
            targetGroup.add(next);
            iterator.remove();
            break;
        }
        IntvCommonFun.INSTANCE.setGroupAppFileUser(this.getView(), groupAppFileUser);
        IntvCommonFun.setGroupInfoByGroupAppFileUserList(groupAppFileUser, this.getModel(), this.getView());
        IntvCommonFun.hideGroupHeader(this.getView());
    }

    public List<IntvCheckEntity> getCheckObjects(DynamicObjectCollection groupInfo) {
        if (groupInfo == null || groupInfo.size() == 0) {
            return null;
        }
        ArrayList checkObjs = Lists.newArrayListWithExpectedSize((int)groupInfo.size());
        for (DynamicObject groupObj : groupInfo) {
            checkObjs.add(this.convertGroupToCheckObj(groupObj));
        }
        return checkObjs;
    }

    private IntvCheckEntity convertGroupToCheckObj(DynamicObject groupDy) {
        IntvCheckEntity checkObj = new IntvCheckEntity();
        if (groupDy != null) {
            checkObj.setObjName(groupDy.get("groupname").toString());
            checkObj.setIntvers(IntvCheckHelper.getIntvers((DynamicObjectCollection)groupDy.getDynamicObjectCollection("intver")));
            String admindivision = "";
            String interviewlocation = "";
            String interviewroom = "";
            Date intvStartTime = null;
            Date intvEndTime = null;
            if (groupDy.get("admindivision") != null) {
                admindivision = groupDy.get("admindivision").toString().trim();
            }
            if (groupDy.get("interviewlocation").toString() != null) {
                interviewlocation = groupDy.get("interviewlocation").toString().trim();
            }
            if (groupDy.get("interviewroom").toString() != null) {
                interviewroom = groupDy.get("interviewroom").toString().trim();
            }
            checkObj.setIntvAddress(admindivision + interviewlocation + interviewroom);
            if (groupDy.getDate("intvdatetime") != null && groupDy.getInt("groupduration") != 0) {
                intvStartTime = groupDy.getDate("intvdatetime");
                int intvTime = groupDy.getInt("groupduration") * IntvDateUtil.TIME_NUM;
                intvEndTime = new Date(intvStartTime.getTime() + (long)intvTime);
            }
            checkObj.setIntvStartTime(intvStartTime);
            checkObj.setIntvEndTime(intvEndTime);
        }
        return checkObj;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "buttonap": {
                this.handlerArrangeIntv();
                break;
            }
            case "close_cale": 
            case "vep_upcale": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"intv_intersect_cale"});
                break;
            }
            case "open_cale": {
                this.getView().setVisible(Boolean.TRUE, new String[]{"intv_intersect_cale"});
                break;
            }
        }
        if (key.contains("groupdelap")) {
            this.handleRemoveHeader(key);
        }
    }

    private void handlerArrangeIntv() {
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("tsrbsGroupClear", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u3010\u7edf\u4e00\u5b89\u6392\u3011\u540e\u5019\u9009\u4eba\u9762\u8bd5\u4fe1\u606f\u5c06\u88ab\u91cd\u65b0\u8986\u76d6;\r\n\u786e\u8ba4\u7edf\u4e00\u5b89\u6392\uff1f", (String)"IntvBatchGroupEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, callBackListener);
        } else {
            this.extracted(model, dynamicObject);
            IntvCommonFun.hideGroupHeader(this.getView());
        }
    }

    private void handleRemoveHeader(String key) {
        List<AppFileUser> appFileUsers;
        boolean delFlag;
        int colIndex = Integer.parseInt(key.substring(key.length() - 1));
        CardEntry cardEntry = (CardEntry)this.getControl("subentryentity");
        int[] selectRows = cardEntry.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        int rowIndex = selectRows[0];
        List<GroupAppfileUser> groupAppFileUser = IntvCommonFun.INSTANCE.getGroupAppFileUser(this.getView());
        long appFileId = this.getAppFileId(colIndex, rowIndex);
        LinkedList headerList = groupAppFileUser.get(rowIndex).getAppfileUserForGroup();
        headerList.remove(colIndex);
        IntvCommonFun.INSTANCE.setGroupAppFileUser(this.getView(), groupAppFileUser);
        String oldRemainderString = this.getPageCache().get("unifypersonnum");
        if (HRStringUtils.isNotEmpty((String)oldRemainderString)) {
            Double oldRemainder;
            Double d = oldRemainder = Double.valueOf(oldRemainderString);
            Double d2 = oldRemainder = Double.valueOf(oldRemainder + 1.0);
            DynamicObject entryEntity = (DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0);
            double groupNum = (double)entryEntity.getInt("unifygroupnum") * doubleOne;
            if (oldRemainder >= groupNum) {
                oldRemainder = oldRemainder - groupNum;
            }
            this.getPageCache().put("unifypersonnum", String.valueOf(oldRemainder));
        }
        if (delFlag = (appFileUsers = IntvCommonFun.INSTANCE.getAppFileUsers(this.getView().getParentView())).removeIf(next -> next.getAppFileId().equals(appFileId))) {
            IntvCommonFun.INSTANCE.setAppFileUser(this.getView().getParentView(), appFileUsers);
            String headPageId = this.getView().getParentView().getPageCache().get("candidateprofilepanel");
            if (HRStringUtils.isNotEmpty((String)headPageId)) {
                IFormView headView = this.getView().getView(headPageId);
                headView.updateView();
                this.getView().sendFormAction(headView);
            }
        }
        IntvCommonFun.setGroupInfoByGroupAppFileUserList(groupAppFileUser, this.getModel(), this.getView());
        IntvCommonFun.hideGroupHeader(this.getView());
    }

    private long getAppFileId(int colIndex, int rowIndex) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("subentryentity");
        return ((DynamicObject)dynamicObjectCollection.get(rowIndex)).getLong("groupappresid" + colIndex);
    }

    private void extracted(IDataModel model, DynamicObject dynamicObject) {
        Date groupTrueDate;
        LocalDateTime groupDate;
        GroupAppfileUser groupAppfileUser;
        List<AppFileUser> appFiles;
        int index;
        IntvUnifyTimeParam intvUnifyTimeParam;
        Date date;
        LocalDateTime preDate;
        int difference;
        ArrayList groupAppfileUsers;
        this.getView().getPageCache().put("clickButtonAssignDataFlag", "1");
        List<AppFileUser> appFileUsers = IntvCommonFun.INSTANCE.getAppFileUsers(this.getView().getParentView());
        int appfileSize = appFileUsers.size();
        int groupPersonNum = dynamicObject.getInt("unifypersonnum");
        int anInt = dynamicObject.getInt("unifygroupnum");
        int groupNum = anInt == 0 ? appfileSize : anInt;
        String radioGroupField = dynamicObject.getString("radiogroupfield");
        if (HRStringUtils.equals((String)radioGroupField, (String)"1")) {
            double groupNum2 = Math.ceil((double)appfileSize * doubleOne / ((double)groupPersonNum * doubleOne));
            if (anInt == 0 || (double)anInt > groupNum2) {
                groupNum = (int)groupNum2;
                this.getModel().setValue("unifygroupnum", (Object)groupNum);
            }
        }
        model.batchCreateNewEntryRow("subentryentity", groupNum);
        this.setCombo(groupNum);
        IntvGroupParam intvGroupParam = new IntvGroupParam(0);
        if (HRStringUtils.equals((String)radioGroupField, (String)"1")) {
            groupAppfileUsers = Lists.newArrayListWithCapacity((int)groupNum);
            difference = appfileSize - (groupNum - 1) * groupPersonNum;
            preDate = null;
            date = dynamicObject.getDate("unifyintvtime");
            if (date != null) {
                preDate = DateUtils.getLocalDateTimeByDate((Date)date);
            }
            intvUnifyTimeParam = new IntvUnifyTimeParam(this.getView(), false);
            for (index = 0; index < groupNum - 1; ++index) {
                LocalDateTime groupDate2 = IntvBatchUtil.getGroupDate((LocalDateTime)preDate, (int)dynamicObject.getInt("unifyduration"), (int)dynamicObject.getInt("halfbegintime"), (int)dynamicObject.getInt("halfendtime"), (IntvUnifyTimeParam)intvUnifyTimeParam);
                Date groupTrueDate2 = DateUtils.getDateByLocalDateTime((LocalDateTime)groupDate2);
                GroupAppfileUser groupAppfileUser2 = new GroupAppfileUser();
                appFiles = appFileUsers.subList(groupPersonNum * index, groupPersonNum * (index + 1));
                this.allocByPerson(model, dynamicObject, groupPersonNum, intvGroupParam, index, appFiles, groupAppfileUser2, groupTrueDate2);
                groupAppfileUsers.add(groupAppfileUser2);
                if (intvUnifyTimeParam.isNoArrange() || Objects.isNull(groupDate2)) continue;
                preDate = groupDate2.plusMinutes(dynamicObject.getInt("unifyduration"));
            }
            int lastIndex = groupNum - 1;
            groupAppfileUser = new GroupAppfileUser();
            appFiles = appFileUsers.subList(lastIndex * groupPersonNum, appfileSize);
            groupDate = IntvBatchUtil.getGroupDate((LocalDateTime)preDate, (int)dynamicObject.getInt("unifyduration"), (int)dynamicObject.getInt("halfbegintime"), (int)dynamicObject.getInt("halfendtime"), (IntvUnifyTimeParam)intvUnifyTimeParam);
            groupTrueDate = DateUtils.getDateByLocalDateTime((LocalDateTime)groupDate);
            this.allocByPerson(model, dynamicObject, difference, intvGroupParam, lastIndex, appFiles, groupAppfileUser, groupTrueDate);
            groupAppfileUsers.add(groupAppfileUser);
            IntvCommonFun.INSTANCE.setGroupAppFileUser(this.getView(), groupAppfileUsers);
        }
        if (HRStringUtils.equals((String)radioGroupField, (String)"2")) {
            groupAppfileUsers = Lists.newArrayListWithCapacity((int)groupNum);
            difference = appfileSize - (groupPersonNum - 1) * groupNum;
            if (difference < 0) {
                difference = appfileSize % groupNum;
                groupPersonNum = (appfileSize - difference) / groupNum + 1;
                this.getModel().setValue("unifypersonnum", (Object)groupPersonNum);
            }
            if (difference == 0) {
                groupPersonNum = (appfileSize - difference) / groupNum;
                this.getModel().setValue("unifypersonnum", (Object)groupPersonNum);
            }
            preDate = null;
            date = dynamicObject.getDate("unifyintvtime");
            if (date != null) {
                preDate = DateUtils.getLocalDateTimeByDate((Date)date);
            }
            intvUnifyTimeParam = new IntvUnifyTimeParam(this.getView(), false);
            for (index = 0; index < groupNum; ++index) {
                groupAppfileUser = new GroupAppfileUser();
                groupDate = IntvBatchUtil.getGroupDate((LocalDateTime)preDate, (int)dynamicObject.getInt("unifyduration"), (int)dynamicObject.getInt("halfbegintime"), (int)dynamicObject.getInt("halfendtime"), (IntvUnifyTimeParam)intvUnifyTimeParam);
                groupTrueDate = DateUtils.getDateByLocalDateTime((LocalDateTime)groupDate);
                if (index + 1 <= difference || difference == 0) {
                    int fromNum = groupPersonNum * index;
                    int toNum = groupPersonNum * (index + 1);
                    appFiles = appFileUsers.subList(fromNum, toNum);
                    this.allocByPerson(model, dynamicObject, groupPersonNum, intvGroupParam, index, appFiles, groupAppfileUser, groupTrueDate);
                } else {
                    int difNum = groupPersonNum * difference;
                    int fromNum = difNum + (index - difference) * (groupPersonNum - 1);
                    int toNum = difNum + (groupPersonNum - 1) * (index - difference + 1);
                    appFiles = appFileUsers.subList(fromNum, toNum);
                    this.allocByPerson(model, dynamicObject, groupPersonNum - 1, intvGroupParam, index, appFiles, groupAppfileUser, groupTrueDate);
                }
                groupAppfileUsers.add(groupAppfileUser);
                if (Objects.isNull(groupDate)) continue;
                preDate = groupDate.plusMinutes(dynamicObject.getInt("unifyduration"));
            }
            IntvCommonFun.INSTANCE.setGroupAppFileUser(this.getView(), groupAppfileUsers);
        }
        this.getView().getPageCache().remove("clickButtonAssignDataFlag");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
        if (HRStringUtils.equals((String)"tsrbsGroupClear", (String)messageBoxClosedEvent.getCallBackId())) {
            if (result == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("subentryentity");
                this.extracted(this.getModel(), dynamicObject);
            }
        } else if (HRStringUtils.equals((String)"tsrbsGroupOverload", (String)messageBoxClosedEvent.getCallBackId())) {
            List<Long> appfileIds = IntvCommonFun.INSTANCE.getAppFileUsersIds(this.getView().getParentView());
            int size = appfileIds.size();
            if (result == MessageBoxResult.Yes) {
                double sum = Double.parseDouble(String.valueOf(size));
                this.getModel().setValue("unifypersonnum", (Object)20);
                this.getModel().setValue("unifygroupnum", (Object)Math.ceil(sum / 20.0));
            } else {
                this.getModel().setValue("unifypersonnum", (Object)1);
                this.getModel().setValue("unifygroupnum", (Object)size);
            }
        }
        IntvCommonFun.hideGroupHeader(this.getView());
    }

    public void setCombo(long groupNum) {
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        int index = 1;
        while ((long)index <= groupNum) {
            String groupName = ResManager.loadKDString((String)"\u7b2c{0}\u7ec4", (String)"IntvBatchGroupEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{Num2ChUtils.toCH((int)index)});
            data.add(new ComboItem(new LocaleString(groupName), String.valueOf(index)));
            ++index;
        }
        this.setComboEdit(data);
    }

    private void setComboEdit(List<ComboItem> data) {
        for (int index = 0; index <= 19; ++index) {
            ComboEdit comboEdit = (ComboEdit)this.getControl("combo" + index);
            if (HRObjectUtils.isEmpty((Object)comboEdit)) continue;
            comboEdit.setComboItems(data);
        }
    }

    private void allocByPerson(IDataModel model, int groupPersonNum, int index, List<DynamicObject> appFiles) {
        String groupName = ResManager.loadKDString((String)"\u7b2c{0}\u7ec4", (String)"IntvBatchGroupEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{Num2ChUtils.toCH((int)(index + 1))});
        model.setValue("groupname", (Object)groupName, index);
        model.setValue("totalnum", (Object)groupPersonNum, index);
        this.setPicAndUserName(groupPersonNum, index, appFiles);
    }

    private void allocByPerson(IDataModel model, DynamicObject dynamicObject, int groupPersonNum, IntvGroupParam intvGroupParam, int index, List<AppFileUser> appFile, GroupAppfileUser groupAppfileUser, Date groupTrueDate) {
        LinkedList<AppfileUserForGroup> appfileUserForGroup = new LinkedList<AppfileUserForGroup>();
        String groupName = ResManager.loadKDString((String)"\u7b2c{0}\u7ec4", (String)"IntvBatchGroupEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{Num2ChUtils.toCH((int)(index + 1))});
        model.setValue("groupname", (Object)groupName, index);
        groupAppfileUser.setGroupName(groupName);
        model.setValue("totalnum", (Object)groupPersonNum, index);
        groupAppfileUser.setTotalName(Integer.valueOf(groupPersonNum));
        IntvBatchUtil.assignData((IDataModel)model, (DynamicObject)dynamicObject, (int)index, (IntvGroupParam)intvGroupParam, (Date)groupTrueDate);
        groupAppfileUser.setAppfileUserForGroup(appfileUserForGroup);
        this.setPicAndUserName(groupPersonNum, index, appFile, appfileUserForGroup);
    }

    private void setPicAndUserName(int groupPersonNum, int index, List<DynamicObject> appFiles) {
        for (int j = 0; j < groupPersonNum; ++j) {
            DynamicObject dynamicObject = appFiles.get(j);
            String photo = dynamicObject.getString(PHOTO);
            String fullName = dynamicObject.getString("name");
            long id = dynamicObject.getLong("id");
            this.getModel().setValue("picturefield" + j, (Object)photo, index);
            this.getModel().setValue("username" + j, (Object)fullName, index);
            this.getModel().setValue("groupappresid" + j, (Object)id, index);
        }
    }

    private void setPicAndUserName(int groupPersonNum, int index, List<AppFileUser> appFile, LinkedList<AppfileUserForGroup> appfileUserForGroups) {
        for (int j = 0; j < groupPersonNum; ++j) {
            AppFileUser dynamicObject = appFile.get(j);
            String photo = dynamicObject.getPhoto();
            String fullName = dynamicObject.getName();
            long id = dynamicObject.getAppFileId();
            this.getModel().setValue("picturefield" + j, (Object)photo, index);
            this.getModel().setValue("username" + j, (Object)fullName, index);
            this.getModel().setValue("groupappresid" + j, (Object)id, index);
            this.getView().getPageCache().put("comboInit", "1");
            this.getModel().setValue("combo" + j, (Object)String.valueOf(index + 1), index);
            this.getView().getPageCache().put("comboInit", "");
            AppfileUserForGroup appfileUserForGroup = new AppfileUserForGroup(Long.valueOf(id), fullName, photo);
            appfileUserForGroups.add(appfileUserForGroup);
        }
    }

    private String[] getVisible(int groupPersonNum) {
        int size = 19 - groupPersonNum;
        StringBuilder sb = new StringBuilder(5200);
        for (int index = 0; index <= size; ++index) {
            sb.append("picturefield").append(19 - index).append(",").append("username").append(19 - index).append(",").append("combo").append(19 - index).append(",").append("groupdelap").append(19 - index).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString().split(",");
    }

    static {
        for (int index = 0; index <= 19; ++index) {
            GROUP_DEL_AP.add("groupdelap" + index);
        }
    }
}

