/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvAppfileTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvevlansHelper;
import kd.tsc.tsirm.business.domain.intv.service.oprecord.IntvOpRecordService;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvOperateUtils;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.IQuestionHandlerStrategy;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.question.QuestionContext;
import kd.tsc.tsrbd.common.entity.evalform.InspectDimensGroup;
import kd.tsc.tsrbd.common.entity.evalform.OptionGroup;
import kd.tsc.tsrbd.common.entity.evalform.SubjectGroup;
import org.apache.commons.lang3.StringUtils;

public class IntvEvlBaseEdit
extends HRDataBaseEdit
implements ClickListener,
UploadListener {
    private static final String KEY_BTNSAVE = "btnsave";
    public static final String CHANGE = "change";
    public static final String INTVSTS = "intvsts";
    public static final String CONFIRM = "confirm";
    public static final String INTVEVLRSLT = "intvevlrslt";
    private static final Log logger = LogFactory.getLog(IntvEvlBaseEdit.class);
    private static final HashMap<String, Consumer<BeforeDoOperationEventArgs>> OPERATE_KEY = new HashMap(4);

    public IntvEvlBaseEdit() {
        OPERATE_KEY.put("save", this::save);
        OPERATE_KEY.put("submit", this::submit);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{KEY_BTNSAVE});
        this.addClickListeners(new String[]{"btnsubmit", KEY_BTNSAVE});
        AttachmentPanel panel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        panel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        this.initData();
    }

    public void afterLoadData(EventObject evt) {
        this.getView().setStatus(OperationStatus.ADDNEW);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setVisible(Boolean.valueOf(customParams.get("showTitle") == null), new String[]{"flexpanelap2"});
        if (customParams.get("showCloseAndCancel") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel", "btnclose"});
        }
        this.initHandle(customParams);
    }

    public void initHandle(Map<String, Object> customParams) {
        if (customParams.size() > 0) {
            this.initData();
            DynamicObject intvObj = this.getModel().getDataEntity();
            this.messageHandle(null);
        }
    }

    public void messageHandle(String message) {
        if (message != null && !HRStringUtils.equals((String)message, (String)ResManager.loadKDString((String)"\u9762\u8bd5\u4efb\u52a1\u5df2\u8bc4\u4ef7\u3002", (String)"IntvEvlBaseEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]))) {
            this.getView().showErrorNotification(message);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        DynamicObject intvObj = this.getModel().getDataEntity();
        DynamicObject byId = IntvEvlHelper.getInstance().findById((Object)intvObj.getLong("id"));
        String message = IntvEvlHelper.getInstance().checkIntvEvlStatus(byId);
        this.messageHandle(args, operate, message);
    }

    public void messageHandle(BeforeDoOperationEventArgs args, FormOperate operate, String message) {
        if (message != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsubmit", KEY_BTNSAVE, "btncancel"});
            this.getView().showErrorNotification(message);
            args.setCancel(true);
            return;
        }
        Consumer<BeforeDoOperationEventArgs> consumer = OPERATE_KEY.get(operate.getOperateKey());
        if (consumer != null) {
            if ("tsirm_intvevl_agent".equals(this.getView().getEntityId()) && !IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"agent_evl").booleanValue()) {
                args.setCancel(true);
                return;
            }
            consumer.accept(args);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)KEY_BTNSAVE)) {
            CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
            HashMap<String, Integer> aa = new HashMap<String, Integer>();
            aa.put("save", new SecureRandom().nextInt());
            customcontrol.setData(aa);
        } else if (HRStringUtils.equals((String)key, (String)"btnsubmit")) {
            CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
            HashMap<String, Integer> aa = new HashMap<String, Integer>();
            aa.put("submit", new SecureRandom().nextInt());
            customcontrol.setData(aa);
        }
    }

    public void customEvent(CustomEventArgs evt) {
        if (HRStringUtils.isNotEmpty((String)evt.getEventArgs()) && HRStringUtils.equals((String)evt.getKey(), (String)"customcontrolap") && HRStringUtils.equals((String)this.getUrlParam("sourceType"), (String)"edit")) {
            this.getPageCache().put("customlabeldata", evt.getEventArgs());
            this.operateHandle(evt.getEventName());
        }
    }

    public void operateHandle(String eventName) {
        if (eventName.equals("save")) {
            this.opSave("save", this.createOperateOption());
        } else if (HRStringUtils.equals((String)eventName, (String)"submit")) {
            this.opSave("submit", this.createOperateOption());
        } else if (HRObjectUtils.equals((Object)eventName, (Object)"cache")) {
            this.getPageCache().put("isUpdata", "1");
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        String fieldName = evt.getProperty().getName();
        this.changeHandle(fieldName);
    }

    public void changeHandle(String fieldName) {
        if (HRStringUtils.equals((String)fieldName, (String)INTVEVLRSLT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"intvrsetip"});
            this.getPageCache().put("isUpdata", "1");
        } else if (HRStringUtils.equals((String)fieldName, (String)"interviewcontent")) {
            this.getPageCache().put("isUpdata", "1");
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.getPageCache().put("isUpdata", "1");
    }

    public void afterRemove(UploadEvent evt) {
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            if (HRStringUtils.equals((String)KEY_BTNSAVE, (String)messageBoxClosedEvent.getCallBackId())) {
                if ("tsirm_intvevl_agent".equals(this.getView().getEntityId()) && !IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"agent_evl").booleanValue()) {
                    return;
                }
                OperateOption operateOption = this.createOperateOption();
                operateOption.setVariableValue(CONFIRM, "true");
                this.opSave("submit", operateOption);
            } else if (HRStringUtils.equals((String)"closeConfirm", (String)messageBoxClosedEvent.getCallBackId())) {
                this.getPageCache().put("isConfirmedClose", "1");
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                if (customParams.get("showCloseAndCancel") != null) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BTNSAVE, "btncancel", "btnsubmit", "btnclose"});
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                this.getView().close();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey = evt.getOperateKey();
        HashMap map = Maps.newHashMapWithExpectedSize((int)16);
        map.put(CHANGE, Boolean.FALSE);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (HRStringUtils.equals((String)operateKey, (String)"submit")) {
            OperationResult opResult = evt.getOperationResult();
            if (opResult != null && opResult.isSuccess()) {
                map.put(CHANGE, Boolean.TRUE);
                Object evlCont = this.getModel().getValue("interviewcontent");
                Object intvRslt = this.getModel().getValue(INTVEVLRSLT);
                Object intvEvlTime = this.getModel().getValue("interviewevaluationtime");
                Object interviewstatus = this.getModel().getValue("interviewstatus");
                Long argId = this.getModel().getDataEntity().getDynamicObject("argintv").getLong("id");
                DynamicObject dynamicObject = ArgIntvHelper.selectById((Long)argId, (String)"tsirm_argintv");
                Object intvsts = dynamicObject.get("interviewstatus");
                map.put("interviewcontent", evlCont);
                map.put(INTVEVLRSLT, intvRslt);
                map.put("interviewevaluationtime", intvEvlTime);
                map.put("interviewstatus", interviewstatus);
                map.put(INTVSTS, intvsts);
                evt.getOperationResult().setShowMessage(false);
                try {
                    IntvOpRecordService.getInstance().intvOp(Collections.singletonList(this.getModel().getDataEntity(true)));
                    long appfileTaskID = this.getModel().getDataEntity().getDynamicObject("appfiletask").getLong("id");
                    DynamicObject[] queryAppfiletasks = IntvAppfileTaskHelper.getInstance().getAppfileTasks("id,application,intvevlstatus,argintv", new QFilter("id", "=", (Object)appfileTaskID));
                    DynamicObject queryAppfiletask = queryAppfiletasks[0];
                    DynamicObject application = queryAppfiletask.getDynamicObject("application");
                    String title = queryAppfiletask.getDynamicObject("argintv").getString("interviewtitle");
                    String intvevlstatus = queryAppfiletask.getString("intvevlstatus");
                    if (null != intvevlstatus && !intvevlstatus.isEmpty()) {
                        String status = intvevlstatus.equals("A") ? ResManager.loadKDString((String)"\u901a\u8fc7", (String)"IntvEvlBaseEdit_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : (intvevlstatus.equals("B") ? ResManager.loadKDString((String)"\u4e0d\u901a\u8fc7", (String)"IntvEvlBaseEdit_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f85\u5b9a", (String)"IntvEvlBaseEdit_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                        IntvOpRecordService.getInstance().autoPathOR(application, status, title);
                    }
                }
                catch (Exception ex) {
                    logger.error("\u3010interview evaluation error\u3011 : ", (Throwable)ex);
                }
            }
            this.getPageCache().put("isUpdata", "0");
            if (customParams.get("showCloseAndCancel") == null) {
                this.getView().returnDataToParent((Object)map);
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BTNSAVE, "btncancel", "btnsubmit", "btnclose"});
            this.getView().setStatus(OperationStatus.VIEW);
            this.getPageCache().put("isConfirmedClose", "1");
            if (customParams.get("showCloseAndCancel") != null) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{KEY_BTNSAVE, "btncancel", "btnsubmit", "btnclose"});
                this.getView().setStatus(OperationStatus.VIEW);
                IFormView parentView = this.getView().getParentView();
                Optional.ofNullable(parentView).ifPresent(v -> {
                    parentView.setVisible(Boolean.valueOf(false), new String[]{"timeaddressflex", "aiquestionflex"});
                    parentView.setStatus(OperationStatus.VIEW);
                    parentView.invokeOperation("refresh");
                    this.getView().sendFormAction(parentView);
                });
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.getPageCache().put("isUpdata", "0");
        }
        if (customParams.get("showCloseAndCancel") == null) {
            this.getView().returnDataToParent((Object)map);
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        evt.setSkipNoField(true);
        this.getModel().setDataChanged(false);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("showCloseAndCancel") != null) {
            IFormView parentView = this.getView().getParentView();
            Optional.ofNullable(parentView).ifPresent(v -> evt.setCancel(true));
        }
        if (HRStringUtils.equals((String)this.getPageCache().get("isConfirmedClose"), (String)"1") || HRStringUtils.equals((String)this.getPageCache().get("isUpdata"), (String)"0") || HRStringUtils.equals((String)this.getUrlParam("sourceType"), (String)"preview") || HRStringUtils.equals((String)this.getUrlParam("sourceType"), (String)"select")) {
            return;
        }
        evt.setCancel(true);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"IntvEvlBaseEdit_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("closeConfirm", (IFormPlugin)this));
    }

    private void initData() {
        Object intvevlqunrID = this.getView().getFormShowParameter().getCustomParam("evlFormId");
        this.getModel().setValue("intvevlqunrid", intvevlqunrID);
        this.getView().setVisible(Boolean.FALSE, new String[]{"intvrsetip"});
        this.setCurPageCache();
        this.fillEvlForm();
        String intverviewStatus = this.getModelValStr("interviewstatus");
        if ("C".equals(intverviewStatus)) {
            Object intvevlId = this.getModelVal("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"tsirm_intvevl_agent", (Object)intvevlId, (String)"attachmentpanelap");
            AttachmentPanel attachPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
            IClientViewProxy proxy = (IClientViewProxy)attachPanel.getView().getService(IClientViewProxy.class);
            proxy.setFieldProperty(attachPanel.getKey(), "v", (Object)attachments);
        }
    }

    private void setCurPageCache() {
        this.getPageCache().put("isUpdata", "0");
        this.getPageCache().put("isConfirmedClose", "0");
    }

    private void fillEvlForm() {
        String pageType = this.getUrlParam("sourceType");
        String evlId = this.getUrlParam("evlId");
        String evlFormId = this.getUrlParam("evlFormId");
        String customEvtName = "initData";
        Gson gson = new Gson();
        String evlJson = this.pageTypeHandle(pageType, evlId, evlFormId, gson, customEvtName);
        CustomControl customcontrol = (CustomControl)this.getControl("customcontrolap");
        HashMap<String, String> customParam = new HashMap<String, String>();
        if ("view".equals(pageType)) {
            customEvtName = "initDataView";
        }
        customParam.put(customEvtName, HRStringUtils.isEmpty((String)evlJson) ? "[]" : evlJson);
        customcontrol.setData(customParam);
    }

    public String pageTypeHandle(String pageType, String evlId, String evlFormId, Gson gson, String customEvtName) {
        List<InspectDimensGroup> evlConfigData;
        String evlJson = "";
        if (HRStringUtils.equals((String)pageType, (String)"preview")) {
            Map previewData = (Map)this.getView().getFormShowParameter().getCustomParam("previewData");
            this.getModel().setValue("evltitle", previewData.get("name"));
            this.getModel().setValue("evldesc", previewData.get("desc"));
            evlJson = (String)previewData.get("content");
            this.getView().setVisible(Boolean.TRUE, new String[]{"operatepanel", "btnclose"});
            HashMap<String, String> cstylesMap = new HashMap<String, String>(16);
            cstylesMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtwb2ludGVyLWV2ZW50czogbm9uZTt9In0=");
            this.getView().updateControlMetadata("customcontrolap", cstylesMap);
            this.getView().updateControlMetadata("flexpanelap7", cstylesMap);
        } else if (HRStringUtils.equals((String)pageType, (String)"select")) {
            evlConfigData = this.getEvlConfigData(evlFormId);
            this.setEvlFormTitle(evlFormId);
            evlJson = gson.toJson(evlConfigData, List.class);
            HashMap<String, String> cstylesMap = new HashMap<String, String>(16);
            cstylesMap.put("cstyles", "eyJ0eXBlIjowLCJjb250ZW50IjoiJHtwb2ludGVyLWV2ZW50czogbm9uZTt9In0=");
            this.getView().updateControlMetadata("customcontrolap", cstylesMap);
            this.getView().updateControlMetadata("flexpanelap7", cstylesMap);
        } else if (HRStringUtils.equals((String)pageType, (String)"view")) {
            evlConfigData = this.getEvlConfigData(evlFormId);
            this.setEvlFormTitle(evlFormId);
            evlConfigData = this.setResToEvlFormSys(evlId, evlFormId, evlConfigData);
            evlJson = gson.toJson(evlConfigData, List.class);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsubmit", KEY_BTNSAVE, "btncancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"operatepanel", "btnclose"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"flexpanelap7"});
            this.getView().setStatus(OperationStatus.VIEW);
        } else if (HRStringUtils.equals((String)pageType, (String)"edit")) {
            evlConfigData = this.getEvlConfigData(evlFormId);
            this.setEvlFormTitle(evlFormId);
            evlConfigData = this.setResToEvlFormSys(evlId, evlFormId, evlConfigData);
            evlJson = gson.toJson(evlConfigData, List.class);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnclose"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"operatepanel", "btnsubmit", KEY_BTNSAVE, "btncancel"});
            this.getView().setStatus(OperationStatus.EDIT);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("showCloseAndCancel") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btncancel", "btnclose"});
        }
        return evlJson;
    }

    public void setEvlFormTitle(String evlFormId) {
        DynamicObject evlFormData = QuestionnaireHelper.findQuestionnaireById((Object)evlFormId);
        if (evlFormData != null) {
            this.getModel().setValue("evltitle", (Object)evlFormData.getString("name"));
            this.getModel().setValue("evldesc", (Object)evlFormData.getString("description"));
        }
    }

    private String getUrlParam(String attr) {
        Object res = this.getView().getFormShowParameter().getCustomParam(attr);
        return HRObjectUtils.isEmpty((Object)res) ? "" : res + "";
    }

    public List<InspectDimensGroup> getEvlConfigData(String evlId) {
        DynamicObject[] inspects = QuestionnaireHelper.findInspectDimOpByQuestionnaireId((String)evlId);
        ArrayList<InspectDimensGroup> evalForm = new ArrayList<InspectDimensGroup>(inspects.length);
        ArrayList<SubjectGroup> subjects = new ArrayList<SubjectGroup>();
        ArrayList<OptionGroup> options = new ArrayList<OptionGroup>();
        for (DynamicObject inspect : inspects) {
            InspectDimensGroup inspectDimensGroup = new InspectDimensGroup();
            inspectDimensGroup.setId(inspect.getString("id"));
            inspectDimensGroup.setTitle(inspect.getString("name"));
            inspectDimensGroup.setDescription(inspect.getString("description"));
            inspectDimensGroup.setIndex(inspect.getInt("index"));
            DynamicObjectCollection questionentry = inspect.getDynamicObjectCollection("questionentry");
            for (DynamicObject question : questionentry) {
                SubjectGroup subjectGroup = new SubjectGroup();
                subjectGroup.setqId(question.getString("id"));
                subjectGroup.setqTitle(question.getString("questioncontent"));
                subjectGroup.setqDesc(question.getString("questiondesc"));
                subjectGroup.setIsReqComment(Boolean.valueOf(question.getBoolean("requiredcomment")));
                subjectGroup.setIsRequired(Boolean.valueOf(question.getBoolean("required")));
                subjectGroup.setType(((IQuestionHandlerStrategy)QuestionContext.getStrategyMap().get(question.getString("questiontype"))).getQuestionTypeName());
                subjectGroup.setIsHaveComment(Boolean.valueOf(question.getBoolean("enablecomment")));
                subjectGroup.setIndex(question.getInt("seq"));
                DynamicObjectCollection optionsubentry = question.getDynamicObjectCollection("optionsubentry");
                this.addOptionGroup(optionsubentry, options);
                subjectGroup.setItems(options.stream().sorted(Comparator.comparing(OptionGroup::getIndex)).collect(Collectors.toList()));
                options.clear();
                subjects.add(subjectGroup);
            }
            inspectDimensGroup.setContent(subjects.stream().sorted(Comparator.comparing(SubjectGroup::getIndex)).collect(Collectors.toList()));
            subjects.clear();
            evalForm.add(inspectDimensGroup);
        }
        return evalForm.stream().sorted(Comparator.comparing(InspectDimensGroup::getIndex)).collect(Collectors.toList());
    }

    private void addOptionGroup(DynamicObjectCollection optionsubentry, List<OptionGroup> options) {
        for (DynamicObject option : optionsubentry) {
            OptionGroup optionGroup = new OptionGroup();
            optionGroup.setsId(option.getString("id"));
            optionGroup.setName(option.getString("optionname"));
            optionGroup.setIndex(option.getInt("seq"));
            options.add(optionGroup);
        }
    }

    private List<InspectDimensGroup> setResToEvlFormSys(String evlId, String evlFormId, List<InspectDimensGroup> evlConfigData) {
        DynamicObject[] resDatas;
        for (DynamicObject resData : resDatas = IntvevlansHelper.findIntevVlans((String)evlId, (String)evlFormId)) {
            String inspectdimId = resData.getString("inspectdim");
            String inspectquId = resData.getString("inspectqu");
            InspectDimensGroup inspectDimensGroup = evlConfigData.stream().filter(inspectItem -> HRStringUtils.equals((String)inspectItem.getId(), (String)inspectdimId)).findFirst().get();
            SubjectGroup subjectGroup = inspectDimensGroup.getContent().stream().filter(subjectItem -> HRStringUtils.equals((String)subjectItem.getqId(), (String)inspectquId)).findFirst().get();
            String subjectType = subjectGroup.getType();
            this.subjecyTypeHandle(resData, subjectGroup, subjectType);
        }
        return evlConfigData;
    }

    public void subjecyTypeHandle(DynamicObject resData, SubjectGroup subjectGroup, String subjectType) {
        if (HRStringUtils.equals((String)subjectType, (String)"simpleAnswer")) {
            subjectGroup.setSubAnswer(resData.getString("subanswer"));
        } else {
            subjectGroup.setSubComment(resData.getString("comment"));
            String optionId = resData.getString("suboption");
            OptionGroup optionGroup = subjectGroup.getItems().stream().filter(optionItem -> HRStringUtils.equals((String)optionItem.getsId(), (String)optionId)).findFirst().get();
            optionGroup.setChecked(Boolean.TRUE);
        }
    }

    private void save(BeforeDoOperationEventArgs args) {
    }

    private void submit(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String customlabeldata = this.getPageCache().get("customlabeldata");
        Gson gson = new Gson();
        Map evlResData = (Map)gson.fromJson(customlabeldata, Map.class);
        Object intvevlrslt = this.getModel().getValue(INTVEVLRSLT);
        this.visibleHandle(intvevlrslt);
        Boolean intvRes = HRObjectUtils.isEmpty((Object)this.getModel().getValue(INTVEVLRSLT));
        if (!((Boolean)evlResData.get("isTestPass")).booleanValue() || intvRes.booleanValue()) {
            ArrayList<String> dimensArr = new ArrayList<String>();
            dimensArr = this.getDimensArrHandle(evlResData, intvRes, dimensArr);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199%s\u3002", (String)"IntvEvlBaseEdit_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{StringUtils.join(dimensArr, (String)"\u3001")}));
            args.setCancel(true);
            return;
        }
        RefObject afterConfirm = new RefObject();
        if (!operate.getOption().tryGetVariableValue(CONFIRM, afterConfirm)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(KEY_BTNSAVE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u63d0\u4ea4\u540e\u4e0d\u53ef\u4fee\u6539\uff0c\u786e\u8ba4\u63d0\u4ea4\uff1f", (String)"IntvEvlBaseEdit_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            args.setCancel(true);
            return;
        }
    }

    public ArrayList<String> getDimensArrHandle(Map<String, Object> evlResData, Boolean intvRes, ArrayList<String> dimensArr) {
        if (evlResData.get("notFillDimens") != null) {
            dimensArr = (ArrayList)evlResData.get("notFillDimens");
        }
        if (intvRes.booleanValue()) {
            dimensArr.add(ResManager.loadKDString((String)"\u8bc4\u4ef7\u9898\u76ee", (String)"IntvEvlBaseEdit_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
        return dimensArr;
    }

    public void visibleHandle(Object intvevlrslt) {
        if (HRObjectUtils.isEmpty((Object)intvevlrslt)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"intvrsetip"});
        }
    }

    private void opSave(String option, OperateOption operateOption) {
        this.getView().invokeOperation(option, operateOption);
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("customlabeldata", this.getPageCache().get("customlabeldata"));
        return operateOption;
    }
}

