/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvGroupHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.business.domain.workaddress.service.HbssAddressDetailDataHelper;
import kd.tsc.tsrbs.common.enums.SignStatusEnum;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class IntvEvlBillList
extends HRDataBaseList {
    private static final Log log = LogFactory.getLog(IntvEvlBillList.class);
    private static final String COL_PORTRAIT = "portrait";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String intvDataStr = (String)customParams.get("intv_date");
        Long intvTaskId = (Long)customParams.get("intv_task_id");
        String intvTaskStr = (String)customParams.get("taskids");
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Object intverid = customParams.get("intverid");
        Optional.ofNullable(intverid).ifPresent(id -> qFilterList.add(new QFilter("interviewer.id", "in", (Object)Long.valueOf((String)intverid))));
        if (StringUtils.isNotEmpty((CharSequence)intvTaskStr)) {
            List<String> intvTaskStrList = Arrays.asList(intvTaskStr.split(","));
            List intvTaskList = intvTaskStrList.stream().map(Long::valueOf).collect(Collectors.toList());
            qFilterList.add(new QFilter("intvtask.id", "in", intvTaskList));
        }
        Optional.ofNullable(intvDataStr).ifPresent(intvData -> qFilterList.add(new QFilter("intvgroup.intvdate", "=", (Object)IntvDateUtil.parseDateStr((String)intvDataStr, (String)"yyyy-MM-dd HH:mm:ss"))));
        Optional.ofNullable(intvTaskId).ifPresent(intvTask -> qFilterList.add(new QFilter("intvtask.id", "=", intvTask)));
        qFilterList.add(new QFilter("interviewer.id", "=", (Object)UserServiceHelper.getCurrentUserId()));
        Boolean homePageFlag = (Boolean)customParams.get("is_homepage");
        if (homePageFlag != null && homePageFlag.booleanValue()) {
            qFilterList.add(new QFilter("handlestatus", "=", (Object)"A").or(new QFilter("handlestatus", "=", (Object)"B")));
        }
        ArrayList statusList = Lists.newArrayListWithCapacity((int)2);
        statusList.add("C");
        statusList.add("D");
        qFilterList.add(new QFilter("handlestatus", "not in", (Object)statusList));
        qFilterList.add(new QFilter("enable", "=", (Object)"1"));
        e.setCustomQFilters(qFilterList);
        e.setOrderBy("intvgroup.intvdate desc,intvgroup.intvstarttime asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.setCommonFilterColumn(args);
    }

    private FilterContainerInitArgs setCommonFilterColumn(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String cache = this.getPageCache().get(this.getView().getPageId());
        if (StringUtils.isEmpty((CharSequence)cache)) {
            this.getPageCache().put(this.getView().getPageId(), "1");
        } else {
            customParams.clear();
        }
        Long intvTaskId = (Long)customParams.get("intv_task_id");
        if (intvTaskId != null) {
            return args;
        }
        Boolean homePageFlag = (Boolean)customParams.get("is_homepage");
        ArrayList intvTimeRange = (ArrayList)JSONObject.parseObject((String)JSONArray.toJSONString(customParams.get("homeIntvTimeRange")), List.class);
        String intvData = (String)customParams.get("intv_date_code");
        String intvTaskStr = (String)customParams.get("taskids");
        List handleStatusList = (List)customParams.get("handle_status");
        List commonFilterColumnList = args.getCommonFilterColumns();
        commonFilterColumnList.forEach(commonFilterColumn -> {
            if ("handlestatus".equals(commonFilterColumn.getFieldName())) {
                List comboItems = ((CommonFilterColumn)commonFilterColumn).getComboItems();
                comboItems.removeIf(comboItem -> "C".equals(comboItem.getValue()) || "D".equals(comboItem.getValue()));
                if (Objects.nonNull(homePageFlag) && homePageFlag.booleanValue() && !CollectionUtils.isEmpty((Collection)handleStatusList)) {
                    commonFilterColumn.setDefaultValues(handleStatusList.toArray(new Object[handleStatusList.size()]));
                } else if (StringUtils.isEmpty((CharSequence)intvTaskStr)) {
                    commonFilterColumn.setDefaultValue("A");
                }
            }
            if ("intvgroup.intvdate".equals(commonFilterColumn.getFieldName())) {
                if (intvTimeRange != null) {
                    commonFilterColumn.setDefaultValues(intvTimeRange.toArray());
                } else if (StringUtils.isNotEmpty((CharSequence)intvData)) {
                    commonFilterColumn.setDefaultValue(intvData.equals("all") ? null : intvData);
                }
            }
        });
        return args;
    }

    public void packageData(PackageDataEvent evt) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)evt.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = evt.getRowData();
        switch (fieldKey) {
            case "interview_address": {
                this.setHrAddressDetail(evt);
                break;
            }
            case "signinstatus": {
                this.setSignInStatus(evt);
                break;
            }
            case "intvstarttime": {
                this.setIntvStartTime(evt);
                break;
            }
            case "reccategory.name": {
                evt.setFormatValue((Object)ResManager.loadKDString((String)"\u5185\u90e8\u62db\u8058", (String)"IntvEvlBillList_23", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "intvevlrslt": {
                String interviewStatus = rowData.getString("interviewstatus");
                if (!HRStringUtils.equals((String)interviewStatus, (String)"A")) break;
                evt.setFormatValue((Object)"");
            }
        }
    }

    private void setIntvStartTime(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        int intvStartTime = rowData.getInt("intvgroup.intvstarttime");
        String startTime = IntvDateUtil.formatTime((Long)Long.valueOf(intvStartTime), (String)"HH:mm:ss");
        e.setFormatValue((Object)startTime);
    }

    private void setSignInStatus(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        QFilter qFilter = new QFilter("application.id", "=", (Object)rowData.getLong("application.id"));
        qFilter.and(new QFilter("intvgroup.id", "=", (Object)rowData.getLong("intvgroup.id")));
        List appFileTaskList = TsrbsHelper.selectByFilter((String)"id, signinstatus", (QFilter[])qFilter.toArray(), (String)"tsirm_appfiletask");
        if (CollectionUtils.isEmpty((Collection)appFileTaskList)) {
            return;
        }
        e.setFormatValue((Object)this.getSignStatus(((DynamicObject)appFileTaskList.get(0)).getString("signinstatus")));
    }

    private String getSignStatus(String signInStatus) {
        String signStatus = null;
        if (StringUtils.isEmpty((CharSequence)signInStatus)) {
            signInStatus = "A";
        }
        switch (signInStatus) {
            case "A": {
                signStatus = SignStatusEnum.UN_SIGN.getValue();
                break;
            }
            case "B": {
                signStatus = SignStatusEnum.SIGN_COMPLETE.getValue();
                break;
            }
            case "C": {
                signStatus = SignStatusEnum.UN_READY.getValue();
            }
        }
        return signStatus;
    }

    private void setHrAddressDetail(PackageDataEvent packageDataEvent) {
        Long addressDetailId = packageDataEvent.getRowData().getLong("intvgroup.addressdetail_id");
        if (addressDetailId != 0L) {
            DynamicObject addressDetail = HbssAddressDetailDataHelper.getInstance().loadSingle((Object)addressDetailId);
            packageDataEvent.setFormatValue((Object)addressDetail.getString("name"));
        }
    }

    private void setInterviewAddress(PackageDataEvent e) {
        Object[] adminDivisions = IntvGroupHelper.selectAdminDivisionByRoundId((Long)e.getRowData().getLong("round.id"));
        if (ArrayUtils.isNotEmpty((Object[])adminDivisions)) {
            String adminDivision = StringUtils.isEmpty((CharSequence)adminDivisions[0].getString("admindivision")) ? "" : IntervEvalHelper.getAdminDivisionName((String)adminDivisions[0].getString("admindivision"));
            String location = e.getRowData().getString("intvgroup.interviewlocation");
            if (StringUtils.isNotEmpty((CharSequence)adminDivision)) {
                if (StringUtils.isNotEmpty((CharSequence)location)) {
                    e.setFormatValue((Object)adminDivision.concat(location));
                } else {
                    e.setFormatValue((Object)adminDivision);
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        if ("application_name".equals(fieldName)) {
            this.showForm(fieldName, this.getPrimaryKey());
        } else if (COL_PORTRAIT.equals(fieldName)) {
            // empty if block
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        this.showForm("application_name", this.getPrimaryKey());
    }

    private void showForm(String column, Long primaryKey) {
        FormShowParameter showParameter = new FormShowParameter();
        if ("application_name".equals(column)) {
            showParameter.setFormId("tsirm_intvevaltaskir");
            Optional.ofNullable(TsrbsHelper.selectById((Long)primaryKey, (String)"tsirm_intvevl")).ifPresent(intvEvl -> showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u9762\u8bd5\u8bc4\u4ef7-%s", (String)"IntvEvlBillList_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), intvEvl.getString("application.name"))));
            try {
                DynamicObject intvEvl2 = TsrbsHelper.selectById((Long)primaryKey, (String)"tsirm_intvevl");
                if (Objects.isNull(intvEvl2)) {
                    return;
                }
                DynamicObject application = intvEvl2.getDynamicObject("application");
                showParameter.setCustomParam("resume_id", intvEvl2.get("resume"));
                showParameter.setCustomParam("app_id", application.get("id"));
                showParameter.setCustomParam("key_argintv_id", (Object)intvEvl2.getLong("argintv.id"));
                showParameter.setCustomParam("interviewers", (Object)intvEvl2.getLong("interviewer.id"));
                showParameter.setCustomParam("intvTaskId", (Object)intvEvl2.getLong("intvtask.id"));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return;
            }
        } else {
            return;
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }

    private Long getPrimaryKey() {
        IListView listView = (IListView)this.getView();
        ListSelectedRow baseDataListRow = listView.getCurrentSelectedRowInfo();
        return (Long)baseDataListRow.getPrimaryKeyValue();
    }

    public void itemClick(ItemClickEvent evt) {
        IFormView parentView;
        super.itemClick(evt);
        String key = evt.getOperationKey();
        if ("close".equals(key) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null) {
            parentView.close();
            this.getView().sendFormAction(parentView);
        }
    }
}

