/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.intv.service.CancelIntvResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.IntervEvalHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckHelper;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeHelper;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvOperateUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.common.util.IntvPermUtil;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.base.BaseHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.util.CollectionUtils;

public class IntvInfoPlugin
extends HRDynamicFormBasePlugin {
    private static final String UPDATE_REPLY = "33F86+T2GCAY";
    private static final String UPDATE_TOTAL_RESULT = "33F8=CSJ9FSZ";
    private static final String URGE_PERMIT = "1TWAZVNH6QR=";
    private static final String TO_INTV = "33F8ILCQGROS";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"closeevl", "openevl", "agentevl", "writeevl", "operation", "viewevlinfo", "urgeevl"});
        Toolbar scoreToolBar = (Toolbar)this.getView().getControl("toolbarap");
        scoreToolBar.addItemClickListener((ItemClickListener)this);
    }

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String interviewStatus = (String)customParams.get("interviewStatus");
        Long appFileTaskId = (Long)customParams.get("key_appFileTask");
        String intvOrgFrm = (String)customParams.get("intvorgfrm");
        DynamicObject appFileTask = TsrbsHelper.selectById((Long)appFileTaskId, (String)"tsirm_appfiletask");
        if (Objects.isNull(appFileTask)) {
            return;
        }
        List intvEvlInfoList = IntvEvlHelper.getInstance().selectIntvEvaluationByGroupIdAndApplicationId(Long.valueOf(appFileTask.getLong("intvgroup.id")), Long.valueOf(appFileTask.getLong("application.id")));
        List<DynamicObject> sortIntvEvl = intvEvlInfoList.stream().sorted(Comparator.comparing(intvEvl -> intvEvl.getLong("id"))).sorted(Comparator.comparingLong(intvEvl -> intvEvl.getDynamicObject("interviewer").getLong("id"))).collect(Collectors.toList());
        this.setApplication(appFileTask, intvOrgFrm);
        this.buildEvalPanel(sortIntvEvl, interviewStatus);
    }

    private void setPerm() {
        if (!IntvPermUtil.verifyHasPerm((String)"tsirm_appfiletask", (String)"bar_cancelintv", (long)RequestContext.get().getOrgId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancelIntv"});
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getView().setVisible(Boolean.FALSE, new String[]{"openevl"});
    }

    private void setApplication(DynamicObject appFileTask, String intvOrgFrm) {
        DynamicObject appFile = TsrbsHelper.selectById((Long)appFileTask.getLong("application.id"), (String)"tsirm_appfilemdl");
        if (Objects.isNull(appFile)) {
            return;
        }
        DynamicObject appres = appFile.getDynamicObject("appres");
        if (Objects.isNull(appres)) {
            return;
        }
        this.getModel().setValue("appfiletask", (Object)appFileTask);
        String appFileReply = appFileTask.getString("applicationanswer");
        if ("C".equals(appFileReply)) {
            Optional.ofNullable(IntervEvalHelper.getRefuseReason((DynamicObject)appFileTask)).ifPresent(refuseReason -> this.getModel().setValue("refusereason", (Object)"\uff08".concat((String)refuseReason).concat("\uff09")));
        }
        this.getModel().setValue("candidatepicture", (Object)appres.getString("photo"));
        this.getModel().setValue("intvcandate", (Object)appres.getString("fullname"));
        this.getModel().setValue("position", (Object)appFile.getString("position.name"));
        String evlStatus = appFileTask.getString("intvevlstatus");
        String taskStatus = appFileTask.getString("taskstatus");
        this.setIntvResult(evlStatus, taskStatus);
        if (!"A".equals(appFileTask.getString("taskstatus"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
        }
        this.setPerm();
        CancelIntvResultEntity entity = IntvCheckHelper.checkAppFileIntv((Long)appFileTask.getLong("id"));
        if ("C".equals(intvOrgFrm) || !entity.getResult().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"cancelIntv"});
        }
    }

    public void setIntvResult(String intvEvlStatus, String taskStatus) {
        HashMap map = new HashMap(16);
        if ("A".equals(taskStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"processlabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"determinelabel", "nopasslabel", "cancellabel", "passlabel"});
        } else if ("B".equals(taskStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"cancellabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"determinelabel", "nopasslabel", "passlabel", "processlabel"});
        } else if ("A".equals(intvEvlStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"passlabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"determinelabel", "processlabel", "nopasslabel", "cancellabel"});
        } else if ("B".equals(intvEvlStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"nopasslabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"passlabel", "cancellabel", "determinelabel", "processlabel"});
        } else if ("C".equals(intvEvlStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"determinelabel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"passlabel", "nopasslabel", "cancellabel", "processlabel"});
        } else {
            return;
        }
        this.getView().updateControlMetadata("intvresult", map);
    }

    private void buildEvalPanel(List<DynamicObject> intvEvlInfoList, String interviewStatus) {
        if (CollectionUtils.isEmpty(intvEvlInfoList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"intvevlflex", "closeevl"});
        }
        CardEntry cardEntry = (CardEntry)this.getView().getControl("entryentity");
        this.getModel().deleteEntryData("entryentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < intvEvlInfoList.size(); ++i) {
            this.doBuildEvaluationPanel(vs, cardEntry, intvEvlInfoList.get(i), interviewStatus, i, intvEvlInfoList.size() - 1);
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
    }

    private void doBuildEvaluationPanel(TableValueSetter vs, CardEntry cardEntry, DynamicObject evaluation, String interviewStatus, int rowIndex, int endIndex) {
        this.setChildHideByEvaluationStatus(cardEntry, evaluation, interviewStatus, rowIndex, endIndex);
        this.setEveryRowData(vs, evaluation, rowIndex);
    }

    private void setChildHideByEvaluationStatus(CardEntry cardEntry, DynamicObject evaluation, String interviewStatus, int rowIndex, int endIndex) {
        String keyEvl;
        boolean isInterviewer;
        String taskStatus;
        DynamicObject intvGroup;
        DynamicObject intvtask = evaluation.getDynamicObject("appfiletask");
        if (!IntvPermUtil.verifyHasPerm((String)"tsirm_appfiletask", (String)"bar_list_urgeevl", (long)RequestContext.get().getOrgId())) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"urgeevl"});
        }
        if (Objects.nonNull(intvGroup = evaluation.getDynamicObject("intvgroup")) && !IntvDateUtil.intvTimeIsBeforeNow((Date)intvGroup.getDate("intvdate"), (Long)intvGroup.getLong("intvstarttime")).booleanValue()) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"urgeevl"});
        }
        if (Objects.nonNull(intvtask) && !"A".equals(taskStatus = intvtask.getString("taskstatus"))) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"urgeevl", "writeevl", "agentevl"});
        }
        String status = evaluation.getString("interviewstatus");
        String handleStatus = evaluation.getString("handlestatus");
        DynamicObject interviewer = evaluation.getDynamicObject("interviewer");
        String intvResult = evaluation.getString("intvevlrslt");
        if ("A".equals(handleStatus)) {
            isInterviewer = interviewer.getPkValue().equals(TSCRequestContext.getUserId());
            String string = keyEvl = !isInterviewer ? "writeevl" : "agentevl";
            if ("agentevl".equals(keyEvl)) {
                cardEntry.setChildVisible(false, rowIndex, new String[]{"urgeevl"});
            }
            cardEntry.setChildVisible(false, rowIndex, new String[]{keyEvl, "evlinfopanelap", "viewevlinfo", "evlcardentry"});
        } else {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"writeevl", "agentevl", "urgeevl"});
        }
        if ("A".equals(status)) {
            isInterviewer = interviewer.getPkValue().equals(TSCRequestContext.getUserId());
            keyEvl = !isInterviewer ? "writeevl" : "agentevl";
            cardEntry.setChildVisible(false, rowIndex, new String[]{keyEvl, "evlinfopanelap", "viewevlinfo", "evlcardentry"});
        } else if ("B".equals(status)) {
            cardEntry.setChildVisible(false, rowIndex, "left_brackets,interviewevaluator,agentevlendlabel,right_brackets".split(","));
        } else if ("C".equals(interviewStatus)) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"evlinfopanelap", "cardentryflexpanelap"});
        }
        this.cardIntvEvlStatusHandle(status, handleStatus, intvResult, cardEntry, rowIndex);
        if (StringUtils.isEmpty((CharSequence)evaluation.getString("interviewcontent"))) {
            cardEntry.setChildVisible(false, rowIndex, new String[]{"labelap6"});
        }
    }

    private void cardIntvEvlStatusHandle(String intverStaus, String handleStatus, String intvResult, CardEntry cardEntry, int rowIndex) {
        if ("A".equals(handleStatus) || "A".equals(intverStaus)) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"card_notevl"});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"card_determine", "card_nopass", "card_pass"});
        } else if ("A".equals(intvResult)) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"card_pass"});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"card_determine", "card_nopass", "card_notevl"});
        } else if ("B".equals(intvResult)) {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"card_nopass"});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"card_notevl", "card_pass", "card_determine"});
        } else {
            cardEntry.setChildVisible(true, rowIndex, new String[]{"card_determine"});
            cardEntry.setChildVisible(false, rowIndex, new String[]{"card_notevl", "card_pass", "card_nopass"});
        }
    }

    private void setEveryRowData(TableValueSetter vs, DynamicObject evaluation, int rowIndex) {
        DynamicObject interviewer = evaluation.getDynamicObject("interviewer");
        String status = evaluation.getString("interviewstatus");
        long evlId = evaluation.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)evaluation.getLong("round.id"));
        List intvRoundList = TsrbsHelper.selectByFilter((String)"roundid, interviewevl", (QFilter[])qFilter.toArray(), (String)"tsirm_intvroundtpl");
        if (!CollectionUtils.isEmpty((Collection)intvRoundList)) {
            vs.set("evltableid", (Object)((DynamicObject)intvRoundList.get(0)).getLong("interviewevl"), rowIndex);
        }
        vs.set("evaluation", (Object)evaluation, rowIndex);
        vs.set("evlid", (Object)evlId, rowIndex);
        vs.set("pkvalue", evaluation.getPkValue(), rowIndex);
        vs.set("interviewer", (Object)interviewer.getString("name"), rowIndex);
        if ("B".equals(status) || "C".equals(status)) {
            String evaluationAt = HRDateTimeUtils.format((Date)evaluation.getDate("interviewevaluationtime"), (String)"yyyy-MM-dd HH:mm");
            vs.set("interviewevaluationtime", (Object)evaluationAt, rowIndex);
            vs.set("interviewcontent", evaluation.get("interviewcontent"), rowIndex);
        }
        if ("C".equals(status)) {
            vs.set("interviewevaluator", (Object)evaluation.getDynamicObject("interviewevaluator").getString("name"), rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        FormShowParameter showParameter = this.getShowParameter();
        String pageId = (String)this.getView().getFormShowParameter().getCustomParam("pageId");
        showParameter.setCustomParam("pageId", (Object)pageId);
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject intvEvl = this.getModel().getEntryRowEntity("entryentity", index);
        long currUserId = RequestContext.get().getCurrUserId();
        switch (operate.getOperateKey()) {
            case "modifysignstatus": {
                this.modifySignStatus(showParameter);
                break;
            }
            case "modifyreply": {
                boolean b = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)UPDATE_REPLY);
                if (!b) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\"\u9762\u8bd5\u7ba1\u7406\"\u7684\"\u4fee\u6539\u7b54\u590d\u72b6\u6001\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntervEvalBasePlugin_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.modifyReply(showParameter);
                break;
            }
            case "modifytotalresult": {
                if (!PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)UPDATE_TOTAL_RESULT)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\"\u9762\u8bd5\u7ba1\u7406\"\u7684\"\u4fee\u6539\u603b\u7ed3\u679c\"\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntervEvalBasePlugin_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.modifyTotalResult(showParameter);
                break;
            }
            case "viewevlinfo": {
                if (!PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)"47150e89000000ac")) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u67e5\u770b\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntvInfoPlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.viewEvlInfoHandle(intvEvl);
                break;
            }
            case "urgeevl": {
                if (!PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)URGE_PERMIT)) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u50ac\u4fc3\u8bc4\u4ef7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrgePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.urgEvlHandle(intvEvl);
                break;
            }
            case "agentevl": {
                this.evlHandle(intvEvl, "tsirm_intvevl_agent");
                break;
            }
            case "writeevl": {
                this.evlHandle(intvEvl, "tsirm_intvevl");
                break;
            }
            default: {
                return;
            }
        }
    }

    private FormShowParameter getShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        OpenStyle openStyle = showParameter.getOpenStyle();
        showParameter.setCustomParam("appfiletask", this.getView().getFormShowParameter().getCustomParam("key_appFileTask"));
        Optional.ofNullable(openStyle).ifPresent(style -> style.setShowType(ShowType.Modal));
        return showParameter;
    }

    private void modifyTotalResult(FormShowParameter showParameter) {
        if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"mod_total_result").booleanValue()) {
            return;
        }
        Long taskId = (Long)showParameter.getCustomParam("appfiletask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(taskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        showParameter.setFormId("tsirm_modifytotalresult");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "totalResult"));
        this.getView().showForm(showParameter);
    }

    private void modifyReply(FormShowParameter showParameter) {
        if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"mod_reply_stat").booleanValue()) {
            return;
        }
        Long taskId = (Long)showParameter.getCustomParam("appfiletask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(taskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        showParameter.setFormId("tsirm_modifyreply");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "reply"));
        this.getView().showForm(showParameter);
    }

    private void modifySignStatus(FormShowParameter showParameter) {
        Long taskId = (Long)showParameter.getCustomParam("appfiletask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(taskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        showParameter.setFormId("tsirm_modifysignstatus");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "signinstatus"));
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("closeevl".equals(key)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"closeevl"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"openevl"});
        } else if ("openevl".equals(key)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap5"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"openevl"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"closeevl"});
        }
    }

    private void evlHandle(DynamicObject intvEvl, String evlForm) {
        long currUserId;
        boolean b;
        if ("tsirm_intvevl_agent".equals(evlForm) && !(b = PermissionServiceHelper.checkPermission((Long)(currUserId = RequestContext.get().getCurrUserId()), (String)"tsirm", (String)"tsirm_appfiletask", (String)TO_INTV))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u4ee3\u8bc4\u4ef7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IntvInfoPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long appFileTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("key_appFileTask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(appFileTaskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("writeevl");
        Pair flag = IntervEvalHelper.selectIntvStateByPk((String)intvEvl.getString("evlid"));
        if (!((Boolean)flag.getLeft()).booleanValue() && ((Boolean)flag.getRight()).booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u5df2\u7ed3\u675f,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c", (String)"IntvTemplatePlugin_15", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        if (!((Boolean)flag.getLeft()).booleanValue() && !((Boolean)flag.getRight()).booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u9762\u8bd5\u4efb\u52a1\u5df2\u88ab\u8bc4\u4ef7,\u4e0d\u80fd\u91cd\u590d\u64cd\u4f5c\u3002", (String)"IntvTemplatePlugin_4", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return;
        }
        this.showIntvEvlPage(intvEvl.getString("evlid"), intvEvl.getString("evltableid"), "edit", ((Object)((Object)this)).getClass().getName(), this.getView(), null, evlForm);
    }

    private void urgEvlHandle(DynamicObject intvEvl) {
        if (!IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"urge_evl").booleanValue()) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Long appFileTaskId = (Long)customParams.get("key_appFileTask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(appFileTaskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        DynamicObject intvEvlById = BaseHelper.selectById((Long)intvEvl.getLong("evlid"), (String)"tsirm_intvevl");
        DynamicObject intvtask = intvEvlById.getDynamicObject("intvtask");
        IntvUrgeResultEntity entity = IntvUrgeHelper.urgeIntvevl(Collections.singletonList(appFileTaskId), (DynamicObject)intvtask);
        this.resultHandle(entity);
    }

    private void viewEvlInfoHandle(DynamicObject intvEvl) {
        Long appFileTaskId = (Long)this.getView().getFormShowParameter().getCustomParam("key_appFileTask");
        if (!IntvJurisdictionService.getInstance().isHasIntvJur(appFileTaskId, "appfiletask").booleanValue()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u9762\u8bd5\u5b89\u6392\u8be6\u60c5\u9875\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"IntvInfoPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        QuestionnaireHelper.showTsirmIntvEvlPage((String)intvEvl.getString("evlid"), (String)intvEvl.getString("evltableid"), (String)"view", (String)((Object)((Object)this)).getClass().getName(), (IFormView)this.getView(), null, (String)"tsirm_intvevl");
    }

    public void resultHandle(IntvUrgeResultEntity entity) {
        if (entity.isUtgeCheckRes()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u4fc3\u6210\u529f", (String)"IntvInfoPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification((String)entity.showMessages.get(0));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Boolean returnFlag;
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
        if ("evlFormSubmit".equals(closedCallBackEvent.getActionId())) {
            Map returnMap = (Map)closedCallBackEvent.getReturnData();
            if (!CollectionUtils.isEmpty((Map)returnMap) && ((Boolean)returnMap.get("change")).booleanValue()) {
                this.refreshParentView();
            }
        } else if ("totalResult".equals(closedCallBackEvent.getActionId()) && Objects.nonNull(returnFlag = (Boolean)closedCallBackEvent.getReturnData()) && returnFlag.booleanValue()) {
            this.refreshParentView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("urgeevl".equals(messageBoxClosedEvent.getCallBackId()) || "writeevl".equals(messageBoxClosedEvent.getCallBackId())) {
            this.refreshParentView();
        }
    }

    private void refreshParentView() {
        IFormView argView = this.getView().getParentView().getParentView();
        argView.invokeOperation("refresh");
        this.getView().sendFormAction(argView);
    }

    private void showIntvEvlPage(String evlId, String evlFormId, String sourceType, String classFullName, IFormView view, Object previewData, String evlForm) {
        String pageId = (String)view.getFormShowParameter().getCustomParam("pageId");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(evlForm);
        showParameter.setPkId((Object)evlId);
        showParameter.setCustomParam("evlId", (Object)evlId);
        showParameter.setCustomParam("evlFormId", (Object)evlFormId);
        showParameter.setCustomParam("sourceType", (Object)sourceType);
        showParameter.setCustomParam("previewData", previewData);
        showParameter.setCustomParam("pageId", (Object)pageId);
        if (HRStringUtils.isNotEmpty((String)classFullName)) {
            showParameter.setCloseCallBack(new CloseCallBack(classFullName, "evlFormSubmit"));
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm((FormShowParameter)showParameter);
    }
}

