/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvEvlHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.AiConfigHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvmail.IntvVariableInfoHelper;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsirm.formplugin.web.intv.service.InterviewerService;
import kd.tsc.tsrbd.business.domain.intv.service.questionnaire.QuestionnaireHelper;
import org.apache.commons.lang3.ObjectUtils;

public class IntvTaskDetailIRFormPlugin
extends HRDynamicFormBasePlugin {
    private static final Log log = LogFactory.getLog(IntvTaskDetailIRFormPlugin.class);
    public static final String INTERVIEWARRANGERORGID = "INTERVIEWARRANGERORGID_";
    public static final String FLEXPANELAP = "flexpanelap";
    private static final String AI_HIGHLIGHT_FLEX = "aihighlightflex";
    private static final String AI_QUESTION_FLEX = "aiquestionflex";
    private static final String INTV_FLEX = "intvflex";
    private static final String INTV_TABLE_FLEX = "intvtableflex";
    private static final String INTERVIEWER_QUESTION_CUSTOM_KEY = "interviewerquestion";
    private static final String RESUME_LIGHT_CONCERN_CUSTOM_KEY = "resumesummary";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"applypositionflex"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (HRStringUtils.equals((String)itemKey, (String)"tblrefresh")) {
            this.getView().updateView();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        InterviewerService.getInstance().showPosition(this.getView(), evt, "intv");
    }

    public void afterCreateNewData(EventObject e) {
        Optional.of(this.getResumeAndAppFile()).ifPresent(resumeAndAppFile -> {
            long appFileId = null != resumeAndAppFile.get("appFile") ? ((DynamicObject)resumeAndAppFile.get("appFile")).getLong("id") : 0L;
            DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
            InterviewerService.getInstance().setHeadValue(this.getView(), appFile);
        });
    }

    public void afterBindData(EventObject eObj) {
        Optional.of(this.getResumeAndAppFile()).ifPresent(resumeAndAppFile -> {
            long userMainOrgId;
            Object arrangeId;
            Long intvtaskId;
            boolean b;
            long appFileId = null != resumeAndAppFile.get("appFile") ? ((DynamicObject)resumeAndAppFile.get("appFile")).getLong("id") : 0L;
            DynamicObject bosUser = (DynamicObject)resumeAndAppFile.get("inteviewer");
            long inteviewer = 0L;
            if (null != bosUser) {
                inteviewer = bosUser.getLong("id");
            }
            if (!(b = this.handleCurrentUserHasIntvTask(appFileId, inteviewer))) {
                return;
            }
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
            if (!resumeAndAppFile.containsKey("intvTaskId")) {
                DynamicObject[] intvEvls;
                intvtaskId = (Long)this.getView().getFormShowParameter().getCustomParam("intvTaskId");
                if (intvtaskId == null && (intvEvls = IntvEvlHelper.getInstance().getIntvEvls(new QFilter("application", "=", (Object)appFileId))) != null && intvEvls.length > 0) {
                    DynamicObject obj = Arrays.stream(intvEvls).filter(intvevl -> intvevl.getDynamicObject("intvtask").getLong("enable") == 1L).findFirst().orElse(null);
                    intvtaskId = obj == null ? 0L : obj.getLong("intvtask.id");
                }
            } else {
                intvtaskId = ((DynamicObject)resumeAndAppFile.get("intvTaskId")).getLong("id");
            }
            if ((arrangeId = this.getView().getFormShowParameter().getCustomParam("key_argintv_id")) instanceof Number && Long.parseLong(arrangeId.toString()) != 0L) {
                DynamicObject intvDataEntiry = ArgIntvHelper.getInstance().getIntvDataEntiry(Long.valueOf(Long.parseLong(arrangeId.toString())));
                long arrangeIntId = intvDataEntiry.getLong("interviewarranger.id");
                userMainOrgId = UserServiceHelper.getUserMainOrgId((long)arrangeIntId);
            } else {
                userMainOrgId = 0L;
            }
            log.info("IntvTaskDetailIRFormPlugin.afterBindData userMainOrgId : {} intvtaskId : {}", (Object)userMainOrgId, (Object)intvtaskId);
            this.getView().getPageCache().put("appFileId", String.valueOf(appFileId));
            this.getView().getPageCache().put("intvTaskId", String.valueOf(intvtaskId));
            this.getView().getPageCache().saveChanges();
            IAppCache appCache = AppCache.get((String)"interviewQuesition");
            appCache.put("beforeAppFileId", (Object)appFileId);
            this.setTablePage((DynamicObject)resumeAndAppFile.get("resume"), (DynamicObject)resumeAndAppFile.get("appFile"));
            DynamicObject[] intvArray = IntvEvlHelper.getInstance().getIntvEvls(new QFilter("intvtask", "=", (Object)intvtaskId));
            if (null != intvArray && intvArray.length > 0) {
                DynamicObject intv = intvArray[0];
                long intvId = intv.getLong("id");
                String interviewStatus = intv.getString("interviewstatus");
                String handleStatus = intv.getString("handlestatus");
                long roundId = intv.getLong("round.id");
                HRBaseServiceHelper intvroundServiceHelper = new HRBaseServiceHelper("tsirm_intvround");
                QFilter entryIdFilter = new QFilter("roundid", "=", (Object)roundId);
                DynamicObject intvRoundDt = (DynamicObject)intvroundServiceHelper.queryOriginalCollection("interviewevl,interviewtheme.name", entryIdFilter.toArray()).get(0);
                Optional.ofNullable(intvRoundDt).ifPresent(round -> {
                    String handleType;
                    long interviewEvl = intvRoundDt.getLong("interviewevl");
                    if ("A".equals(handleStatus) && "A".equals(interviewStatus)) {
                        handleType = "edit";
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"intvtable"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"intvdetail"});
                    } else {
                        handleType = "view";
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"intvtable"});
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"intvdetail"});
                    }
                    String intvType = intvRoundDt.getString("interviewtheme.name");
                    Label label = (Label)this.getControl("intvtype");
                    label.setText(intvType);
                    long groupId = intv.getLong("intvgroup.id");
                    DynamicObject intvTask = TsrbsHelper.selectById((Long)groupId, (String)"tsirm_intvgroup");
                    Optional.ofNullable(intvTask).ifPresent(this::setIntvAddressAndTime);
                    QuestionnaireHelper.showTsirmIntvEvlPageInModel((String)String.valueOf(intvId), (String)String.valueOf(interviewEvl), (String)handleType, (String)((Object)((Object)this)).getClass().getName(), (IFormView)this.getView(), null, (String)"tsirm_intvevl", (String)INTV_TABLE_FLEX);
                    DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
                    InterviewerService.getInstance().setHeadValue(this.getView(), appFile);
                    if ("view".equals(handleType)) {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"intvresultflex"});
                        String intvResult = intv.getString("intvevlrslt");
                        String interviewContent = intv.getString("interviewcontent");
                        if ("A".equals(intvResult)) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pass"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"notpass", "delay"});
                        } else if ("B".equals(intvResult)) {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"notpass"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pass", "delay"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"delay"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"notpass", "pass"});
                        }
                        if (HRStringUtils.isBlank((CharSequence)interviewContent)) {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"intvresulttextflex"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"intvresulttextflex"});
                            Label resultLabel = (Label)this.getControl("intvresult");
                            resultLabel.setText(interviewContent);
                        }
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"timeaddressflex", AI_QUESTION_FLEX});
                    } else {
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"timeaddressflex"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"intvresultflex"});
                    }
                    this.showAIInfo(appFile, handleType);
                });
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("newQuestion".equals(callBackId) && MessageBoxResult.Yes.getValue() == result.getValue()) {
            IAppCache appCache = AppCache.get((String)"interviewQuesition");
            Long appFileId = (Long)appCache.get("beforeAppFileId", Long.class);
            DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
            AppFileHelper.cleanInterviewerQuestion((DynamicObject)appFile);
            InterviewerService.getInstance().setInterviewQuestionForAgain((IFormPlugin)this, this.getView(), INTERVIEWER_QUESTION_CUSTOM_KEY, appFileId);
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventArgs = e.getEventArgs();
        String key = e.getKey();
        if (!INTERVIEWER_QUESTION_CUSTOM_KEY.equals(key)) {
            return;
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)eventArgs, Map.class);
        InterviewerService.getInstance().dealCustomEvent((IFormPlugin)this, this.getView(), INTERVIEWER_QUESTION_CUSTOM_KEY, map);
    }

    private void showAIInfo(DynamicObject appFile, String type) {
        if (!AiConfigHelper.getInstance().getIfOpen("interviewerairesume") && AiConfigHelper.getInstance().getIfOpen("intervieweraiquestion")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{AI_HIGHLIGHT_FLEX, AI_QUESTION_FLEX});
            return;
        }
        String aiQuestion = appFile.getString("interviewerquestion_tag");
        String light = appFile.getString("talenthighlight_tag");
        String concern = appFile.getString("talentconcern_tag");
        DynamicObjectCollection lightLabelCollection = appFile.getDynamicObjectCollection("talenthighlightlabel");
        DynamicObjectCollection concernLabelCollection = appFile.getDynamicObjectCollection("talentconcernlabel");
        boolean lightOrConcernLabelEmpty = HRStringUtils.isNotEmpty((String)light) || HRStringUtils.isNotEmpty((String)concern) || !CollectionUtils.isEmpty((Collection)lightLabelCollection) || !CollectionUtils.isEmpty((Collection)concernLabelCollection);
        this.getView().setVisible(Boolean.valueOf(AiConfigHelper.getInstance().getIfOpen("interviewerairesume") && lightOrConcernLabelEmpty), new String[]{AI_HIGHLIGHT_FLEX});
        this.getView().setVisible(Boolean.valueOf(AiConfigHelper.getInstance().getIfOpen("intervieweraiquestion")), new String[]{AI_QUESTION_FLEX});
        InterviewerService.getInstance().setInterviewerQuestionForOpenView(this.getView(), INTERVIEWER_QUESTION_CUSTOM_KEY, aiQuestion, type);
        InterviewerService.getInstance().showResumeConcernAndLight(this.getView(), RESUME_LIGHT_CONCERN_CUSTOM_KEY, concern, concernLabelCollection, light, lightLabelCollection);
    }

    private void setIntvAddressAndTime(DynamicObject group) {
        String intvAddress;
        DynamicObject addressDetail = group.getDynamicObject("addressdetail");
        String room = group.getString("interviewroom");
        if (!Objects.isNull(addressDetail)) {
            String detailaddr = addressDetail.getString("detailaddr.name");
            intvAddress = IntvVariableInfoHelper.handel((String)detailaddr) + IntvVariableInfoHelper.handel((String)room);
        } else {
            intvAddress = group.containsProperty("intvervedioaddress") ? group.getString("intvervedioaddress") : "";
        }
        Label addressLabel = (Label)this.getControl("intvaddress");
        addressLabel.setText(intvAddress);
        Date intvDate = group.getDate("intvdate");
        long intvStartTime = group.getLong("intvstarttime");
        Date intvDateTime = IntvDateUtil.getIntvDateTime((Date)intvDate, (Long)intvStartTime);
        String intvTime = HRInteDateTimeUtil.formatDate((String)"tsirm_appfiletask", (String)"intvtime", (Date)intvDateTime);
        Label intvTimeLabel = (Label)this.getControl("intvtime");
        intvTimeLabel.setText(intvTime);
    }

    public Map<String, DynamicObject> getResumeAndAppFile() {
        DynamicObject appFile;
        DynamicObject resume;
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        AtomicReference<Long> resumeId = new AtomicReference<Long>();
        AtomicReference<Long> appFileId = new AtomicReference<Long>();
        AtomicReference interviewTaskId = new AtomicReference();
        List<Object> interViewIdList = Lists.newArrayListWithCapacity((int)2);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (null == taskId) {
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("resume_id")).ifPresent(resumeIdObj -> resumeId.set(resumeIdObj instanceof Long ? (Long)resumeIdObj : Long.parseLong(resumeIdObj.toString())));
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("app_id")).ifPresent(appFileIdObj -> appFileId.set(appFileIdObj instanceof Long ? (Long)appFileIdObj : Long.parseLong(appFileIdObj.toString())));
            Object objInterviews = this.getView().getFormShowParameter().getCustomParam("interviewers");
            if (ObjectUtils.isNotEmpty((Object)objInterviews)) {
                interViewIdList = Arrays.stream(objInterviews.toString().split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList());
            }
            Optional.ofNullable(this.getView().getFormShowParameter().getCustomParam("interviewtaskid")).ifPresent(interviewTaskIdObj -> interviewTaskId.set(interviewTaskIdObj instanceof Long ? (Long)interviewTaskIdObj : Long.parseLong(interviewTaskIdObj.toString())));
        } else {
            AtomicReference<Long> businessKey = new AtomicReference<Long>(0L);
            Optional.ofNullable(WfUtils.getWfService().getTaskService().getHistoricTask(taskId)).ifPresent(historicTask -> businessKey.set(Long.valueOf(historicTask.getBusinessKey())));
            try {
                DynamicObjectCollection selectIntvEvlList = ArgIntvHelper.selectIntvEvlByTaskId((Long)businessKey.get(), this.getSelectColumnList());
                DynamicObject intvEvl = (DynamicObject)selectIntvEvlList.get(0);
                resumeId.set(intvEvl.getLong("resume"));
                appFileId.set(intvEvl.getLong("application"));
                interViewIdList.add(intvEvl.getLong("interviewer"));
                map.put("intvTaskId", intvEvl.getDynamicObject("intvtask"));
            }
            catch (Exception e) {
                log.error((Throwable)e);
                return Collections.emptyMap();
            }
        }
        log.info("IntvTaskDetailIRFormPlugin.getResumeAndAppFile resume : {} appFile : {}", resumeId.get(), appFileId.get());
        try {
            resume = ArgIntvHelper.selectById((Long)((Long)resumeId.get()), (String)"tsirm_srrsm");
        }
        catch (Exception ex) {
            log.error("IntvTaskDetailIRFormPlugin.getResumeAndAppFile resume error", (Throwable)ex);
            resume = null;
        }
        try {
            appFile = ArgIntvHelper.selectById((Long)((Long)appFileId.get()), (String)"tsirm_appfilemdl");
        }
        catch (Exception ex) {
            log.error("IntvTaskDetailIRFormPlugin.getResumeAndAppFile appFile error", (Throwable)ex);
            appFile = null;
        }
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = TsrbsHelper.selectById((Long)((Long)interViewIdList.get(0)), (String)"bos_user");
        }
        catch (Exception e) {
            log.error("IntvTaskDetailIRFormPlugin.getResumeAndAppFile bos_user error", (Throwable)e);
        }
        DynamicObject interviewTask = null;
        try {
            interviewTask = TsrbsHelper.selectById((Long)((Long)interviewTaskId.get()), (String)"tsirm_intvtask");
        }
        catch (Exception e) {
            log.error("IntvTaskDetailIRFormPlugin.getResumeAndAppFile interview task error", (Throwable)e);
        }
        map.put("resume", resume);
        map.put("appFile", appFile);
        map.put("interviewtask", interviewTask);
        if (dynamicObject != null) {
            map.put("inteviewer", dynamicObject);
        }
        return map;
    }

    private List<String> getSelectColumnList() {
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.add("id");
        columnList.add("resume");
        columnList.add("application");
        columnList.add("interviewer");
        return columnList;
    }

    private void setTablePage(DynamicObject resume, DynamicObject appFile) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tab_resume");
        this.setTableEval(appFile);
        BaseShowParameter baseShowParameter = this.setResumeTable(appFile);
        this.getView().getPageCache().put("tsirm_srrsm_layout", baseShowParameter.getPageId());
        this.getView().getPageCache().saveChanges();
    }

    private void setTableEval(DynamicObject appFile) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_assessmentinhir");
        showParameter.setCustomParam("applicationid", null == appFile ? null : appFile.getString("id"));
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("tab_eval");
        this.getView().showForm(showParameter);
        this.getView().getPageCache().put("tsirm_assessmentinhir", showParameter.getPageId());
        this.getView().getPageCache().saveChanges();
    }

    private BaseShowParameter setResumeTable(DynamicObject appFile) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId("tsirm_srrsm_layout");
        showParameter.setCustomParam("pagestatussign", (Object)"see");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setSendToClient(true);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("tab_resume");
        long appresId = appFile.getDynamicObject("appres").getLong("id");
        showParameter.setPkId((Object)appresId);
        this.getView().showForm((FormShowParameter)showParameter);
        return showParameter;
    }

    private void initAppFileHead(Long appFileId, Long taskId) {
        FormShowParameter appFileHeadShowParameter = new FormShowParameter();
        appFileHeadShowParameter.setCustomParam("appFileId", (Object)appFileId);
        appFileHeadShowParameter.setCustomParam("id", (Object)appFileId);
        appFileHeadShowParameter.setCustomParam("page_type", (Object)"1");
        appFileHeadShowParameter.setCustomParam("fromView", (Object)"intv");
        appFileHeadShowParameter.setCustomParam("taskId", (Object)taskId);
        appFileHeadShowParameter.setFormId("tsirm_head_template");
        appFileHeadShowParameter.setStatus(OperationStatus.VIEW);
        appFileHeadShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        appFileHeadShowParameter.setSendToClient(true);
        appFileHeadShowParameter.getOpenStyle().setTargetKey(FLEXPANELAP);
        Long arrangeIntId = (Long)this.getView().getFormShowParameter().getCustomParam("key_argintv_id");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String userMainOrgId = (String)cache.get(INTERVIEWARRANGERORGID + arrangeIntId);
        if (HRStringUtils.isNotEmpty((String)userMainOrgId)) {
            appFileHeadShowParameter.setCustomParam("useorg", (Object)Long.valueOf(userMainOrgId));
        }
        this.getView().showForm(appFileHeadShowParameter);
        this.getView().getPageCache().put("tsirm_intvevaltaskirappFileId", appFileHeadShowParameter.getPageId());
    }

    private boolean handleCurrentUserHasIntvTask(long appFileId, long inteviewer) {
        if (inteviewer != RequestContext.get().getCurrUserId()) {
            log.error(String.format("current user %d and reviewer %d not equals", RequestContext.get().getCurrUserId(), inteviewer));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13", "flexpanelap12"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
            return false;
        }
        QFilter qFilter = new QFilter("interviewer", "=", (Object)RequestContext.get().getCurrUserId());
        qFilter.and("application", "=", (Object)appFileId);
        List dynamicObjects = TsrbsHelper.selectByFilter((QFilter[])new QFilter[]{qFilter}, (String)"tsirm_intvevl");
        if (ObjectUtils.isEmpty((Object)dynamicObjects)) {
            log.error(String.format("current user %d and reviewer %d  and appfile %d equals,but can not get info from db", RequestContext.get().getCurrUserId(), inteviewer, appFileId));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap13", "flexpanelap12"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap2"});
            return false;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap13", "flexpanelap12"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap2"});
        return true;
    }

    private void showInterviewEvl(Long intvPkId) {
    }
}

