/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.business.domain.intv.service.jurisdiction.IntvJurisdictionService;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeHelper;
import kd.tsc.tsirm.business.domain.intv.service.urge.IntvUrgeResultEntity;
import kd.tsc.tsirm.business.domain.intv.service.util.IntvOperateUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import org.springframework.util.CollectionUtils;

public class UrgePlugin
extends HRCoreBaseBillEdit {
    private static final String URGE_PERMIT = "1TWAZVNH6QR=";
    private static final String URGE_REPLY = "1TWDZNJSE41K";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (operate.getOperateKey().contains("urgeevl") && !IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"urge_evl").booleanValue()) {
            return;
        }
        if (operate.getOperateKey().contains("urgereply") && !IntvOperateUtils.invokeOperate((IFormView)this.getView(), (String)"urge_reply").booleanValue()) {
            return;
        }
        if ("bar_list_urgeevl".equals(operate.getOperateKey()) || "bar_list_urgereply".equals(operate.getOperateKey())) {
            this.listHandle(operate.getOperateKey());
        } else if ("bar_urgeevl".equals(operate.getOperateKey()) || "bar_urgereply".equals(operate.getOperateKey())) {
            if ("bar_urgeevl".equals(operate.getOperateKey())) {
                long currUserId = RequestContext.get().getCurrUserId();
                boolean b = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)URGE_PERMIT);
                if (!b) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u50ac\u4fc3\u8bc4\u4ef7\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrgePlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                long currUserId = RequestContext.get().getCurrUserId();
                boolean b = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"tsirm", (String)"tsirm_appfiletask", (String)URGE_REPLY);
                if (!b) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u50ac\u4fc3\u7b54\u590d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UrgePlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            this.barHandle(operate.getOperateKey());
        }
    }

    private void barHandle(String itemKey) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject argIntv = dataEntity.getDynamicObject("argintv");
        Long argId = argIntv.getLong("id");
        QFilter qFilter = new QFilter("argintv.id", "=", (Object)argId);
        List appFileTaskList = TsrbsHelper.selectByFilter((QFilter[])qFilter.toArray(), (String)"tsirm_appfiletask");
        if (CollectionUtils.isEmpty((Collection)appFileTaskList)) {
            return;
        }
        List appFileTaskIdList = appFileTaskList.stream().map(appFile -> appFile.getLong("id")).collect(Collectors.toList());
        for (Long aLong : appFileTaskIdList) {
            if (IntvJurisdictionService.getInstance().isHasIntvJur(aLong, "appfiletask").booleanValue()) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"UrgePlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        IntvUrgeResultEntity entity = "bar_urgeevl".equals(itemKey) ? IntvUrgeHelper.urgeIntvevl(appFileTaskIdList, null) : IntvUrgeHelper.urgeAppAnswer(appFileTaskIdList);
        this.resultHandle(entity, itemKey);
    }

    public void listHandle(String itemKey) {
        ListView listView = (ListView)this.getView();
        ListSelectedRowCollection selectedRowList = listView.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRowList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u5c11\u50ac\u4fc31\u4eba", (String)"UrgePlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRowList.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6bcf\u6b21\u6700\u591a\u50ac\u4fc3100\u4eba", (String)"UrgePlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            return;
        }
        List appFileTaskIdList = selectedRowList.stream().map(selectedRow -> (Long)selectedRow.getPrimaryKeyValue()).collect(Collectors.toList());
        for (Long aLong : appFileTaskIdList) {
            if (IntvJurisdictionService.getInstance().isHasIntvJur(aLong, "appfiletask").booleanValue()) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u201c\u5019\u9009\u4eba\u9762\u8bd5\u5217\u8868\u201d\u67e5\u8be2\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762", (String)"UrgePlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return;
        }
        IntvUrgeResultEntity entity = "bar_list_urgeevl".equals(itemKey) ? IntvUrgeHelper.urgeIntvevl(appFileTaskIdList, null) : IntvUrgeHelper.urgeAppAnswer(appFileTaskIdList);
        this.resultHandle(entity, itemKey);
    }

    public void resultHandle(IntvUrgeResultEntity entity, String itemKey) {
        if (entity.isUtgeCheckRes()) {
            if (entity.showMessages.isEmpty()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u4fc3\u6210\u529f", (String)"UrgePlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else if ("bar_list_urgeevl".equals(itemKey) || "bar_urgeevl".equals(itemKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u4fc3\u6210\u529f\uff0c\u81ea\u52a8\u8df3\u8fc7\u5df2\u50ac\u4fc3\u6216\u5df2\u8bc4\u4ef7\u7684\u9762\u8bd5\u5b98", (String)"UrgePlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u50ac\u4fc3\u6210\u529f\uff0c\u81ea\u52a8\u8df3\u8fc7\u5df2\u50ac\u4fc3\u6216\u5df2\u7b54\u590d\u7684\u5019\u9009\u4eba", (String)"UrgePlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        } else {
            this.showFailMessage(entity.getShowTitileMessage(), entity.showMessages);
        }
    }

    private void showFailMessage(String showTitleMessage, List<String> messageList) {
        if (!CollectionUtils.isEmpty(messageList) && messageList.size() == 1) {
            this.getView().showTipNotification(messageList.get(0));
            return;
        }
        FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)showTitleMessage, messageList, (boolean)false);
        this.getView().showForm(formShowParameter);
    }
}

