/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.arrangeintv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tsc.tsirm.common.entity.intv.AppFileUser;
import kd.tsc.tsirm.common.entity.intv.GroupAppfileUser;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.IntvCommonFun;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.PageCacheUtil;
import org.apache.commons.collections.MapUtils;

public class IntvMultiHeader
extends HRCoreBaseBillEdit {
    public static final String MORE_APP_FILE_HEADER = "more_app_file_header";
    public static final String BTN_MORE_HEADER = "moreheader";
    public static final String BTN_DEL_HEADER = "delvectorap";
    public static final String KEY_PROPERTY_NAME = "name";
    public static final String KEY_APPFILEID = "appfileid";
    public static final String KEY_PICTUREFIELD = "picturefield";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{BTN_MORE_HEADER, BTN_DEL_HEADER});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        IFormView mainView = this.getView().getParentView();
        switch (key) {
            case "moreheader": {
                this.showMoreHeader(mainView);
                break;
            }
            case "delvectorap": {
                this.deleteOneHeader(mainView);
                break;
            }
        }
    }

    private void deleteOneHeader(IFormView mainView) {
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        List<AppFileUser> linkedList = IntvCommonFun.INSTANCE.getAppFileUsers(mainView);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
        long row = ((DynamicObject)entry.get(selectRows[0])).getLong(KEY_APPFILEID);
        boolean flag = IntvCommonFun.INSTANCE.deleteHeaderValidator(this.getView(), mainView, Lists.newArrayList((Object[])new Long[]{row}));
        if (flag) {
            return;
        }
        assert (linkedList != null);
        linkedList.removeIf(next -> next.getAppFileId().equals(row));
        this.getModel().deleteEntryRow("entryentity", selectRows[0]);
        IntvCommonFun.INSTANCE.setAppFileUser(this.getView().getParentView(), linkedList);
        IPageCache pageCache = mainView.getPageCache();
        ArrayList appFileIds = Lists.newArrayList((Object[])new Long[]{row});
        pageCache.put("groupAppresIds", appFileIds.toString());
        this.getView().updateView();
        String intvFormType = this.getView().getParentView().getPageCache().get("intv_form_type");
        if ("B".equals(intvFormType)) {
            this.updateGroup(Lists.newArrayList((Object[])new Long[]{row}));
        } else {
            this.updateGroup();
        }
    }

    private void showMoreHeader(IFormView mainView) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("tsirm_intvheadermore");
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5019\u9009\u4eba", (String)"IntvMultiHeader_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MORE_APP_FILE_HEADER));
        this.getView().showForm(formShowParameter);
    }

    public void beforeBindData(EventObject evt) {
        int count;
        super.beforeBindData(evt);
        IDataModel model = this.getModel();
        IFormView mainView = this.getView().getParentView();
        model.deleteEntryData("entryentity");
        List<AppFileUser> linkedList = IntvCommonFun.INSTANCE.getAppFileUsers(mainView);
        long longValue = PageCacheUtil.INSTANCE.getLongValue("groupAppresId", mainView);
        boolean delFlag = linkedList.removeIf(next -> next.getAppFileId().equals(longValue));
        if (delFlag) {
            IntvCommonFun.INSTANCE.setAppFileUser(mainView, linkedList);
        }
        if ((count = Math.min(linkedList.size(), 20)) > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", count);
            for (int index = 0; index < count; ++index) {
                this.getModel().setValue(KEY_PICTUREFIELD, (Object)linkedList.get(index).getPhoto(), index);
                this.getModel().setValue(KEY_PROPERTY_NAME, (Object)linkedList.get(index).getName(), index);
                this.getModel().setValue(KEY_APPFILEID, (Object)linkedList.get(index).getAppFileId(), index);
            }
        }
        Label lblAppFileSize = (Label)this.getControl(BTN_MORE_HEADER);
        lblAppFileSize.setText(ResManager.loadKDString((String)"{0}\u540d\u5019\u9009\u4eba", (String)"IntvMultiHeader_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{linkedList.size()}));
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (MapUtils.isNotEmpty((Map)customParams)) {
            int index = (Integer)customParams.get("isAddNew");
            if (index == 1) {
                String[] delEle = new String[]{BTN_DEL_HEADER};
                IntvCommonFun.INSTANCE.hiddenEntryEle(this.getView(), "entryentity", delEle);
            } else if (linkedList.size() <= 2) {
                cardEntry.setChildVisible(false, 0, new String[]{BTN_DEL_HEADER});
                cardEntry.setChildVisible(false, 1, new String[]{BTN_DEL_HEADER});
            } else {
                cardEntry.setChildVisible(true, 0, new String[]{BTN_DEL_HEADER});
                cardEntry.setChildVisible(true, 1, new String[]{BTN_DEL_HEADER});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (MORE_APP_FILE_HEADER.equals(actionId)) {
            this.getView().updateView();
            String intvFormType = this.getView().getParentView().getPageCache().get("intv_form_type");
            if (HRStringUtils.isNotEmpty((String)intvFormType)) {
                if ("B".equals(intvFormType)) {
                    List<Long> delIds = IntvCommonFun.INSTANCE.getIds(this.getView(), "delHeaderIds");
                    this.updateGroup(delIds);
                    delIds.clear();
                    IntvCommonFun.INSTANCE.setIds(this.getView(), "delHeaderIds", delIds);
                } else {
                    this.updateGroup();
                }
            }
        }
    }

    private void updateGroup(List<Long> row) {
        IFormView opView = this.getView();
        IFormView mainView = this.getView().getParentView();
        String group_form = mainView.getPageCache().get("group_form_page_id");
        if (HRStringUtils.isNotEmpty((String)group_form)) {
            IFormView groupView = this.getView().getView(group_form);
            List<GroupAppfileUser> groupAppFileUser = IntvCommonFun.INSTANCE.getGroupAppFileUser(groupView);
            for (GroupAppfileUser groupAppfileUser : groupAppFileUser) {
                LinkedList headerList = groupAppfileUser.getAppfileUserForGroup();
                headerList.removeIf(next -> row.contains(next.getAppFileId()));
            }
            IntvCommonFun.INSTANCE.setGroupAppFileUser(groupView, groupAppFileUser);
            IntvCommonFun.setGroupInfoByGroupAppFileUserList(groupAppFileUser, groupView.getModel(), groupView);
            IntvCommonFun.hideGroupHeader(groupView);
            opView.sendFormAction(groupView);
        }
    }

    private void updateGroup() {
        IFormView opView = this.getView();
        IFormView mainView = this.getView().getParentView();
        String group_form = mainView.getPageCache().get("group_form_page_id");
        IFormView view = opView.getView(group_form);
        view.updateView();
        opView.sendFormAction(view);
    }
}

