/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.arrangeintv;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.common.entity.intv.AppFileUser;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.IntvCommonFun;
import kd.tsc.tsirm.formplugin.web.intv.arrangeintv.PageCacheUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;

public class IntvMultiHeaderMore
extends AbstractListPlugin {
    public static final String DEL_HEADER_IDS = "delHeaderIds";
    public static final String DEL_APP_FILE_IDS = "del_appFile_ids";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"delvectorap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.equals("delvectorap")) {
            this.deleteOneHeader();
        }
    }

    private void deleteOneHeader() {
        String str;
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int[] selectRows = cardEntry.getSelectRows();
        IFormView mainView = this.getView().getParentView().getParentView();
        List<AppFileUser> linkedList = IntvCommonFun.INSTANCE.getAppFileUsers(mainView);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity");
        long row = ((DynamicObject)entry.get(selectRows[0])).getLong("appfileid");
        boolean flag = IntvCommonFun.INSTANCE.deleteHeaderValidator(this.getView(), mainView, Lists.newArrayList((Object[])new Long[]{row}));
        if (flag) {
            return;
        }
        String string = mainView.getModel().getDataEntity().getString("intvorgfrm");
        if ("B".equals(string) && HRStringUtils.isNotEmpty((String)(str = mainView.getPageCache().get("group_form_page_id"))) && this.doDelete(row, str)) {
            return;
        }
        linkedList.removeIf(next -> next.getAppFileId().equals(row));
        this.getModel().deleteEntryRow("entryentity", selectRows[0]);
        IntvCommonFun.hideDeleteLabel(linkedList, this.getView(), "entryentity", "delvectorap");
        IntvCommonFun.INSTANCE.setAppFileUser(mainView, linkedList);
        IFormView parentView = this.getView().getParentView();
        List<Long> delHeaderIds = IntvCommonFun.INSTANCE.getIds(parentView, DEL_HEADER_IDS);
        delHeaderIds.add(row);
        IntvCommonFun.INSTANCE.setIds(parentView, DEL_HEADER_IDS, delHeaderIds);
    }

    private boolean doDelete(long row, String str) {
        DynamicObjectCollection dynamicObjectCollection = ((DynamicObject)this.getView().getView(str).getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(0)).getDynamicObjectCollection("subentryentity");
        List<List<Long>> groupModel = this.getGroupModel(dynamicObjectCollection);
        for (List<Long> longs : groupModel) {
            Iterator<Long> iterator = longs.iterator();
            List<Long> cacheDelIds = PageCacheUtil.INSTANCE.get1(this.getView(), DEL_APP_FILE_IDS);
            if (CollectionUtils.isNotEmpty(cacheDelIds)) {
                while (iterator.hasNext()) {
                    Long next = iterator.next();
                    if (!cacheDelIds.contains(next)) continue;
                    iterator.remove();
                }
            }
            if (!longs.contains(row)) continue;
            if (longs.size() <= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5019\u9009\u4eba\u4e3a\u5c0f\u7ec4\u5185\u552f\u4e00\u7684\u5019\u9009\u4eba\uff0c\u4e0d\u53ef\u5220\u9664", (String)"IntvMultiHeaderMore_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return true;
            }
            PageCacheUtil.INSTANCE.add(this.getView(), DEL_APP_FILE_IDS, row);
            break;
        }
        return false;
    }

    @NotNull
    private List<List<Long>> getGroupModel(DynamicObjectCollection dynamicObjectCollection) {
        ArrayList groupModel = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            ArrayList oneGroup = Lists.newArrayListWithCapacity((int)10);
            for (int i = 0; i < 20; ++i) {
                long aLong = dynamicObject.getLong("groupappresid" + i);
                if (aLong == 0L) continue;
                oneGroup.add(aLong);
            }
            groupModel.add(oneGroup);
        }
        return groupModel;
    }

    public void afterCreateNewData(EventObject evt) {
        IFormView mainView = this.getView().getParentView().getParentView();
        List<AppFileUser> linkedList = IntvCommonFun.INSTANCE.getAppFileUsers(mainView);
        int count = linkedList.size();
        if (count > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", count);
            for (int i = 0; i < count; ++i) {
                this.getModel().setValue("picturefield", (Object)linkedList.get(i).getPhoto(), i);
                this.getModel().setValue("name", (Object)linkedList.get(i).getName(), i);
                this.getModel().setValue("appfileid", (Object)linkedList.get(i).getAppFileId(), i);
            }
        }
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        IFormView mainView = this.getView().getParentView().getParentView();
        int isAddNew = PageCacheUtil.INSTANCE.getIntValue("isAddNew", mainView);
        if (isAddNew == 1) {
            IntvCommonFun.INSTANCE.hiddenEntryEle(this.getView(), "entryentity", new String[]{"delvectorap"});
        } else {
            IntvCommonFun.hideDeleteLabel(IntvCommonFun.INSTANCE.getAppFileUsers(mainView), this.getView(), "entryentity", "delvectorap");
        }
    }
}

