/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.arrangeintv;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class PageCacheUtil {
    public static final Log log = LogFactory.getLog(PageCacheUtil.class);
    public static final PageCacheUtil INSTANCE = new PageCacheUtil();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public int getIntValue(String cacheKey, IFormView view) {
        String strCache = view.getPageCache().get(cacheKey);
        String intCache = Optional.ofNullable(strCache).orElse("-1");
        return Integer.parseInt(intCache);
    }

    public long getLongValue(String cacheKey, IFormView view) {
        String strCache = view.getPageCache().get(cacheKey);
        String intCache = Optional.ofNullable(strCache).orElse("-1");
        return Long.parseLong(intCache);
    }

    public void setIntValue(String cacheKey, int value, IFormView view) {
        view.getPageCache().put(cacheKey, String.valueOf(value));
    }

    public Map<String, Object> get(IFormView view, String key) throws KDException {
        try {
            return PageCacheUtil.json2map(view.getPageCache().get(key));
        }
        catch (Exception e) {
            ErrorCode errorCode = new ErrorCode("int parse json", e.getMessage());
            throw new KDException(errorCode, new Object[0]);
        }
    }

    public void put(IFormView view, String key, Object value) throws JsonProcessingException {
        view.getPageCache().put(key, PageCacheUtil.obj2json(value));
    }

    public void add(IFormView view, String key, long value) {
        String ids = view.getPageCache().get(key);
        try {
            List delIds = HRStringUtils.isNotEmpty((String)ids) ? (List)HRJSONUtils.cast((String)ids, List.class, (Class[])new Class[]{Long.class}) : Lists.newArrayListWithCapacity((int)10);
            delIds.add(value);
            view.getPageCache().put(key, HRJSONUtils.toString((Object)delIds));
        }
        catch (IOException e) {
            log.info("", (Object)e);
        }
    }

    public List<Long> get1(IFormView view, String key) {
        String ids = view.getPageCache().get(key);
        if (HRStringUtils.isEmpty((String)ids)) {
            return Collections.emptyList();
        }
        List delIds = null;
        try {
            delIds = (List)HRJSONUtils.cast((String)ids, List.class, (Class[])new Class[]{Long.class});
        }
        catch (IOException e) {
            log.info("get del ids error", (Object)e);
        }
        return delIds;
    }

    public static String obj2json(Object obj) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString(obj);
    }

    public static Map<String, Object> json2map(String jsonString) throws KDException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            return (Map)mapper.readValue(jsonString, Map.class);
        }
        catch (JsonProcessingException e) {
            ErrorCode errorCode = new ErrorCode("int parse json", e.getMessage());
            throw new KDException(errorCode, new Object[0]);
        }
    }
}

