/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.calendar;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.appfile.AppFileOpHelper;
import kd.tsc.tsirm.business.domain.intv.service.calendar.SetAbleInterviewTimeFormHelper;
import kd.tsc.tsirm.common.util.IntvPermUtil;
import kd.tsc.tsrbd.common.enums.InterviewTimeWayEnum;
import kd.tsc.tsrbs.common.utils.PageUtils;

public class SetAbleInterviewTimeEdit
extends HRDataBaseEdit {
    private static final Log log = LogFactory.getLog(SetAbleInterviewTimeEdit.class);
    private static final SetAbleInterviewTimeFormHelper HELPER = SetAbleInterviewTimeFormHelper.getInstance();

    public void preOpenForm(PreOpenFormEventArgs evt) {
        super.preOpenForm(evt);
        HELPER.setTitle(evt);
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"confirmap", "arrangeintvap", "closeap", "cancelap"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        String key = ((Control)source).getKey();
        if (HRStringUtils.equals((String)key, (String)"confirmap")) {
            HELPER.setCustomData("customEvtName", "submit", this.getView());
        } else if (HRStringUtils.equals((String)key, (String)"arrangeintvap")) {
            this.handArrangeInterview(this.getView());
            IFormView parentView = PageUtils.getParentView((IFormView)this.getView());
            if (parentView != null && "tsirm_filterfeedbackpop".equals(parentView.getFormShowParameter().getFormId())) {
                parentView.close();
                this.getView().sendFormAction(parentView);
            }
            this.getView().close();
        } else if (HRStringUtils.equals((String)key, (String)"closeap") || HRStringUtils.equals((String)key, (String)"cancelap")) {
            this.getView().close();
        }
    }

    private void handArrangeInterview(IFormView view) {
        Map customParams = view.getFormShowParameter().getCustomParams();
        Object obj = customParams.get("appFileId");
        String sVal = String.valueOf(obj);
        List appFileIds = Lists.newArrayList();
        try {
            appFileIds = (List)HRJSONUtils.cast((String)sVal, List.class, (Class[])new Class[]{Long.class});
        }
        catch (IOException evt) {
            log.error("set interview time parse appFile param error: ", (Throwable)evt);
        }
        log.info("appFileId: {}", (Object)appFileIds);
        AppFileOpHelper.showFormArrangeInterview((List)appFileIds, (AbstractFormPlugin)this);
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        HELPER.saveOpenParamToCache(this.getView());
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        Object pageState = formShowParameter.getCustomParams().get("pageState");
        if (InterviewTimeWayEnum.ENTRANCE_HOMPAGE.getPageStatus().equals(String.valueOf(pageState)) && formShowParameter.getStatus() == OperationStatus.VIEW || !IntvPermUtil.verifyHasPerm((String)"tsirm_appfile_view", (String)"arrangeintvap", (long)RequestContext.get().getOrgId())) {
            view.setVisible(Boolean.TRUE, new String[]{"closeap"});
            view.setVisible(Boolean.FALSE, new String[]{"confirmap"});
            view.setVisible(Boolean.FALSE, new String[]{"arrangeintvap"});
        } else if (status == OperationStatus.VIEW) {
            view.setVisible(Boolean.FALSE, new String[]{"cancelap"});
            view.setVisible(Boolean.FALSE, new String[]{"confirmap"});
            view.setVisible(Boolean.TRUE, new String[]{"arrangeintvap"});
        } else {
            view.setVisible(Boolean.TRUE, new String[]{"cancelap"});
            view.setVisible(Boolean.TRUE, new String[]{"confirmap"});
            view.setVisible(Boolean.FALSE, new String[]{"arrangeintvap"});
        }
    }

    public void customEvent(CustomEventArgs evt) {
        super.customEvent(evt);
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        switch (eventName) {
            case "getIntvData": {
                HELPER.renderJsonData(eventArgs, this.getView());
                break;
            }
            case "setIntvData": {
                HELPER.setJsonValueToObj(eventArgs, this.getModel().getDataEntity(true), this.getView());
                break;
            }
        }
    }
}

