/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.interveranswer;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ArgIntvHelper;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.GroupEntity;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerHelper;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerStateEntity;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InteRverAnswerGroupPlugin
extends HRDynamicFormBasePlugin
implements CellClickListener {
    private static final Log logger = LogFactory.getLog(InteRverAnswerGroupPlugin.class);
    private DynamicObject[] intvevlInfos;

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"flexbutton"});
        this.addClickListeners(new String[]{"groupiconup", "groupicondown", "grouplableup", "grouplabledown"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("appfileentryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent arg0) {
        if (arg0.getFieldKey().equals("operationfield")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_intvevaltaskir");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("resume_id", this.getModel().getValue("resumefield", arg0.getRow()));
            paramMap.put("app_id", this.getModel().getValue("appfileid", arg0.getRow()));
            String cacheEntity = this.getView().getPageCache().get(this.getView().getPageId() + "_group");
            if (HRStringUtils.isNotEmpty((String)cacheEntity)) {
                GroupEntity groupEntity = (GroupEntity)SerializationUtils.fromJsonString((String)cacheEntity, GroupEntity.class);
                DynamicObject intvTask = IntvTaskHelper.getInstance().getIntvTask(new QFilter("id", "=", (Object)groupEntity.getIntvTaskId()));
                if (null != intvTask) {
                    paramMap.put("interviewers", intvTask.getLong("interviewer.id"));
                }
            }
            formShowParameter.setCustomParams(paramMap);
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_intvevaltaskir"));
            this.getView().showForm(formShowParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void showRefresBox() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_cancle", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"InteRverAnswerGroupPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult().getValue() == 6) {
            IFormView argView = this.getView().getParentView();
            argView.invokeOperation("refresh");
            this.getView().sendFormAction(argView);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        boolean checkTaskCheck;
        String itemKey = evt.getItemKey();
        String cacheEntity = this.getView().getPageCache().get(this.getView().getPageId() + "_group");
        GroupEntity groupObj = new GroupEntity();
        if (HRStringUtils.isNotEmpty((String)cacheEntity)) {
            groupObj = (GroupEntity)SerializationUtils.fromJsonString((String)cacheEntity, GroupEntity.class);
        }
        if (null == this.intvevlInfos || this.intvevlInfos.length == 0) {
            this.intvevlInfos = InteRverAnswerHelper.getIntvevlInfos((GroupEntity)groupObj);
        }
        if (!(checkTaskCheck = InteRverAnswerHelper.checkAnswerState((GroupEntity)groupObj, (DynamicObject[])this.intvevlInfos))) {
            this.showRefresBox();
            return;
        }
        String answerResult = "";
        if (itemKey.equals("btnagree") || itemKey.equals("btnmodify_agree")) {
            Boolean checkRverAnswerAgreeState = InteRverAnswerHelper.checkRverAnswerAgreeState((GroupEntity)groupObj, (DynamicObject[])this.intvevlInfos);
            if (checkRverAnswerAgreeState.booleanValue()) {
                ArrayList<GroupEntity> groupObjs = new ArrayList<GroupEntity>();
                groupObjs.add(groupObj);
                InteRverAnswerHelper.rverAnswerAgree(groupObjs);
                this.initStatesAndButtons(groupObj);
                answerResult = ResManager.loadKDString((String)"\u63a5\u53d7", (String)"InteRverAnswerGroupPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            }
        } else if (itemKey.equals("btnrefuse") || itemKey.equals("btnmodify_refuse")) {
            Boolean checkRverAnswerRefuseState = InteRverAnswerHelper.checkRverAnswerRefuseState((GroupEntity)groupObj, (DynamicObject[])this.intvevlInfos);
            if (checkRverAnswerRefuseState.booleanValue()) {
                ArrayList<GroupEntity> groupObjs = new ArrayList<GroupEntity>();
                groupObjs.add(groupObj);
                InteRverAnswerHelper.rverAnswerRefuse(groupObjs);
                this.initStatesAndButtons(groupObj);
                answerResult = ResManager.loadKDString((String)"\u62d2\u7edd", (String)"InteRverAnswerGroupPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            }
        } else if (itemKey.equals("btntransfer") || itemKey.equals("btnmodify_transfer")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_intvanstransfer");
            ArrayList<GroupEntity> groups = new ArrayList<GroupEntity>();
            groups.add(groupObj);
            formShowParameter.setCustomParam("group", groups);
            formShowParameter.setCustomParam("transferType", (Object)"one");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_interveranswergroup"));
            this.getView().showForm(formShowParameter);
        }
        if (HRStringUtils.isBlank((CharSequence)answerResult)) {
            return;
        }
        if (itemKey.equals("btnrefuse") || itemKey.equals("btnmodify_refuse") || itemKey.equals("btnagree") || itemKey.equals("btnmodify_agree")) {
            this.sendMessageToHR(answerResult);
        }
    }

    private void sendMessageToHR(String answerResult) {
        if (HRStringUtils.isBlank((CharSequence)answerResult)) {
            return;
        }
        MessageInfo messageInfo = new MessageInfo();
        String interviewerName = RequestContext.get().getUserName();
        String entity = this.getView().getPageCache().get(this.getView().getPageId() + "_group");
        if (HRStringUtils.isBlank((CharSequence)entity)) {
            return;
        }
        GroupEntity groupEntity = (GroupEntity)SerializationUtils.fromJsonString((String)entity, GroupEntity.class);
        if (null == groupEntity.getArgintvId()) {
            return;
        }
        DynamicObject argIntv = ArgIntvHelper.getInstance().getArgIntv(new QFilter("id", "=", (Object)groupEntity.getArgintvId()));
        if (null == argIntv) {
            return;
        }
        String interviewTitle = argIntv.getString("interviewtitle");
        long receiverId = argIntv.getDynamicObject("interviewarranger").getLong("id");
        messageInfo.setUserIds((List)Lists.newArrayList((Object[])new Long[]{receiverId}));
        messageInfo.setTag(ResManager.loadKDString((String)"\u5185\u90e8\u62db\u8058", (String)"InterRverAnswerGroupPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        List applicationIds = groupEntity.getAppLicationIds();
        Pair positionAndStage = AppFileHelper.getPositionAndStageByAppFileId((Long)((Long)applicationIds.get(0)));
        String clientUrl = UrlService.getDomainContextUrl();
        String url = clientUrl + "/?formId=tsirm_argintv&pkId=" + argIntv.getLong("id") + "&type=base&position=" + positionAndStage.getLeft() + "&recrustg=" + positionAndStage.getRight() + "&status=VIEW";
        String content = ResManager.loadKDString((String)"{0}{1}\u4e86\u60a8\u5b89\u6392\u7684{2}\u3002", (String)"InterRverAnswerGroupPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{interviewerName, answerResult, interviewTitle});
        String title = ResManager.loadKDString((String)"{0}{1}\u4e86\u60a8\u5b89\u6392\u7684{2}\u3002", (String)"InterRverAnswerGroupPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[]{interviewerName, answerResult, interviewTitle});
        messageInfo.setContentUrl(url);
        messageInfo.setContent(content);
        messageInfo.setTitle(title);
        messageInfo.setEntityNumber("tsirm_argintv");
        messageInfo.setSenderId(Long.valueOf(RequestContext.get().getCurrUserId()));
        messageInfo.setBizDataId(Long.valueOf(argIntv.getLong("id")));
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null && "tsirm_interveranswergroup".equals(closedCallBackEvent.getActionId())) {
            String answerResult = ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"InteRverAnswerGroupPlugin_14", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.sendMessageToHR(answerResult);
            this.getView().invokeOperation("refresh");
        }
    }

    public void click(EventObject evt) {
        Control sControl = (Control)evt.getSource();
        String key = sControl.getKey();
        if (key.equals("groupiconup") || key.equals("groupicondown") || key.equals("grouplableup") || key.equals("grouplabledown")) {
            this.setGorupCandidateUpDown(key);
        }
    }

    private void setGorupCandidateUpDown(String key) {
        if ("groupiconup".contains(key) || "grouplableup".contains(key)) {
            this.setGorupCandidateUp();
        } else if ("groupicondown".contains(key) || "grouplabledown".contains(key)) {
            this.setGorupCandidateDown();
        }
    }

    private void setGorupCandidateUp() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexgroupcandidate"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupiconup", "grouplableup"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"groupicondown", "grouplabledown"});
    }

    private void setGorupCandidateDown() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexgroupcandidate"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"groupiconup", "grouplableup"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupicondown", "grouplabledown"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.initGroupInfo();
    }

    private void initGroupInfo() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("group") != null) {
            GroupEntity groupObj = new GroupEntity();
            if (params.get("group").getClass().getName().contains(GroupEntity.class.getName())) {
                groupObj = (GroupEntity)params.get("group");
            } else {
                JSONObject groupJsonObj = JSONObject.parseObject((String)params.get("group").toString());
                groupObj = (GroupEntity)groupJsonObj.toJavaObject(GroupEntity.class);
            }
            this.getView().getPageCache().put(this.getView().getPageId() + "_group", SerializationUtils.toJsonString((Object)groupObj));
            this.initGroupLableInfo(groupObj);
            this.initAppFileList(groupObj);
            this.initStatesAndButtons(groupObj);
        }
        if (params.get("index") != null) {
            Integer index = Integer.valueOf(params.get("index").toString());
            this.initGorupCandidateUpDown(index);
        }
    }

    private void initStatesAndButtons(GroupEntity groupObj) {
        if (null == this.intvevlInfos || this.intvevlInfos.length == 0) {
            this.intvevlInfos = InteRverAnswerHelper.getIntvevlInfos((GroupEntity)groupObj);
        }
        InteRverAnswerStateEntity groupStates = InteRverAnswerHelper.getGroupStates((GroupEntity)groupObj, (DynamicObject[])this.intvevlInfos);
        String inteRverAnswerState = groupStates.getInteRverAnswerState();
        String taskState = groupStates.getTaskState();
        boolean isIntvevl = groupStates.isIntvevl();
        Boolean checkIntvelDate = IntvDateUtil.intvTimeIsBeforeNow((Date)groupObj.getIntvDateTypeDate(), (Long)groupObj.getIntvStartTimeTypeLong());
        if (checkIntvelDate.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexbutton"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltaskstate"});
            return;
        }
        if (!isIntvevl && "A".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnagree", "btnrefuse", "btntransfer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblrveranswerstate", "lbltaskstate", "btnmodify"});
        } else if (isIntvevl && "A".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnagree", "btnrefuse"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblrveranswerstate", "lbltaskstate", "btnmodify", "btntransfer"});
        } else if (!isIntvevl && "B".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmodify", "lblrveranswerstate", "btnmodify_refuse", "btnmodify_transfer"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltaskstate", "btnagree", "btnrefuse", "btntransfer", "btnmodify_agree"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
        } else if (isIntvevl && "B".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmodify_refuse", "btnmodify", "lblrveranswerstate"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltaskstate", "btnagree", "btntransfer", "btnmodify_transfer", "btnmodify_agree", "btnrefuse"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
        } else if (!isIntvevl && "C".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmodify_agree", "btnmodify_transfer", "btnmodify"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltaskstate", "btnagree", "btntransfer", "btnrefuse", "btnmodify_refuse"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblrveranswerstate"});
        } else if (isIntvevl && "C".equals(inteRverAnswerState) && "A".equals(taskState)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmodify_agree"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
            this.getView().setVisible(Boolean.FALSE, new String[]{"lbltaskstate", "btnagree", "btntransfer", "btnrefuse", "btnmodify_refuse", "btnmodify_transfer"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnmodify_agree", "btnmodify_transfer", "btnmodify", "lblrveranswerstate"});
        } else if (!"A".equals(taskState)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexbutton"});
            this.setStateTextByCode("rveranswerstate", inteRverAnswerState);
            this.setStateTextByCode("taskstate", taskState);
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblrveranswerstate", "lbltaskstate"});
            if (taskState.equals("C")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"operationfield"});
            }
            if (taskState.equals("D")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"operationfield"});
                String rverAnswerState = this.setStateTextByCode("rveranswerstate", taskState) + ":" + groupObj.getPassPersonName();
                Label label = (Label)this.getControl("lblrveranswerstate");
                label.setText(rverAnswerState);
                HashMap<String, Integer> ctrl = new HashMap<String, Integer>();
                ctrl.put("w", 0);
                this.getView().updateControlMetadata("lblrveranswerstate", ctrl);
            }
        }
    }

    private String setStateTextByCode(String stateType, String stateValue) {
        String stateText = "";
        HashMap<String, String> ctrl = new HashMap<String, String>();
        if (stateType.equals("rveranswerstate")) {
            switch (stateValue) {
                case "A": {
                    stateText = ResManager.loadKDString((String)"\u672a\u7b54\u590d", (String)"InteRverAnswerGroupPlugin_10", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#D9D9D9");
                    break;
                }
                case "B": {
                    stateText = ResManager.loadKDString((String)"\u63a5\u53d7", (String)"InteRverAnswerGroupPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#1BA854");
                    break;
                }
                case "C": {
                    stateText = ResManager.loadKDString((String)"\u62d2\u7edd", (String)"InteRverAnswerGroupPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#FB2323");
                    break;
                }
                case "D": {
                    stateText = ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"InteRverAnswerGroupPlugin_11", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#16B0F1");
                    break;
                }
                default: {
                    stateText = ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"InteRverAnswerGroupPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    logger.error("rveranswer state  data Error!");
                }
            }
            this.setLabel("lblrveranswerstate", stateText);
            this.getView().updateControlMetadata("lblrveranswerstate", ctrl);
        } else if (stateType.equals("taskstate")) {
            switch (stateValue) {
                case "A": {
                    stateText = ResManager.loadKDString((String)"\u672a\u5b8c\u6210", (String)"InteRverAnswerGroupPlugin_5", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#ffffff");
                    ctrl.put("bc", "#D9D9D9");
                    break;
                }
                case "B": {
                    stateText = ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"InteRverAnswerGroupPlugin_6", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#ffffff");
                    ctrl.put("bc", "#1BA854");
                    break;
                }
                case "C": {
                    stateText = ResManager.loadKDString((String)"\u5df2\u53d6\u6d88", (String)"InteRverAnswerGroupPlugin_7", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#ffffff");
                    ctrl.put("bc", "#D9D9D9");
                    break;
                }
                case "D": {
                    stateText = ResManager.loadKDString((String)"\u5df2\u8f6c\u4ea4", (String)"InteRverAnswerGroupPlugin_8", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    ctrl.put("fc", "#ffffff");
                    ctrl.put("bc", "#16B0F1");
                    break;
                }
                default: {
                    stateText = ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"InteRverAnswerGroupPlugin_9", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                    logger.error("intv task state data Error!");
                }
            }
            this.setLabel("lbltaskstate", stateText);
            this.getView().updateControlMetadata("lbltaskstate", ctrl);
        }
        return stateText;
    }

    private void initAppFileList(GroupEntity groupObj) {
        List appFileIds = groupObj.getAppLicationIds();
        this.intvevlInfos = InteRverAnswerHelper.getIntvevlInfos((GroupEntity)groupObj);
        ArgIntvHelper argHelp = new ArgIntvHelper();
        DynamicObject[] appFiles = argHelp.getAppFileAllFields(appFileIds);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[0]);
        setter.addField("appfileid", new Object[0]);
        setter.addField("resumefield", new Object[0]);
        setter.addField("namefield", new Object[0]);
        setter.addField("positionfield", new Object[0]);
        setter.addField("sexfield", new Object[0]);
        setter.addField("educationfield", new Object[0]);
        setter.addField("schoolfield", new Object[0]);
        setter.addField("specialfield", new Object[0]);
        setter.addField("workyearfield", new Object[0]);
        setter.addField("operationfield", new Object[0]);
        for (int i = 0; i < appFiles.length; ++i) {
            String appfileid = appFiles[i].getString("id");
            DynamicObject appResObj = appFiles[i].getDynamicObject("appres");
            DynamicObject appPosition = appFiles[i].getDynamicObject("position");
            String namefield = appFiles[i].getString("name");
            String positionfield = "";
            String resumefield = "";
            String sexfield = "";
            String educationfield = "";
            String schoolfield = "";
            String specialfield = "";
            String workyearfield = "";
            String operationfield = "";
            if (appPosition != null) {
                positionfield = appPosition.getString("name");
            }
            if (appResObj != null) {
                resumefield = appResObj.getString("id");
                DynamicObject gender = appResObj.getDynamicObject("gender");
                if (Objects.nonNull(gender)) {
                    sexfield = gender.getString("name");
                }
                educationfield = this.getAppResChildInfo(appResObj, "highesteducation", "name");
                schoolfield = this.getAppResChildInfo(appResObj, "highesteduschool", "name");
                specialfield = appResObj.getString("highestspecialty");
                workyearfield = this.getWorkYears(appResObj);
            }
            operationfield = this.getOperationText(this.intvevlInfos, appfileid);
            setter.addRow(new Object[]{appfileid, resumefield, namefield, positionfield, sexfield, educationfield, schoolfield, specialfield, workyearfield, operationfield});
        }
        model.batchCreateNewEntryRow("appfileentryentity", setter);
        model.endInit();
        this.getView().updateView("appfileentryentity");
    }

    private String getWorkYears(DynamicObject appResObj) {
        String workyear = "";
        workyear = ResumeAnalysisHelper.getWorkYearShow((int)appResObj.getInt("workingyears"));
        return workyear;
    }

    private String getAppResChildInfo(DynamicObject appResObj, String childObjName, String childObjAttributeName) {
        String resAttributeValue = "";
        DynamicObject childObj = appResObj.getDynamicObject(childObjName);
        if (childObj != null) {
            resAttributeValue = childObj.getString(childObjAttributeName);
        }
        return resAttributeValue;
    }

    private String getOperationText(DynamicObject[] intvevlInfos, String appfileid) {
        String operationText = ResManager.loadKDString((String)"\u67e5\u770b\u8bc4\u4ef7\u8be6\u60c5", (String)"InteRverAnswerGroupPlugin_12", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        if (intvevlInfos == null) {
            return "";
        }
        for (int i = 0; i < intvevlInfos.length; ++i) {
            String interviewstatus;
            if (!appfileid.equals(intvevlInfos[i].getDynamicObject("application").get("id").toString()) || !(interviewstatus = intvevlInfos[i].getString("interviewstatus")).equals("A")) continue;
            operationText = ResManager.loadKDString((String)"\u53bb\u8bc4\u4ef7", (String)"InteRverAnswerGroupPlugin_13", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
        }
        return operationText;
    }

    private void initGorupCandidateUpDown(Integer index) {
        if (index == 0) {
            this.setGorupCandidateDown();
        } else {
            this.setGorupCandidateUp();
        }
    }

    private void initGroupLableInfo(GroupEntity groupObj) {
        this.setLabel("lblgroupid", groupObj.getGroupId().toString() + "_" + groupObj.getIntvTaskId());
        this.setLabel("lblintvdatetime", groupObj.getIntvDate() + " " + groupObj.getIntvStartTime());
        this.setLabel("lblinterviewername", groupObj.getInterViewerName());
        this.setLabel("lblintvmethod", groupObj.getIntvMethod());
        this.setLabel("lblintvappnum", String.valueOf(groupObj.getAppLicationIds().size()));
        if (groupObj.getIntvMethod().equals(ResManager.loadKDString((String)"\u89c6\u9891\u9762\u8bd5", (String)"InteRverAnswerGroupPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblintvurltext", "lblintvurlvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblinterviewlocationtext", "lblinterviewlocation", "flexlocation"});
            this.setLabel("lblintvurlvalue", groupObj.getIntvUrl());
        } else if (groupObj.getIntvMethod().equals(ResManager.loadKDString((String)"\u7535\u8bdd\u9762\u8bd5", (String)"InteRverAnswerGroupPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblintvurltext", "lblintvurlvalue"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblinterviewlocationtext", "lblinterviewlocation", "flexlocation"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"lblintvurltext", "lblintvurlvalue", "flexlocationonline"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"lblinterviewlocationtext", "lblinterviewlocation"});
            this.setLabel("lblinterviewlocation", groupObj.getInterViewLocation());
        }
    }

    private void setLabel(String labelName, String lableValue) {
        Label label = (Label)this.getControl(labelName);
        label.setText(lableValue);
    }
}

