/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.interveranswer;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.intv.service.IntvTaskHelper;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.GroupEntity;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerHelper;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerPageParam;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumerFilterBiz;
import kd.tsc.tsirm.common.util.FormShowUtils;
import kd.tsc.tsirm.common.util.IntvDateUtil;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;

public class InteRverAnswerPlugin
extends HRDynamicFormBasePlugin {
    public List<GroupEntity> groups = new ArrayList<GroupEntity>(0);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addItemClickListeners(new String[]{"toolbtn"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        boolean taskStateChange = this.checkTaskState();
        if (!taskStateChange) {
            this.showRefresBox();
            return;
        }
        if (itemKey.equals("btnagree")) {
            this.inteRverAnswerAgree();
        } else if (itemKey.equals("btnrefuse")) {
            this.inteRverAnswerRefuse();
        } else if (itemKey.equals("btntransfer")) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_intvanstransfer");
            formShowParameter.setCustomParam("group", this.groups);
            formShowParameter.setCustomParam("transferType", (Object)"multiple");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tsirm_interveranswer"));
            this.getView().showForm(formShowParameter);
        }
    }

    private boolean checkTaskState() {
        boolean isHaveChangeGroup = false;
        ArrayList<GroupEntity> taskStateIsNotC = new ArrayList<GroupEntity>();
        InteRverAnswerPageParam pageParam = this.getPageParam();
        DynamicObject[] intvevlInfosAll = InteRverAnswerHelper.getAllIntvevlInfos((Long)pageParam.getArgIntvId());
        for (int i = 0; i < this.groups.size(); ++i) {
            DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfosByGroupId((DynamicObject[])intvevlInfosAll, (Long)this.groups.get(i).getGroupId());
            Boolean checkTaskStateC = InteRverAnswerHelper.checkAnswerState((GroupEntity)this.groups.get(i), (DynamicObject[])intvevlInfos);
            if (checkTaskStateC.booleanValue()) continue;
            taskStateIsNotC.add(this.groups.get(i));
        }
        if (taskStateIsNotC.isEmpty()) {
            isHaveChangeGroup = true;
        }
        return isHaveChangeGroup;
    }

    public void showRefresBox() {
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("bar_cancle", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5", (String)"InteRverAnswerPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
    }

    public void inteRverAnswerRefuse() {
        boolean isHaveRefuseGroup = false;
        ArrayList<GroupEntity> rverAnswerAgreeGroups = new ArrayList<GroupEntity>();
        InteRverAnswerPageParam pageParam = this.getPageParam();
        DynamicObject[] intvevlInfosAll = InteRverAnswerHelper.getAllIntvevlInfos((Long)pageParam.getArgIntvId());
        for (GroupEntity group : this.groups) {
            DynamicObject[] intvevlInfos;
            boolean checkRverAnswerRefuseState = InteRverAnswerHelper.checkRverAnswerRefuseState((GroupEntity)group, (DynamicObject[])(intvevlInfos = InteRverAnswerHelper.getIntvevlInfosByGroupId((DynamicObject[])intvevlInfosAll, (Long)group.getGroupId())));
            if (!checkRverAnswerRefuseState) continue;
            rverAnswerAgreeGroups.add(group);
            isHaveRefuseGroup = true;
        }
        InteRverAnswerHelper.rverAnswerRefuse(rverAnswerAgreeGroups);
        if (isHaveRefuseGroup) {
            this.setGroupFlexShowForm(this.groups);
        }
    }

    public void inteRverAnswerAgree() {
        boolean isHaveAgreeGroup = false;
        ArrayList<GroupEntity> rverAnswerAgreeGroups = new ArrayList<GroupEntity>();
        InteRverAnswerPageParam pageParam = this.getPageParam();
        DynamicObject[] intvevlInfosAll = InteRverAnswerHelper.getAllIntvevlInfos((Long)pageParam.getArgIntvId());
        for (int i = 0; i < this.groups.size(); ++i) {
            DynamicObject[] intvevlInfos = InteRverAnswerHelper.getIntvevlInfosByGroupId((DynamicObject[])intvevlInfosAll, (Long)this.groups.get(i).getGroupId());
            Boolean checkRverAnswerAgreeState = InteRverAnswerHelper.checkRverAnswerAgreeState((GroupEntity)this.groups.get(i), (DynamicObject[])intvevlInfos);
            if (!checkRverAnswerAgreeState.booleanValue()) continue;
            rverAnswerAgreeGroups.add(this.groups.get(i));
            isHaveAgreeGroup = true;
        }
        InteRverAnswerHelper.rverAnswerAgree(rverAnswerAgreeGroups);
        if (isHaveAgreeGroup) {
            this.setGroupFlexShowForm(this.groups);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getResult().getValue() == 6) {
            this.initTaskInfo();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            this.initTaskInfo();
        }
    }

    public void afterCreateNewData(EventObject evt) {
        this.initTaskInfo();
    }

    private void initTaskInfo() {
        long userId = TSCRequestContext.getUserId();
        InteRverAnswerPageParam pageParam = this.getPageParam();
        boolean checkRequestUserAuth = this.checkRequestUser(pageParam, userId);
        if (!checkRequestUserAuth) {
            this.initNoAuth();
            return;
        }
        this.groups = InteRverAnswerHelper.getIntvGroupsByIntvId((Long)pageParam.getArgIntvId(), (Long)userId);
        this.setGroupFlexShowForm(this.groups);
        this.initHeadButtonAndLableInfo(this.groups);
    }

    private void initHeadButtonAndLableInfo(List<GroupEntity> groups) {
        Boolean checkIntvelDate = Boolean.FALSE;
        this.getView().setVisible(Boolean.TRUE, new String[]{"toolbtn"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexlableinfo", "flexnoauth"});
        for (int i = 0; i < groups.size(); ++i) {
            boolean checktime = IntvDateUtil.intvTimeIsBeforeNow((Date)groups.get(i).getIntvDateTypeDate(), (Long)groups.get(i).getIntvStartTimeTypeLong());
            if (checktime) continue;
            checkIntvelDate = Boolean.TRUE;
        }
        if (!checkIntvelDate.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbtn"});
            Label label = (Label)this.getControl("lbltextinfo");
            label.setText(ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u7ed3\u675f", (String)"InteRverAnswerPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexlableinfo"});
        }
        int entableNum = 0;
        int passedpNnum = 0;
        int cancelNum = 0;
        Object[] tasks = InteRverAnswerHelper.getIntvTasks(groups);
        if (HRArrayUtils.isEmpty((Object[])tasks)) {
            return;
        }
        for (int i = 0; i < tasks.length; ++i) {
            String enableState = tasks[i].getString("enable");
            String interveranswer = tasks[i].getString("interveranswer");
            String taskState = tasks[i].getString("taskstatus");
            if ("1".equals(enableState)) {
                ++entableNum;
            }
            if (interveranswer.equals("D")) {
                ++passedpNnum;
            }
            if (!taskState.equals("C")) continue;
            ++cancelNum;
        }
        if (entableNum == 0 && passedpNnum == tasks.length) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbtn"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexlableinfo"});
        } else if (entableNum == 0 && passedpNnum != tasks.length) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbtn"});
            Label label = (Label)this.getControl("lbltextinfo");
            label.setText(ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u5931\u6548", (String)"InteRverAnswerPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexlableinfo"});
        }
        if (cancelNum == tasks.length) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toolbtn"});
            Label label = (Label)this.getControl("lbltextinfo");
            label.setText(ResManager.loadKDString((String)"\u9762\u8bd5\u5df2\u53d6\u6d88", (String)"InteRverAnswerPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexlableinfo"});
        }
    }

    private boolean checkRequestUser(InteRverAnswerPageParam pageParam, long userId) {
        boolean res = false;
        String userIdMdStr = EncryptionDecryptUtil.getEncryptStr((Object)userId);
        if (pageParam.getParamFrom().equals("page_param_workflow_task")) {
            return true;
        }
        if (pageParam.getInterviewerIdSecretStr().equals(userIdMdStr)) {
            return true;
        }
        return res;
    }

    private void initNoAuth() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexlableinfo", "flexgroup", "flextool"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexnoauth"});
    }

    private InteRverAnswerPageParam getPageParam() {
        InteRverAnswerPageParam pageParam = new InteRverAnswerPageParam();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        if (taskId != null) {
            DynamicObject hitask = QueryServiceHelper.queryOne((String)"wf_hitaskinst", (String)"businesskey", (QFilter[])new QFilter("processinstanceid", "=", (Object)taskId).toArray());
            Long businessKey = Objects.isNull(hitask) ? ResumerFilterBiz.init().getNodeIdByBusinesskey(taskId) : Long.valueOf(hitask.getLong("businesskey"));
            pageParam.setParamFrom("page_param_workflow_task");
            QFilter qFilterTask = new QFilter("id", "=", (Object)businessKey);
            DynamicObject intvTask = IntvTaskHelper.getInstance().getIntvTaskObj(qFilterTask);
            DynamicObject intv = intvTask.getDynamicObject("argintv");
            pageParam.setArgIntvId(Long.valueOf(intv.getLong("id")));
        } else {
            pageParam.setParamFrom("page_param_email");
            pageParam.setArgIntvId(this.getPageParamArgIntvId(params));
            pageParam.setInterviewerIdSecretStr(this.getPageParamInterviewerIdSecret(params));
            pageParam.setIntvTaskIds(this.getPageParamTaskIds(params));
        }
        return pageParam;
    }

    private Long getPageParamArgIntvId(Map<String, Object> params) {
        Long argIntvId = 0L;
        if (params.get("argintvid") != null) {
            argIntvId = Long.valueOf(params.get("argintvid").toString());
        }
        return argIntvId;
    }

    private List<Long> getPageParamTaskIds(Map<String, Object> params) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (params.get("taskids") != null && params.get("taskids") != "") {
            String[] taskIdStrs = params.get("taskids").toString().split(",");
            for (int i = 0; i < taskIdStrs.length; ++i) {
                taskIds.add(Long.parseLong(taskIdStrs[i]));
            }
        }
        return taskIds;
    }

    private String getPageParamInterviewerIdSecret(Map<String, Object> params) {
        String interviewerIdSecretStr = "";
        if (params.get("interviewerIdSecretStr") != null) {
            interviewerIdSecretStr = params.get("interviewerIdSecretStr").toString();
        }
        return interviewerIdSecretStr;
    }

    private void setGroupFlexShowForm(List<GroupEntity> intvGroups) {
        Container flexPanel = (Container)this.getControl("flexgroup");
        for (int i = 0; i < intvGroups.size(); ++i) {
            GroupEntity groupObj = intvGroups.get(i);
            FormShowParameter showParameter = FormShowUtils.setFlexFormShowInteRverAnswer((Container)flexPanel, (String)flexPanel.getKey().concat(String.valueOf(i)), (String)"tsirm_interveranswergroup", (int)i, (Object)groupObj);
            this.getView().showForm(showParameter);
        }
    }
}

