/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.interveranswer;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.GroupEntity;
import kd.tsc.tsirm.business.domain.intv.service.interveranswer.InteRverAnswerHelper;
import kd.tsc.tsirm.business.domain.intv.service.intvcheck.IntvCheckResultEntity;

public class InteRverAnswerTransferPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(InteRverAnswerTransferPlugin.class);
    public JSONArray groups = new JSONArray();
    public String transferType = "";

    public void registerListener(EventObject evt) {
        BasedataEdit bdTransferhr;
        super.registerListener(evt);
        BasedataEdit bdTransfer = (BasedataEdit)this.getView().getControl("bdtransfer");
        if (!Objects.isNull(bdTransfer)) {
            bdTransfer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (!Objects.isNull(bdTransferhr = (BasedataEdit)this.getView().getControl("bdtransferhr"))) {
            bdTransferhr.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            DynamicObject transferHr = (DynamicObject)this.getModel().getValue("bdtransfer");
            if (Objects.isNull(transferHr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u4ea4\u4eba", (String)"InteRverAnswerTransferPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject transferObj = (DynamicObject)this.getModel().getValue("bdtransfer");
            if (transferObj == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u4ea4\u4eba", (String)"InteRverAnswerTransferPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long transferId = transferObj.getLong("id");
            ArrayList<GroupEntity> transferGroups = new ArrayList<GroupEntity>();
            DynamicObjectCollection intvTasks = new DynamicObjectCollection();
            Map params = this.getView().getFormShowParameter().getCustomParams();
            this.groups = JSONArray.parseArray((String)params.get("group").toString());
            this.transferType = params.get("transferType").toString();
            for (int i = 0; i < this.groups.size(); ++i) {
                JSONObject jsonObj = this.groups.getJSONObject(i);
                GroupEntity groupObj = (GroupEntity)jsonObj.toJavaObject(GroupEntity.class);
                IntvCheckResultEntity checkRverAnswerTransferState = InteRverAnswerHelper.checkRverAnswerTransferState((GroupEntity)groupObj, (Long)transferId);
                if (!checkRverAnswerTransferState.isCheckResult() && this.transferType.equals("one")) {
                    this.getView().showErrorNotification(checkRverAnswerTransferState.getCheckMessage());
                    return;
                }
                if (!checkRverAnswerTransferState.isCheckResult()) continue;
                DynamicObject intvTask = InteRverAnswerHelper.getIntvTask((GroupEntity)groupObj);
                intvTasks.add((Object)intvTask);
                transferGroups.add(groupObj);
            }
            this.answerTransfer(transferGroups, intvTasks, transferObj);
        }
    }

    private boolean answerTransfer(List<GroupEntity> transferGroups, DynamicObjectCollection intvTasks, DynamicObject transferDO) {
        boolean transferRes = false;
        transferRes = InteRverAnswerHelper.rverAnswerTransfer(transferGroups, (DynamicObjectCollection)intvTasks, (DynamicObject)transferDO);
        if (transferRes) {
            if (this.transferType.equals("one")) {
                this.getView().returnDataToParent((Object)transferDO.getString("name"));
                this.getView().close();
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u4ea4\u5931\u8d25", (String)"InteRverAnswerTransferPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            logger.error("Transfer fail");
        }
        return transferRes;
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit mulBasedataField = (BasedataEdit)arg0.getSource();
        QFilter searchFilter = mulBasedataField.getSearchFilter();
        if (arg0.getSourceMethod().equals("click")) {
            arg0.setCancel(true);
        }
        if (searchFilter == null) {
            return;
        }
        String value = (String)searchFilter.getValue();
        String searchName = StringUtils.substringAfter((String)value, (String)"#");
        if (searchName.length() >= 2) {
            String fieldKey = arg0.getProperty().getName();
            if (StringUtils.equals((CharSequence)"getLookUpList", (CharSequence)arg0.getSourceMethod()) && StringUtils.equals((CharSequence)fieldKey, (CharSequence)"bdtransfer")) {
                QFilter qFilter = new QFilter("name", "=", (Object)searchName);
                arg0.setCustomQFilters(Collections.singletonList(qFilter));
            } else {
                arg0.setCancel(true);
            }
        } else {
            arg0.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
    }
}

