/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.intv.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.intv.service.ai.InterviewAiService;
import kd.tsc.tsirm.business.domain.position.service.PositionHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InterviewerService {
    private static final InterviewerService INTERVIEWER_SERVICE = new InterviewerService();

    private InterviewerService() {
    }

    public static InterviewerService getInstance() {
        return INTERVIEWER_SERVICE;
    }

    public void setInterviewerQuestionForOpenView(IFormView view, String questionCustomControlKey, String question, String type) {
        CustomControl control = (CustomControl)view.getControl(questionCustomControlKey);
        if (null == control) {
            return;
        }
        if ("view".equals(type)) {
            view.setVisible(Boolean.valueOf(false), new String[]{questionCustomControlKey});
        }
        control.setData(this.setEventData(question, null, type));
    }

    public void setInterviewQuestionForAgain(IFormPlugin formPlugin, IFormView view, String questionCustomControlKey, Long appFileId) {
        DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
        if (null == appFile) {
            return;
        }
        CustomControl customControl = (CustomControl)view.getControl(questionCustomControlKey);
        if (null == customControl) {
            return;
        }
        String historyQuestion = appFile.getString("interviewerquestion_tag");
        if (HRStringUtils.isNotEmpty((String)historyQuestion)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("newQuestion", formPlugin);
            List questionList = (List)SerializationUtils.fromJsonString((String)historyQuestion, ArrayList.class);
            if (questionList != null && questionList.size() > 10) {
                view.showConfirm(ResManager.loadKDString((String)"\u7ee7\u7eed\u751f\u6210\u66f4\u591a\u95ee\u9898\u5c06\u8986\u76d6\u5386\u53f2\u6587\u672c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f\u53d6\u6d88/\u786e\u5b9a\uff0c\u70b9\u51fb\u786e\u5b9a\u5219\u751f\u6210\u7b2c11\u6279\u95ee\u9898\u5e76\u8986\u76d6\u5386\u53f2\u95ee\u9898\u3002", (String)"InterviewService_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                return;
            }
        }
        String newQuestion = InterviewAiService.getInstance().getAiQuestion(appFile);
        customControl.setData(this.setEventData(historyQuestion, newQuestion, "edit"));
        IAppCache appCache = AppCache.get((String)"interviewQuesition");
        appCache.put("beforeQuestion", (Object)newQuestion);
        appCache.put("beforeAppFileId", (Object)appFileId);
    }

    public void showResumeConcernAndLight(IFormView view, String lightAndConcernCustomKey, String concern, DynamicObjectCollection concernLabelCollection, String light, DynamicObjectCollection lightLabelCollection) {
        CustomControl customControl = (CustomControl)view.getControl(lightAndConcernCustomKey);
        if (null == customControl) {
            return;
        }
        customControl.setData(this.setLightAndConcernData(view, concern, concernLabelCollection, light, lightLabelCollection));
    }

    public void dealCustomEvent(IFormPlugin plugin, IFormView view, String questionCustomKey, Map<String, String> map) {
        String type = map.get("type");
        if (HRStringUtils.isBlank((CharSequence)type)) {
            return;
        }
        IAppCache appCache = AppCache.get((String)"interviewQuesition");
        String newQuestion = (String)appCache.get("beforeQuestion", String.class);
        Long appFileId = (Long)appCache.get("beforeAppFileId", Long.class);
        switch (type) {
            case "new": {
                if (appFileId == null || appFileId == 0L) break;
                this.setInterviewQuestionForAgain(plugin, view, questionCustomKey, appFileId);
                break;
            }
            case "end": {
                if (appFileId == null || appFileId == 0L || !HRStringUtils.isNotEmpty((String)newQuestion)) break;
                DynamicObject appFile = AppFileHelper.queryOne((long)appFileId);
                AppFileHelper.updateInterviewerQuestion((DynamicObject)appFile, (String)newQuestion);
                appCache.remove("beforeQuestion");
                break;
            }
        }
    }

    public void showPosition(IFormView view, EventObject evt, String fromViewStr) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)"applypositionflex", (CharSequence)key)) {
            String positionIdStr = view.getPageCache().get("applyposition");
            if (HRStringUtils.isBlank((CharSequence)positionIdStr)) {
                return;
            }
            DynamicObject position = PositionHelper.queryOne((Object)Long.parseLong(positionIdStr));
            if (null != position) {
                String taskIdStr = view.getPageCache().get("intvTaskId");
                long taskId = 0L;
                if (!HRStringUtils.isBlank((CharSequence)taskIdStr)) {
                    taskId = Long.parseLong(taskIdStr);
                }
                AppFileHelper.showPositionViewForInterView((long)position.getLong("id"), (IFormView)view, (String)fromViewStr, (Long)taskId);
            }
        }
    }

    public void setHeadValue(IFormView view, DynamicObject appFile) {
        DynamicObject resume;
        view.getModel().setValue("fullname", (Object)appFile.getString("name"));
        DynamicObject position = appFile.getDynamicObject("position");
        if (Objects.nonNull(position)) {
            view.getPageCache().put("applyposition", position.getString("id"));
            view.getModel().setValue("applyposition", (Object)position.getString("name"));
        }
        if (null != (resume = appFile.getDynamicObject("appres"))) {
            long resumeId = resume.getLong("id");
            HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_rsm");
            DynamicObject rsm = helper.loadSingle((Object)resumeId);
            view.getModel().setValue("dlychannel", (Object)rsm.getString("delivery.recruchnlnm.name"));
            String photoUrl = resume.getString("photo");
            Image photo = (Image)view.getControl("photo");
            if (ObjectUtils.isNotEmpty((Object)photoUrl)) {
                photo.setUrl(HRImageUrlUtil.getImageFullUrl((String)photoUrl));
            } else {
                photo.setUrl("/images/pc/emotion/default_person_82_82.png");
            }
        }
    }

    private Map<String, Object> setLightAndConcernData(IFormView view, String concern, DynamicObjectCollection concernLabelCollection, String light, DynamicObjectCollection lightLabelCollection) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("code", 200);
        result.put("success", true);
        result.put("eventName", "openView");
        result.put("times", System.currentTimeMillis());
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        if (HRStringUtils.isNotEmpty((String)light)) {
            resultMap.put("light", light);
        }
        if (HRStringUtils.isNotEmpty((String)concern)) {
            resultMap.put("concern", concern);
        }
        ArrayList lightLabelList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lightLabelCollection)) {
            lightLabelCollection.forEach(lightLabel -> {
                DynamicObject label = lightLabel.getDynamicObject("fbasedataid");
                if (null == label) {
                    return;
                }
                lightLabelList.add(label.getString("name"));
            });
            resultMap.put("lightLabel", lightLabelList);
        }
        ArrayList concernLabelList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)concernLabelCollection)) {
            concernLabelCollection.forEach(concernLabel -> {
                DynamicObject label = concernLabel.getDynamicObject("fbasedataid");
                if (null == label) {
                    return;
                }
                concernLabelList.add(label.getString("name"));
            });
            resultMap.put("concernLabel", concernLabelList);
        }
        String assessPageId = view.getPageCache().get("tsirm_assessmentinhir");
        String appresPageId = view.getPageCache().get("tsirm_srrsm_layout");
        String pageId = view.getPageId();
        resultMap.put("pageId", Lists.newArrayList((Object[])new String[]{assessPageId, appresPageId, pageId}));
        dataMap.put("result", resultMap);
        result.put("data", dataMap);
        return result;
    }

    private Map<String, Object> setEventData(String historyQuestion, String newQuestion, String type) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)8);
        result.put("code", 200);
        result.put("success", true);
        result.put("eventName", "openView");
        result.put("times", System.currentTimeMillis());
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)2);
        if (HRStringUtils.isNotEmpty((String)historyQuestion) || HRStringUtils.isNotEmpty((String)newQuestion)) {
            HashMap<String, Object> question = new HashMap<String, Object>(2);
            if (HRStringUtils.isNotEmpty((String)historyQuestion)) {
                List questionList = (List)SerializationUtils.fromJsonString((String)historyQuestion, ArrayList.class);
                question.put("historyQuestion", questionList);
            }
            question.put("newQuestion", newQuestion);
            dataMap.put("result", question);
        }
        dataMap.put("type", type);
        result.put("data", dataMap);
        return result;
    }
}

