/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.operationmanage;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tsc.tsirm.business.domain.operationmanage.OperateEmployeeService;
import kd.tsc.tsrbd.business.domain.common.service.TscMutexHelper;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class OperateEmployeeEdit
extends HRDataBaseEdit {
    private static final String SELECTEDEMPLOYEE = "selectedemployee";
    private static final String ADVCONCHILDPANELAP = "advconchildpanelap";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getView().setVisible(Boolean.FALSE, new String[]{"save", "cancel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"modify"});
        this.showSelectEmployee();
        Object[] hasMutex = TscMutexHelper.checkHasMutex((String)this.getView().getEntityId(), Collections.singletonList((Long)this.getModelVal("id")), (String)"custommodify");
        if (ArrayUtils.isEmpty((Object[])hasMutex)) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void showSelectEmployee() {
        DynamicObject[] query = OperateEmployeeService.query();
        List collect = Arrays.stream(query).map(employee -> employee.getLong("employee.id")).collect(Collectors.toList());
        String employees = SerializationUtils.toJsonString(collect);
        if (StringUtils.isNotBlank((CharSequence)employees)) {
            FormShowParameter selectedAppfileParam = this.getHeadShowForm(employees);
            this.getView().showForm(selectedAppfileParam);
        }
    }

    private FormShowParameter getHeadShowForm(String employees) {
        FormShowParameter selectedAppfileParam = new FormShowParameter();
        selectedAppfileParam.setFormId("tsirm_selectedemployee");
        selectedAppfileParam.setShowTitle(false);
        selectedAppfileParam.getOpenStyle().setShowType(ShowType.InContainer);
        selectedAppfileParam.getOpenStyle().setTargetKey(ADVCONCHILDPANELAP);
        String pageId = selectedAppfileParam.getPageId();
        this.getView().getPageCache().put(SELECTEDEMPLOYEE, pageId);
        selectedAppfileParam.setStatus(this.getView().getFormShowParameter().getStatus());
        selectedAppfileParam.setCustomParam("addHrEmployee", (Object)employees);
        return selectedAppfileParam;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operationKey = formOperate.getOperateKey();
        Object[] hasMutex = TscMutexHelper.checkHasMutex((String)this.getView().getEntityId(), Collections.singletonList((Long)this.getModelVal("id")), (String)operationKey);
        if (ArrayUtils.isEmpty((Object[])hasMutex)) {
            if ("custommodify".equals(operationKey)) {
                IFormView view = this.getView();
                TscMutexHelper.requireMutex((String)this.getView().getEntityId(), (Object)this.getModelVal("id"), (String)operationKey, (StringBuilder)new StringBuilder());
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().setVisible(Boolean.TRUE, new String[]{"save", "cancel"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"modify", "tblrefresh", "bar_close"});
                view.setStatus(OperationStatus.EDIT);
                this.showSelectEmployee();
            } else if ("customsave".equals(operationKey)) {
                String pageId = this.getView().getPageCache().get(SELECTEDEMPLOYEE);
                String employees = this.getView().getView(pageId).getPageCache().get("addHrEmployee");
                if (StringUtils.isNotEmpty((CharSequence)employees)) {
                    this.getModel().setValue("employees", (Object)employees);
                }
            }
        } else if (ArrayUtils.isNotEmpty((Object[])hasMutex) && hasMutex[0].getLong("user.id") != TSCRequestContext.getUserId()) {
            String name = hasMutex[0].getString("user.name");
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"{0}\u6b63\u5728PC\u7aef\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PosPortraitPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), name);
            args.setCancel(true);
            this.getView().showTipNotification(tip);
        } else if (ArrayUtils.isNotEmpty((Object[])hasMutex) && hasMutex[0].getLong("user.id") == TSCRequestContext.getUserId()) {
            String name = hasMutex[0].getString("user.name");
            String tip = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u5df2\u6253\u5f00\u8fd0\u8425\u56e2\u961f\u6210\u5458\u914d\u7f6e\uff0c\u8bf7\u8fd4\u56de\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"PosPortraitPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), name);
            args.setCancel(true);
            this.getView().showTipNotification(tip);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (null != operationResult && !operationResult.isSuccess()) {
            return;
        }
        IFormView view = this.getView();
        if ("customsave".equals(operateKey) || "cancel".equals(operateKey)) {
            TscMutexHelper.releaseMutex((String)this.getView().getEntityId(), (Long)((Long)this.getModelVal("id")), (String)"custommodify");
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.FALSE, new String[]{"save", "cancel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"modify", "tblrefresh", "bar_close"});
            view.setStatus(OperationStatus.VIEW);
            view.invokeOperation("refresh");
            this.getView().sendFormAction(view);
        }
        if ("customsave".equals(operateKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"OperateEmployeeEdit_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent closedEvent) {
        super.beforeClosed(closedEvent);
        Object[] hasMutex = TscMutexHelper.checkHasMutex((String)this.getView().getEntityId(), Collections.singletonList((Long)this.getModelVal("id")), (String)"custommodify");
        if (!ArrayUtils.isEmpty((Object[])hasMutex)) {
            TscMutexHelper.releaseMutex((String)this.getView().getEntityId(), (Long)((Long)this.getModelVal("id")), (String)"custommodify");
        }
    }
}

