/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.operationmanage;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tsc.tsirm.business.domain.operationmanage.OperationManageEmployeeService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;

public class OperationManageList
extends HRDataBaseList {
    private static final String[] dynPropertyKeys = new String[]{"adminorg", "apositiontype", "position", "stdposition", "job"};

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
        if (!verifyCert.isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            } else if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new OperationManageListDataProvider());
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (Arrays.asList(dynPropertyKeys).contains(fieldKey)) {
            this.setRowDataFormatValue(event, fieldKey);
        }
    }

    private void setRowDataFormatValue(PackageDataEvent event, String propertyName) {
        DynamicObject rowData = event.getRowData();
        DataEntityPropertyCollection properties = rowData.getDataEntityType().getProperties();
        if (properties.containsKey((Object)propertyName)) {
            event.setFormatValue(rowData.get(propertyName));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("manualoperation".equals(formOperate.getOperateKey())) {
            args.setCancel(true);
            Map verifyCertMap = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
            if (verifyCertMap != null && "FORBIDDEN".equals(verifyCertMap.get("infoType"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf", (String)"OperationMngTreeListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                String message = ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u7684\u5019\u9009\u4eba\u5f00\u901a\u5185\u90e8\u5e94\u8058\u670d\u52a1\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OperationMngTreeListPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("OPENING_LICENSE_CLOSE", (IFormPlugin)this));
            }
        } else if ("canceloperation".equals(formOperate.getOperateKey())) {
            args.setCancel(true);
            String message = ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u7684\u5019\u9009\u4eba\u53d6\u6d88\u5f00\u901a\u5185\u90e8\u5e94\u8058\u670d\u52a1\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OperationMngTreeListPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CANCEL_LICENSE_CLOSE", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("OPENING_LICENSE_CLOSE".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResult().name())) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"manualoperation", (String)"tsirm_operationmanage", (Object[])this.getSelectedRows().getPrimaryKeyValues(), null);
            if (operationResult.isSuccess()) {
                String message = ResManager.loadKDString((String)"\u5f00\u901a\u6210\u529f", (String)"OperationMngTreeListPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showOperationResult(operationResult);
            }
            this.getView().invokeOperation("refresh");
        } else if ("CANCEL_LICENSE_CLOSE".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResult().name())) {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation("canceloperation", "tsirm_operationmanage", this.getSelectedRows().getPrimaryKeyValues(), null);
            if (operationResult.isSuccess()) {
                String message = ResManager.loadKDString((String)"\u53d6\u6d88\u5f00\u901a\u6210\u529f", (String)"OperationMngTreeListPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showOperationResult(operationResult);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
        Long id = (Long)selectedRow.getPrimaryKeyValue();
        if ("failreasoncombo".equals(fieldName)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_operationfailreason");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject object = OperationManageServiceHelper.Singleton.INSTANCE.getInstance().queryOne("id,failreason", (Object)id);
            if (!Objects.isNull(object)) {
                formShowParameter.setCustomParam("textarea", (Object)object.getString("failreason"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    private static class OperationManageListDataProvider
    extends ListDataProvider {
        private OperationManageListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection pageData = super.getData(start, limit);
            List personIds = pageData.stream().filter(data -> !HRObjectUtils.isEmpty((Object)data.getDynamicObject("employee.person"))).map(data -> data.getDynamicObject("employee.person").getLong("id")).collect(Collectors.toList());
            List empPosOrgRels = OperationManageEmployeeService.queryEmpposorgrel(personIds, null);
            if (CollectionUtils.isEmpty((Collection)empPosOrgRels)) {
                return pageData;
            }
            empPosOrgRels.forEach(data -> {
                Object aPositionType = data.get("apositiontype");
                if (aPositionType != null && HRStringUtils.isNotEmpty((String)aPositionType.toString())) {
                    ImmutableMap apositionTypeKv = ImmutableMap.of((Object)"0", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"OperationManageList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (Object)"1", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"OperationManageList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (Object)"2", (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"OperationManageList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    data.put("apositiontype", apositionTypeKv.get(aPositionType.toString()));
                }
            });
            Map<Long, Map> empPosOrgRelInfoMap = empPosOrgRels.stream().collect(Collectors.toMap(empPosOrgRelMap -> Long.valueOf(empPosOrgRelMap.get("person").toString()), empPosOrgRelMap -> empPosOrgRelMap, (v1, v2) -> v1));
            for (DynamicObject pageDataRow : pageData) {
                long personId;
                Map empPosOrgRelInfo;
                DynamicObject personObj = pageDataRow.getDynamicObject("employee.person");
                if (HRObjectUtils.isEmpty((Object)personObj) || CollectionUtils.isEmpty((Map)(empPosOrgRelInfo = empPosOrgRelInfoMap.get(personId = personObj.getLong("id"))))) continue;
                this.setRowDataValue(pageDataRow, empPosOrgRelInfo, "adminorg");
                this.setRowDataValue(pageDataRow, empPosOrgRelInfo, "apositiontype");
                this.setRowDataValue(pageDataRow, empPosOrgRelInfo, "position");
                this.setRowDataValue(pageDataRow, empPosOrgRelInfo, "stdposition");
                this.setRowDataValue(pageDataRow, empPosOrgRelInfo, "job");
            }
            return pageData;
        }

        private void setRowDataValue(DynamicObject pageDataRow, Map<String, Object> empPosOrgRelInfo, String propertyName) {
            DataEntityPropertyCollection properties = pageDataRow.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)propertyName)) {
                TextProp prop = new TextProp();
                prop.setName(propertyName);
                prop.setDbIgnore(true);
                pageDataRow.getDynamicObjectType().registerSimpleProperty((DynamicSimpleProperty)prop);
            }
            pageDataRow.set(propertyName, empPosOrgRelInfo.get(propertyName));
        }
    }
}

