/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.operationmanage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.template.AdminOrgTreeListTemplate;
import kd.tsc.tsirm.business.domain.operationmanage.OperationManageEmployeeService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;

public class OperationManageTreeListPlugin
extends AdminOrgTreeListTemplate {
    private static final Log logger = LogFactory.getLog(OperationManageTreeListPlugin.class);

    public OperationManageTreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.TRUE, Boolean.FALSE, false));
    }

    public void initialize() {
        super.initialize();
        this.orgTreeModel.setIncludeChild(this.getDefaultIsIncludeChild());
        this.orgTreeModel.setHisTree(false);
        this.orgTreeModel.setFilterTreePerm(false);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.orgTreeModel.setIncludeChild(this.getDefaultIsIncludeChild());
        this.orgTreeModel.setHisTree(false);
        this.orgTreeModel.setFilterTreePerm(false);
    }

    private boolean getDefaultIsIncludeChild() {
        MainEntityType metadata = MetadataServiceHelper.getDataEntityType((String)this.getView().getFormShowParameter().getFormId());
        DynamicProperty isIncludeChildProp = metadata.getProperty("chkincludechild");
        return Boolean.parseBoolean(String.valueOf(isIncludeChildProp.getDefaultValue()));
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity().getBoolean("chkincludechild");
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        List allOrgBoIdList = super.getAllOrgBoIdListFast();
        if (allOrgBoIdList == null) {
            logger.info("buildNodeClickFilter, allOrgBoIdList is null.");
            return null;
        }
        DynamicObject[] operationMngs = OperationManageServiceHelper.Singleton.INSTANCE.getInstance().query("employee.person.id", null);
        List allPersonIdList = Arrays.stream(operationMngs).map(dynamicObject -> dynamicObject.getLong("employee.person.id")).collect(Collectors.toList());
        List empPosorgrels = OperationManageEmployeeService.queryEmpposorgrel(allPersonIdList, (List)allOrgBoIdList);
        ArrayList<Long> operationMngIdList = new ArrayList<Long>(operationMngs.length);
        List personIdList = empPosorgrels.stream().map(stringObjectMap -> (Long)stringObjectMap.get("person")).collect(Collectors.toList());
        for (DynamicObject operationMng : operationMngs) {
            if (!personIdList.contains(operationMng.getLong("employee.person.id"))) continue;
            operationMngIdList.add(operationMng.getLong("id"));
        }
        return new QFilter("id", "in", operationMngIdList);
    }
}

