/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.operationmanage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.operationmanage.OperationManageEmployeeService;
import kd.tsc.tsirm.business.domain.operationmanage.helper.OperationManageServiceHelper;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsirm.business.license.VerifyCertTypeEnum;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OperationMngTreeListPlugin
extends AbstractTreeListPlugin {
    private static Log logger = LogFactory.getLog(OperationMngTreeListPlugin.class);
    private static long packageDataDuration = 0L;

    public void initializeTree(EventObject eventObject) {
        long sTime = System.currentTimeMillis();
        TreeNode rootNode = TscTreeUtils.unRenderRoot();
        DynamicObject[] adminOrgDys = HRBaseServiceHelper.create((String)"haos_adminorghr").loadDynamicObjectArray(new QFilter[]{new QFilter("iscurrentversion", "=", (Object)"1")});
        if (ObjectUtils.isEmpty((Object)adminOrgDys)) {
            return;
        }
        int objSize = adminOrgDys.length;
        for (int i = 0; i < objSize; ++i) {
            DynamicObject dy = adminOrgDys[i];
            if (dy.getLong("parent.id") != Long.parseLong(rootNode.getId())) continue;
            long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)rootNode.getId());
            treeNode.setIsOpened(true);
            this.getTreeModel().setCurrentNodeId((Object)treeNode.getId());
            List<TreeNode> children = this.getChildrenList(adminOrgDys, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            rootNode.addChild(treeNode);
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        this.getTreeModel().setRoot(rootNode);
        this.getPageCache().put(treeView.getKey(), SerializationUtils.toJsonString((Object)rootNode));
        this.getTreeModel().setRootVisable(false);
        long eTime = System.currentTimeMillis();
        logger.info("OperationMngTreeListPlugin.initializeTree.duration->{}", (Object)(eTime - sTime));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map verifyCert = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
        if (!verifyCert.isEmpty() && verifyCert.containsKey("infoType")) {
            String infoType = (String)verifyCert.get("infoType");
            if (VerifyCertTypeEnum.WARNING.getValue().equals(infoType) || VerifyCertTypeEnum.EXCEED.getValue().equals(infoType)) {
                this.getView().showTipNotification((String)verifyCert.get("message"));
            } else if (VerifyCertTypeEnum.FORBIDDEN.getValue().equals(infoType)) {
                this.getView().showErrorNotification((String)verifyCert.get("message"));
            }
        }
    }

    public void afterBindData(EventObject e) {
        Object currentNodeId = this.getTreeListView().getTreeModel().getCurrentNodeId();
        this.getTreeListView().getTreeView().focusNode(this.getTreeModel().getRoot().getTreeNode(currentNodeId.toString()));
        logger.info("OperationMngTreeListPlugin.packageData.duration->{}", (Object)packageDataDuration);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        long sTime = System.currentTimeMillis();
        super.buildTreeListFilter(e);
        Object nodeId = e.getNodeId();
        List<Long> adminOrgList = this.getAdminOrgList(nodeId);
        DynamicObject[] operationMngs = OperationManageServiceHelper.Singleton.INSTANCE.getInstance().query("employee.person.id", null);
        List allPersonIdList = Arrays.stream(operationMngs).map(dynamicObject -> dynamicObject.getLong("employee.person.id")).collect(Collectors.toList());
        List empPosorgrels = OperationManageEmployeeService.queryEmpposorgrel(allPersonIdList, adminOrgList);
        ArrayList<Long> operationMngIdList = new ArrayList<Long>(operationMngs.length);
        List personIdList = empPosorgrels.stream().map(stringObjectMap -> (Long)stringObjectMap.get("person")).collect(Collectors.toList());
        for (DynamicObject operationMng : operationMngs) {
            if (!personIdList.contains(operationMng.getLong("employee.person.id"))) continue;
            operationMngIdList.add(operationMng.getLong("id"));
        }
        QFilter treeFilter = new QFilter("id", "in", operationMngIdList);
        e.addQFilter(treeFilter);
        long eTime = System.currentTimeMillis();
        logger.info("OperationMngTreeListPlugin.buildTreeListFilter.duration->{}", (Object)(eTime - sTime));
    }

    public void refreshNode(RefreshNodeEvent e) {
        String currNodeId;
        TreeNode root = this.getTreeModel().getRoot();
        TreeNode currNode = root.getTreeNode(currNodeId = (String)e.getNodeId(), 20);
        if (currNode.getChildren() != null && !currNode.getChildren().isEmpty()) {
            e.setChildNodes(currNode.getChildren());
        }
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        String searchText = evt.getText();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        ITreeListView treeListView = this.getTreeListView();
        TscTreeUtils.searchTalentTree((String)searchText, (IFormView)view, (IPageCache)pageCache, (ITreeListView)treeListView);
    }

    public List<TreeNode> getChildrenList(DynamicObject[] objects, long parentId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)objects.length);
        for (DynamicObject dy : objects) {
            if (dy.getLong("parent.id") != parentId) continue;
            Long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)String.valueOf(parentId));
            treeNode.setIsOpened(true);
            List<TreeNode> children = this.getChildrenList(objects, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        long sTime = System.currentTimeMillis();
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        List collect = pageData.stream().map(person -> person.getDynamicObject("employee.person").getLong("id")).collect(Collectors.toList());
        List empPosorgrels = OperationManageEmployeeService.queryEmpposorgrel(collect, null);
        if (!empPosorgrels.isEmpty()) {
            this.getPageCache().putBigObject("empPosorgrels", SerializationUtils.toJsonString((Object)empPosorgrels));
        }
        long eTime = System.currentTimeMillis();
        logger.info("OperationMngTreeListPlugin.beforePackageData.duration->{}", (Object)(eTime - sTime));
    }

    public void packageData(PackageDataEvent event) {
        long sTime = System.currentTimeMillis();
        super.packageData(event);
        String empPosorgrels = this.getPageCache().getBigObject("empPosorgrels");
        if (StringUtils.isNotBlank((CharSequence)empPosorgrels)) {
            List objects = SerializationUtils.fromJsonStringToList((String)empPosorgrels, Map.class);
            AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
            String fieldKey = columnDesc.getFieldKey();
            long personId = event.getRowData().getLong("employee.person.id");
            Optional<Map> first = objects.stream().filter(object -> (Long)object.get("person") == personId).findFirst();
            if (first.isPresent()) {
                Map obj = first.get();
                if ("adminorg".equals(fieldKey)) {
                    event.setFormatValue(obj.get("adminorg"));
                } else if ("apositiontype".equals(fieldKey)) {
                    ImmutableMap apositionTypeKv = ImmutableMap.of((Object)"0", (Object)ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"OperationManageList_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (Object)"1", (Object)ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"OperationManageList_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]), (Object)"2", (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"OperationManageList_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
                    event.setFormatValue(apositionTypeKv.get(obj.get("apositiontype")));
                } else if ("position".equals(fieldKey)) {
                    event.setFormatValue(obj.get("position"));
                } else if ("stdposition".equals(fieldKey)) {
                    event.setFormatValue(obj.get("stdposition"));
                } else if ("job".equals(fieldKey)) {
                    event.setFormatValue(obj.get("job"));
                }
            }
        }
        long eTime = System.currentTimeMillis();
        packageDataDuration += eTime - sTime;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        if ("iscontainlower1".equals(keyName)) {
            this.getTreeListView().refreshTreeView();
        }
    }

    private List<Long> getAdminOrgList(Object nodeId) {
        List<Long> adminOrgList;
        boolean isContainLower = this.getModel().getDataEntity().getBoolean("iscontainlower1");
        if (isContainLower) {
            List treeNodeAll = TscTreeUtils.getTreeNodeAll((TreeNode)this.getTreeModel().getRoot().getTreeNode(nodeId.toString()));
            adminOrgList = treeNodeAll.stream().map(treeNode -> Long.parseLong(treeNode.getId())).collect(Collectors.toList());
        } else {
            adminOrgList = new ArrayList<Long>(1);
        }
        adminOrgList.add(Long.parseLong(nodeId.toString()));
        return adminOrgList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("manualoperation".equals(formOperate.getOperateKey())) {
            args.setCancel(true);
            Map verifyCertMap = TSIRMCertCommonHelper.verifyCert((String)"2+TXFE9NU13A", (String)"tsirm_stdrsm");
            if (verifyCertMap != null && "FORBIDDEN".equals(verifyCertMap.get("infoType"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bb8\u53ef\u5360\u7528\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u7cfb\u7edf\u529f\u80fd\u9650\u5236\u4f7f\u7528\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8bb8\u53ef\u8d2d\u4e70\u6570\u91cf\u3002", (String)"OperationMngTreeListPlugin_0", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]));
            } else {
                String message = ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u7684\u5019\u9009\u4eba\u5f00\u901a\u5185\u90e8\u5e94\u8058\u670d\u52a1\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OperationMngTreeListPlugin_1", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("OPENING_LICENSE_CLOSE", (IFormPlugin)this));
            }
        } else if ("canceloperation".equals(formOperate.getOperateKey())) {
            args.setCancel(true);
            String message = ResManager.loadKDString((String)"\u5c06\u4e3a\u6240\u9009\u7684\u5019\u9009\u4eba\u53d6\u6d88\u5f00\u901a\u5185\u90e8\u5e94\u8058\u670d\u52a1\uff0c\u786e\u5b9a\u7ee7\u7eed\u5417\uff1f", (String)"OperationMngTreeListPlugin_2", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CANCEL_LICENSE_CLOSE", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("OPENING_LICENSE_CLOSE".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResult().name())) {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"manualoperation", (String)"tsirm_operationmanage", (Object[])this.getSelectedRows().getPrimaryKeyValues(), null);
            if (operationResult.isSuccess()) {
                String message = ResManager.loadKDString((String)"\u5f00\u901a\u6210\u529f", (String)"OperationMngTreeListPlugin_3", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showOperationResult(operationResult);
            }
            this.getView().invokeOperation("refresh");
        } else if ("CANCEL_LICENSE_CLOSE".equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResult().name())) {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation("canceloperation", "tsirm_operationmanage", this.getSelectedRows().getPrimaryKeyValues(), null);
            if (operationResult.isSuccess()) {
                String message = ResManager.loadKDString((String)"\u53d6\u6d88\u5f00\u901a\u6210\u529f", (String)"OperationMngTreeListPlugin_4", (String)"tsc-tsirm-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(message);
            } else {
                this.getView().showOperationResult(operationResult);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        ListSelectedRow selectedRow = list.getCurrentSelectedRowInfo();
        Long id = (Long)selectedRow.getPrimaryKeyValue();
        if ("failreasoncombo".equals(fieldName)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tsirm_operationfailreason");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject object = OperationManageServiceHelper.Singleton.INSTANCE.getInstance().queryOne("id,failreason", (Object)id);
            if (!Objects.isNull(object)) {
                formShowParameter.setCustomParam("textarea", (Object)object.getString("failreason"));
                this.getView().showForm(formShowParameter);
            }
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        TreeListModel treeListModel = (TreeListModel)this.treeListView.getTreeModel();
        treeListModel.setGobackToRoot(false);
    }
}

