/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.formplugin.web.pc;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.ListShowParameter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.pc.helper.UserAdvertRelHelper;
import org.apache.commons.lang3.StringUtils;

public class PersonalCenterFormPlugin
extends HRDynamicFormBasePlugin {
    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String activeTab = (String)this.getView().getFormShowParameter().getCustomParam("activetab");
        Tab tab = (Tab)this.getControl("tabap");
        if (!HRStringUtils.isEmpty((String)activeTab)) {
            tab.activeTab(activeTab);
        }
        this.showFavoriteAdvertTab();
        this.showApplyTab();
        this.showResume();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            this.getView().updateView();
        }
    }

    private void showResume() {
        Long empCVId = EmpCVHelper.getEmpCVId((Long)RequestContext.get().getCurrUserId());
        BaseShowParameter formShowParameter = this.createBaseFormShowParameter("tsirm_empcv", "resume", empCVId, null);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void showApplyTab() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("tsirm_apply_list");
        fsp.getOpenStyle().setShowType(ShowType.InContainer);
        fsp.getOpenStyle().setTargetKey("flexpanelap");
        fsp.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
        this.getView().showForm(fsp);
    }

    private void showFavoriteAdvertTab() {
        List collectionAdvert = UserAdvertRelHelper.getCollectionAdvert();
        if (collectionAdvert == null || collectionAdvert.size() == 0) {
            FormShowParameter formShowParameter = this.createFormShowParameter("tsirm_favoriteadvertempty", "favoriteadvertpanel", null);
            this.getView().showForm(formShowParameter);
        } else {
            ListShowParameter listFormShowParameter = this.createListFormShowParameter("tsirm_favoriteadvertlist", "favoriteadvertpanel", "tsirm_favoriteadverts", null);
            this.getView().showForm((FormShowParameter)listFormShowParameter);
        }
    }

    private BaseShowParameter createBaseFormShowParameter(String formId, String target, Long pkId, Map<String, Object> params) {
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.setFormId(formId);
        if (pkId != null) {
            showParameter.setPkId((Object)pkId);
        }
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (StringUtils.isNotBlank((CharSequence)target)) {
            showParameter.getOpenStyle().setTargetKey(target);
        }
        if (params != null && params.size() > 0) {
            params.forEach((arg_0, arg_1) -> ((BaseShowParameter)showParameter).setCustomParam(arg_0, arg_1));
        }
        return showParameter;
    }

    private ListShowParameter createListFormShowParameter(String formId, String target, String billFormId, Map<String, Object> params) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId(billFormId);
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(target);
        if (params != null && params.size() > 0) {
            params.forEach((arg_0, arg_1) -> ((ListShowParameter)showParameter).setCustomParam(arg_0, arg_1));
        }
        return showParameter;
    }

    private FormShowParameter createFormShowParameter(String formId, String target, Map<String, Object> params) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(target);
        if (params != null && params.size() > 0) {
            params.forEach((arg_0, arg_1) -> ((FormShowParameter)showParameter).setCustomParam(arg_0, arg_1));
        }
        return showParameter;
    }
}

